//=============================================================================
/**
 *
 *	@file		FieldMoveModelEffect_IconExclamation.cpp
 *	@brief  ACRFrbN}[N
 *	@author hosaka genya
 *	@data		2011.09.27
 *
 */
//=============================================================================

#include "FieldMoveModelEffect_IconExclamation.h"

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( mmodel );


//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
      
    //----------------------------------------------------------------------------
    /**
     *	@brief  
     *
     *	@param	p_wk    [N
     */
    //-----------------------------------------------------------------------------
    void EffectIconExclamation::InitFunc( void* p_work, MoveModelEffectManager* p_manager, MoveModelBase* p_model, gfl::heap::HeapBase* p_heap, gfl::heap::NwAllocator* p_device ) const
    {
      Work* p_wk = reinterpret_cast<Work*>(p_work);
      bool result;

      gfl::grp::g3d::Resource* p_mdlres = p_manager->GetResource( MoveModelEffectManager::RES_ICON_EXCLAMATION_MDL );
      gfl::grp::g3d::Resource* p_mdlskel = p_manager->GetResource( MoveModelEffectManager::RES_ICON_EXCLAMATION_SKL );
//      gfl::grp::g3d::Resource* p_mdltp = p_manager->GetResource( MoveModelEffectManager::RES_ENCKUSA00_TP );

#if 0
      // eNX`p^[\[XZbgAbv
      result = p_mdltp->Setup( p_device, p_mdlres );
      if( !result ){
        p_mdltp->PrintUnresolvedReference(); 
        GFL_ASSERT_STOP( result );
      }
#endif

      // ff[^
      p_wk->p_model = GFL_NEW(p_heap) gfl::grp::g3d::Model();
      p_wk->p_model->Create( p_device, p_device, p_mdlres, 0 );

      p_wk->p_anmres[0] = GFL_NEW(p_heap) gfl::grp::g3d::ResAnim();
      p_wk->p_anmres[0]->Create( p_device, p_mdlskel, 0, gfl::grp::g3d::ResAnim::TYPE_SKELETAL );
      
      p_wk->p_model->ChangeAnimation( p_device, p_wk->p_anmres[0], 0, 0 );
      
      
      //@Wݒ肵ĕ\
      gfl::math::VEC3 pos;
      Attr attr;
      
      p_model->GetVectorPos(&pos);
      
      
      f32 yofs = 36.0f;
      
      //@todo b菈 ̎qႭ
      if( p_model->GetOBJCode() == SMALLGIRL )
      {
        yofs = 24.0f;
      }
      
      pos.y += yofs;
      p_wk->p_model->SetTranslate( pos );

      // 
      {
        gfl::grp::g3d::Scene* p_scene = p_manager->GetGraphics()->GetScene();
        p_scene->AddSceneNode( p_wk->p_model );


        p_manager->GetGraphics()->SetUpEnd();
      }

      // uIvSEĐ
      // @todo `ł̓og͖̎炳ȂAȊOł͖炷Bł͖B

    }
    

    //----------------------------------------------------------------------------
    /**
     *	@brief  XV
     *
     *	@param	p_wk    [N
     *
     *	@retval true  I
     */
    //-----------------------------------------------------------------------------
    bool EffectIconExclamation::UpdateFunc( void* p_work, MoveModelEffectManager* p_manager, MoveModelBase* p_model ) const
    {
      Work* p_wk = reinterpret_cast<Work*>(p_work);

      // Aj[VI܂ő҂B
      if( p_wk->p_model->IsAnimationFrameEndFrame(0) )
      {
        return true;
      }
      
      return false;
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  j
     *
     *	@param	p_wk    [N
     */
    //-----------------------------------------------------------------------------
    void EffectIconExclamation::DeleteFunc( void* p_work, MoveModelEffectManager* p_manager, MoveModelBase* p_model ) const
    {
      Work* p_wk = reinterpret_cast<Work*>(p_work);

      // j
      {
        gfl::grp::g3d::Scene* p_scene = p_manager->GetGraphics()->GetScene();
        // V[j
        p_scene->RemoveSceneNode( p_wk->p_model );

        GFL_DELETE p_wk->p_model;

        GFL_DELETE p_wk->p_anmres[0];
        p_wk->p_anmres[0] = NULL;

        p_manager->GetGraphics()->SetUpEnd();

      }

    }



GFL_NAMESPACE_END( mmodel );
GFL_NAMESPACE_END( field );
