//=============================================================================
/**
 *
 *	@file		FieldActionCmdIcon.h
 *	@brief  ACR\
 *	@author hosaka genya
 *	@data		2011.09.27
 *
 */
//=============================================================================
#include "FieldActionCmdIcon.h"

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( mmodel );

//-----------------------------------------------------------------------------
/**
 *	@brief   
 *
 *	@param	ActionCmdBase::ActionCmdWork* p_work
 *	@param	type 
 */
//-----------------------------------------------------------------------------
void ActionCmdIcon::InitializeWork( ActionCmdBase::ActionCmdWork* p_work, MoveModelEffectManager::Type type )
{
  Work* p_wk = reinterpret_cast<Work*>( ActionCmdBase::GetAcmdWork( p_work, sizeof(Work) ) );
  p_wk->type = type;
  
  MoveModel* p_mdl = reinterpret_cast<MoveModel*>( p_work->p_model );
  MoveModelEffectManager* p_eff = p_mdl->GetManager()->GetEffectManager();
  
  // GtFNgJn
  p_eff->CreateEffect( type, p_work->p_model );
  
  // 
  ActionCmdBase::AddAcmdWorkSeq( p_work, 1 );
}
  
//-----------------------------------------------------------------------------
/**
 *	@brief   又
 *
 *	@param	ActionCmdBase::ActionCmdWork* p_work 
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
ActionCmdBase::AcmdRet ActionCmdIcon::AcIcon( ActionCmdBase::ActionCmdWork* p_work )
{
  Work* p_wk = reinterpret_cast<Work*>( ActionCmdBase::GetAcmdWork( p_work, sizeof(Work) ) );
  MoveModel* p_mdl = reinterpret_cast<MoveModel*>( p_work->p_model );
  MoveModelEffectManager* p_eff = p_mdl->GetManager()->GetEffectManager();
  
  if( p_eff->GetEffectCount( p_wk->type ) > 0 )
  {
    return ActionCmdBase::ACMD_RET_ONE_TIME_END;
  }
  
  // 
  ActionCmdBase::AddAcmdWorkSeq( p_work, 1 );

  return ActionCmdBase::ACMD_RET_CONTINUE;
}

//=====================================================================================
// ActionCmdIconExclamation
//=====================================================================================
ActionCmdIconExclamation::ActionCmdIconExclamation( void )
{ 
  m_pFuncTbl[0] = AcIconExclamationInit;
  m_pFuncTbl[1] = ActionCmdIcon::AcIcon;
  m_pFuncTbl[2] = ActionCmdBase::AcEnd;
  m_SeqNum = 3;
}

ActionCmdBase::AcmdRet ActionCmdIconExclamation::AcIconExclamationInit( ActionCmdBase::ActionCmdWork* p_work )
{
  ActionCmdIcon::InitializeWork( p_work, MoveModelEffectManager::TYPE_ICON_EXCLAMATION );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

GFL_NAMESPACE_END( mmodel );
GFL_NAMESPACE_END( field );

