//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldDepthOfField.cpp
 *	@brie   ʊE[x@ݒNX
 *	@author	tomoya takahashi
 *	@date		2011.09.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "FieldDepthOfField.h"

namespace field{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------


  // RXgN^
  DepthOfField::DepthOfField( void ) : 
    m_Focus(DEFAULT_FOCUS),
    m_SakuranEnkei(DEFAULT_SAKURAN_ENKEI),  // e~a
    m_ShotenKyori(DEFAULT_SHOTENKYORI), // œ_
    m_Distance(DEFAULT_HISYATAI_KYORI),  // ʑ̋
    m_Enable(true)
  {
  }

  // fXgN^
  DepthOfField::~DepthOfField()
  {
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  
   *
   *	@param  cp_setting    JZbeBO
   */
  //-----------------------------------------------------------------------------
  void DepthOfField::Initialize( const FieldCameraSetting::FieldCameraSettingData* cp_setting )
  {
    this->SetEnable( cp_setting->depth_f_flag );
    this->SetF( cp_setting->depth_f );
    this->SetFovy( cp_setting->fovy );
    this->SetDistance( cp_setting->distance );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ʊE[x@ONEOFFݒ
   *
   *	@param	flag  ON/OFF
   */
  //-----------------------------------------------------------------------------
  void DepthOfField::SetEnable( b32 flag )
  {
    m_Enable = flag;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  tH[JXl̍XV
   */
  //-----------------------------------------------------------------------------
  void DepthOfField::SetF( f32 focus )
  {
    m_Focus = focus;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  p̐ݒ
   *
   *	@param	deg   fovy  p
   */
  //-----------------------------------------------------------------------------
  void DepthOfField::SetFovy( f32 deg )
  {
    // œ_߂B
    m_ShotenKyori = DISPLAY_CROSS_DISTANCE / (2.0f * gfl::math::TanDeg( deg/2 ));
    m_RealShotenKyori = 240.0f / (2.0f * gfl::math::TanDeg( deg/2 ));// RDJł̏œ_
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  JDistance̐ݒ
   *
   *	@param	distance  
   */
  //-----------------------------------------------------------------------------
  void DepthOfField::SetDistance( f32 distance )
  {
    m_Distance = distance * NUM_TYPE; // ~ɂB
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  ʊE[xp[^vZ
   */
  //-----------------------------------------------------------------------------
  void DepthOfField::Calc( void )
  {
    f32 front_length;
    f32 back_length;
    f32 child;
    f32 syouten_2;
    f32 sakuran_focus_dist;

    TOMOYA_PRINT( "œ_ %f\n", m_ShotenKyori );
    TOMOYA_PRINT( "ʑ̋ %f\n", m_Distance );
    TOMOYA_PRINT( "e~a %f\n", m_SakuranEnkei );
    TOMOYA_PRINT( "i %f\n", m_Focus );


    child = m_SakuranEnkei * m_Focus * m_Distance * m_Distance;
    syouten_2 = m_ShotenKyori * m_ShotenKyori;
    sakuran_focus_dist = m_SakuranEnkei * m_Focus * m_Distance;

    front_length = child / (syouten_2 + sakuran_focus_dist);
    back_length = child / (syouten_2 - sakuran_focus_dist);
    
    // ~̒萔AĂ̂ŁAZ`ɂB
    front_length *= NUM_TYPE;
    back_length *= NUM_TYPE;

    
    
    m_BackFocusLength = (m_RealShotenKyori) + back_length;
    m_FrontFocusLength = (m_RealShotenKyori) - front_length;

    TOMOYA_PRINT( "FrontLength %f .. %f\n", m_FrontFocusLength );
    TOMOYA_PRINT( "BackLength %f .. %f\n", m_BackFocusLength );

    static f32 length_div = 4;
    static f32 power_div = 4;

    // back_focus front_length̋ɂāAp[^ݒ
    for( u32 i=0; i<gfl::grp::g3d::G3DDepthOfFieldSystem::DOF_LAYER_MAX; ++i ){
      m_BackRangeOffs[i] = ((back_length / length_div) * static_cast<f32>(i));
      m_FrontRangeOffs[i] = -((front_length / length_div) * static_cast<f32>(i));

      m_BackRangePower[i] = static_cast<f32>(i) * (1.0f/power_div);
      m_FrontRangePower[i] = static_cast<f32>(i) * (1.0f/power_div);
    }
    
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief ʊE[x`
   *
   *  @param  p_grpsys    OtBbNXVXe
   *	@param	p_scene     V[VXe
   *	@param	p_camera    J
   */
  //-----------------------------------------------------------------------------
  void DepthOfField::RenderingDepthField( gfl::grp::GraphicsSystem* p_grpsys, gfl::grp::g3d::Scene* p_scene, gfl::grp::g3d::StereoCamera* p_camera ) const
  {
    // 
    if(this->IsEnabel()){
      //ȉAݒ֐͖t[ĂԕKv͖łB
      p_scene->SetDofType( gfl::grp::g3d::DofType::Back );
      p_scene->SetFocusLength( this->GetBackFocusLength() );
      for( u32 i=0; i<gfl::grp::g3d::G3DDepthOfFieldSystem::DOF_LAYER_MAX; ++i ){
        p_scene->SetFocusRange( i,  this->GetBackRangeOffs(i), this->GetBackRangePower(i) );
      }
      //`֐
      p_scene->StereoDrawPostDepthOfField( p_grpsys, p_camera );
    }

    // O
    if(this->IsEnabel()){
      //ȉAݒ֐͖t[ĂԕKv͖łB
      p_scene->SetDofType( gfl::grp::g3d::DofType::Front );
      p_scene->SetFocusLength( this->GetFrontFocusLength() );
      for( u32 i=0; i<gfl::grp::g3d::G3DDepthOfFieldSystem::DOF_LAYER_MAX; ++i ){
        p_scene->SetFocusRange( i,  this->GetFrontRangeOffs(i), this->GetFrontRangePower(i) );
      }
      //`֐
      p_scene->StereoDrawPostDepthOfField( p_grpsys, p_camera );
    }
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  @WItZbg@̎擾
   *
   *	@param	index   CfbNX
   *
   *	@return WItZbg
   */
  //-----------------------------------------------------------------------------
  f32 DepthOfField::GetBackRangeOffs( s32 index ) const
  {
    if( index < gfl::grp::g3d::G3DDepthOfFieldSystem::DOF_LAYER_MAX ){
      return m_BackRangeOffs[index]; 
    }
    GFL_ASSERT( index < gfl::grp::g3d::G3DDepthOfFieldSystem::DOF_LAYER_MAX );
    return m_BackRangeOffs[0]; 
  }
  //----------------------------------------------------------------------------
  /**
   *	@brief  @Wp[@̎擾
   *
   *	@param	index   CfbNX
   *
   *	@return Wp[
   */
  //-----------------------------------------------------------------------------
  f32 DepthOfField::GetBackRangePower( s32 index ) const
  { 
    if( index < gfl::grp::g3d::G3DDepthOfFieldSystem::DOF_LAYER_MAX ){
      return m_BackRangePower[index]; 
    }
    GFL_ASSERT( index < gfl::grp::g3d::G3DDepthOfFieldSystem::DOF_LAYER_MAX );
    return m_BackRangePower[0]; 
  }
  //----------------------------------------------------------------------------
  /**
   *	@brief  O@WItZbg@̎擾
   *
   *	@param	index   CfbNX
   *
   *	@return WItZbg
   */
  //-----------------------------------------------------------------------------
  f32 DepthOfField::GetFrontRangeOffs( s32 index ) const
  {
    if( index < gfl::grp::g3d::G3DDepthOfFieldSystem::DOF_LAYER_MAX ){
      return m_FrontRangeOffs[index]; 
    }
    GFL_ASSERT( index < gfl::grp::g3d::G3DDepthOfFieldSystem::DOF_LAYER_MAX );
    return m_FrontRangeOffs[0]; 
  }
  //----------------------------------------------------------------------------
  /**
   *	@brief  O@Wp[@̎擾
   *
   *	@param	index   CfbNX
   *
   *	@return@Wp[
   */
  //-----------------------------------------------------------------------------
  f32 DepthOfField::GetFrontRangePower( s32 index ) const
  {
    if( index < gfl::grp::g3d::G3DDepthOfFieldSystem::DOF_LAYER_MAX ){
      return m_FrontRangePower[index]; 
    }
    GFL_ASSERT( index < gfl::grp::g3d::G3DDepthOfFieldSystem::DOF_LAYER_MAX );
    return m_FrontRangePower[0]; 
  }

} // field
