//=======================================================================================
/**
 * @file IPPSelect.h
 * @briefuPP񕜂ZIvʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.05
 */
//=======================================================================================
#ifndef __PPSELECTBASE_H__
#define __PPSELECTBASE_H__
#include <gflib.h>
#include "AppBase.h"


namespace btl {

  class BTL_PARTY;
  class BattleViewSystem;


  namespace app {

    class IPPSelect : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( IPPSelect );  // Rs[֎~

      public: 


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      IPPSelect( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~IPPSelect();




      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      // ݒ
      struct Setting {
        const BTL_POKEPARAM* btl_param;  // \Ώۂ̃|P
      };

      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting ) = 0;




      //---------------------------------------------------------------------------------
      // 
      //---------------------------------------------------------------------------------
      // I
      enum Result {
        RESULT_RETURN,  //uǂvI
        RESULT_SELECT,  // ZI
        RESULT_NULL,
      };

      /**
       * @brief ʂ擾
       */
      Result GetResult( void ) const;

      /**
       * @brief IZ̃CfbNX擾
       * @note RESULT_SELECT ̏ꍇɂ̂ݗL
       */
      u8 GetSelectedWazaIndex( void ) const;





      protected:
      void SetSetting( const Setting& new_setting ) { m_settings = new_setting; }
      const Setting& GetSetting( void ) const { return m_settings; }
      const BTL_POKEPARAM* GetBtlParam( void ) const { return m_settings.btl_param; }

      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }
      void SetSelectedWazaIndex( u8 index ) { m_selected_waza_index = index; }


      private:
      Setting m_settings;
      Result m_result;
      u8 m_selected_waza_index;
    };


  }  // namespace app
}  // namespace btl


#endif // __PPSELECTBASE_H__ 
