#ifndef __TEST_OHNO_P2PMAC_H__
#define __TEST_OHNO_P2PMAC_H__
//================================================================================
/**
 * @file   test_ohno_p2pmac.h
 * @brief  ŏ̓r[R
           r[RI\
           Iꍇ e@ƂȂڑ҂
           r[R̒Ɏq@ɂȂڑɂ
 * @author k.ohno
 * @date   2011.09.27
 */
//================================================================================
#include <gfl_Heap.h>
#include <gflnet.h>
#include "test_ohno_Base.h"

#include <netapp/gfeachother/GFEachOther.h>
#include "p2p/gflnet_P2pManager.h"

GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)


//class P2pManager;  //wb_[̏ԂővȂ


class TestOhnoP2pMac : public Base {
  GFL_FORBID_COPY_AND_ASSIGN( TestOhnoP2pMac );


  struct TestBeaconStruct{  //eXgpr[R
    int id1;
    int id2;
  };


public:
  TestOhnoP2pMac(
    gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
    gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
    gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager );
  virtual ~TestOhnoP2pMac();
  virtual void UpdateTest( void );
  virtual void DrawTest( void );
private:

  gfl::heap::HeapBase* mpSystemHeap;
  gfl::heap::HeapBase* mpDevHeap;
  u8 mStep;
  gflnet::p2p::P2pManager* mpP2pManager;
  gflnet::p2p::NetGame*  mpNetGame;
  netapp::beacon::GFEachOther* mGFEachOther;
  gflnet::p2p::NetPlayer* mpNetPlayer;

  void initP2p( void );

  u8 mRecvflg[100];
  u8 mBuff[MAC_ADDRESS_SIZE];

  
};



GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)
#endif //__TEST_OHNO_P2PMAC_H__
