//================================================================================
/**
 * @file   test_ohno_p2pmac.cpp
 * @brief  ŏ̓r[R
           r[RI\
           Iꍇ e@ƂȂڑ҂
           r[R̒Ɏq@ɂȂڑɂ
 * @author k.ohno
 * @date   2011.09.27
 */
//================================================================================
#include <nn.h>
#include <gflib.h>
#include <gflnet.h>
#include <gamesystem/GameManager.h>
#include <gamesystem/GameProcManager.h>
#include "test_ohno_p2pmac.h"
#include <system/gfl_use.h>

GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)




//-----------------------------------------------------------------------------
// RXgN^
//-----------------------------------------------------------------------------
TestOhnoP2pMac::TestOhnoP2pMac(
  gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
  gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
  gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager ) :
Base( heap, device_heap, heap_allocator, device_allcator, graphics_system, ui_device_manager )
{

  mpSystemHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  mpDevHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

  TestBeaconStruct tbs = {12,13};

  mGFEachOther = GFL_NEW(mpSystemHeap) netapp::beacon::GFEachOther( mpSystemHeap, mpDevHeap);
  mGFEachOther->Initialize(reinterpret_cast<const u8*>( &tbs ));

  gfl::std::MemClear(mRecvflg,sizeof(mRecvflg));
}


//-----------------------------------------------------------------------------
// fXgN^
//-----------------------------------------------------------------------------
TestOhnoP2pMac::~TestOhnoP2pMac()
{
  GFL_DELETE mGFEachOther;
  GFL_DELETE mpNetGame;
  GFL_DELETE mpP2pManager;
  GFL_DELETE mpNetPlayer;
}


//-----------------------------------------------------------------------------
// C
//-----------------------------------------------------------------------------

enum{
  _START,
  _CONNECT,
  _CONNECT_END,
  _MATCHING,
  _MATCHING_END,
  _LOOP,
  _SHUTDOWN,

};

void TestOhnoP2pMac::UpdateTest( void )
{
  if(mpP2pManager){
    gfl::proc::MainStatus ms = mpP2pManager->NetMain();
  }
  if(mGFEachOther){
    mGFEachOther->Main();
  }


  switch(mStep){
  case _START:
    //r[RWĂ
    for(int i=0;i<100;i++){
      if(mGFEachOther->GetBeacon( i )){
        if(mRecvflg[i] == 0){
          mRecvflg[i] = 1;
          u8* pmac = mGFEachOther->GetBeaconMacAddress( i );
          NN_LOG("new %d = mac%2x%2x%2x%2x%2x%2x\n",i, pmac[0], pmac[1], pmac[2], pmac[3], pmac[4], pmac[5]);
        }
      }
    }
    if( m_button->IsTrigger( gfl::ui::BUTTON_A ) ){
      u8* pmac = mGFEachOther->GetBeaconMacAddress( 0 );
      gfl::std::MemCopy(pmac,mBuff,MAC_ADDRESS_SIZE);
      mGFEachOther->Finalize();
      mStep++;
    }
    else if( m_button->IsTrigger( gfl::ui::BUTTON_B ) ){
      u8* pmac = mGFEachOther->GetBeaconMacAddress( 1 );
      gfl::std::MemCopy(pmac,mBuff,MAC_ADDRESS_SIZE);
      mGFEachOther->Finalize();
      mStep++;
    }
    break;
  case _CONNECT:
    if(mGFEachOther->IsFinalized()){
      mStep++;
    }
    break;
  case _CONNECT_END:
    mStep++;
    break;
  case _MATCHING:
    mpNetPlayer = GFL_NEW(mpSystemHeap) gflnet::p2p::NetPlayer();
    mpNetPlayer->SetMacAddress( mBuff );
    mpNetGame->Initialize();
    mpP2pManager->Matching(NULL);
    mStep++;
    break;
  case _MATCHING_END:
    if(mpP2pManager->IsMatchingEnd()){
      mStep++;
    }
    break;
  case _LOOP:
    /*
    if( mpNetGame->RecvData(0, buff, 100) ){
      NN_LOG("0 M\n");
    }
    if( mpNetGame->RecvData(1, buff, 100) ){
      NN_LOG("1 M\n");
    }
     */
    // START {^ŏI
    if( m_button->IsTrigger( gfl::ui::BUTTON_START ) ){
      mStep++;
      mpP2pManager->Disconnect();
      mpP2pManager->Shutdown();
      mpNetGame->Finalize();
    }
    break;
  case _SHUTDOWN:
    if(mpP2pManager->IsShutdownEnd()){
      this->End();
    }
    NN_LOG("܂\n");
    break;
  }

}



//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void TestOhnoP2pMac::DrawTest( void )
{

}



void TestOhnoP2pMac::initP2p( void )
{
  gflnet::p2p::NETWORK_CONFIG cfg = {
    0,//  u32 maxSilenceTime;
    0,//  u32 keepAliveTimeout;
    0,//  u32 maxWindowMapSize;
    false,//  bool useUserDO;   //IuWFNg Duplicated Object̂
    // lbg[Ng|W֘AB
    nn::nex::NetworkTopology::Peer2Peer,
    false, // bool testRouting;

    // bZ[Woh֘A
    false, //  bool enableMessageBundle;
    0,//  u16  messageBundleFlushDelay;
    0,//  u16  messageBundleFlushCheckPeriod;

    // pPbgoh֘A
    false,//  bool enablePacketBundle;
    0,//  u32  packetBundleFlushDelay;

  };

  mpP2pManager = GFL_NEW(mpSystemHeap) gflnet::p2p::P2pManager( mpSystemHeap,  mpDevHeap, mpSystemHeap );
  mpP2pManager->Initialize( &cfg );

  mStep = 0;

  gflnet::p2p::GameInitialize init;
  init.max = 2;   //ڑMAX
  init.pHeapSystem = mpSystemHeap;  //ʐMŎgHEAPID
  mpNetGame = GFL_NEW( mpSystemHeap ) gflnet::p2p::NetGame(&init);
}

GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)
