//=============================================================================
/**
 * @file btl_item.h
 * @brief ogŎgpACeɃANZX֐Q
 * @author obata_toshihiro
 * @date 2011.09.26
 */
//=============================================================================
#include <gflib.h>
#include <arc/arc_def.h>
#include <item/itemsym.h>
#include <item/btl_item.h>


namespace item {



  // og|Pbgf[^̃obt@
  static void* s_btlpocket_buffer = NULL;
  static const u32 BTLPOCKET_DATASIZE = ( sizeof(u8) * ( ITEM_DATA_MAX + 1 ) );



  //---------------------------------------------------------------------------
  /**
   * @brief ACẽog|Pbgf[^ǂݍ
   * @param heap  obt@mۂɎgpq[v
   *
   * @attention 
   * ǂݍ񂾃f[^̎gpIUnloadBtlPocketData()ŔjĂ.
   */
  //---------------------------------------------------------------------------
  void LoadBtlPocketData( gfl::heap::HeapBase* heap )
  {
    if( s_btlpocket_buffer == NULL )
    {
      gfl::heap::HeapBase* lower_heap = heap->GetLowerHandle();
      s_btlpocket_buffer = GflHeapAllocMemory( lower_heap, BTLPOCKET_DATASIZE );
      gfl::fs::ArcFile arcfile( ARCID_BATTLE_POCKET, lower_heap );
      arcfile.LoadData( GARC_item_battle_pocket_battle_pocket_DAT, s_btlpocket_buffer );
    }
  }


  //---------------------------------------------------------------------------
  /**
   * @brief ǂݍ񂾃ACẽog|Pbgf[^j
   */
  //---------------------------------------------------------------------------
  void UnloadBtlPocketData( void )
  {
    if( s_btlpocket_buffer )
    {
      GflHeapFreeMemory( s_btlpocket_buffer );
      s_btlpocket_buffer = NULL;
    }
  }


  //---------------------------------------------------------------------------
  /**
   * @brief w肵og|Pbgɏ邩ǂ𒲂ׂ
   * @param item    `FbN铹
   * @param pocket  `FbN|Pbg
   * @retval true   item  pocket ɏ
   * @retval false  item  pocket ɏȂ
   *
   * @attention
   * K, LoadBtlPocketData() Ńf[^ǂݍłgpĂ.
   * [h̏ꍇ false Ԃ܂.
   *
   * @note
   * ARCID_BATTLE_POCKET  GARC_item_battle_pocket_battle_pocket_DAT 
   * ̎̂ reousrce/item/item_battle_pocket.dat
   * SẴACeɂ
   * ǂ̃og|Pbgɏ̂8biti[Ă.
   * 0000 0001 ̃rbgĂȂu{[v      |Pbgɏ.
   * 0000 0010 ̃rbgĂȂuƂ悤v|Pbgɏ.
   * 0000 0100 ̃rbgĂȂuHP/PPv       |Pbgɏ.
   * 0000 1000 ̃rbgĂȂuԈُv    |Pbgɏ.
   */
  //---------------------------------------------------------------------------
  bool CheckBtlPocket( u32 item, BtlPocket pocket )
  {
    // og|PbgID
    const u8 BTLPOCKET_ID[ BTLPOCKET_NUM ] = 
    {
      1 << 2,  // HP/PP
      1 << 3,  // Ԉُ
      1 << 0,  // {[
      1 << 1,  // Ƃ悤
    };

    GFL_ASSERT( s_btlpocket_buffer );  // f[^ǂݍ܂ĂȂ
    if( s_btlpocket_buffer == NULL ) {
      return false;
    }

    u8* btlpocket_data = static_cast<u8*>( s_btlpocket_buffer );
    return ( btlpocket_data[ item ] & BTLPOCKET_ID[ pocket ] );
  }


}  // namespace item
