//========================================================================================
/**
 * @brief j[EBhE`NX( Avp )
 * @file app_tool_AppMenuDrawer.cpp
 * @author obata_toshihiro
 * @date 2011.05.26
 */
//========================================================================================
#include <nw.h>
#include "app_tool_MenuWindowDrawer.h"
#include "app_tool_AppMenuDrawer.h"

#include <arc/arc_def.h>
#include <arc/menu_window.gaix>
#include "menu_app.h"
#include "menu_app_pane.h"
#include "menu_field.h"
#include "menu_field_pane.h"


namespace app {
  namespace tool {



    // CAEg̃ZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp AppMenuDrawer::LYT_SETUP_DATA =
    {
      gfl::math::VEC3(0,0,0),   // pos
      gfl::math::VEC2(1,1),     // scale
      gfl::math::VEC3(0,0,0),   // rotate
      1,                        // priority
    };



    // Ajf[^
    const gfl::grp::g2d::LytArcIndex AppMenuDrawer::ANIME_DATA_TABLE[ ANIME_DATA_NUM ] = 
    {
      /* ANIME_DATA_DUMMY_ACTIVE */ LYTRES_MENU_APP_MENU_APP_DUMMY_ACTIVE_BCLAN,
      /* ANIME_DATA_DUMMY_PASSIVE */ LYTRES_MENU_APP_MENU_APP_DUMMY_PASSIVE_BCLAN,
      /* ANIME_DATA_DUMMY_HOLD */ LYTRES_MENU_APP_MENU_APP_DUMMY_HOLD_BCLAN,
      /* ANIME_DATA_DUMMY_RELEASE */ LYTRES_MENU_APP_MENU_APP_DUMMY_RELEASE_BCLAN,
      /* ANIME_DATA_DUMMY_CURSOR_BLINK */ LYTRES_MENU_APP_MENU_APP_DUMMY_CURSOR_BLINK_BCLAN,
      /* ANIME_DATA_DUMMY_CURSOR_SELECT */ LYTRES_MENU_APP_MENU_APP_DUMMY_CUROSR_SELECT_BCLAN,
      /* ANIME_DATA_DUMMY_CURSOR_OFF */ LYTRES_MENU_APP_MENU_APP_DUMMY_CURSOR_OFF_BCLAN,
      /* ANIME_DATA_DUMMY_CURSOR_ON */ LYTRES_MENU_APP_MENU_APP_DUMMY_CURSOR_ON_BCLAN,
    };



    // LAj[VƂ̐ݒ
    const AppMenuDrawer::ShareAnimeDesc 
      AppMenuDrawer::SHARE_ANIME_DESC[ AppMenuDrawer::SHARE_ANIME_NUM ] =
      {
        /* SHARE_ANIME_ALT_ACTIVE */
        {
          ANIME_ALT_ACTIVE,
          ANIME_DATA_DUMMY_ACTIVE,
          MAX_ALT_NUM,
          PANENAME_MENU_APP_GROUP_MASK,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_PASSIVE */
        {
          ANIME_ALT_PASSIVE,
          ANIME_DATA_DUMMY_PASSIVE,
          MAX_ALT_NUM,
          PANENAME_MENU_APP_GROUP_MASK,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_HOLD */
        {
          ANIME_ALT_HOLD,
          ANIME_DATA_DUMMY_HOLD,
          MAX_ALT_NUM,
          PANENAME_MENU_APP_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_RELEASE */
        {
          ANIME_ALT_RELEASE,
          ANIME_DATA_DUMMY_RELEASE,
          MAX_ALT_NUM,
          PANENAME_MENU_APP_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_CURSOR_BLINK */
        {
          ANIME_ALT_CURSOR_BLINK,
          ANIME_DATA_DUMMY_CURSOR_BLINK,
          MAX_ALT_NUM,
          PANENAME_MENU_APP_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_CURSOR_SELECT */
        {
          ANIME_ALT_CURSOR_SELECT,
          ANIME_DATA_DUMMY_CURSOR_SELECT,
          MAX_ALT_NUM,
          PANENAME_MENU_APP_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_CURSOR_OFF */
        {
          ANIME_ALT_CURSOR_OFF,
          ANIME_DATA_DUMMY_CURSOR_OFF,
          MAX_ALT_NUM,
          PANENAME_MENU_APP_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
        /* SHARE_ANIME_ALT_CURSOR_ON */
        {
          ANIME_ALT_CURSOR_ON,
          ANIME_DATA_DUMMY_CURSOR_ON,
          MAX_ALT_NUM,
          PANENAME_MENU_APP_GROUP_CURSOR,
          gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
        },
      };




    // IƂ̐ݒ
    const AppMenuDrawer::AlternativeDesc AppMenuDrawer::ALT_DESC[ MAX_ALT_NUM ] = 
    {
      {
        PANENAME_MENU_APP_PANE_WIN_00,
        PANENAME_MENU_APP_PANE_MASK_00,
        PANENAME_MENU_APP_PANE_CURSOR_00,
        PANENAME_MENU_APP_PANE_LABEL_00,
        PANENAME_MENU_APP_PANE_LEFT_00,
        PANENAME_MENU_APP_PANE_RETURN_00,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 0 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 0 ),
      },
      {
        PANENAME_MENU_APP_PANE_WIN_01,
        PANENAME_MENU_APP_PANE_MASK_01,
        PANENAME_MENU_APP_PANE_CURSOR_01,
        PANENAME_MENU_APP_PANE_LABEL_01,
        PANENAME_MENU_APP_PANE_LEFT_01,
        PANENAME_MENU_APP_PANE_RETURN_01,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 1 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 1 ),
      },
      {
        PANENAME_MENU_APP_PANE_WIN_02,
        PANENAME_MENU_APP_PANE_MASK_02,
        PANENAME_MENU_APP_PANE_CURSOR_02,
        PANENAME_MENU_APP_PANE_LABEL_02,
        PANENAME_MENU_APP_PANE_LEFT_02,
        PANENAME_MENU_APP_PANE_RETURN_02,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 2 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 2 ),
      },
      {
        PANENAME_MENU_APP_PANE_WIN_03,
        PANENAME_MENU_APP_PANE_MASK_03,
        PANENAME_MENU_APP_PANE_CURSOR_03,
        PANENAME_MENU_APP_PANE_LABEL_03,
        PANENAME_MENU_APP_PANE_LEFT_03,
        PANENAME_MENU_APP_PANE_RETURN_03,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 3 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 3 ),
      },
      {
        PANENAME_MENU_APP_PANE_WIN_04,
        PANENAME_MENU_APP_PANE_MASK_04,
        PANENAME_MENU_APP_PANE_CURSOR_04,
        PANENAME_MENU_APP_PANE_LABEL_04,
        PANENAME_MENU_APP_PANE_LEFT_04,
        PANENAME_MENU_APP_PANE_RETURN_04,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 4 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 4 ),
      },
      {
        PANENAME_MENU_APP_PANE_WIN_05,
        PANENAME_MENU_APP_PANE_MASK_05,
        PANENAME_MENU_APP_PANE_CURSOR_05,
        PANENAME_MENU_APP_PANE_LABEL_05,
        PANENAME_MENU_APP_PANE_LEFT_05,
        PANENAME_MENU_APP_PANE_RETURN_05,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 5 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 5 ),
      },
      {
        PANENAME_MENU_APP_PANE_WIN_06,
        PANENAME_MENU_APP_PANE_MASK_06,
        PANENAME_MENU_APP_PANE_CURSOR_06,
        PANENAME_MENU_APP_PANE_LABEL_06,
        PANENAME_MENU_APP_PANE_LEFT_06,
        PANENAME_MENU_APP_PANE_RETURN_06,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 6 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 6 ),
      },
      {
        PANENAME_MENU_APP_PANE_WIN_07,
        PANENAME_MENU_APP_PANE_MASK_07,
        PANENAME_MENU_APP_PANE_CURSOR_07,
        PANENAME_MENU_APP_PANE_LABEL_07,
        PANENAME_MENU_APP_PANE_LEFT_07,
        PANENAME_MENU_APP_PANE_RETURN_07,
        static_cast<AnimeIndex>( ANIME_ALT_ACTIVE + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_PASSIVE + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_HOLD + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_RELEASE + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_BLINK + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_SELECT + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_ON + 7 ),
        static_cast<AnimeIndex>( ANIME_ALT_CURSOR_OFF + 7 ),
      },
    };








    //--------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap             AvP[Vq[v
     * @param device_heap      foCXq[v
     * @param graphics_system  `ɎgpOtBbNXVXe
     * @param layout_system    `Ɏgp郌CAEgVXe
     */
    //--------------------------------------------------------------------------------
    AppMenuDrawer::AppMenuDrawer( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, 
        gfl::grp::GraphicsSystem* graphics_system, gfl::grp::g2d::LytSys* layout_system ) :
      MenuWindowDrawer( heap, device_heap, graphics_system ),
      m_layout_system( layout_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 )
    {
      this->CreateLayoutWork( heap, device_heap, layout_system );
    } 


    /**
     * @brief CAEg[N𐶐
     * @param heap           gpAvP[Vq[v
     * @param device_heap    gpfoCXq[v
     * @param layout_system  CAEgVXe
     */
    void AppMenuDrawer::CreateLayoutWork( 
        gfl::heap::HeapBase* heap, 
        gfl::heap::HeapBase* device_heap,
        gfl::grp::g2d::LytSys* layout_system )
    {
      gfl::heap::NwAllocator nw_device_allocator( device_heap );
      gfl::fs::ArcFile arc_file( ARCID_MENU_WINDOW, true, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          &nw_device_allocator, &arc_file, GARC_menu_window_menu_app_LYTDAT ); 
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id, LYTRES_MENU_APP_MENU_APP_BCLYT, 
          ANIME_DATA_TABLE, ANIME_DATA_NUM, ANIME_NUM,
          &LYT_SETUP_DATA, false );  // Aj[V̓oChȂ

      for( u32 i=0; i<SHARE_ANIME_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIME_DESC[i].start_anime_index,
            ANIME_DATA_TABLE[ SHARE_ANIME_DESC[i].anime_data_index ],
            SHARE_ANIME_DESC[i].max_share_num,
            SHARE_ANIME_DESC[i].share_group_index,
            SHARE_ANIME_DESC[i].share_pane_index );
      } 

      m_layout_work->SetAutoDrawFlag( false );
    }





    //--------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //--------------------------------------------------------------------------------
    AppMenuDrawer::~AppMenuDrawer()
    {
      this->DeleteLayoutWork();
    } 

    /**
     * @brief CAEg[Nj
     */
    void AppMenuDrawer::DeleteLayoutWork( void )
    {
      m_layout_system->RemoveLytWk( m_layout_work );
      m_layout_system->ReleaseLytRes( m_layout_resource_id );
    }




    /**
     * @brief CAEg[N擾
     */
    gfl::grp::g2d::LytWk* AppMenuDrawer::GetLayoutWork( void ) const
    {
      return m_layout_work;
    }



    /**
     * @brief EBhEO[vCfbNX擾
     */
    gfl::grp::g2d::LytPaneIndex AppMenuDrawer::GetWindowPaneGroup( void ) const
    {
      return PANENAME_MENU_APP_GROUP_WIN;
    }

    /**
     * @brief EBhẼyCCfbNX擾
     * @param alt_index  ĨCfbNX
     */
    gfl::grp::g2d::LytPaneIndex AppMenuDrawer::GetWindowPaneIndex( u32 alt_index ) const
    {
      return ALT_DESC[ alt_index ].window_pane;
    }



    /**
     * @brief eyC擾
     * @param alt_index  ĨCfbNX
     */
    gfl::grp::g2d::LytWindow* AppMenuDrawer::GetWindowPane( u32 alt_index ) const
    {
      return m_layout_work->GetWindowPane( ALT_DESC[ alt_index ].window_pane );
    }

    gfl::grp::g2d::LytWindow* AppMenuDrawer::GetMaskPane( u32 alt_index ) const
    {
      return m_layout_work->GetWindowPane( ALT_DESC[ alt_index ].mask_pane );
    }

    gfl::grp::g2d::LytWindow* AppMenuDrawer::GetCursorPane( u32 alt_index ) const
    {
      return m_layout_work->GetWindowPane( ALT_DESC[ alt_index ].cursor_pane );
    }

    gfl::grp::g2d::LytTextBox* AppMenuDrawer::GetLabelPane( u32 alt_index ) const
    {
      return m_layout_work->GetTextBoxPane( ALT_DESC[ alt_index ].label_pane );
    }

    gfl::grp::g2d::LytPane* AppMenuDrawer::GetChildIconPane( u32 alt_index ) const
    {
      return m_layout_work->GetPane( ALT_DESC[ alt_index ].childicon_pane );
    }

    gfl::grp::g2d::LytPane* AppMenuDrawer::GetReturnIconPane( u32 alt_index ) const
    {
      return m_layout_work->GetPane( ALT_DESC[ alt_index ].returnicon_pane );
    }



    /**
     * @brief eAjJn
     * @param alt_index  ĨCfbNX
     */
    void AppMenuDrawer::StartActiveAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].active_anime );
    }

    void AppMenuDrawer::StartPassiveAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].passive_anime );
    }

    void AppMenuDrawer::StartHoldAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].hold_anime );
    }

    void AppMenuDrawer::StartReleaseAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].release_anime );
    }

    void AppMenuDrawer::StartCursorBlinkAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].cursor_blink_anime );
    }

    void AppMenuDrawer::StartCursorSelectAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].cursor_select_anime );
    }

    void AppMenuDrawer::StartCursorOnAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].cursor_on_anime );
    }

    void AppMenuDrawer::StartCursorOffAnime( u32 alt_index )
    {
      this->StartAnime( ALT_DESC[ alt_index ].cursor_off_anime );
    }


    /**
     * @brief eAj~
     * @param alt_index  ĨCfbNX
     */
    void AppMenuDrawer::StopActiveAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].active_anime );
    }

    void AppMenuDrawer::StopPassiveAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].passive_anime );
    }

    void AppMenuDrawer::StopHoldAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].hold_anime );
    }

    void AppMenuDrawer::StopReleaseAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].release_anime );
    }

    void AppMenuDrawer::StopCursorBlinkAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].cursor_blink_anime );
    }

    void AppMenuDrawer::StopCursorSelectAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].cursor_select_anime );
    }

    void AppMenuDrawer::StopCursorOnAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].cursor_on_anime );
    }

    void AppMenuDrawer::StopCursorOffAnime( u32 alt_index )
    {
      this->StopAnime( ALT_DESC[ alt_index ].cursor_off_anime );
    }


    /**
     * @brief Aj[VIǂ𒲂ׂ
     * @param alt_index  Ώۂ̑ICfbNX
     * @retval true   I( ܂͊JnĂȂ )
     * @retval false  IĂȂ( Đ )
     */
    bool AppMenuDrawer::IsReleaseAnimeEnd( u32 alt_index ) const
    {
      AnimeIndex anime = ALT_DESC[ alt_index ].release_anime;
      return !( 
          m_layout_work->IsAnime( anime ) &&
          m_layout_work->IsBindAnime( anime ) &&
          !m_layout_work->IsAnimeEnd( anime ) );
    }

    /**
     * @brief Aj[VJn
     * @param anime  JnAj
     */
    void AppMenuDrawer::StartAnime( AnimeIndex anime )
    {
      if( anime < ANIME_NUM ) {
        m_layout_work->BindAnime( anime );
        m_layout_work->SetAutoAnime( anime, true );
        m_layout_work->SetAnimeFrame( anime, 0 );
      }
    }

    /**
     * @brief Aj[V~
     * @param anime  ~Aj
     */
    void AppMenuDrawer::StopAnime( AnimeIndex anime ) 
    {
      if( anime < ANIME_NUM ) {
        m_layout_work->UnBindAnime( anime );
      }
    }





  } // namespace tool
} // namespace app 
