//=======================================================================================
/**
 * @file PosSelect3.h
 * @briefuꏊ̎Ov
 * @author obata_toshihiro
 * @date 2011.09.23
 */
//=======================================================================================
#ifndef __POSSELECT3_H__
#define __POSSELECT3_H__
#include <gflib.h>
#include <battle/btl_common.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "IPosSelect3.h"


namespace btl {

  class BattleViewSystem;


  namespace app {

    class PosSelect3 : public IPosSelect3
    {
      GFL_FORBID_COPY_AND_ASSIGN( PosSelect3 );  // Rs[֎~

      public:


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap      gpAvP[Vq[v
       * @param device_heap   gpfoCXq[v
       * @param btlv_system   og`RAVXe
       */
      PosSelect3( 
          gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap,
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~PosSelect3(); 


      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting );


      //---------------------------------------------------------------------------------
      // {
      //---------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      virtual void Update( void );

      /**
       * @brief ŏĊJ( ݒ͈p )
       */
      virtual void Restart( void );

      /**
       * @brief I[g`tOZbg
       * @param flag  true Ȃ`悷
       */
      virtual void SetAutoDrawFlag( bool flag );





      private:


      // V[PX
      enum Sequence {
        SEQ_INPUT_WAIT,   // ͑҂
        SEQ_ANIME_WAIT,   // Aj[V҂
        SEQ_FINISH,       // I
        SEQ_NULL,
      };


      // {^ԍ
      enum ButtonIndex {
        BUTTON_LEFT,    // {^
        BUTTON_RIGHT,   // E{^
        BUTTON_CENTER,  // {^
        BUTTON_RETURN,  //uǂv{^
        BUTTON_NUM,
      };


      // \|P
      enum PokeIndex {
        POKE_TARGET,  // Ώۃ|P
        POKE_LEFT,    // |P
        POKE_RIGHT,   // E|P
        POKE_CENTER,  // |P
        POKE_NUM,
      };


      // Aj[Vf[^ԍ
      enum AnimeDataIndex {
        ANIME_DATA_DUMMY_HP_GAUGE,
        ANIME_DATA_DUMMY_BUTTON_HOLD,
        ANIME_DATA_DUMMY_BUTTON_RELEASE,
        ANIME_DATA_DUMMY_BUTTON_SELECT,
        ANIME_DATA_LEFT_POKE_NOT_EXIST,
        ANIME_DATA_LEFT_POKE_EXIST,
        ANIME_DATA_LEFT_BUTTON_ACTIVE,
        ANIME_DATA_LEFT_BUTTON_PASSIVE,
        ANIME_DATA_RIGHT_POKE_NOT_EXIST,
        ANIME_DATA_RIGHT_POKE_EXIST,
        ANIME_DATA_RIGHT_BUTTON_ACTIVE,
        ANIME_DATA_RIGHT_BUTTON_PASSIVE,
        ANIME_DATA_CENTER_POKE_NOT_EXIST,
        ANIME_DATA_CENTER_POKE_EXIST,
        ANIME_DATA_CENTER_BUTTON_ACTIVE,
        ANIME_DATA_CENTER_BUTTON_PASSIVE,
        ANIME_DATA_CURSOR_FLUCTUATE,
        ANIME_DATA_CURSOR_ON_LEFT,
        ANIME_DATA_CURSOR_ON_RIGHT,
        ANIME_DATA_CURSOR_ON_CENTER,
        ANIME_DATA_CURSOR_ON_RETURN,
        ANIME_DATA_T_POKE_SICK,
        ANIME_DATA_T_POKE_DEAD,
        ANIME_DATA_L_POKE_SICK,
        ANIME_DATA_L_POKE_DEAD,
        ANIME_DATA_R_POKE_SICK,
        ANIME_DATA_R_POKE_DEAD,
        ANIME_DATA_C_POKE_SICK,
        ANIME_DATA_C_POKE_DEAD,
        ANIME_DATA_NUM,
      };


      // Aj[Vԍ
      enum AnimeIndex {
        ANIME_DUMMY_HP_GAUGE,
        ANIME_DUMMY_BUTTON_HOLD,
        ANIME_DUMMY_BUTTON_RELEASE,
        ANIME_DUMMY_BUTTON_SELECT,
        ANIME_LEFT_POKE_NOT_EXIST,
        ANIME_LEFT_POKE_EXIST,
        ANIME_LEFT_BUTTON_ACTIVE,
        ANIME_LEFT_BUTTON_PASSIVE,
        ANIME_RIGHT_POKE_NOT_EXIST,
        ANIME_RIGHT_POKE_EXIST,
        ANIME_RIGHT_BUTTON_ACTIVE,
        ANIME_RIGHT_BUTTON_PASSIVE,
        ANIME_CENTER_POKE_NOT_EXIST,
        ANIME_CENTER_POKE_EXIST,
        ANIME_CENTER_BUTTON_ACTIVE,
        ANIME_CENTER_BUTTON_PASSIVE,
        ANIME_CURSOR_FLUCTUATE,
        ANIME_CURSOR_ON_LEFT,
        ANIME_CURSOR_ON_RIGHT,
        ANIME_CURSOR_ON_CENTER,
        ANIME_CURSOR_ON_RETURN,
        ANIME_T_POKE_SICK,
        ANIME_T_POKE_DEAD,
        ANIME_L_POKE_SICK,
        ANIME_L_POKE_DEAD,
        ANIME_R_POKE_SICK,
        ANIME_R_POKE_DEAD,
        ANIME_C_POKE_SICK,
        ANIME_C_POKE_DEAD,
        // ȉ, LAj[V
        ANIME_HP_GAUGE,
        ANIME_BUTTON_HOLD = ANIME_HP_GAUGE + POKE_NUM,
        ANIME_BUTTON_RELEASE = ANIME_BUTTON_HOLD + BUTTON_NUM,
        ANIME_BUTTON_SELECT = ANIME_BUTTON_RELEASE + BUTTON_NUM,
        ANIME_NUM = ANIME_BUTTON_SELECT + BUTTON_NUM,
        ANIME_NULL,
      };


      // LAj[Vԍ
      enum ShareAnimeIndex {
        SHARE_ANIME_HP_GAUSE,
        SHARE_ANIME_BUTTON_HOLD,
        SHARE_ANIME_BUTTON_RELEASE,
        SHARE_ANIME_BUTTON_SELECT,
        SHARE_ANIME_NUM,
      };


      // LAj[VƂ̐ݒ
      struct ShareAnimeDesc {
        AnimeIndex top_anime_index;                     // o^CfbNX
        AnimeDataIndex anime_data_index;                // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };


      // {^Ƃ̐ݒ
      struct ButtonDesc {
        Result result;                           // Iꂽꍇ̌
        gfl::grp::g2d::LytPaneIndex pane_index;  // {^ƂĈyC
        AnimeIndex hold_anime;                   // ꂽۂ̃Aj[V
        AnimeIndex release_anime;                // ꂽۂ̃Aj[V
        AnimeIndex select_anime;                 // I΂ꂽۂ̃Aj[V
        AnimeIndex active_anime;                 // {^Lȍۂ̃Aj[V
        AnimeIndex passive_anime;                // {^ȍۂ̃Aj[V
        AnimeIndex cursor_anime;                 // J[\ZbgAj[V
        u32 select_se;                           // {^Îrd
      };


      // |PƂ̐ݒ
      struct PokeDesc {
        gfl::grp::g2d::LytPaneIndex poke_icon_pane;  // |PACR̃yC
        gfl::grp::g2d::LytPaneIndex item_icon_pane;  // ACR̃yC
        AnimeIndex hp_gauge_anime;                   // HPQ[W̃Aj
        AnimeIndex sick_anime;                       // ԈُACR𑀍삷Aj
        AnimeIndex dead_anime;                       // mԂɂAj
      };



      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE;
      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIME_DATA_TABLE[ ANIME_DATA_NUM ];
      static const ShareAnimeDesc SHARE_ANIME_DESC[ SHARE_ANIME_NUM ];
      static const ButtonDesc BUTTON_DESC[ BUTTON_NUM ];
      static const PokeDesc POKE_DESC[ POKE_NUM ];
      static const ::app::tool::CursorManager::MOVE_DATA CURSOR_MOVE_DATA[ BUTTON_NUM ];

      
      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;
      ::app::tool::ButtonManager* m_button_manager;
      ::app::tool::CursorManager* m_cursor_manager;
      Sequence m_seq;
      Sequence m_next_seq;
      AnimeIndex m_wait_anime_index;


      void InitializeGraphicsSystem( void );
      void SetupFont( void );
      void CreateLayoutWork( void );
      void CreateShareAnime( void );
      void CreateCursorManager( void );
      void CreateButtonManager( void );
      void SetupButtonManager( void ); 

      void FinalizeGraphicsSystem( void );
      void DeleteLayoutWork( void );
      void DeleteCursorManager( void );
      void DeleteButtonManager( void );

      void SetupMessageWindow( void );
      void SetupTargetPoke( void );
      void SetupLeftButton( void );
      void SetupRightButton( void );
      void SetupCenterButton( void );
      void SetupPokeInfo( PokeIndex poke_index, const BTL_POKEPARAM* btlparam );

      void InitSequence( void );
      void InitCursorPos( void );

      void UpdateSequence( void );
      void UpdateSequence_INPUT_WAIT( void );
      void UpdateSequence_ANIME_WAIT( void );
      bool IsButtonSelectedByTouch( void ) const;
      bool IsButtonHolding( void ) const;
      bool IsButtonSelectEnable( ButtonIndex button ) const;
      ButtonIndex GetSelectedButtonByTouch( void ) const;
      void OnButtonSelectedByKey( ButtonIndex selected_button );
      bool UpdateCursorMove( void );
      ButtonIndex GetCurrentCursorPos( void ) const;
      ButtonIndex GetPrevCursorPos( void ) const;
      void OnCursorMoved( ButtonIndex old_pos, ButtonIndex new_pos );
      bool IsWaitAnimeFinished( void ) const;
    };


  }  // namespace app
}  // namespace btl


#endif // __POSSELECT3_H__ 
