//=======================================================================================
/**
 * @file IPosSelect3.h
 * @briefuꏊ̎Ovʂ̃C^[tF[X
 * @author obata_toshihiro
 * @date 2011.09.23
 */
//=======================================================================================
#ifndef __IPOSSELECT3_H__
#define __IPOSSELECT3_H__
#include <gflib.h>
#include "AppBase.h"


namespace btl {

  class BattleViewSystem;


  namespace app {

    class IPosSelect3 : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( IPosSelect3 );  // Rs[֎~

      public: 


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      IPosSelect3( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~IPosSelect3();




      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      struct Setting {
        bool left_enable;                  // {^Ił邩ǂ
        bool right_enable;                 // E{^Ił邩ǂ
        bool center_enable;                // {^Ił邩ǂ
        const BTL_POKEPARAM* target_poke;  // ꏊIΏۃ|P
        const BTL_POKEPARAM* left_poke;    // ɕ\|P( ȂꍇNULL )
        const BTL_POKEPARAM* right_poke;   // Eɕ\|P( ȂꍇNULL )
        const BTL_POKEPARAM* center_poke;  // ɕ\|P( ȂꍇNULL )
      };

      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting ) = 0;




      //---------------------------------------------------------------------------------
      // 
      //---------------------------------------------------------------------------------
      // I
      enum Result {
        RESULT_LEFT,    // I
        RESULT_RIGHT,   // EI
        RESULT_CENTER,  // I
        RESULT_RETURN,  //uǂvI
        RESULT_NULL,
      };

      /**
       * @brief ʂ擾
       */
      Result GetResult( void ) const;






      protected:
      void SetSetting( const Setting& new_setting ) { m_settings = new_setting; }
      const Setting& GetSetting( void ) const { return m_settings; }
      bool IsLeftButtonEnable( void ) const { return m_settings.left_enable; }
      bool IsRightButtonEnable( void ) const { return m_settings.right_enable; }
      bool IsCenterButtonEnable( void ) const { return m_settings.center_enable; }
      const BTL_POKEPARAM* GetTargetPoke( void ) const { return m_settings.target_poke; }
      const BTL_POKEPARAM* GetLeftPoke( void ) const { return m_settings.left_poke; }
      const BTL_POKEPARAM* GetRightPoke( void ) const { return m_settings.right_poke; }
      const BTL_POKEPARAM* GetCenterPoke( void ) const { return m_settings.center_poke; }

      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }


      private:
      Setting m_settings;
      Result m_result;
    };


  }  // namespace app
}  // namespace btl


#endif // __IPOSSELECT3_H__ 
