//=======================================================================================
/**
 * @file PosSelect2.cpp
 * @briefuꏊ̓v
 * @author obata_toshihiro
 * @date 2011.09.23
 */
//=======================================================================================
#include <gflib.h>
#include <sound/SEController.h>
#include <sound/xy_sound.csid>
#include <app/util/app_util.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include <battle/btlv/btlv_core.h>
#include "IPosSelect2.h"
#include "PosSelect2.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "pos_select2.h"
#include "pos_select2_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 PosSelect2::APP_HEAPSIZE    =  0x1000;
    const u32 PosSelect2::DEVICE_HEAPSIZE = 0x60000;



    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp PosSelect2::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };



    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex PosSelect2::ANIME_DATA_TABLE[ PosSelect2::ANIME_DATA_NUM ] = 
    {
      /* ANIME_DATA_DUMMY_HP_GAUGE */ LYTRES_POS_SELECT2_POS_SELECT2_DUMMY_HP_GAUGE_BCLAN,
      /* ANIME_DATA_DUMMY_BUTTON_HOLD */ LYTRES_POS_SELECT2_POS_SELECT2_DUMMY_BUTTON_HOLD_BCLAN,
      /* ANIME_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_POS_SELECT2_POS_SELECT2_DUMMY_BUTTON_RELEASE_BCLAN,
      /* ANIME_DATA_DUMMY_BUTTON_SELECT */ LYTRES_POS_SELECT2_POS_SELECT2_DUMMY_BUTTON_SELECT_BCLAN,
      /* ANIME_DATA_LEFT_POKE_NOT_EXIST */ LYTRES_POS_SELECT2_POS_SELECT2_LEFT_POKE_NOT_EXIST_BCLAN,
      /* ANIME_DATA_LEFT_POKE_EXIST */ LYTRES_POS_SELECT2_POS_SELECT2_LEFT_POKE_EXIST_BCLAN,
      /* ANIME_DATA_LEFT_BUTTON_ACTIVE */ LYTRES_POS_SELECT2_POS_SELECT2_LEFT_BUTTON_ACTIVE_BCLAN,
      /* ANIME_DATA_LEFT_BUTTON_PASSIVE */ LYTRES_POS_SELECT2_POS_SELECT2_LEFT_BUTTON_PASSIVE_BCLAN,
      /* ANIME_DATA_RIGHT_POKE_NOT_EXIST */ LYTRES_POS_SELECT2_POS_SELECT2_RIGHT_POKE_NOT_EXIST_BCLAN,
      /* ANIME_DATA_RIGHT_POKE_EXIST */ LYTRES_POS_SELECT2_POS_SELECT2_RIGHT_POKE_EXIST_BCLAN,
      /* ANIME_DATA_RIGHT_BUTTON_ACTIVE */ LYTRES_POS_SELECT2_POS_SELECT2_RIGHT_BUTTON_ACTIVE_BCLAN,
      /* ANIME_DATA_RIGHT_BUTTON_PASSIVE */ LYTRES_POS_SELECT2_POS_SELECT2_RIGHT_BUTTON_PASSIVE_BCLAN,
      /* ANIME_DATA_CURSOR_FLUCTUATE */ LYTRES_POS_SELECT2_POS_SELECT2_CURSOR_FLUCTUATE_BCLAN,
      /* ANIME_DATA_CURSOR_ON_LEFT */ LYTRES_POS_SELECT2_POS_SELECT2_CURSOR_ON_LEFT_BCLAN,
      /* ANIME_DATA_CURSOR_ON_RIGHT */ LYTRES_POS_SELECT2_POS_SELECT2_CURSOR_ON_RIGHT_BCLAN,
      /* ANIME_DATA_CURSOR_ON_RETURN */ LYTRES_POS_SELECT2_POS_SELECT2_CURSOR_ON_RETURN_BCLAN,
      /* ANIME_DATA_T_POKE_SICK */ LYTRES_POS_SELECT2_POS_SELECT2_T_POKE_SICK_BCLAN,
      /* ANIME_DATA_T_POKE_DEAD */ LYTRES_POS_SELECT2_POS_SELECT2_T_POKE_DEAD_BCLAN,
      /* ANIME_DATA_L_POKE_SICK */ LYTRES_POS_SELECT2_POS_SELECT2_L_POKE_SICK_BCLAN,
      /* ANIME_DATA_L_POKE_DEAD */ LYTRES_POS_SELECT2_POS_SELECT2_L_POKE_DEAD_BCLAN,
      /* ANIME_DATA_R_POKE_SICK */ LYTRES_POS_SELECT2_POS_SELECT2_R_POKE_SICK_BCLAN,
      /* ANIME_DATA_R_POKE_DEAD */ LYTRES_POS_SELECT2_POS_SELECT2_R_POKE_DEAD_BCLAN,
    }; 

    

    // LAj[VƂ̐ݒ
    const PosSelect2::ShareAnimeDesc PosSelect2::SHARE_ANIME_DESC[ PosSelect2::SHARE_ANIME_NUM ] = 
    {
      /* SHARE_ANIME_HP_GAUSE */
      {
        ANIME_HP_GAUGE, 
        ANIME_DATA_DUMMY_HP_GAUGE,
        POKE_NUM,
        PANENAME_POS_SELECT2_GROUP_HP_GAUGE,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_BUTTON_HOLD */
      {
        ANIME_BUTTON_HOLD, 
        ANIME_DATA_DUMMY_BUTTON_HOLD,
        BUTTON_NUM,
        PANENAME_POS_SELECT2_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_BUTTON_RELEASE */
      {
        ANIME_BUTTON_RELEASE, 
        ANIME_DATA_DUMMY_BUTTON_RELEASE,
        BUTTON_NUM,
        PANENAME_POS_SELECT2_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_BUTTON_SELECT */
      {
        ANIME_BUTTON_SELECT, 
        ANIME_DATA_DUMMY_BUTTON_SELECT,
        BUTTON_NUM,
        PANENAME_POS_SELECT2_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };




    // {^Ƃ̐ݒ
    const PosSelect2::ButtonDesc PosSelect2::BUTTON_DESC[ PosSelect2::BUTTON_NUM ] = 
    {
      /* BUTTON_LEFT */ 
      {
        IPosSelect2::RESULT_LEFT,
        PANENAME_POS_SELECT2_PANE_LEFT_BUTTON,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_LEFT ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_LEFT ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_LEFT ),
        ANIME_LEFT_BUTTON_ACTIVE,
        ANIME_LEFT_BUTTON_PASSIVE,
        ANIME_CURSOR_ON_LEFT,
        SEQ_SE_CANCEL2,
      },
      /* BUTTON_RIGHT */ 
      {
        IPosSelect2::RESULT_RIGHT,
        PANENAME_POS_SELECT2_PANE_RIGHT_BUTTON,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_RIGHT ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_RIGHT ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_RIGHT ),
        ANIME_RIGHT_BUTTON_ACTIVE,
        ANIME_RIGHT_BUTTON_PASSIVE,
        ANIME_CURSOR_ON_RIGHT,
        SEQ_SE_CANCEL2,
      },
      /* BUTTON_RETURN */ 
      {
        IPosSelect2::RESULT_RETURN,
        PANENAME_POS_SELECT2_PANE_RETURN_BUTTON,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_RETURN ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_RETURN ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_RETURN ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_RETURN,
        SEQ_SE_CANCEL2,
      },
    };




    // |PƂ̐ݒ
    const PosSelect2::PokeDesc PosSelect2::POKE_DESC[ PosSelect2::POKE_NUM ] = 
    {
      /* POKE_TARGET */
      {
        PANENAME_POS_SELECT2_PANE_POKE_ICON_00,
        PANENAME_POS_SELECT2_PANE_POKE_ITEM_00,
        static_cast<AnimeIndex>( ANIME_HP_GAUGE + POKE_TARGET ),
        ANIME_T_POKE_SICK,
        ANIME_T_POKE_DEAD,
      },
      /* POKE_LEFT */
      {
        PANENAME_POS_SELECT2_PANE_POKE_ICON_01,
        PANENAME_POS_SELECT2_PANE_POKE_ITEM_01,
        static_cast<AnimeIndex>( ANIME_HP_GAUGE + POKE_LEFT ),
        ANIME_L_POKE_SICK,
        ANIME_L_POKE_DEAD,
      },
      /* POKE_RIGHT */
      {
        PANENAME_POS_SELECT2_PANE_POKE_ICON_02,
        PANENAME_POS_SELECT2_PANE_POKE_ITEM_02,
        static_cast<AnimeIndex>( ANIME_HP_GAUGE + POKE_RIGHT ),
        ANIME_R_POKE_SICK,
        ANIME_R_POKE_DEAD,
      },
    };




    // J[\ړf[^
    const ::app::tool::CursorManager::MOVE_DATA 
      PosSelect2::CURSOR_MOVE_DATA[ PosSelect2::BUTTON_NUM ] = 
      {
        /*   id            up             down           left           right  */
        { BUTTON_LEFT,   { BUTTON_LEFT,   BUTTON_RETURN, BUTTON_LEFT,   BUTTON_RIGHT } },
        { BUTTON_RIGHT,  { BUTTON_RIGHT,  BUTTON_RETURN, BUTTON_LEFT,   BUTTON_RIGHT } },
        { BUTTON_RETURN, { BUTTON_RIGHT,  BUTTON_RETURN, BUTTON_RETURN, BUTTON_RETURN } },
      };








    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap          gpAvP[Vq[v
     * @param device_heap   gpfoCXq[v
     * @param btlv_system   og`RAVXe
     */
    //---------------------------------------------------------------------------------
    PosSelect2::PosSelect2( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
        BattleViewSystem* btlv_system ) :
      IPosSelect2( heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, btlv_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager( NULL ),
      m_cursor_manager( NULL ),
      m_seq( SEQ_INPUT_WAIT ),
      m_next_seq( SEQ_INPUT_WAIT ),
      m_wait_anime_index( ANIME_NULL )
    {
      this->InitializeGraphicsSystem();
      this->SetupFont();
      this->CreateLayoutWork();
      this->CreateShareAnime();
      this->CreateCursorManager();
      this->CreateButtonManager();
      this->SetupButtonManager();

#if 0 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_BATTLE_POS_SELECT2: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif
    }


    /**
     * @brief OtBbNXVXe
     */
    void PosSelect2::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    /**
     * @brief tHg̏
     */
    void PosSelect2::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    /**
     * @brief CAEg[N𐶐
     */
    void PosSelect2::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_pos_select2_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_POS_SELECT2_POS_SELECT2_BCLYT,
          ANIME_DATA_TABLE, ANIME_DATA_NUM, ANIME_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ
    }


    /**
     * @brief LAj[V𐶐
     */
    void PosSelect2::CreateShareAnime( void )
    {
      for( u32 i=0; i<SHARE_ANIME_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIME_DESC[i].top_anime_index,
            ANIME_DATA_TABLE[ SHARE_ANIME_DESC[i].anime_data_index ],
            SHARE_ANIME_DESC[i].max_share_num,
            SHARE_ANIME_DESC[i].share_group_index,
            SHARE_ANIME_DESC[i].share_pane_index );
      }
    }


    /**
     * @brief J[\ǗIuWFNg𐶐
     */
    void PosSelect2::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager( CURSOR_MOVE_DATA, BUTTON_NUM, heap, 0 );
    }


    /**
     * @brief {^}l[W𐶐
     */
    void PosSelect2::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIME_NULL );
    }


    /**
     * @brief {^}l[WZbgAbv
     */
    void PosSelect2::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) 
      {
        m_button_manager->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_anime,
            BUTTON_DESC[i].release_anime,
            BUTTON_DESC[i].select_anime,
            BUTTON_DESC[i].active_anime,
            BUTTON_DESC[i].passive_anime,
            NULL );  // R[obNȂ

        m_button_manager->SetButtonSelectSE( i, BUTTON_DESC[i].select_se );
      }
    }








    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    PosSelect2::~PosSelect2()
    {
      this->DeleteCursorManager();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
      this->FinalizeGraphicsSystem();
    } 


    /**
     * @brief J[\ǗIuWFNgj
     */
    void PosSelect2::DeleteCursorManager( void )
    {
      if( m_cursor_manager ) {
        GFL_DELETE m_cursor_manager;
      }
    }


    /**
     * @brief {^}l[Wj
     */
    void PosSelect2::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    /**
     * @brief CAEg[Nj
     */
    void PosSelect2::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    /**
     * @brief OtBbNXVXȅI
     */
    void PosSelect2::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief I[g`tOZbg
     * @param flag  true Ȃ`悷
     */
    //--------------------------------------------------------------------------------- 
    void PosSelect2::SetAutoDrawFlag( bool flag )
    {
      if( m_layout_work ) {
        m_layout_work->SetAutoDrawFlag( flag );
      }
    }






    //---------------------------------------------------------------------------------
    /**
     * @brief ݒύX
     * @param new_setting  Vݒ
     */
    //---------------------------------------------------------------------------------
    void PosSelect2::ChangeSetting( const Setting& new_setting )
    {
      this->SetSetting( new_setting ); 
      this->SetupMessageWindow();
      this->SetupTargetPoke();
      this->SetupLeftButton();
      this->SetupRightButton();
    } 


    /**
     * @brief bZ[WEBhẼZbgAbv
     */
    void PosSelect2::SetupMessageWindow( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetTargetPoke();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      gfl::str::MsgData* message_data = AppBase::GetMessageData(); 
      gfl::str::StrBuf* src_strbuf = ::app::util::GetTempStrBuf( 0 );
      gfl::str::StrBuf* expand_strbuf = ::app::util::GetTempStrBuf( 1 );
      WordSet* wordset = ::app::util::GetWordset();

      message_data->GetString( str_btl_pos_00, *src_strbuf );
      wordset->RegisterPokeNickName( 0, pokeparam );
      wordset->Expand( expand_strbuf, src_strbuf ); 
      ::app::util::SetTextboxPaneString( 
          m_layout_work, PANENAME_POS_SELECT2_PANE_MESSAGE, expand_strbuf );
    }


    /**
     * @brief Ώۃ|P̕\ZbgAbv
     */
    void PosSelect2::SetupTargetPoke( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetTargetPoke();
      const pml::pokepara::PokemonParam* pokeparam = btlparam->GetSrcData();
      gfl::str::StrBuf* strbuf = ::app::util::GetTempStrBuf( 0 ); 
      pokeparam->GetNickName( strbuf );
      ::app::util::SetTextboxPaneString( 
          m_layout_work, PANENAME_POS_SELECT2_PANE_POKE_NAME_00, strbuf );
      this->SetupPokeInfo( POKE_TARGET, btlparam );
    }


    /**
     * @brief {^ZbgAbv
     */
    void PosSelect2::SetupLeftButton( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetLeftPoke();

      if( btlparam ) {
        ::app::util::StopAnimation( m_layout_work, ANIME_LEFT_POKE_NOT_EXIST );
        ::app::util::StartAnimation( m_layout_work, ANIME_LEFT_POKE_EXIST );
        this->SetupPokeInfo( POKE_LEFT, btlparam );
      }
      else {
        ::app::util::StopAnimation( m_layout_work, ANIME_LEFT_POKE_EXIST );
        ::app::util::StartAnimation( m_layout_work, ANIME_LEFT_POKE_NOT_EXIST );
      }

      if( this->IsLeftButtonEnable() ) {
        m_button_manager->SetButtonActive( BUTTON_LEFT );
      }
      else {
        m_button_manager->SetButtonPassive( BUTTON_LEFT );
      }
    }


    /**
     * @brief E{^ZbgAbv
     */
    void PosSelect2::SetupRightButton( void )
    {
      const BTL_POKEPARAM* btlparam = this->GetRightPoke();

      if( btlparam ) {
        ::app::util::StopAnimation( m_layout_work, ANIME_RIGHT_POKE_NOT_EXIST );
        ::app::util::StartAnimation( m_layout_work, ANIME_RIGHT_POKE_EXIST );
        this->SetupPokeInfo( POKE_RIGHT, btlparam );
      }
      else {
        ::app::util::StopAnimation( m_layout_work, ANIME_RIGHT_POKE_EXIST );
        ::app::util::StartAnimation( m_layout_work, ANIME_RIGHT_POKE_NOT_EXIST );
      }

      if( this->IsRightButtonEnable() ) {
        m_button_manager->SetButtonActive( BUTTON_RIGHT );
      }
      else {
        m_button_manager->SetButtonPassive( BUTTON_RIGHT );
      }
    } 


    /**
     * @brief |P̕\ZbgAbv
     * @param poke_index  ZbgAbvΏۂ̃|PCfbNX
     * @param btlparam    \|Pp[^
     */
    void PosSelect2::SetupPokeInfo( PokeIndex poke_index, const BTL_POKEPARAM* btlparam )
    {
      // ACeACR
      u32 itemno = btlparam->GetItem();
      if( itemno == ITEM_DUMMY_DATA ) {
        ::app::util::SetPaneInvisible( m_layout_work, POKE_DESC[ poke_index ].item_icon_pane );
      }
      else {
        ::app::util::SetPaneVisible( m_layout_work, POKE_DESC[ poke_index ].item_icon_pane );
      }

      // HPQ[W
      u32 max_hp = btlparam->GetValue( BTL_POKEPARAM::BPP_MAX_HP );
      u32 now_hp = btlparam->GetValue( BTL_POKEPARAM::BPP_HP );
      u32 gauge_frame = ::app::tool::Gauge::GetDottoNum( now_hp, max_hp, 100 );  // ő100t[
      AnimeIndex gauge_anime = POKE_DESC[ poke_index ].hp_gauge_anime;
      ::app::util::StartAnimation( m_layout_work, gauge_anime );
      ::app::util::PauseAnimation( m_layout_work, gauge_anime, false );
      ::app::util::SetAnimationFrame( m_layout_work, gauge_anime, gauge_frame );

      // ԈُACR
      if( btlparam->IsDead() ) {
        ::app::util::StartAnimation( m_layout_work, POKE_DESC[ poke_index ].dead_anime );
        ::app::util::StopAnimation( m_layout_work, POKE_DESC[ poke_index ].sick_anime );
      }
      else { 
        pml::pokepara::Sick sick = btlparam->GetPokeSick();
        ::app::util::StopAnimation( m_layout_work, POKE_DESC[ poke_index ].dead_anime );
        ::app::util::StartAnimation( m_layout_work, POKE_DESC[ poke_index ].sick_anime );
        ::app::util::PauseAnimation( m_layout_work, POKE_DESC[ poke_index ].sick_anime, false );
        ::app::util::SetAnimationFrame( m_layout_work, POKE_DESC[ poke_index ].sick_anime, sick );
      }
    }






    //---------------------------------------------------------------------------------
    /**
     * @brief ŏĊJ( ݒ͈p )
     */
    //---------------------------------------------------------------------------------
    void PosSelect2::Restart( void )
    {
      this->ResetFinishFlag();
      this->ResetResult();
      this->InitSequence();
      this->InitCursorPos();
    } 

    /**
     * @brief V[PX
     */
    void PosSelect2::InitSequence( void )
    {
      m_seq = SEQ_INPUT_WAIT;
      m_next_seq = SEQ_INPUT_WAIT;
      m_wait_anime_index = ANIME_NULL;
    } 

    /**
     * @brief J[\ʒu
     */
    void PosSelect2::InitCursorPos( void )
    {
      ButtonIndex pos = BUTTON_LEFT;
      for( u8 i=0; i<BUTTON_NUM; i++ ) {
        ::app::util::StopAnimation( m_layout_work, BUTTON_DESC[i].cursor_anime );
      } 
      m_cursor_manager->SetPos( pos );
      ::app::util::StartAnimation( m_layout_work, BUTTON_DESC[ pos ].cursor_anime );
      ::app::util::StartAnimation( m_layout_work, ANIME_CURSOR_FLUCTUATE );
    }








    //---------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //---------------------------------------------------------------------------------
    void PosSelect2::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 
    } 

    /**
     * @brief V[PXXV
     */
    void PosSelect2::UpdateSequence( void )
    { 
      switch( m_seq )
      {
      case SEQ_INPUT_WAIT:
        this->UpdateSequence_INPUT_WAIT();
        break; 

      case SEQ_ANIME_WAIT:
        this->UpdateSequence_ANIME_WAIT();
        break; 

      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
        break; 
      }
    }



    //=================================================================================
    /**
     * @brief V[PXXV( ͑҂ )
     */
    //=================================================================================
    void PosSelect2::UpdateSequence_INPUT_WAIT( void )
    {
      const gfl::ui::Button* ui_button = this->GetButton();

      if( this->IsButtonSelectedByTouch() ) {
        ButtonIndex selected_button = this->GetSelectedButtonByTouch();
        this->SetResult( BUTTON_DESC[ selected_button ].result );
        m_wait_anime_index = BUTTON_DESC[ selected_button ].select_anime;
        m_seq = SEQ_ANIME_WAIT;
        m_next_seq = SEQ_FINISH;
      }
      else if( this->IsButtonHolding() ) {
        // do nothing
      }
      else if( ui_button->IsTrigger( gfl::ui::BUTTON_B ) ) {
        if( this->IsButtonSelectEnable( BUTTON_RETURN ) ) {
          this->OnButtonSelectedByKey( BUTTON_RETURN );
          this->SetResult( BUTTON_DESC[ BUTTON_RETURN ].result );
          m_wait_anime_index = BUTTON_DESC[ BUTTON_RETURN ].select_anime;
          m_seq = SEQ_ANIME_WAIT;
          m_next_seq = SEQ_FINISH;
        }
      }
      else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
        ButtonIndex cursor_pos = this->GetCurrentCursorPos();
        if( this->IsButtonSelectEnable( cursor_pos ) ) {
          this->OnButtonSelectedByKey( cursor_pos );
          this->SetResult( BUTTON_DESC[ cursor_pos ].result );
          m_wait_anime_index = BUTTON_DESC[ cursor_pos ].select_anime;
          m_seq = SEQ_ANIME_WAIT;
          m_next_seq = SEQ_FINISH;
        }
      }
      else if( this->UpdateCursorMove() ) {  // J[\ړ
        ButtonIndex old_cursor_pos = this->GetPrevCursorPos();
        ButtonIndex new_cursor_pos = this->GetCurrentCursorPos();
        this->OnCursorMoved( old_cursor_pos, new_cursor_pos );
      }
    }

    /**
     * @brief ^b`͂ɂ{^Iꂽǂ𒲂ׂ
     * @retval true   Iꂽ
     * @retval false  IĂȂ
     */
    bool PosSelect2::IsButtonSelectedByTouch( void ) const
    {
      return m_button_manager->IsButtonSelected();
    }

    /**
     * @brief ^b`͂ɂIꂽ{^擾
     */
    PosSelect2::ButtonIndex PosSelect2::GetSelectedButtonByTouch( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetSelectedButtonId() );
    }

    /**
     * @brief {^^b`Ă邩ǂ𒲂ׂ
     * @retval true   ^b`Ă
     * @retval false  ^b`ĂȂ
     */
    bool PosSelect2::IsButtonHolding( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    /**
     * @brief {^I\ǂ𒲂ׂ
     * @param button  `FbN{^
     * @retval true   Ił
     * @retval false  IłȂ
     */
    bool PosSelect2::IsButtonSelectEnable( ButtonIndex button ) const
    {
      return m_button_manager->IsButtonActive( button );
    } 

    /**
     * @brief L[͂ɂ{^Iꂽۂ̏
     * @param selected_button  Iꂽ{^
     */
    void PosSelect2::OnButtonSelectedByKey( ButtonIndex selected_button )
    {
      m_button_manager->StartSelectedAct( selected_button );
    } 

    /**
     * @brief J[\̓XV
     * @retval true   J[\ړ
     * @retval false  J[\ړȂ
     */
    bool PosSelect2::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 

    /**
     * @brief ÕJ[\ʒu擾
     */
    PosSelect2::ButtonIndex PosSelect2::GetPrevCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetOldID() );
    }

    /**
     * @brief ݂̃J[\ʒu擾
     */
    PosSelect2::ButtonIndex PosSelect2::GetCurrentCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetID() );
    } 

    /**
     * @brief J[\ړۂ̏
     * @param old_pos  ړÕJ[\ʒu
     * @param new_pos  ړ̃J[\ʒu
     */
    void PosSelect2::OnCursorMoved( ButtonIndex old_pos, ButtonIndex new_pos )
    {
      ::app::util::StopAnimation( m_layout_work, BUTTON_DESC[ old_pos ].cursor_anime );
      ::app::util::StartAnimation( m_layout_work, BUTTON_DESC[ new_pos ].cursor_anime );
      snd::SEController::PlaySE( SEQ_SE_SELECT2 );
    }




    //=================================================================================
    /**
     * @brief V[PXXV( AjI҂ )
     */
    //=================================================================================
    void PosSelect2::UpdateSequence_ANIME_WAIT( void )
    {
      if( this->IsWaitAnimeFinished() ) {
        m_seq = m_next_seq;
      }
    } 

    /**
     * @brief ȊIAj[VIǂ𒲂ׂ
     * @retval true   I
     * @retval false  IĂȂ
     */
    bool PosSelect2::IsWaitAnimeFinished( void ) const
    {
      if( m_wait_anime_index < ANIME_NUM ) {
        return ::app::util::IsAnimationEnd( m_layout_work, m_wait_anime_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    } 





  }  // namespace app
}  // namespace btl
