//=======================================================================================
/**
 * @file	btlv_ui_yesno.h
 * @brief	퓬ʁuґvʃV[PX
 * @author obata
 * @data 2011.09.23
 */
//=======================================================================================
#ifndef __BTLVUIYESNO_H__
#define __BTLVUIYESNO_H__
#include "app/YesNo.h"


namespace btl {

  class BattleViewSystem;
  class BtlvUi; 


  class BtlvUiYesno
  {
    public:
      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param core  `RAVXe
       * @param ui    UIVXe
       */
      BtlvUiYesno( BattleViewSystem* core, BtlvUi* ui );

      /**
       * @brief fXgN^
       */
      virtual ~BtlvUiYesno();



      //---------------------------------------------------------------------------------
      // Ej
      //---------------------------------------------------------------------------------
      /**
       * @brief 
       */
      void Create( void );

      /**
       * @brief j
       */
      void Delete( void );



      //---------------------------------------------------------------------------------
      // {
      //---------------------------------------------------------------------------------
      /**
       * @brief I[h
       */
      enum Mode {
        MODE_YESNO,      //u͂v              uv
        MODE_NEXT_POKE,  //ũ|Pgvuɂv
        MODE_FORGET,     //u킷ꂳv      u킷ꂳȂv
      }; 

      /**
       * @brief IJn
       * @param mode  I[h
       */
      void Start( Mode mode );

      /**
       * @brief XV
       */
      void Update( void ); 

      /**
       * @brief IIǂ𒲂ׂ
       * @retval true   I
       * @retval false  ܂IĂȂ
       */
      bool IsFinished( void ) const;



      //--------------------------------------------------------------------------------- 
      // 
      //--------------------------------------------------------------------------------- 
      enum Result {
        RESULT_YES,   //u͂vI
        RESULT_NO,    //uvI
        RESULT_NONE,
      };
      /**
       * @brief Iʂ擾
       */
      Result GetResult( void ) const;




    private: 

      // 
      enum State {
        STATE_CLOSE,  // Ă
        STATE_YESNO,  // 
      };


      BattleViewSystem* m_btlv_core;
      BtlvUi* m_btlv_ui; 
      btl::app::AppBase* m_now_app;
      btl::app::YesNo* m_yesno;
      State m_now_state;
      State m_prev_state; 
      Result m_result;         // I


      void CreateYesNo( void );
      void DeleteYesNo( void );
      void UpdateYesNo( void );

      void UpdateYesNoSetting( Mode mode );

      void OnAppFinished( void );
      void ChangeState( State next_state );
  };


}  // namespace btl 



#endif //__BTLV_UI_YESNO_H__
