//=======================================================================================
/**
 * @file	btlv_ui_yesno.h
 * @brief	퓬ʁuґvʃV[PX
 * @author	obata
 * @data 2011.09.23
 */
//=======================================================================================
#include <gflib.h>
#include <savedata/sv_myitem.h>
#include "btlv_core.h"
#include "btlv_types.h"
#include "btlv_ui.h"
#include "btlv_ui_yesno.h"

#include "app/AppBase.h"
#include "app/YesNo.h"


namespace btl { 




  //---------------------------------------------------------------------------------
  /**
   * @brief RXgN^
   * @param core  `RAVXe
   * @param ui    UIVXe
   */
  //---------------------------------------------------------------------------------
  BtlvUiYesno::BtlvUiYesno( BattleViewSystem* core, BtlvUi* ui ) :
    m_btlv_core( core ),
    m_btlv_ui( ui ),
    m_now_app( NULL ),
    m_yesno( NULL ),
    m_now_state( STATE_CLOSE ),
    m_prev_state( STATE_CLOSE ),
    m_result( RESULT_NONE )
  {
  }



  //---------------------------------------------------------------------------------
  /**
   * @brief fXgN^
   */
  //---------------------------------------------------------------------------------
  BtlvUiYesno::~BtlvUiYesno()
  {
  }






  //---------------------------------------------------------------------------------
  /**
   * @brief 
   */
  //---------------------------------------------------------------------------------
  void BtlvUiYesno::Create( void )
  {
    this->CreateYesNo();
    m_yesno->SetAutoDrawFlag( false );
  }

  /**
   * @brief ʂ𐶐
   */
  void BtlvUiYesno::CreateYesNo( void )
  {
    GFL_ASSERT( !m_yesno );
    if( !m_yesno ) {
      gfl::heap::HeapBase* heap = m_btlv_core->GetHeapMem();
      gfl::heap::HeapBase* device_heap = m_btlv_core->GetDeviceMem();
      m_yesno = GFL_NEW( heap ) btl::app::YesNo( heap, device_heap, m_btlv_core );
    } 
  }





  //---------------------------------------------------------------------------------
  /**
   * @brief j
   */
  //---------------------------------------------------------------------------------
  void BtlvUiYesno::Delete( void )
  {
    this->DeleteYesNo();
  }

  /**
   * @brief ʂj
   */
  void BtlvUiYesno::DeleteYesNo( void )
  {
    if( m_yesno ) {
      GFL_DELETE m_yesno;
      m_yesno = NULL;
    }
  }








  //--------------------------------------------------------------------------------- 
  /**
   * @brief IJn
   * @param mode  I[h
   */
  //--------------------------------------------------------------------------------- 
  void BtlvUiYesno::Start( Mode mode )
  {
    m_now_app = m_yesno;
    this->ChangeState( STATE_YESNO );

    this->UpdateYesNoSetting( mode );
    m_yesno->SetAutoDrawFlag( true );
    m_yesno->Restart();
  } 

  /**
   * @brief ʂ̓ݒXV
   * @param mode  I[h
   */
  void BtlvUiYesno::UpdateYesNoSetting( Mode mode )
  {
    switch( mode ) {
    case MODE_YESNO:
      m_yesno->ChangeMode( app::YesNo::MODE_YESNO );
      break;
    case MODE_NEXT_POKE:
      m_yesno->ChangeMode( app::YesNo::MODE_NEXT_POKE );
      break;
    case MODE_FORGET:
      m_yesno->ChangeMode( app::YesNo::MODE_FORGET );
      break;
    }
  }






  //--------------------------------------------------------------------------------- 
  /**
   * @brief IIǂ𒲂ׂ
   * @retval true   I
   * @retval false  ܂IĂȂ
   */
  //--------------------------------------------------------------------------------- 
  bool BtlvUiYesno::IsFinished( void ) const
  {
    return ( m_now_state == STATE_CLOSE );
  }

  //--------------------------------------------------------------------------------- 
  /**
   * @brief Iʂ擾
   */
  //--------------------------------------------------------------------------------- 
  BtlvUiYesno::Result BtlvUiYesno::GetResult( void ) const
  {
    return m_result;
  }








  //--------------------------------------------------------------------------------- 
  /**
   * @brief XV
   */
  //--------------------------------------------------------------------------------- 
  void BtlvUiYesno::Update( void )
  {
    if( m_now_app == NULL ) {
      return;
    }

    m_now_app->Update();
    if( m_now_app->IsFinished() ) 
    {
      // Iʂ\ɂ
      if( m_now_app ) {  
        m_now_app->SetAutoDrawFlag( false );
      }

      this->OnAppFinished();

      // Vʂ\
      if( m_now_app ) {  
        m_now_app->SetAutoDrawFlag( true );
        m_now_app->Restart();
      }
    }
  } 


  /**
   * @brief eʂIۂ̏
   * @note ̏Ԃ̌, XgJڂ̌ʂ̌s
   */
  void BtlvUiYesno::OnAppFinished( void )
  { 
    switch( m_now_state )
    {
    case STATE_YESNO:  // 
      switch( m_yesno->GetResult() ) {
      case app::YesNo::RESULT_YES:  //u͂vI
        this->ChangeState( STATE_CLOSE );
        m_now_app = NULL;
        m_result = RESULT_YES;
        break;
      case app::YesNo::RESULT_NO:  //uvI
        this->ChangeState( STATE_CLOSE );
        m_now_app = NULL;
        m_result = RESULT_NO;
        break;
      }
      break;
    }
  } 


  /**
   * @brief ԂύX
   * @param next_state  ̏
   */
  void BtlvUiYesno::ChangeState( State next_state )
  {
    m_prev_state = m_now_state;
    m_now_state = next_state;
  } 



}  // namespace btl 
