//============================================================================================
/**
 * @file		pss_profile_main.h
 * @brief		C
 * @author	Hiroyuki Nakamura
 * @date		11.09.22
 *
 * namespace	app::pss_profile::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#pragma	once

#include "app/pss_profile/pss_profile.h"
#include "pss_profile_heap.h"
#include "pss_profile_2d.h"
#include "pss_profile_ui.h"


namespace app {
namespace pss_profile {

// Tu[NiʑJڎɉj
typedef struct {
	gfl::grp::GraphicsSystem * pGraSystem;
	G2DSystem * pG2d;
	UI * ui;
}SUB_WORK;

// C[N
typedef struct {
	APP_PARAM * prm;

	int	mainSeq;
	int	nextSeq;
	int	fadeNextSeq;
}MAIN_WORK;


class MainSystem {
public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		prm		Oݒp[^
	 */
	//--------------------------------------------------------------------------------------------
	MainSystem( APP_PARAM * prm );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~MainSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @retval	"true = "
	 * @retval	"false = ȊO"
	 */
	//--------------------------------------------------------------------------------------------
	bool Update(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`揈
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw(void);

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateSubWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteSubWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		OtBbNVXe쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateGraphicsSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		OtBbNVXe폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteGraphicsSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		tF[hCZbg
	 *
	 * @param		next		tF[h̃V[PX
	 *
	 * @return	MAINSEQ_FADE
	 */
	//--------------------------------------------------------------------------------------------
	int SetFadeIn( int next );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		tF[hAEgZbg
	 *
	 * @param		next		tF[h̃V[PX
	 *
	 * @return	MAINSEQ_FADE
	 */
	//--------------------------------------------------------------------------------------------
	int SetFadeOut( int next );

// CV[PX
public:
	int MainSeq_Init(void);
	int MainSeq_Release(void);
	int MainSeq_Fade(void);
	int MainSeq_Main(void);

private:
	MAIN_WORK	mainWork;		// C[N
	SUB_WORK * subWork;
	Heap	heap;
};

}		// pss_profile
}		// app
