//============================================================================================
/**
 * @file		pss_profile_main.cpp
 * @brief		C
 * @author	Hiroyuki Nakamura
 * @date		11.09.22
 *
 * namespace	app::pss_profile::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "pss_profile_main.h"
#include "pss_profile_ui.h"
#include "pss_profile_res.h"
#include "pss_profile_res_pane.h"


namespace app {
namespace pss_profile {


//============================================================================================
//	萔`
//============================================================================================
// CV[PX`
enum {
	MAINSEQ_INIT = 0,
	MAINSEQ_RELEASE,
	MAINSEQ_FADE,
	MAINSEQ_MAIN,
	MAINSEQ_END
};

typedef int (MainSystem::*pSeqFunc)(void);

#define	PSS_PROFILE_FADE_SYNC		( 8 )

enum {
	PSS_PROFILE_LAYOUT_ID_UPPER = 0,
	PSS_PROFILE_LAYOUT_ID_LOWER,
	PSS_PROFILE_LAYOUT_ID_MAX,
};


// CV[PX֐e[u
static const pSeqFunc MainSeq[] = {
	&MainSystem::MainSeq_Init,
	&MainSystem::MainSeq_Release,
	&MainSystem::MainSeq_Fade,
	&MainSystem::MainSeq_Main,
};


static const LYTWK_DATA PssProfileLayoutData[] =
{
	{	// 
		LYTRES_PSS_PROFILE_RES_PROFILE_UPPER_BCLYT,	// resID̃CAEgf[^ID
		NULL,																				// Aj[Vf[^IDe[u	AĵȂꍇNULL
		0,																					// Aj[Vf[^IDe[u AĵȂꍇ0
		0,																					// o^Aj[Vő吔
		SETUP_UPPER,																// fBXvC
		true,																				// \ݒ
	},
	{	// 
		LYTRES_PSS_PROFILE_RES_PROFILE_LOWER_BCLYT,
		NULL,
		0,
		0,
		SETUP_LOWER,
		true,
	},
};



//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		prm		Oݒp[^
 */
//--------------------------------------------------------------------------------------------
MainSystem::MainSystem( APP_PARAM * prm )
{
	mainWork.prm = prm;
	mainWork.mainSeq = MAINSEQ_INIT;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
MainSystem::~MainSystem(void)
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @retval	"true = "
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool MainSystem::Update(void)
{
	MAIN_WORK * mwk = &mainWork;

	mwk->mainSeq = (this->*MainSeq[mwk->mainSeq])();

	if( mwk->mainSeq == MAINSEQ_END ){
		return false;
	}

	subWork->pG2d->Update();

	return true;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`揈
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::Draw(void)
{
	MAIN_WORK * mwk = &mainWork;

	if( mwk->mainSeq == MAINSEQ_END ){
		return;
	}
	subWork->pG2d->Draw( PSS_PROFILE_LAYOUT_ID_UPPER );
	subWork->pG2d->Draw( PSS_PROFILE_LAYOUT_ID_LOWER );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::CreateSubWork(void)
{
	heap.Create();

	subWork = GFL_NEW( heap.Get() )	SUB_WORK;

	subWork->ui = GFL_NEW( heap.Get() )	UI( &heap );

	CreateGraphicsSystem();
	subWork->pG2d = GFL_NEW( heap.Get() )	G2DSystem( subWork->pGraSystem, PSS_PROFILE_LAYOUT_ID_MAX, &heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::DeleteSubWork(void)
{
	GFL_DELETE	subWork->pG2d;
	DeleteGraphicsSystem();

	GFL_DELETE	subWork->ui;
	GFL_DELETE	subWork;

	heap.Delete();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		OtBbNVXe쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::CreateGraphicsSystem(void)
{
	gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	subWork->pGraSystem = gm->GetGraphicsSystem();
	subWork->pGraSystem->InitializeApplicationMemory( heap.GetDeviceAllocator() );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		OtBbNVXe폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::DeleteGraphicsSystem(void)
{
	subWork->pGraSystem->FinalizeApplicationMemory();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hCZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	MAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::SetFadeIn( int next )
{
	gfl::math::VEC4	col( 0.0f, 0.0f, 0.0f, 1.0f );
	gfl::grp::Fade_ForceOut( gfl::grp::Fade::DISP_DOUBLE, &col );
	gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, PSS_PROFILE_FADE_SYNC );
	mainWork.fadeNextSeq = next;
	return MAINSEQ_FADE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hAEgZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	MAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::SetFadeOut( int next )
{
	gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_BLACK, PSS_PROFILE_FADE_SYNC, false );
	mainWork.fadeNextSeq = next;
	return MAINSEQ_FADE;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_INIT
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Init(void)
{
	CreateSubWork();

	subWork->pG2d->SetLayoutWork( PssProfileLayoutData, PSS_PROFILE_LAYOUT_ID_UPPER, GFL_NELEMS(PssProfileLayoutData) );

	return SetFadeIn( MAINSEQ_MAIN );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_RELEASE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Release(void)
{
	DeleteSubWork();

	return mainWork.nextSeq;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Fade(void)
{
	if( gfl::grp::Fade_IsEnd() == true ){
		return mainWork.fadeNextSeq;
	}
	return MAINSEQ_FADE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFC
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_MAIN
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Main(void)
{
	if( subWork->ui->DEBUG_GetEndButton() == true ){
		mainWork.nextSeq = MAINSEQ_END;
		return SetFadeOut( MAINSEQ_RELEASE );
	}
	return MAINSEQ_MAIN;
}


}		// pss_profile
}		// app

