//============================================================================================
/**
 * @file		kawaigari_2d.h
 * @brief		킢 2D֘A
 * @author	Hiroyuki Nakamura
 * @date		11.09.20
 *
 * namespace	kawaigari::
 */
//============================================================================================
#pragma	once

#include <gflib.h>
#include <gfl_Device.h>


namespace kawaigari {

class G2DSystem {
public:

	// CAEgID
	enum {
		LAYOUT_ID_ICON = 0,	// ACR
		LAYOUT_ID_MENU,			// j[
		LAYOUT_ID_MAX
	};

	// {^̖߂l
	enum {
		GSM_BUTTON_SELECT_NONE = 0,			// I
		GSM_BUTTON_SELECT_FOOD_BUTTON,	// Hו{^
		GSM_BUTTON_SELECT_END_BUTTON,		// I{^
		GSM_BUTTON_SELECT_GAME_BUTTON,	// Q[{^
		GSM_BUTTON_SELECT_GAME,					// Q[I
		GSM_BUTTON_SELECT_GAME_CANCEL,	// LZ
	};

	// ACRID
	enum {
		ICON_ID_TAP = 0,				// ^bv
		ICON_ID_HIT,						// qbg
		ICON_ID_STOP_POINT,			// wJ[\iAjȂj
		ICON_ID_ANIME_POINT,		// wJ[\iAjj
		ICON_ID_OPEN_HAND,			// J[\
		ICON_ID_SHOCK,					// rr
	};

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		gra										OtBbNVXe
	 * @param		heap									q[v
	 * @param		deviceHeap						foCXq[v
	 * @param		heapAllocator					q[vAP[^
	 * @param		deviceHeapAllocator		foCXq[vAP[^
	 */
	//--------------------------------------------------------------------------------------------
	G2DSystem(
		gfl::grp::GraphicsSystem * gra,
		gfl::heap::HeapBase * heap,
		gfl::heap::HeapBase * deviceHeap,
		gfl::heap::NwAllocator * heapAllocator,
		gfl::heap::NwAllocator * deviceHeapAllocator );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~G2DSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Update(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg`
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg\ݒ
	 *
	 * @param		id			CAEgID
	 * @param		flg			true = \, false = \
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetLayoutDrawEnable( u32 id, bool flg );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg\Ԏ擾
	 *
	 * @param		id			CAEgID
	 *
	 * @retval	"true = \"
	 * @retval	"false = \"
	 */
	//--------------------------------------------------------------------------------------------
	bool GetLayoutDrawEnable( u32 id ) const;

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		yC\ݒ
	 *
	 * @param		lytID		CAEgID
	 * @param		index		yC̃CfbNX
	 * @param		flg			true = \, false = \
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetPaneVisible( u32 lytID, gfl::grp::g2d::LytPaneIndex index, bool flg );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		yC̍W擾
	 *
	 * @param		lytID		CAEgID
	 * @param		index		yC̃CfbNX
	 *
	 * @return	yC̍W
	 */
	//--------------------------------------------------------------------------------------------
	gfl::math::VEC3 GetPanePos( u32 lytID, gfl::grp::g2d::LytPaneIndex index ) const;

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		yC̍Wݒ
	 *
	 * @param		lytID		CAEgID
	 * @param		index		yC̃CfbNX
	 * @param		pos			W
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetPanePos( u32 lytID, gfl::grp::g2d::LytPaneIndex index, gfl::math::VEC3 * pos );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		yC̊gkݒ
	 *
	 * @param		lytID		CAEgID
	 * @param		index		yC̃CfbNX
	 * @param		scale		XP[l
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetScale( u32 lytID, gfl::grp::g2d::LytPaneIndex index, gfl::math::VEC2 & scale );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		j[{^`FbN
	 *
	 * @param		none
	 *
	 * @retval	"GSM_BUTTON_SELECT_NONE = I"
	 * @retval	"GSM_BUTTON_SELECT_FOOD_BUTTON = Hו{^"
	 * @retval	"GSM_BUTTON_SELECT_END_BUTTON = I{^"
	 * @retval	"GSM_BUTTON_SELECT_GAME_BUTTON = Q[{^"
	 * @retval	"GSM_BUTTON_SELECT_GAME = Q[I"
	 * @retval	"GSM_BUTTON_SELECT_GAME_CANCEL = LZ"
	 */
	//--------------------------------------------------------------------------------------------
	u32 CheckGameMenuButton(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Q[If[^擾
	 *
	 * @param		type		Q[̎
	 * @param		level		Փx
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void GetGameData( u32 * type, u32 * level );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ACR\؂ւ
	 *
	 * @param		id		ACRID
	 * @param		flg		true = \, false = \
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetIconDrawEnable( u32 id, bool flg );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ACR\ʒuݒ
	 *
	 * @param		id		ACRID
	 * @param		pos		\ʒu
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void PutIcon( u32 id, gfl::math::VEC3 * pos );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`
	 *
	 * @param		lytID		CAEgID
	 * @param		pane		yC
	 * @param		strID		ID
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void PutStrCode( u32 lytID, gfl::grp::g2d::LytPaneIndex pane, u32 strID );

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEgVXe쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateLayoutSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEgVXe폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteLayoutSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateLayoutEnv(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteLayoutEnv(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateLayoutWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteLayoutWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEgݒ
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetLayoutWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N擾
	 *
	 * @param		id			CAEgID
	 *
	 * @return	CAEg[Ñ|C^
	 */
	//--------------------------------------------------------------------------------------------
	gfl::grp::g2d::LytWk * GetLayoutWork( u32 id ) const;

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		bZ[W֘A쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateMessageData(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		bZ[W֘A폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteMessageData(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		{^}l[W쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateButtonManager(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		{^}l[W폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteButtonManager(void);


	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		{^Ajݒ
	 *
	 * @param		index		{^AjCfbNX
	 * @param		next		{^Aj̃V[PX
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetButtonAnm( u32 index, u32 next );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		{^Aj`FbN
	 *
	 * @param		index		{^AjCfbNX
	 *
	 * @retval	"true = I"
	 * @retval	"false = Aj"
	 */
	//--------------------------------------------------------------------------------------------
	bool CheckButtonAnm( u32 index );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Q[Ij[Ԃ̃yC\
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CancelGameSelectPane(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Q[If[^
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void InitGameData(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ACR\
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void InitIconOff(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void InitGameSelectStr(void);

private:
	gfl::grp::GraphicsSystem * pGraSystem;		// OtBbNVXe

	gfl::heap::HeapBase * pHeap;
	gfl::heap::HeapBase * pDeviceHeap;
	gfl::heap::NwAllocator * pHeapAllocator;
	gfl::heap::NwAllocator * pDeviceHeapAllocator;

	// CAEg[NǗ
	typedef struct {
		gfl::grp::g2d::LytWk * pLytWk;	// CAEg[N
		u32	setupDisp;									// `
		bool enable;										// \ݒ
	}LAYOUT_WORK;

	gfl::grp::g2d::LytSys * pLayoutSystem;		// CAEgVXe
	gfl::grp::g2d::LytResID	layoutResID[LAYOUT_ID_MAX];		// \[XID
	gfl::grp::g2d::Env * pUpperLayoutEnv;			// ʂ̃CAEg
	gfl::grp::g2d::Env * pLowerLayoutEnv;			// ʂ̃CAEg
	LAYOUT_WORK * pLayoutWork;								// CAEg[NǗf[^

	gfl::str::MsgData * pMsgData;		// bZ[Wf[^
	WordSet * pWordSet;							// PZbg

	app::tool::ButtonManager * pButtonManager;	// {^}l[W

	u32	seq;				// {^̃V[PX
	u32	anmIndex;		// AjCfbNX
	u32	select;			// I{^

	u32	selMode;		// I[h
	u32	gameID;			// Q[ID
	u32	levelNo;		// Փx
};


}	// kawaigari
