//============================================================================================
/**
 * @file		kawaigari_2d.cpp
 * @brief		킢 2D֘A
 * @author	Hiroyuki Nakamura
 * @date		11.09.20
 *
 * namespace	kawaigari::
 */
//============================================================================================
#include "app/util/app_util.h"

#include "kawaigari_2d.h"
#include "message/message.gaix"
#include "message/msg_game_select.h"

#include "kawaigari_menu_res.h"
#include "kawaigari_menu_res_pane.h"

#include "kawaigari_icon_res.h"
#include "kawaigari_icon_res_pane.h"


namespace kawaigari {

//============================================================================================
//	萔`
//============================================================================================
#define	KAWAIGARI_MENU_LYTSYS_SETUP_RES_MAX		( 128 )		// CAEgVXe̊Ǘ\[Xő吔
#define	KAWAIGARI_MENU_LYTSYS_SETUP_WORK_MAX	( 10 )		// CAEgVXe̊Ǘ[Nő吔


// \fBXvC`
enum {
	KAWAIGARI_2D_SETUP_UPPER = 0,		// 
	KAWAIGARI_2D_SETUP_LOWER,				// 
};

// CAEg[Nݒf[^
typedef struct {
	gfl::grp::g2d::LytArcIndex	lytDataID;						// resID̃CAEgf[^ID
	const gfl::grp::g2d::LytArcIndex * anmDataIDTbl;	// Aj[Vf[^IDe[u	AĵȂꍇNULL
	u32 anmTblNum;																		// Aj[Vf[^IDe[u AĵȂꍇ0
	u32 anmMax;																				// o^Aj[Vő吔
	u32	setupDisp;																		// fBXvC
	bool enable;																			// \ݒ
}KAWAIGARI_2D_LYTWK_DATA;


// {^ĨV[PX
enum {
	KAWAIGARI_GSM_SEQ_BUTTON_CHECK = 0,
	KAWAIGARI_GSM_SEQ_START_ANM_WAIT,
	KAWAIGARI_GSM_SEQ_CHAIN_ANM_WAIT,
};

// Q[Ij[CAEg̃Aj`
enum {
	KAWAIGARI_GSM_ANMID_PLATE_UP = 0,		// 00: v[gɃXCh
	KAWAIGARI_GSM_ANMID_PLATE_DOWN,			// 01: v[gɃXCh
	KAWAIGARI_GSM_ANMID_MV1_LEFT1,			// 02: Pv[gAɍւPړi0>>1)
	KAWAIGARI_GSM_ANMID_MV1_LEFT2,			// 03: Pv[gAɍւPړ (1>>2)
	KAWAIGARI_GSM_ANMID_MV1_RIGHT1,			// 04: Pv[gAɉEւPړi1>>0)
	KAWAIGARI_GSM_ANMID_MV1_RIGHT2,			// 05: Pv[gAɉEւPړi2>>1)
	KAWAIGARI_GSM_ANMID_MV1_START,			// 06: Pv[gEXChCBX^[g
	KAWAIGARI_GSM_ANMID_MV2_LEFT1,			// 07: Qv[gAɍւPړ (0>>1)
	KAWAIGARI_GSM_ANMID_MV2_LEFT2,			// 08: Qv[gAɍւPړ (1>>2)
	KAWAIGARI_GSM_ANMID_MV2_LEFT3,			// 09: Qv[gAɍւPړ (2>>3)
	KAWAIGARI_GSM_ANMID_MV2_RIGHT1,			// 10: Qv[gAɉEւPړi1>>0)
	KAWAIGARI_GSM_ANMID_MV2_RIGHT2,			// 11: Qv[gAɉEւPړi2>>1)
	KAWAIGARI_GSM_ANMID_MV2_RIGHT3,			// 12: Qv[gAɉEւPړi3>>2)
	KAWAIGARI_GSM_ANMID_PLATE_IN,				// 13: \^uォXChC
	KAWAIGARI_GSM_ANMID_PLATE_OUT,			// 14: \^u֏
	KAWAIGARI_GSM_ANMID_L_ARROW_ON,			// 15: ION
	KAWAIGARI_GSM_ANMID_L_ARROW_OFF,		// 16: IOFF
	KAWAIGARI_GSM_ANMID_R_ARROW_ON,			// 17: EION
	KAWAIGARI_GSM_ANMID_R_ARROW_OFF,		// 18: EIOFF
	KAWAIGARI_GSM_ANMID_MAX,
};

// {^ID
enum {
	KAWAIGARI_GSM_BUTTON_ID_FOOD_ICON = 0,		// HוACR
	KAWAIGARI_GSM_BUTTON_ID_GAME_ICON,				// Q[ACR
	KAWAIGARI_GSM_BUTTON_ID_RET_ICON,					// I{^

	KAWAIGARI_GSM_BUTTON_ID_SEL_LEFT,					// Q[I {^
	KAWAIGARI_GSM_BUTTON_ID_SEL_RIGHT,				// Q[I E{^

	KAWAIGARI_GSM_BUTTON_ID_GAME1,						// Q[P
	KAWAIGARI_GSM_BUTTON_ID_GAME2,						// Q[Q
	KAWAIGARI_GSM_BUTTON_ID_GAME3,						// Q[R

	KAWAIGARI_GSM_BUTTON_ID_LEVEL1,						// ՓxP
	KAWAIGARI_GSM_BUTTON_ID_LEVEL2,						// ՓxQ
	KAWAIGARI_GSM_BUTTON_ID_LEVEL3,						// ՓxR
	KAWAIGARI_GSM_BUTTON_ID_LEVEL4,						// ՓxS

	KAWAIGARI_GSM_BUTTON_ID_CANCEL,						// LZ{^

	KAWAIGARI_GSM_BUTTON_ID_MAX,
};

// {^AjID
enum {
	KAWAIGARI_GSM_BUTTON_ANM_GAME_OPEN = 0,		// Q[j[J

	KAWAIGARI_GSM_BUTTON_ANM_GAME_LEFT1,			// Q[I{@0 >> 1
	KAWAIGARI_GSM_BUTTON_ANM_GAME_LEFT2,			// Q[I{@1 >> 2
	KAWAIGARI_GSM_BUTTON_ANM_GAME_RIGHT1,			// Q[I|@1 >> 0
	KAWAIGARI_GSM_BUTTON_ANM_GAME_RIGHT2,			// Q[I|@2 >> 1

	KAWAIGARI_GSM_BUTTON_ANM_LEVEL_LEFT1,			// ՓxI{@0 >> 1
	KAWAIGARI_GSM_BUTTON_ANM_LEVEL_LEFT2,			// ՓxI{@0 >> 1
	KAWAIGARI_GSM_BUTTON_ANM_LEVEL_LEFT3,			// ՓxI{@0 >> 1
	KAWAIGARI_GSM_BUTTON_ANM_LEVEL_RIGHT1,		// ՓxI|@1 >> 0
	KAWAIGARI_GSM_BUTTON_ANM_LEVEL_RIGHT2,		// ՓxI|@1 >> 0
	KAWAIGARI_GSM_BUTTON_ANM_LEVEL_RIGHT3,		// ՓxI|@1 >> 0

	KAWAIGARI_GSM_BUTTON_ANM_SELECT_GAME,						// Q[I
	KAWAIGARI_GSM_BUTTON_ANM_LEVEL_CANCEL1,					// ՓxILZiQ[Oցj
	KAWAIGARI_GSM_BUTTON_ANM_LEVEL_CANCEL2,					// ՓxILZiQ[Pցj
	KAWAIGARI_GSM_BUTTON_ANM_LEVEL_CANCEL3,					// ՓxILZiQ[Qցj
	KAWAIGARI_GSM_BUTTON_ANM_LEVEL_CANCEL_CHAIN,		// ՓxILZ

	KAWAIGARI_GSM_BUTTON_ANM_TAB_DOWN,				// ^u\

	KAWAIGARI_GSM_BUTTON_ANM_L_ARROW_ON,			// \ؑ
	KAWAIGARI_GSM_BUTTON_ANM_L_ARROW_OFF,
	KAWAIGARI_GSM_BUTTON_ANM_R_ARROW_ON,
	KAWAIGARI_GSM_BUTTON_ANM_R_ARROW_OFF,

	KAWAIGARI_GSM_BUTTON_ANM_MAX,
};

// ACRAjID
enum {
	KAWAIGARI_ICON_ANMID_TAP = 0,
	KAWAIGARI_ICON_ANMID_HIT,
	KAWAIGARI_ICON_ANMID_POINT,
	KAWAIGARI_ICON_ANMID_SHOCK,
	KAWAIGARI_ICON_ANMID_MAX
};

// {^f[^
typedef struct {
	gfl::grp::g2d::LytPaneIndex	pane;		// {^ɎgpyC
	u32	startAnm;												// Ĩ{^Aj
	u32	chainAnm;												// Ĩ{^AjĨ{^Aj
}BUTTON_DATA;



// Q[Ij[CAEg̃Ajf[^e[u
static const gfl::grp::g2d::LytArcIndex KawaigariGameSelectMenuAnmDataIDTbl[] = {
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_UP_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_DOWN_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_MOVE1_LEFT1_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_MOVE1_LEFT2_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_MOVE1_RIGHT1_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_MOVE1_RIGHT2_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_MOVE1_START_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_MOVE2_LEFT1_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_MOVE2_LEFT2_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_MOVE2_LEFT3_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_MOVE2_RIGHT1_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_MOVE2_RIGHT2_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_PLATE_MOVE2_RIGHT3_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_TAB_MOVE_DOWN_BCLAN,
	LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_TAB_MOVE_UP_BCLAN,
  LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_LEFT_OFF_BCLAN,
  LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_LEFT_ON_BCLAN,
  LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_RIGHT_OFF_BCLAN,
  LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_RIGHT_ON_BCLAN,
};

// ACRCAEg̃Ajf[^e[u
static const gfl::grp::g2d::LytArcIndex KawaigariIconAnmDataIDTbl[] = {
	LYTRES_KAWAIGARI_ICON_RES_KAWAIGARI_ICON_TAP_ANIM_BCLAN,
	LYTRES_KAWAIGARI_ICON_RES_KAWAIGARI_ICON_HIT_ANIM_BCLAN,
	LYTRES_KAWAIGARI_ICON_RES_KAWAIGARI_ICON_YUBI_ANIM_BCLAN,
	LYTRES_KAWAIGARI_ICON_RES_KAWAIGARI_ICON_BIRIBIRI_ANIM_BCLAN,
};

// CAEgf[^
static const KAWAIGARI_2D_LYTWK_DATA KawaigariLytwkData[] =
{
	{	// ACR
		LYTRES_KAWAIGARI_ICON_RES_KAWAIGARI_ICON_BCLYT,			// resID̃CAEgf[^ID
		KawaigariIconAnmDataIDTbl,								// Aj[Vf[^IDe[u	AĵȂꍇNULL
		KAWAIGARI_ICON_ANMID_MAX,														// Aj[Vf[^IDe[u AĵȂꍇ0
		KAWAIGARI_ICON_ANMID_MAX,														// o^Aj[Vő吔
		KAWAIGARI_2D_SETUP_LOWER,														// fBXvC
		true,																								// \ݒ
	},
	{	// j[
		LYTRES_KAWAIGARI_MENU_RES_GAME_SELECT_LOWER_BCLYT,	// resID̃CAEgf[^ID
		KawaigariGameSelectMenuAnmDataIDTbl,								// Aj[Vf[^IDe[u	AĵȂꍇNULL
		KAWAIGARI_GSM_ANMID_MAX,														// Aj[Vf[^IDe[u AĵȂꍇ0
		KAWAIGARI_GSM_ANMID_MAX,														// o^Aj[Vő吔
		KAWAIGARI_2D_SETUP_LOWER,														// fBXvC
		true,																								// \ݒ
	},
};

// {^Ajf[^
// Q[j[J
static const u32 KawaigariGameMenuButtonAnmGameOpen[] = {
	KAWAIGARI_GSM_ANMID_MV1_START,
	KAWAIGARI_GSM_ANMID_PLATE_IN,			// 15: \^uォXChC
	KAWAIGARI_GSM_ANMID_MAX,
};
// Q[I{
// 0 >> 1
static const u32 KawaigariGameMenuButtonAnmGameLeft1[] = {
	KAWAIGARI_GSM_ANMID_MV1_LEFT1,
	KAWAIGARI_GSM_ANMID_L_ARROW_ON,
	KAWAIGARI_GSM_ANMID_MAX,
};
// 1 >> 2
static const u32 KawaigariGameMenuButtonAnmGameLeft2[] = {
	KAWAIGARI_GSM_ANMID_MV1_LEFT2,
	KAWAIGARI_GSM_ANMID_R_ARROW_OFF,
	KAWAIGARI_GSM_ANMID_MAX,
};
// Q[I|
// 1 >> 0
static const u32 KawaigariGameMenuButtonAnmGameRight1[] = {
	KAWAIGARI_GSM_ANMID_MV1_RIGHT2,
	KAWAIGARI_GSM_ANMID_L_ARROW_OFF,
	KAWAIGARI_GSM_ANMID_MAX,
};
// 2 >> 1
static const u32 KawaigariGameMenuButtonAnmGameRight2[] = {
	KAWAIGARI_GSM_ANMID_MV1_RIGHT1,
	KAWAIGARI_GSM_ANMID_R_ARROW_ON,
	KAWAIGARI_GSM_ANMID_MAX,
};
// ՓxI{
// 0 >> 1
static const u32 KawaigariGameMenuButtonAnmLevelLeft1[] = {
	KAWAIGARI_GSM_ANMID_MV2_LEFT1,
	KAWAIGARI_GSM_ANMID_L_ARROW_ON,
	KAWAIGARI_GSM_ANMID_MAX,
};
// 1 >> 2
static const u32 KawaigariGameMenuButtonAnmLevelLeft2[] = {
	KAWAIGARI_GSM_ANMID_MV2_LEFT2,
	KAWAIGARI_GSM_ANMID_MAX,
};
// 2 >> 3
static const u32 KawaigariGameMenuButtonAnmLevelLeft3[] = {
	KAWAIGARI_GSM_ANMID_MV2_LEFT3,
	KAWAIGARI_GSM_ANMID_R_ARROW_OFF,
	KAWAIGARI_GSM_ANMID_MAX,
};
// ՓxI|
// 1 >> 0
static const u32 KawaigariGameMenuButtonAnmLevelRight1[] = {
	KAWAIGARI_GSM_ANMID_MV2_RIGHT3,
	KAWAIGARI_GSM_ANMID_L_ARROW_OFF,
	KAWAIGARI_GSM_ANMID_MAX,
};
// 2 >> 1
static const u32 KawaigariGameMenuButtonAnmLevelRight2[] = {
	KAWAIGARI_GSM_ANMID_MV2_RIGHT2,
	KAWAIGARI_GSM_ANMID_MAX,
};
// 3 >> 2
static const u32 KawaigariGameMenuButtonAnmLevelRight3[] = {
	KAWAIGARI_GSM_ANMID_MV2_RIGHT1,
	KAWAIGARI_GSM_ANMID_R_ARROW_ON,
	KAWAIGARI_GSM_ANMID_MAX,
};
// Q[I
static const u32 KawaigariGameMenuButtonAnmGameSelect[] = {
	KAWAIGARI_GSM_ANMID_PLATE_UP,
	KAWAIGARI_GSM_ANMID_PLATE_OUT,		// 16: \^u֏
	KAWAIGARI_GSM_ANMID_L_ARROW_OFF,	// 18: IOFF
	KAWAIGARI_GSM_ANMID_MAX,
};
// ^u\
static const u32 KawaigariGameMenuButtonAnmTabDown[] = {
	KAWAIGARI_GSM_ANMID_PLATE_IN,			// 15: \^uォXChC
	KAWAIGARI_GSM_ANMID_MAX,
};
// ՓxILZiQ[Oցj
static const u32 KawaigariGameMenuButtonAnmLevelCancel1[] = {
	KAWAIGARI_GSM_ANMID_PLATE_DOWN,
	KAWAIGARI_GSM_ANMID_PLATE_OUT,	// 16: \^u֏
	KAWAIGARI_GSM_ANMID_R_ARROW_ON,
	KAWAIGARI_GSM_ANMID_L_ARROW_OFF,
	KAWAIGARI_GSM_ANMID_MAX,
};
// ՓxILZiQ[Pցj
static const u32 KawaigariGameMenuButtonAnmLevelCancel2[] = {
	KAWAIGARI_GSM_ANMID_PLATE_DOWN,
	KAWAIGARI_GSM_ANMID_PLATE_OUT,	// 16: \^u֏
	KAWAIGARI_GSM_ANMID_R_ARROW_ON,
	KAWAIGARI_GSM_ANMID_L_ARROW_ON,
	KAWAIGARI_GSM_ANMID_MAX,
};
// ՓxILZiQ[Qցj
static const u32 KawaigariGameMenuButtonAnmLevelCancel3[] = {
	KAWAIGARI_GSM_ANMID_PLATE_DOWN,
	KAWAIGARI_GSM_ANMID_PLATE_OUT,	// 16: \^u֏
	KAWAIGARI_GSM_ANMID_R_ARROW_OFF,
	KAWAIGARI_GSM_ANMID_L_ARROW_ON,
	KAWAIGARI_GSM_ANMID_MAX,
};
// ՓxILZ
static const u32 KawaigariGameMenuButtonAnmLevelCancelChain[] = {
	KAWAIGARI_GSM_ANMID_PLATE_IN,			// 15: \^uォXChC
	KAWAIGARI_GSM_ANMID_MV2_RIGHT3,
	KAWAIGARI_GSM_ANMID_MAX,
};
// \ؑ
static const u32 KawaigariGameMenuButtonAnmLArrowOn[] = {
	KAWAIGARI_GSM_ANMID_L_ARROW_ON,		// 17: ION
	KAWAIGARI_GSM_ANMID_MAX,
};
static const u32 KawaigariGameMenuButtonAnmLArrowOff[] = {
	KAWAIGARI_GSM_ANMID_L_ARROW_OFF,	// 18: IOFF
	KAWAIGARI_GSM_ANMID_MAX,
};
static const u32 KawaigariGameMenuButtonAnmRArrowOn[] = {
	KAWAIGARI_GSM_ANMID_R_ARROW_ON,		// 19: EION
	KAWAIGARI_GSM_ANMID_MAX,
};
static const u32 KawaigariGameMenuButtonAnmRArrowOff[] = {
	KAWAIGARI_GSM_ANMID_R_ARROW_OFF,	// 20: EIOFF
	KAWAIGARI_GSM_ANMID_MAX,
};

// {^Ajf[^e[u
static const u32 * const KawaigariGameMenuButtonAnmTable[] = {
	KawaigariGameMenuButtonAnmGameOpen,

	KawaigariGameMenuButtonAnmGameLeft1,
	KawaigariGameMenuButtonAnmGameLeft2,
	KawaigariGameMenuButtonAnmGameRight1,
	KawaigariGameMenuButtonAnmGameRight2,

	KawaigariGameMenuButtonAnmLevelLeft1,
	KawaigariGameMenuButtonAnmLevelLeft2,
	KawaigariGameMenuButtonAnmLevelLeft3,
	KawaigariGameMenuButtonAnmLevelRight1,
	KawaigariGameMenuButtonAnmLevelRight2,
	KawaigariGameMenuButtonAnmLevelRight3,

	KawaigariGameMenuButtonAnmGameSelect,
	KawaigariGameMenuButtonAnmLevelCancel1,
	KawaigariGameMenuButtonAnmLevelCancel2,
	KawaigariGameMenuButtonAnmLevelCancel3,
	KawaigariGameMenuButtonAnmLevelCancelChain,

	KawaigariGameMenuButtonAnmTabDown,

	KawaigariGameMenuButtonAnmLArrowOn,
	KawaigariGameMenuButtonAnmLArrowOff,
	KawaigariGameMenuButtonAnmRArrowOn,
	KawaigariGameMenuButtonAnmRArrowOff,
};

// {^f[^e[u
static const BUTTON_DATA KawaigariGameMenuButtonData[] =
{
	{	// HוACR
		PANENAME_GAME_SELECT_LOWER_PANE_FOOD_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
	},
	{	// Q[ACR
		PANENAME_GAME_SELECT_LOWER_PANE_PLAY_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_GAME_OPEN,
		KAWAIGARI_GSM_BUTTON_ANM_R_ARROW_ON,
	},
	{	// I{^
		PANENAME_GAME_SELECT_LOWER_PANE_BALL_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
	},
	{	// Q[I {^
		PANENAME_GAME_SELECT_LOWER_PANE_PLAY_LEFT_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_GAME_LEFT1,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
	},
	{	// Q[I E{^
		PANENAME_GAME_SELECT_LOWER_PANE_PLAY_RIGHT_BOUD,
		KAWAIGARI_GSM_BUTTON_ANM_GAME_RIGHT1,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
	},
	{	// Q[P
		PANENAME_GAME_SELECT_LOWER_PANE_GAME01_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_SELECT_GAME,
		KAWAIGARI_GSM_BUTTON_ANM_TAB_DOWN,
	},
	{	// Q[Q
		PANENAME_GAME_SELECT_LOWER_PANE_GAME02_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_SELECT_GAME,
		KAWAIGARI_GSM_BUTTON_ANM_TAB_DOWN,
	},
	{	// Q[R
		PANENAME_GAME_SELECT_LOWER_PANE_GAME03_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_SELECT_GAME,
		KAWAIGARI_GSM_BUTTON_ANM_TAB_DOWN,
	},
	{	// ՓxP
		PANENAME_GAME_SELECT_LOWER_PANE_GAME01_E_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
	},
	{	// ՓxQ
		PANENAME_GAME_SELECT_LOWER_PANE_GAME01_N_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
	},
	{	// ՓxR
		PANENAME_GAME_SELECT_LOWER_PANE_GAME01_H_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
	},
	{	// ՓxS
		PANENAME_GAME_SELECT_LOWER_PANE_GAME01_I_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
		KAWAIGARI_GSM_BUTTON_ANM_MAX,
	},
	{	// LZ{^
		PANENAME_GAME_SELECT_LOWER_PANE_BACK_BOUND,
		KAWAIGARI_GSM_BUTTON_ANM_LEVEL_CANCEL1,
		KAWAIGARI_GSM_BUTTON_ANM_LEVEL_CANCEL_CHAIN,
	},
};

// ACRf[^e[u
static const u32 IconDataTable[][2] =
{	// pane, anime
	{ PANENAME_KAWAIGARI_ICON_PANE_ICON_TAP0_00, KAWAIGARI_ICON_ANMID_TAP },
	{ PANENAME_KAWAIGARI_ICON_PANE_ICON_HIT0_00, KAWAIGARI_ICON_ANMID_HIT },
	{ PANENAME_KAWAIGARI_ICON_PANE_ICON_YUBI_FIX_00, KAWAIGARI_ICON_ANMID_MAX },
	{ PANENAME_KAWAIGARI_ICON_PANE_ICON_YUBI_A1_00, KAWAIGARI_ICON_ANMID_POINT },
	{ PANENAME_KAWAIGARI_ICON_PANE_ICON_HAND_00, KAWAIGARI_ICON_ANMID_MAX },
	{ PANENAME_KAWAIGARI_ICON_PANE_ICON_BIRIBIRI_00, KAWAIGARI_ICON_ANMID_SHOCK },
};
	



//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		gra										OtBbNVXe
 * @param		heap									q[v
 * @param		deviceHeap						foCXq[v
 * @param		heapAllocator					q[vAP[^
 * @param		deviceHeapAllocator		foCXq[vAP[^
 */
//--------------------------------------------------------------------------------------------
G2DSystem::G2DSystem(
	gfl::grp::GraphicsSystem * gra,
	gfl::heap::HeapBase * heap,
	gfl::heap::HeapBase * deviceHeap,
	gfl::heap::NwAllocator * heapAllocator,
	gfl::heap::NwAllocator * deviceHeapAllocator ) :
		pGraSystem( gra ),
		pHeap( heap ),
		pDeviceHeap( deviceHeap ),
		pHeapAllocator( heapAllocator ),
		pDeviceHeapAllocator( deviceHeapAllocator ),
		seq( 0 )
{
	CreateMessageData();
	CreateLayoutSystem();
	CreateLayoutEnv();
	CreateLayoutWork();

	SetLayoutWork();

	CreateButtonManager();

	InitGameSelectStr();
	InitIconOff();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
G2DSystem::~G2DSystem(void)
{
	DeleteButtonManager();

	DeleteLayoutWork();
	DeleteLayoutEnv();
	DeleteLayoutSystem();
	DeleteMessageData();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::Update(void)
{
	for( int i=0; i<LAYOUT_ID_MAX; i++ ){
		if( pLayoutWork[i].pLytWk != NULL ){
			pLayoutWork[i].pLytWk->Update();
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg`
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::Draw(void)
{
	for( int i=0; i<LAYOUT_ID_MAX; i++ ){
		LAYOUT_WORK * lytwk = &pLayoutWork[i];

		if( lytwk->enable == false ){
			return;
		}
		if(	lytwk->setupDisp == KAWAIGARI_2D_SETUP_UPPER ){
			gfl::grp::RenderTarget * upperFrame = pGraSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
			gfl::grp::RenderTarget * rightFrame = pGraSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );

			lytwk->pLytWk->Draw( pGraSystem, gfl::grp::DISPLAY_UPPER, upperFrame, rightFrame );
		}else{
			gfl::grp::RenderTarget * lowerFrame = pGraSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );

			lytwk->pLytWk->Draw( pGraSystem, gfl::grp::DISPLAY_LOWER, lowerFrame );
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEgVXe쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::CreateLayoutSystem(void)
{
	const gfl::grp::g2d::LytSysSetUp setup = {
		KAWAIGARI_MENU_LYTSYS_SETUP_RES_MAX,			// Ǘ\[Xő吔
		KAWAIGARI_MENU_LYTSYS_SETUP_WORK_MAX			// ǗCAEg[Nő吔
	};
	pLayoutSystem = GFL_NEW( pHeap )	gfl::grp::g2d::LytSys( &setup, pHeapAllocator, pDeviceHeapAllocator );

	pLayoutSystem->SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEgVXe폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::DeleteLayoutSystem(void)
{
	GFL_DELETE	pLayoutSystem;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::CreateLayoutEnv(void)
{
	// ˉeݒiˉej
	const gfl::grp::ProjectionParam projection[] =
	{
		{	// 
			gfl::grp::PROJECTION_ORTHO,
			{ -200.0f, 200.0f, -120.0f, 120.0f },
			0.1f,
			800.0f,
			gfl::math::PIVOT_UPSIDE_TO_TOP,
		},
		{	// 
			gfl::grp::PROJECTION_ORTHO,
			{ -160.0f, 160.0f, -120.0f, 120.0f },
			0.1f,
			800.0f,
			gfl::math::PIVOT_UPSIDE_TO_TOP,
		}
	};
	// r[ݒ
	const gfl::grp::ViewParam view[] =
	{
		{	// ʁiځj
			gfl::math::VEC3(0,0,1),		// JW
			gfl::math::VEC3(0,1,0),		// 
			gfl::math::VEC3(0,0,0),		// ^[QbgW
		},
		{	// ʁiEځj
			gfl::math::VEC3(10,0,1),	// JW
			gfl::math::VEC3(0,1,0),		// 
			gfl::math::VEC3(10,0,0),	// ^[QbgW
		},
		{	// 
			gfl::math::VEC3(0,-290,1),	// JW
			gfl::math::VEC3(0,1,0),			// 
			gfl::math::VEC3(0,-290,0),	// ^[QbgW
		},
	};

	// 
	pUpperLayoutEnv = GFL_NEW( pHeap )	gfl::grp::g2d::Env();
	pUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, projection[0], view[0] );
	pUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, projection[0], view[1] );
	// 
	pLowerLayoutEnv = GFL_NEW( pHeap )	gfl::grp::g2d::Env();
	pLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, projection[1], view[2] );
	pLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, projection[1], view[2] );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::DeleteLayoutEnv(void)
{
	GFL_DELETE	pUpperLayoutEnv;
	GFL_DELETE	pLowerLayoutEnv;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::CreateLayoutWork(void)
{
	// \[Xǂݍ
	gfl::fs::ArcFile * af = GFL_NEW( pHeap ) gfl::fs::ArcFile( ARCID_KAWAIGARI_MENU_GRA );
	layoutResID[LAYOUT_ID_MENU] = pLayoutSystem->LoadLytRes( pDeviceHeapAllocator, af, 0 );
	GFL_DELETE af;
	// FCRAMɃeNX`]
	pLayoutSystem->TransferAllTexture( layoutResID[LAYOUT_ID_MENU], gfl::grp::MEMORY_AREA_FCRAM );

	// \[Xǂݍ
	af = GFL_NEW( pHeap ) gfl::fs::ArcFile( ARCID_KAWAIGARI_ICON_GRA );
	layoutResID[LAYOUT_ID_ICON] = pLayoutSystem->LoadLytRes( pDeviceHeapAllocator, af, 0 );
	GFL_DELETE af;
	// FCRAMɃeNX`]
	pLayoutSystem->TransferAllTexture( layoutResID[LAYOUT_ID_ICON], gfl::grp::MEMORY_AREA_FCRAM );

	pLayoutWork = GFL_NEW( pHeap )	LAYOUT_WORK[LAYOUT_ID_MAX];
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::DeleteLayoutWork(void)
{
	GFL_DELETE	[]pLayoutWork;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEgݒ
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::SetLayoutWork(void)
{
	// [N쐬
	const gfl::grp::g2d::LytWkSetUp setup[] =
	{
		{	// 
			gfl::math::VEC3(0,0,0),		// pos
			gfl::math::VEC2(1,1),			// scale
			gfl::math::VEC3(0,0,0),		// rotate
			1,												// priority
		},
		{	// 
			gfl::math::VEC3(0,-290,0),	// pos
			gfl::math::VEC2(1,1),				// scale
			gfl::math::VEC3(0,0,0),			// rotate
			1,													// priority
		}
	};

	const KAWAIGARI_2D_LYTWK_DATA * dat = KawaigariLytwkData;

	for( int i=0; i<LAYOUT_ID_MAX; i++ ){
		pLayoutWork[i].pLytWk = pLayoutSystem->CreateLytWk(
															layoutResID[i],
															dat[i].lytDataID,
															dat[i].anmDataIDTbl,
															dat[i].anmTblNum,
															dat[i].anmMax,
															&setup[ dat[i].setupDisp ],
															false );

		pLayoutWork[i].pLytWk->SetUserEnv( pUpperLayoutEnv, pLowerLayoutEnv );	// [NɊ֘At
		pLayoutWork[i].pLytWk->SetAutoDrawFlag( false );												// ʕ\

		pLayoutWork[i].setupDisp = dat[i].setupDisp;
		pLayoutWork[i].enable    = dat[i].enable;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N擾
 *
 * @param		id			CAEgID
 *
 * @return	CAEg[Ñ|C^
 */
//--------------------------------------------------------------------------------------------
gfl::grp::g2d::LytWk * G2DSystem::GetLayoutWork( u32 id ) const
{
	return pLayoutWork[id].pLytWk;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg\ݒ
 *
 * @param		id			CAEgID
 * @param		flg			true = \, false = \
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::SetLayoutDrawEnable( u32 id, bool flg )
{
	pLayoutWork[id].enable = flg;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg\Ԏ擾
 *
 * @param		id			CAEgID
 *
 * @retval	"true = \"
 * @retval	"false = \"
 */
//--------------------------------------------------------------------------------------------
bool G2DSystem::GetLayoutDrawEnable( u32 id ) const
{
	return pLayoutWork[id].enable;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC\ݒ
 *
 * @param		lytID		CAEgID
 * @param		index		yC̃CfbNX
 * @param		flg			true = \, false = \
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::SetPaneVisible( u32 lytID, gfl::grp::g2d::LytPaneIndex index, bool flg )
{
  gfl::grp::g2d::LytPane * pane = pLayoutWork[lytID].pLytWk->GetPane( index );
	pane->SetVisible( flg );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC̍W擾
 *
 * @param		lytID		CAEgID
 * @param		index		yC̃CfbNX
 *
 * @return	yC̍W
 */
//--------------------------------------------------------------------------------------------
gfl::math::VEC3 G2DSystem::GetPanePos( u32 lytID, gfl::grp::g2d::LytPaneIndex index ) const
{
  gfl::grp::g2d::LytPane * basePane;
  gfl::grp::g2d::LytPane * parentPane;

	basePane   = pLayoutWork[lytID].pLytWk->GetPane( index );
	parentPane = basePane->GetParent();
	// eꍇi[gyC͐eƂ݂ȂȂj
	if( !( parentPane == NULL || parentPane == pLayoutWork[lytID].pLytWk->GetLayoutCore()->GetRootPane() ) ){
		return ( basePane->GetTranslate() + parentPane->GetTranslate() );
	}
	return basePane->GetTranslate();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC̍Wݒ
 *
 * @param		lytID		CAEgID
 * @param		index		yC̃CfbNX
 * @param		pos			W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::SetPanePos( u32 lytID, gfl::grp::g2d::LytPaneIndex index, gfl::math::VEC3 * pos )
{
  gfl::grp::g2d::LytPane * pane = pLayoutWork[lytID].pLytWk->GetPane( index );
	pane->SetTranslate( *pos );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC̊gkݒ
 *
 * @param		lytID		CAEgID
 * @param		index		yC̃CfbNX
 * @param		scale		XP[l
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::SetScale( u32 lytID, gfl::grp::g2d::LytPaneIndex index, gfl::math::VEC2 & scale )
{
  gfl::grp::g2d::LytPane * pane = pLayoutWork[lytID].pLytWk->GetPane( index );
	pane->SetScale( scale );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		bZ[W֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::CreateMessageData(void)
{
	pMsgData = GFL_NEW( pHeap ) gfl::str::MsgData( L"rom:/message.garc", GARC_message_game_select_DAT, pHeap, gfl::str::MsgData::LOAD_PART );
//	pWordSet = GFL_NEW( pHeap ) WordSet( pHeap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		bZ[W֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::DeleteMessageData(void)
{
//	GFL_DELETE	pWordSet;
	GFL_DELETE	pMsgData;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		lytID		CAEgID
 * @param		pane		yC
 * @param		strID		ID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::PutStrCode( u32 lytID, gfl::grp::g2d::LytPaneIndex pane, u32 strID )
{
	gfl::str::StrBuf strbuf( 1024, pHeap );			// fXgN^ŉ
	pMsgData->GetString( strID, strbuf );

	gfl::grp::g2d::LytTextBox * textBox = pLayoutWork[lytID].pLytWk->GetTextBoxPane( pane );
	GFL_ASSERT( textBox != NULL );
	textBox->SetString( strbuf.GetPtr() );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::InitGameSelectStr(void)
{
	PutStrCode( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_GAME_NAME1, game_select_01 );
	PutStrCode( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_GAME_NAME2, game_select_02 );
	PutStrCode( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_GAME_NAME3, game_select_03 );
	
	PutStrCode( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_GAME01_E_TEXT, game_select_04 );
	PutStrCode( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_GAME01_N_TEXT, game_select_05 );
	PutStrCode( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_GAME01_H_TEXT, game_select_06 );
	PutStrCode( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_GAME01_I_TEXT, game_select_07 );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		{^}l[W쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::CreateButtonManager(void)
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	gfl::ui::DeviceManager * dvm = pgm->GetUiDeviceManager();

	pButtonManager = GFL_NEW( pHeap ) app::tool::ButtonManager( pHeap, dvm, KAWAIGARI_GSM_BUTTON_ID_MAX );

	for( int i=0; i<KAWAIGARI_GSM_BUTTON_ID_MAX; i++ ){
		pButtonManager->AddButton(
											pHeap,				// Ǘ[NmۂɎgpq[v
											i,						// {^̎ʎq( IꂽۂUpdate()ŕԂĂl )
											pLayoutWork[LAYOUT_ID_MENU].pLytWk,				// {^郌CAEg[N
											KawaigariGameMenuButtonData[i].pane,			// {^\yC( 蔻Ɏgp )
											app::tool::ButtonManager::ANIMATION_NULL,	// {^^b`ꂽۂɍĐAj[V
											app::tool::ButtonManager::ANIMATION_NULL,	// {^ꂽۂɍĐAj[V
											app::tool::ButtonManager::ANIMATION_NULL,	// {^IꂽۂɍĐAj[V
											NULL );				// {^IꂽۂɒʒmR[obNNX( svȂNULL )
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		{^}l[W폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::DeleteButtonManager(void)
{
	GFL_DELETE pButtonManager;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		j[{^`FbN
 *
 * @param		none
 *
 * @retval	"GSM_BUTTON_SELECT_NONE = I"
 * @retval	"GSM_BUTTON_SELECT_FOOD_BUTTON = Hו{^"
 * @retval	"GSM_BUTTON_SELECT_END_BUTTON = I{^"
 * @retval	"GSM_BUTTON_SELECT_GAME_BUTTON = Q[{^"
 * @retval	"GSM_BUTTON_SELECT_GAME = Q[I"
 * @retval	"GSM_BUTTON_SELECT_GAME_CANCEL = LZ"
 */
//--------------------------------------------------------------------------------------------
u32 G2DSystem::CheckGameMenuButton(void)
{
	if( seq == KAWAIGARI_GSM_SEQ_BUTTON_CHECK ){
		switch( pButtonManager->Update() ){
		case app::tool::ButtonManager::UPDATE_STATE_IDLE:			// ĂȂ
			break;

		case app::tool::ButtonManager::UPDATE_STATE_HOLDING:	// {^Ă
//			GFL_PRINT( "hold : %d\n", pButtonManager->GetHoldingButtonId() );
			break;

		case app::tool::ButtonManager::UPDATE_STATE_SELECTED:	// {^Iꂽ
			select = pButtonManager->GetSelectedButtonId();

			// Q[P
			if( select == KAWAIGARI_GSM_BUTTON_ID_GAME1 ){
				if( gameID != 0 ){ break; }
				selMode = 1;
				SetButtonAnm( KawaigariGameMenuButtonData[select].startAnm, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
			// Q[Q
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_GAME2 ){
				if( gameID != 1 ){ break; }
				selMode = 1;
				SetButtonAnm( KawaigariGameMenuButtonData[select].startAnm, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
			// Q[R
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_GAME3 ){
				if( gameID != 2 ){ break; }
				selMode = 1;
				SetButtonAnm( KawaigariGameMenuButtonData[select].startAnm, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
			// ՓxP
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_LEVEL1 ){
				if( levelNo != 0 ){ break; }
				return GSM_BUTTON_SELECT_GAME;			// Q[I
			// ՓxQ
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_LEVEL2 ){
				if( levelNo != 1 ){ break; }
				return GSM_BUTTON_SELECT_GAME;			// Q[I
			// ՓxR
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_LEVEL3 ){
				if( levelNo != 2 ){ break; }
				return GSM_BUTTON_SELECT_GAME;			// Q[I
			// ՓxS
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_LEVEL4 ){
				if( levelNo != 3 ){ break; }
				return GSM_BUTTON_SELECT_GAME;			// Q[I
			// Q[ILZ
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_CANCEL ){
				if( selMode == 0 ){
					CancelGameSelectPane();
					return GSM_BUTTON_SELECT_GAME_CANCEL;	// LZ
				}else{
					selMode = 0;
					levelNo = 0;
					SetButtonAnm( KAWAIGARI_GSM_BUTTON_ANM_LEVEL_CANCEL1+gameID, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
				}
			// Q[I {^
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_SEL_LEFT ){
				if( selMode == 0 ){
					if( gameID == 1 ){
						SetButtonAnm( KAWAIGARI_GSM_BUTTON_ANM_GAME_RIGHT1, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
						gameID--;
					}else if( gameID == 2 ){
						SetButtonAnm( KAWAIGARI_GSM_BUTTON_ANM_GAME_RIGHT2, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
						gameID--;
					}else if( gameID == 0 ){
					}
				}else{
					if( levelNo == 1 ){
						SetButtonAnm( KAWAIGARI_GSM_BUTTON_ANM_LEVEL_RIGHT1, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
						levelNo--;
					}else if( levelNo == 2 ){
						SetButtonAnm( KAWAIGARI_GSM_BUTTON_ANM_LEVEL_RIGHT2, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
						levelNo--;
					}else if( levelNo == 3 ){
						SetButtonAnm( KAWAIGARI_GSM_BUTTON_ANM_LEVEL_RIGHT3, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
						levelNo--;
					}else if( levelNo == 0 ){
					}
				}
			// Q[I E{^
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_SEL_RIGHT ){
				if( selMode == 0 ){
					if( gameID == 0 ){
						SetButtonAnm( KAWAIGARI_GSM_BUTTON_ANM_GAME_LEFT1, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
						gameID++;
					}else if( gameID == 1 ){
						SetButtonAnm( KAWAIGARI_GSM_BUTTON_ANM_GAME_LEFT2, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
						gameID++;
					}else if( gameID == 2 ){
					}
				}else{
					if( levelNo == 0 ){
						SetButtonAnm( KAWAIGARI_GSM_BUTTON_ANM_LEVEL_LEFT1, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
						levelNo++;
					}else if( levelNo == 1 ){
						SetButtonAnm( KAWAIGARI_GSM_BUTTON_ANM_LEVEL_LEFT2, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
						levelNo++;
					}else if( levelNo == 2 ){
						SetButtonAnm( KAWAIGARI_GSM_BUTTON_ANM_LEVEL_LEFT3, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
						levelNo++;
					}else if( levelNo == 3 ){
					}
				}
			// HוACR
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_FOOD_ICON ){
				return GSM_BUTTON_SELECT_FOOD_BUTTON;		// Hו{^
			// Q[ACR
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_GAME_ICON ){
				InitGameData();
				SetButtonAnm( KawaigariGameMenuButtonData[select].startAnm, KAWAIGARI_GSM_SEQ_START_ANM_WAIT );
				PutStrCode( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_TAB_TEXT, game_select_08 );
				return GSM_BUTTON_SELECT_GAME;			// Q[{^
			// I{^
			}else if( select == KAWAIGARI_GSM_BUTTON_ID_RET_ICON ){
				return GSM_BUTTON_SELECT_END_BUTTON;			// I{^
			}else{
				GFL_ASSERT( 0 );
			}
		}
	}else if( seq == KAWAIGARI_GSM_SEQ_START_ANM_WAIT ){
		if( CheckButtonAnm( anmIndex ) == true ){
			if( KawaigariGameMenuButtonData[select].chainAnm != KAWAIGARI_GSM_BUTTON_ANM_MAX ){
				// Փx
				if( select == KAWAIGARI_GSM_BUTTON_ID_GAME1 ||
						select == KAWAIGARI_GSM_BUTTON_ID_GAME2 ||
						select == KAWAIGARI_GSM_BUTTON_ID_GAME3 ){
					PutStrCode( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_TAB_TEXT, game_select_09 );
				// ՓxLZ
				}else if( select == KAWAIGARI_GSM_BUTTON_ID_CANCEL ){
					PutStrCode( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_TAB_TEXT, game_select_08 );
				}
				SetButtonAnm( KawaigariGameMenuButtonData[select].chainAnm, KAWAIGARI_GSM_SEQ_CHAIN_ANM_WAIT );
			}else{
				seq = KAWAIGARI_GSM_SEQ_BUTTON_CHECK;
			}
		}
	}else{
		if( CheckButtonAnm( anmIndex ) == true ){
			seq = KAWAIGARI_GSM_SEQ_BUTTON_CHECK;
		}
	}

	return GSM_BUTTON_SELECT_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		{^Ajݒ
 *
 * @param		index		{^AjCfbNX
 * @param		next		{^Aj̃V[PX
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::SetButtonAnm( u32 index, u32 next )
{
	const u32 * anmTbl = KawaigariGameMenuButtonAnmTable[index];
	int	i=0;

	while( anmTbl[i] != KAWAIGARI_GSM_ANMID_MAX ){
		app::util::StartAnimation( pLayoutWork[LAYOUT_ID_MENU].pLytWk, anmTbl[i] );
		i++;
	}

	anmIndex = index;
	seq = next;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		{^Aj`FbN
 *
 * @param		index		{^AjCfbNX
 *
 * @retval	"true = I"
 * @retval	"false = Aj"
 */
//--------------------------------------------------------------------------------------------
bool G2DSystem::CheckButtonAnm( u32 index )
{
	const u32 * anmTbl = KawaigariGameMenuButtonAnmTable[index];
	bool end = true;
	int	i=0;

	while( anmTbl[i] != KAWAIGARI_GSM_ANMID_MAX ){
		if( app::util::IsAnimationEnd( pLayoutWork[LAYOUT_ID_MENU].pLytWk, anmTbl[i] ) == false ){
			end = false;
		}else{
			app::util::StopAnimation( pLayoutWork[LAYOUT_ID_MENU].pLytWk, anmTbl[i] );
		}
		i++;
	}

	return end;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Q[Ij[Ԃ̃yC\
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::CancelGameSelectPane(void)
{
	// E\ioEfBOyCj
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_BUTTON_LEFT, false );
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_PLAY_LEFT_BOUND, false );
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_BUTTON_RIGHT, false );
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_PLAY_RIGHT_BOUD, false );
	// LZ\ioEfBOyCj
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_BUTTON_BACK, false );
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_BACK_BOUND, false );
	// ^uړ
	gfl::math::VEC3	pos( 0.0f, 145.0f, 0.0f );
	SetPanePos( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_PLAY_TAB, &pos );
	// Q[IړiƂȂ̂Łj
	pos.x = 240.0f;
	pos.y = 0.0f;
	SetPanePos( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_PLATE_00, &pos );

	// eACR\ioEfBOyCj
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_BUTTON_FOOD, true );
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_FOOD_BOUND, true );
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_BUTTON_PLAY, true );
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_PLAY_BOUND, true );
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_BUTTON_BALL, true );
	SetPaneVisible( LAYOUT_ID_MENU, PANENAME_GAME_SELECT_LOWER_PANE_BALL_BOUND, true );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Q[If[^
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::InitGameData(void)
{
	gameID  = 0;
	levelNo = 0;
	selMode = 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Q[If[^擾
 *
 * @param		type		Q[̎
 * @param		level		Փx
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::GetGameData( u32 * type, u32 * level )
{
	*type  = gameID;
	*level = levelNo;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief		ACR\
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::InitIconOff(void)
{
	SetPaneVisible( LAYOUT_ID_ICON, PANENAME_KAWAIGARI_ICON_PANE_ICON_TAP0_00, false );
	SetPaneVisible( LAYOUT_ID_ICON, PANENAME_KAWAIGARI_ICON_PANE_ICON_HIT0_00, false );
	SetPaneVisible( LAYOUT_ID_ICON, PANENAME_KAWAIGARI_ICON_PANE_ICON_YUBI_FIX_00, false );
	SetPaneVisible( LAYOUT_ID_ICON, PANENAME_KAWAIGARI_ICON_PANE_ICON_YUBI_A1_00, false );
	SetPaneVisible( LAYOUT_ID_ICON, PANENAME_KAWAIGARI_ICON_PANE_ICON_HAND_00, false );
	SetPaneVisible( LAYOUT_ID_ICON, PANENAME_KAWAIGARI_ICON_PANE_ICON_BIRIBIRI_00, false );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ACR\؂ւ
 *
 * @param		id		ACRID
 * @param		flg		true = \, false = \
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::SetIconDrawEnable( u32 id, bool flg )
{
	if( IconDataTable[id][1] != KAWAIGARI_ICON_ANMID_MAX ){
		if( flg == true ){
			app::util::StartAnimation( pLayoutWork[LAYOUT_ID_ICON].pLytWk, IconDataTable[id][1] );
		}else{
			app::util::StopAnimation( pLayoutWork[LAYOUT_ID_ICON].pLytWk, IconDataTable[id][1] );
		}
	}
	SetPaneVisible( LAYOUT_ID_ICON, IconDataTable[id][0], flg );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ACR\ʒuݒ
 *
 * @param		id		ACRID
 * @param		pos		\ʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G2DSystem::PutIcon( u32 id, gfl::math::VEC3 * pos )
{
	SetPanePos( LAYOUT_ID_ICON, IconDataTable[id][0], pos );
}



}	// kawaigari
