//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		TreeLight.cpp
 *	@brief  ؘR
 *	@author	Koji Kawada
 *	@date		2011.09.19
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C

// gflib
#include <gflib.h>

// xy_project
#include "skybox/SkyboxDefine.h"
#include "skybox/Star.h"
#include "skybox/Sun.h"
#include "skybox/Moon.h"

#include "skybox/TreeLight.h"


namespace skybox {

TreeLight::TreeLight(void)
  : m_camera(NULL),
    m_camera_index(gfl::grp::g3d::CAMERA_INDEX_NONE),
    m_light_intensity(0.0f)
{
  for( s32 i=0; i<TREE_LIGHT_TEXTURE_KIND_MAX; ++i )
  {
    m_tree_light_texture_resource[i] = NULL;
  }
}
TreeLight::~TreeLight()
{
  Destroy();
}

void TreeLight::Create(
    gfl::heap::NwAllocator*  heap_allocator,
    gfl::heap::NwAllocator*  device_allocator,
    const BufferPack*        buffer_pack,
    const f32                light_intensity
)
{
  gfl::grp::g3d::Resource::Description resource_description;
  u32 common_resource_flag;

  common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;

  for( s32 i=0; i<TREE_LIGHT_TEXTURE_KIND_MAX; ++i )
  {
    m_tree_light_texture_resource[i] = GFL_NEW(heap_allocator->GetHeapBase()) gfl::grp::g3d::Resource;
    m_tree_light_texture_resource[i]->AttachBufferAndSetup(device_allocator, buffer_pack->tree_light_texture_buffer[i], &resource_description, false, common_resource_flag);
  }

  gfl::grp::g3d::Camera::Description camera_description;
  gfl::grp::g3d::Camera::InitializeDescriptionForLookAtOrtho(
      &camera_description,
      TREE_LIGHT_CAMERA_POSITION,
      TREE_LIGHT_TARGET_POSITION,
      gfl::math::VEC3(0.0f, 0.0f, -1.0f),
      0.0f,
      1.0f,
      256.0f,
      gfl::math::VEC2(0.0f, 0.0f),
      1.0f,
      10000.0f,
      gfl::math::PIVOT_NONE
  );
  m_camera = GFL_NEW(heap_allocator->GetHeapBase()) gfl::grp::g3d::Camera();
  m_camera->Create(device_allocator, &camera_description);
  
  m_light_intensity   = light_intensity;
}

void TreeLight::Destroy(void)
{
  if( m_camera )
  {
    GFL_DELETE m_camera;
    m_camera = NULL;
  }

  for( s32 i=0; i<TREE_LIGHT_TEXTURE_KIND_MAX; ++i )
  {
    if( m_tree_light_texture_resource[i] )
    {
      GFL_DELETE m_tree_light_texture_resource[i];
      m_tree_light_texture_resource[i] = NULL;
    }
  }

  m_camera_index = gfl::grp::g3d::CAMERA_INDEX_NONE;
  m_light_intensity   = 0.0f;
}

void TreeLight::SwitchTreeLightReceiver(
    gfl::grp::g3d::Model*  model,
    const b32              receive_on
)
{
  // êł^Cṽ}eAȂreceiverOn/Off
  s32 material_num = model->GetMaterialCount();
  for( s32 material_index=0; material_index<material_num; ++material_index )
  {
    b32 ret = false;
    if( receive_on )
    {
      ret = gfl::grp::g3d::G3DGSSShadowSystem::SetupProjectionLightReceiver(
          model,
          material_index,
          m_light_intensity,
          m_camera_index,
          m_tree_light_texture_resource[TREE_LIGHT_TEXTURE_KIND_SUNNY_00],
          0
      );
      if(ret)
      {
        // gfl::grp::g3d::G3DGSSShadowSystem::SwitchOnProjectionLightReceiverōsꂽݒύX
        model->SetMaterialTextureCoordinatorScaleUV(material_index, 0, gfl::math::VEC2(1.0f, 1.0f));
        model->SetMaterialTextureCoordinatorRotateUV(material_index, 0, GFL_MATH_DEG_TO_RAD(0.0f));
        model->SetMaterialTextureCoordinatorTranslateUV(material_index, 0, gfl::math::VEC2(0.0f, 0.0f));
        model->SetMaterialTextureMapperWrapU(material_index, 0, gfl::grp::g3d::Model::MATERIAL_TEXTURE_WRAP_REPEAT);
        model->SetMaterialTextureMapperWrapV(material_index, 0, gfl::grp::g3d::Model::MATERIAL_TEXTURE_WRAP_REPEAT);
      }
    }
    else
    {
      /*
      {
        // ύXݒɖ߂
        model->SetMaterialTextureCoordinatorScaleUV(material_index, 0, gfl::math::VEC2(1.0f, 1.0f));
        model->SetMaterialTextureCoordinatorRotateUV(material_index, 0, GFL_MATH_DEG_TO_RAD(0.0f));
        model->SetMaterialTextureCoordinatorTranslateUV(material_index, 0, gfl::math::VEC2(0.0f, 0.0f));
        model->SetMaterialTextureMapperWrapU(material_index, 0, gfl::grp::g3d::Model::MATERIAL_TEXTURE_WRAP_REPEAT);
        model->SetMaterialTextureMapperWrapV(material_index, 0, gfl::grp::g3d::Model::MATERIAL_TEXTURE_WRAP_REPEAT);
      }
      킴킴ɖ߂ȂĂƎv̂ŃRgAEg
      */
      ret = gfl::grp::g3d::G3DGSSShadowSystem::CleanupProjectionLightReceiver(
        model,
        material_index
      );
    }
  }
}

// ̊֐̌Agfl::grp::g3d::SceneInitializeCalculate(J̍W𔽉f邽)ĂԂƁB
void TreeLight::AddCameraToScene(
    gfl::grp::g3d::Scene* scene,
    const s32             scene_calculate_group_index,
    const s32             camera_index
)
{
  m_camera_index = camera_index;
  scene->AddCameraToSceneCalculateGroup( m_camera, scene_calculate_group_index );
  scene->AssignCameraIndex( m_camera, m_camera_index );

  // ̊֐̌Agfl::grp::g3d::SceneInitializeCalculate(J̍W𔽉f邽)ĂԂƁB
}
// ̊֐̌Agfl::grp::g3d::SceneInitializeĂԂƁB
void TreeLight::RemoveCameraFromScene(gfl::grp::g3d::Scene* scene)
{
  scene->RemoveCameraFromSceneCalculateGroup( m_camera );
  m_camera_index = gfl::grp::g3d::CAMERA_INDEX_NONE;
  
  // ̊֐̌Agfl::grp::g3d::SceneInitializeĂԂƁB
}

void TreeLight::Initialize(
    const gfl::math::VEC3&  origin_translate_vector,  // XJC{bNX̌_̈ړxNg
    const Season&           season,
    const Period&           period,
    const Climate&          climate,
    const Weather&          weather,
    const f32               earth_bright,  // n̖邳  // 0.0f<= <=1.0f(nオ^Â̂Ƃ0.0fAnオ^̂Ƃ1.0f)
    const Star&             star,
    const Sun&              sun,
    const Moon&             moon,
    const TreeLightType     tree_light_type
)
{
  GFL_UNUSED(tree_light_type);

  // ŌɁȀuԂɐݒł邱Ƃݒ肷֐
  UpdateColor(
      origin_translate_vector,
      season,
      period,
      climate,
      weather,
      earth_bright,
      star,
      sun,
      moon
  );
}
void TreeLight::Calculate(
    const gfl::math::VEC3&  origin_translate_vector,  // XJC{bNX̌_̈ړxNg
    const Season&           season,
    const Period&           period,
    const Climate&          climate,
    const Weather&          weather,
    const f32               earth_bright,  // n̖邳  // 0.0f<= <=1.0f(nオ^Â̂Ƃ0.0fAnオ^̂Ƃ1.0f)
    const Star&             star,
    const Sun&              sun,
    const Moon&             moon
)
{
  // ŌɁȀuԂɐݒł邱Ƃݒ肷֐
  UpdateColor(
      origin_translate_vector,
      season,
      period,
      climate,
      weather,
      earth_bright,
      star,
      sun,
      moon
  );
}
void TreeLight::SubmitView(void)
{
  m_camera->UpdateCameraMatrix();  // @todo }u
}

// UpdateColorƂOłȀuԂɐݒł邱Ƃݒ肷֐łB
void TreeLight::UpdateColor(
    const gfl::math::VEC3&  origin_translate_vector,  // XJC{bNX̌_̈ړxNg
    const Season&           season,
    const Period&           period,
    const Climate&          climate,
    const Weather&          weather,
    const f32               earth_bright,  // n̖邳  // 0.0f<= <=1.0f(nオ^Â̂Ƃ0.0fAnオ^̂Ƃ1.0f)
    const Star&             star,
    const Sun&              sun,
    const Moon&             moon
)
{
  GFL_UNUSED(origin_translate_vector);
  GFL_UNUSED(season);
  GFL_UNUSED(period);
  GFL_UNUSED(climate);
  GFL_UNUSED(weather);
  GFL_UNUSED(earth_bright);
  GFL_UNUSED(star);
  GFL_UNUSED(sun);
  GFL_UNUSED(moon);
}

#if PM_DEBUG
void TreeLight::Control(const gfl::ui::DeviceManager* device_manager)
{
#if 0
  ControlLq̂{ƂĕۑĂ
  const gfl::ui::VectorDevice* stick       = device_manager->GetStick(0);       // AiOXeBbN
  const gfl::ui::VectorDevice* cross_key   = device_manager->GetCrossKey(0);    // \L[
  const gfl::ui::Button*       button      = device_manager->GetButton(0);      // {^
  const gfl::ui::TouchPanel*   touch_panel = device_manager->GetTouchPanel(0);  // ^b`pl

  if( stick->GetY() == -1.0f )
  {
  }
  if( cross_key->IsHold( gfl::ui::DIR_UP ) )
  {
  }
  if( button->IsHold( gfl::ui::BUTTON_X ) )
  {
  }
  if( touch_panel->IsTouch() )
  {
    if( touch_panel->GetY() == 239 )
    {
    }
  }
#endif

  GFL_UNUSED(device_manager);
}
#endif  // #if PM_DEBUG

}  // namespace skybox

