#ifndef __SKYBOX_TREELIGHT__
#define __SKYBOX_TREELIGHT__

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		TreeLight.h
 *	@brief  ؘR
 *	@author	Koji Kawada
 *	@date		2011.09.19
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#if 0
ؘR
(1) eĂeNX`炩ɕύX邱Ƃ͂łȂB
    uōւ邵ȂB
    Aւꍇ́A
    E܂Ȃ̂ŃCgÂĂ̂ɍ킹ĖؘRȂؘ̖R̃eNX`\B
      A܂Ă̂͑ŜeɂȂĂ̂Ȃ̂ŁAؘR͏oɂĂWoĂ͂ȂȂƎvB
#endif


// CTR_SDK

// NW4C

// gflib
#include <gflib.h>

// xy_project
#include "SkyboxDefine.h"
#include "Star.h"
#include "Sun.h"
#include "Moon.h"


namespace skybox {

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-------------------------------------
///	ؘRNX
//=====================================
class TreeLight
{
  GFL_FORBID_COPY_AND_ASSIGN(TreeLight);

  friend class Skybox;

  // friendNX̂݃ANZXprivateo
private:
  enum
  {
    TREE_LIGHT_TEXTURE_KIND_SUNNY_00,  // 4_ؘ̖̓R
    //TREE_LIGHT_TEXTURE_KIND_SUNNY_01,  // 8_ؘ̖̓R

    TREE_LIGHT_TEXTURE_KIND_MAX
  };
  struct BufferPack
  {
    const void* tree_light_texture_buffer[TREE_LIGHT_TEXTURE_KIND_MAX];
  };

private:
  // ̗
  // RXgN^CreateAddCameraToSceneSwitchTreeLightReceiver(true)
  // InitializeCalculateSubmitView
  // SwitchTreeLightReceivera(false)RemoveCameraFromSceneDestroyfXgN^
  
  // @todo
  // SwitchŊǗXgɓ邱ƁBȂƃCg̋ύXłȂB

  TreeLight(void);
  virtual ~TreeLight();

  void Create(
      gfl::heap::NwAllocator*  heap_allocator,
      gfl::heap::NwAllocator*  device_allocator,
      const BufferPack*        buffer_pack,
      const f32                light_intensity  // 1.0fœeĂeNX`̂܂܉ZB
                                                // 0.0fœeĂeNX`^ɂȂ̂ŉZĂNȂB
  );
  void Destroy(void);

  void SwitchTreeLightReceiver(
      gfl::grp::g3d::Model*  model,
      const b32              receive_on
  );
  
  // ̊֐̌Agfl::grp::g3d::SceneInitializeCalculate(J̍W𔽉f邽)ĂԂƁB
  void AddCameraToScene(
      gfl::grp::g3d::Scene* scene,
      const s32             scene_calculate_group_index,
      const s32             camera_index
  );
  // ̊֐̌Agfl::grp::g3d::SceneInitializeĂԂƁB
  void RemoveCameraFromScene(gfl::grp::g3d::Scene* scene);

  void Initialize(
      const gfl::math::VEC3&  origin_translate_vector,  // XJC{bNX̌_̈ړxNg
      const Season&           season,
      const Period&           period,
      const Climate&          climate,
      const Weather&          weather,
      const f32               earth_bright,  // n̖邳  // 0.0f<= <=1.0f(nオ^Â̂Ƃ0.0fAnオ^̂Ƃ1.0f)
      const Star&             star,
      const Sun&              sun,
      const Moon&             moon,
      const TreeLightType     tree_light_type
  );
  void Calculate(
      const gfl::math::VEC3&  origin_translate_vector,  // XJC{bNX̌_̈ړxNg
      const Season&           season,
      const Period&           period,
      const Climate&          climate,
      const Weather&          weather,
      const f32               earth_bright,  // n̖邳  // 0.0f<= <=1.0f(nオ^Â̂Ƃ0.0fAnオ^̂Ƃ1.0f)
      const Star&             star,
      const Sun&              sun,
      const Moon&             moon
  );
  void SubmitView(void);

  // friendNXANZXĂ͂ȂȂprivateo
private:
  // UpdateColorƂOłȀuԂɐݒł邱Ƃݒ肷֐łB
  void UpdateColor(
      const gfl::math::VEC3&  origin_translate_vector,  // XJC{bNX̌_̈ړxNg
      const Season&           season,
      const Period&           period,
      const Climate&          climate,
      const Weather&          weather,
      const f32               earth_bright,  // n̖邳  // 0.0f<= <=1.0f(nオ^Â̂Ƃ0.0fAnオ^̂Ƃ1.0f)
      const Star&             star,
      const Sun&              sun,
      const Moon&             moon
  );

private:
  gfl::grp::g3d::Resource*  m_tree_light_texture_resource[TREE_LIGHT_TEXTURE_KIND_MAX];
  gfl::grp::g3d::Camera*    m_camera;
  s32                       m_camera_index;
  f32                       m_light_intensity;

#if PM_DEBUG
public:
  // t[Ăŉ
  void Control(const gfl::ui::DeviceManager* device_manager);
#endif  // #if PM_DEBUG

};

}  // namespace skybox

#endif // __SKYBOX_TREELIGHT__
