//=======================================================================================
/**
 * @file YesNoBase.h
 * @briefuґvʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.20
 */
//=======================================================================================
#ifndef __YESNOBASE_H__
#define __YESNOBASE_H__
#include <gflib.h>
#include "AppBase.h"


namespace btl {

  class BattleViewSystem;


  namespace app {

    class YesNoBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( YesNoBase );  // Rs[֎~

      public: 


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      YesNoBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~YesNoBase();




      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      // \[h
      enum Mode {
        MODE_YESNO,      //u͂v              uv
        MODE_NEXT_POKE,  //ũ|Pgvuɂv
        MODE_FORGET,     //u킷ꂳv      u킷ꂳȂv
      };

      /**
       * @brief ݒύX
       * @param mode  \[h
       */
      virtual void ChangeMode( Mode mode ) = 0;




      //---------------------------------------------------------------------------------
      // 
      //---------------------------------------------------------------------------------
      // I
      enum Result {
        RESULT_YES,  //u͂vI
        RESULT_NO,   //uvI
        RESULT_NULL,
      };

      /**
       * @brief ʂ擾
       */
      Result GetResult( void ) const;






      protected:
      void SetMode( Mode mode ) { m_mode = mode; }
      Mode GetMode( void ) const { return m_mode; }
      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }


      private:
      Mode m_mode;
      Result m_result;
    };


  }  // namespace app
}  // namespace btl


#endif // __YESNOBASE_H__ 
