//=======================================================================================
/**
 * @file YesNo.h
 * @briefuґv
 * @author obata_toshihiro
 * @date 2011.09.20
 */
//=======================================================================================
#ifndef __YESNO_H__
#define __YESNO_H__
#include <gflib.h>
#include <battle/btl_common.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "YesNoBase.h"


namespace btl {

  class BattleViewSystem;


  namespace app {

    class YesNo : public YesNoBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( YesNo );  // Rs[֎~

      public:


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap      gpAvP[Vq[v
       * @param device_heap   gpfoCXq[v
       * @param btlv_system   og`RAVXe
       */
      YesNo( 
          gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap,
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~YesNo(); 


      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param mode  \[h
       */
      virtual void ChangeMode( Mode mode );


      //---------------------------------------------------------------------------------
      // {
      //---------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      virtual void Update( void );

      /**
       * @brief ŏĊJ( ݒ͈p )
       */
      virtual void Restart( void );

      /**
       * @brief I[g`tOZbg
       */
      virtual void SetAutoDrawFlag( bool flag );





      private:


      // V[PX
      enum Sequence {
        SEQ_INPUT_WAIT,   // ͑҂
        SEQ_ANIME_WAIT,   // Aj[V҂
        SEQ_FINISH,       // I
        SEQ_NULL,
      };


      // {^ԍ
      enum ButtonIndex {
        BUTTON_YES, //u͂v
        BUTTON_NO,  //uv
        BUTTON_NUM,
      };


      // Aj[Vf[^ԍ
      enum AnimeDataIndex {
        ANIME_DATA_DUMMY_BUTTON_HOLD,
        ANIME_DATA_DUMMY_BUTTON_RELEASE,
        ANIME_DATA_DUMMY_BUTTON_SELECT,
        ANIME_DATA_CURSOR_FLUCTUATE,
        ANIME_DATA_CURSOR_ON_YES,
        ANIME_DATA_CURSOR_ON_NO,
        ANIME_DATA_NUM,
      };


      // Aj[Vԍ
      enum AnimeIndex {
        ANIME_DUMMY_BUTTON_HOLD,
        ANIME_DUMMY_BUTTON_RELEASE,
        ANIME_DUMMY_BUTTON_SELECT,
        ANIME_CURSOR_FLUCTUATE,
        ANIME_CURSOR_ON_YES,
        ANIME_CURSOR_ON_NO,
        // ȉ, LAj[V
        ANIME_BUTTON_HOLD,
        ANIME_BUTTON_RELEASE = ANIME_BUTTON_HOLD + BUTTON_NUM,
        ANIME_BUTTON_SELECT = ANIME_BUTTON_RELEASE + BUTTON_NUM,
        ANIME_NUM = ANIME_BUTTON_SELECT + BUTTON_NUM,
        ANIME_NULL,
      };


      // LAj[Vԍ
      enum ShareAnimeIndex {
        SHARE_ANIME_BUTTON_HOLD,
        SHARE_ANIME_BUTTON_RELEASE,
        SHARE_ANIME_BUTTON_SELECT,
        SHARE_ANIME_NUM,
      };


      // LAj[VƂ̐ݒ
      struct ShareAnimeDesc {
        AnimeIndex top_anime_index;                     // o^CfbNX
        AnimeDataIndex anime_data_index;                // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };


      // {^Ƃ̐ݒ
      struct ButtonDesc {
        Result result;                           // Iꂽꍇ̌
        gfl::grp::g2d::LytPaneIndex pane_index;  // {^ƂĈyC
        AnimeIndex hold_anime;                   // ꂽۂ̃Aj[V
        AnimeIndex release_anime;                // ꂽۂ̃Aj[V
        AnimeIndex select_anime;                 // I΂ꂽۂ̃Aj[V
        AnimeIndex active_anime;                 // {^Lȍۂ̃Aj[V
        AnimeIndex passive_anime;                // {^ȍۂ̃Aj[V
        AnimeIndex cursor_anime;                 // J[\ZbgAj[V
      };




      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE;
      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIME_DATA_TABLE[ ANIME_DATA_NUM ];
      static const ShareAnimeDesc SHARE_ANIME_DESC[ SHARE_ANIME_NUM ];
      static const ButtonDesc BUTTON_DESC[ BUTTON_NUM ];
      static const ::app::tool::CursorManager::MOVE_DATA CURSOR_MOVE_DATA[ BUTTON_NUM ];

      
      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;
      ::app::tool::ButtonManager* m_button_manager;
      ::app::tool::CursorManager* m_cursor_manager;

      Sequence m_seq;
      Sequence m_next_seq;
      AnimeIndex m_wait_anime_index;


      void InitializeGraphicsSystem( void );
      void SetupFont( void );
      void CreateLayoutWork( void );
      void CreateShareAnime( void );
      void CreateCursorManager( void );
      void CreateButtonManager( void );
      void SetupButtonManager( void ); 

      void FinalizeGraphicsSystem( void );
      void DeleteLayoutWork( void );
      void DeleteCursorManager( void );
      void DeleteButtonManager( void );

      void InitializeCursorPos( void );

      void SetupButtonStrings( void );

      void UpdateSequence( void );
      bool IsButtonHolding( void ) const;
      bool IsButtonSelected( void ) const;
      ButtonIndex GetSelectedCursorPosByButton( void ) const;
      bool UpdateCursorMove( void );
      ButtonIndex GetCurrentCursorPos( void ) const;
      ButtonIndex GetPrevCursorPos( void ) const;
      bool IsSelectEnable( ButtonIndex cursor_pos ) const;
      void SetResultByCursorPos( ButtonIndex cursor_pos );

      void StartSelectAnime( ButtonIndex cursor_pos );
      bool IsSelectAnimeFinished( void ) const;
      void StartCursorMoveAnime( ButtonIndex old_cursor_pos, ButtonIndex new_cursor_pos );
    };


  }  // namespace app
}  // namespace btl


#endif // __YESNO_H__ 
