//=======================================================================================
/**
 * @file YesNo.h
 * @briefuґv
 * @author obata_toshihiro
 * @date 2011.09.20
 */
//=======================================================================================
#include <gflib.h>
#include <battle/btlv/btlv_core.h>
#include <app/util/app_util.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "YesNoBase.h"
#include "YesNo.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "yes_no.h"
#include "yes_no_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 YesNo::APP_HEAPSIZE    =  0x1000;
    const u32 YesNo::DEVICE_HEAPSIZE = 0x60000;


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp YesNo::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };



    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex YesNo::ANIME_DATA_TABLE[ YesNo::ANIME_DATA_NUM ] = 
    {
      /* ANIME_DATA_DUMMY_BUTTON_HOLD */ LYTRES_YES_NO_YES_NO_DUMMY_BUTTON_HOLD_BCLAN,
      /* ANIME_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_YES_NO_YES_NO_DUMMY_BUTTON_RELEASE_BCLAN,
      /* ANIME_DATA_DUMMY_BUTTON_SELECT */ LYTRES_YES_NO_YES_NO_DUMMY_BUTTON_SELECT_BCLAN,
      /* ANIME_DATA_CURSOR_FLUCTUATE */ LYTRES_YES_NO_YES_NO_CURSOR_FLUCTUATE_BCLAN,
      /* ANIME_DATA_CURSOR_ON_YES */ LYTRES_YES_NO_YES_NO_CURSOR_ON_YES_BCLAN,
      /* ANIME_DATA_CURSOR_ON_NO */ LYTRES_YES_NO_YES_NO_CURSOR_ON_NO_BCLAN,
    }; 



    // LAj[VƂ̐ݒ
    const YesNo::ShareAnimeDesc YesNo::SHARE_ANIME_DESC[ YesNo::SHARE_ANIME_NUM ] = 
    {
      /* SHARE_ANIME_BUTTON_HOLD */
      {
        ANIME_BUTTON_HOLD, 
        ANIME_DATA_DUMMY_BUTTON_HOLD,
        BUTTON_NUM,
        PANENAME_YES_NO_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_BUTTON_RELEASE */
      {
        ANIME_BUTTON_RELEASE, 
        ANIME_DATA_DUMMY_BUTTON_RELEASE,
        BUTTON_NUM,
        PANENAME_YES_NO_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_BUTTON_SELECT */
      {
        ANIME_BUTTON_SELECT, 
        ANIME_DATA_DUMMY_BUTTON_SELECT,
        BUTTON_NUM,
        PANENAME_YES_NO_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };




    // {^Ƃ̐ݒ
    const YesNo::ButtonDesc YesNo::BUTTON_DESC[ YesNo::BUTTON_NUM ] = 
    {
      /* BUTTON_YES */
      {
        YesNoBase::RESULT_YES,
        PANENAME_YES_NO_PANE_YES_BUTTON,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_YES ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_YES ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_YES ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_YES,
      },
      /* BUTTON_NO */ 
      {
        YesNoBase::RESULT_NO,
        PANENAME_YES_NO_PANE_NO_BUTTON,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_NO ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_NO ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_NO ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_NO,
      },
    };





    // J[\ړf[^
    const ::app::tool::CursorManager::MOVE_DATA 
      YesNo::CURSOR_MOVE_DATA[ YesNo::BUTTON_NUM ] = 
      {
        /*   id          up           down         left         right  */
        { BUTTON_YES,  { BUTTON_YES,  BUTTON_NO,   BUTTON_YES,  BUTTON_YES } },
        { BUTTON_NO,   { BUTTON_YES,  BUTTON_NO,   BUTTON_NO,   BUTTON_NO } },
      };








    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap          gpAvP[Vq[v
     * @param device_heap   gpfoCXq[v
     * @param btlv_system   og`RAVXe
     */
    //---------------------------------------------------------------------------------
    YesNo::YesNo( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
        BattleViewSystem* btlv_system ) :
      YesNoBase( heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, btlv_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager( NULL ),
      m_cursor_manager( NULL ),
      m_seq( SEQ_INPUT_WAIT ),
      m_next_seq( SEQ_INPUT_WAIT ),
      m_wait_anime_index( ANIME_NULL )
    {
      this->InitializeGraphicsSystem();
      this->SetupFont();
      this->CreateLayoutWork();
      this->CreateShareAnime();
      this->CreateCursorManager();
      this->CreateButtonManager();
      this->SetupButtonManager();

#if 0 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_BATTLE_YESNO_INFO: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif
    }



    // OtBbNXVXe
    void YesNo::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void YesNo::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void YesNo::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_yes_no_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_YES_NO_YES_NO_BCLYT,
          ANIME_DATA_TABLE, ANIME_DATA_NUM, ANIME_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ
    }


    // LAj[V𐶐
    void YesNo::CreateShareAnime( void )
    {
      for( u32 i=0; i<SHARE_ANIME_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIME_DESC[i].top_anime_index,
            ANIME_DATA_TABLE[ SHARE_ANIME_DESC[i].anime_data_index ],
            SHARE_ANIME_DESC[i].max_share_num,
            SHARE_ANIME_DESC[i].share_group_index,
            SHARE_ANIME_DESC[i].share_pane_index );
      }
    }


    // J[\ǗIuWFNg𐶐
    void YesNo::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager( CURSOR_MOVE_DATA, BUTTON_NUM, heap, 0 );
    }


    // {^}l[W𐶐
    void YesNo::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIME_NULL );
    }


    // {^}l[WZbgAbv
    void YesNo::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) {
        m_button_manager->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_anime,
            BUTTON_DESC[i].release_anime,
            BUTTON_DESC[i].select_anime,
            BUTTON_DESC[i].active_anime,
            BUTTON_DESC[i].passive_anime,
            NULL );  // R[obNȂ
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    YesNo::~YesNo()
    {
      this->DeleteCursorManager();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
      this->FinalizeGraphicsSystem();
    }



    // J[\ǗIuWFNgj
    void YesNo::DeleteCursorManager( void )
    {
      if( m_cursor_manager ) {
        GFL_DELETE m_cursor_manager;
      }
    }


    // {^}l[Wj
    void YesNo::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    // CAEg[Nj
    void YesNo::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    // OtBbNXVXȅI
    void YesNo::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }










    //---------------------------------------------------------------------------------
    /**
     * @brief ݒύX
     * @param mode  \[h
     */
    //---------------------------------------------------------------------------------
    void YesNo::ChangeMode( Mode mode )
    {
      this->SetMode( mode ); 
      this->SetupButtonStrings();
    }



    // Œ蕶̃ZbgAbv
    void YesNo::SetupButtonStrings( void )
    {
      gfl::str::MsgData* message = AppBase::GetMessageData();

      switch( this->GetMode() ) 
      {
      case MODE_YESNO:
        ::app::util::SetTextboxPaneMessage( 
            m_layout_work, PANENAME_YES_NO_PANE_YES_LABEL, message, str_btl_bag_00 );
        ::app::util::SetTextboxPaneMessage( 
            m_layout_work, PANENAME_YES_NO_PANE_NO_LABEL, message, str_btl_bag_00 );
        break;

      case MODE_NEXT_POKE:
        ::app::util::SetTextboxPaneMessage(
            m_layout_work, PANENAME_YES_NO_PANE_YES_LABEL, message, str_btl_bag_00 );
        ::app::util::SetTextboxPaneMessage(
            m_layout_work, PANENAME_YES_NO_PANE_NO_LABEL, message, str_btl_bag_00 );
        break;

      case MODE_FORGET:
        ::app::util::SetTextboxPaneMessage(
            m_layout_work, PANENAME_YES_NO_PANE_YES_LABEL, message, str_btl_bag_00 );
        ::app::util::SetTextboxPaneMessage(
            m_layout_work, PANENAME_YES_NO_PANE_NO_LABEL, message, str_btl_bag_00 );
        break;

      default:
        GFL_ASSERT(0);
        break;
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief ŏĊJ( ݒ͈p )
     */
    //---------------------------------------------------------------------------------
    void YesNo::Restart( void )
    {
      this->ResetFinishFlag();
      this->ResetResult();
      m_seq = SEQ_INPUT_WAIT;
      m_next_seq = SEQ_INPUT_WAIT;
      m_wait_anime_index = ANIME_NULL;
      this->InitializeCursorPos();
    }


    // J[\ʒu
    void YesNo::InitializeCursorPos( void )
    {
      for( u8 i=0; i<BUTTON_NUM; i++ ) {
        ::app::util::StopAnimation( m_layout_work, BUTTON_DESC[i].cursor_anime );
      } 
      m_cursor_manager->SetPos( BUTTON_YES );
      ::app::util::StartAnimation( m_layout_work, BUTTON_DESC[ BUTTON_YES ].cursor_anime );
      ::app::util::StartAnimation( m_layout_work, ANIME_CURSOR_FLUCTUATE );
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief I[g`tOZbg
     */
    //--------------------------------------------------------------------------------- 
    void YesNo::SetAutoDrawFlag( bool flag )
    {
      if( m_layout_work ) {
        m_layout_work->SetAutoDrawFlag( flag );
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //---------------------------------------------------------------------------------
    void YesNo::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 
    } 



    // V[PXXV
    void YesNo::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = this->GetButton();
      const gfl::ui::TouchPanel* touchpanel = this->GetTouchpanel();

      switch( m_seq )
      {
      case SEQ_INPUT_WAIT:
        if( this->IsButtonSelected() ) {
          ButtonIndex selected_button = this->GetSelectedCursorPosByButton();
          if( this->IsSelectEnable( selected_button ) ) {
            this->SetResultByCursorPos( selected_button );
            this->StartSelectAnime( selected_button );
            m_seq = SEQ_ANIME_WAIT;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->IsButtonHolding() ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          ButtonIndex cursor_pos = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->SetResultByCursorPos( cursor_pos );
            this->StartSelectAnime( cursor_pos );
            m_seq = SEQ_ANIME_WAIT;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->UpdateCursorMove() ) {  // J[\ړ
          ButtonIndex old_cursor_pos = this->GetPrevCursorPos();
          ButtonIndex new_cursor_pos = this->GetCurrentCursorPos();
          this->StartCursorMoveAnime( old_cursor_pos, new_cursor_pos );
        }
        break;


      case SEQ_ANIME_WAIT:
        if( this->IsSelectAnimeFinished() ) {
          m_seq = m_next_seq;
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
        break; 
      }
    }






    // {^Ă邩ǂ𒲂ׂ
    bool YesNo::IsButtonHolding( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    // {^Iꂽǂ𒲂ׂ
    bool YesNo::IsButtonSelected( void ) const
    {
      return m_button_manager->IsButtonSelected();
    }

    // Iꂽ{^Ɋ֘AtĂJ[\ʒu擾
    YesNo::ButtonIndex YesNo::GetSelectedCursorPosByButton( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetSelectedButtonId() );
    }





    // J[\̓XV
    bool YesNo::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 


    // ݂̃J[\ʒu擾
    YesNo::ButtonIndex YesNo::GetCurrentCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetID() );
    } 


    // ÕJ[\ʒu擾
    YesNo::ButtonIndex YesNo::GetPrevCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetOldID() );
    }


    // J[\ړۂ̏
    void YesNo::StartCursorMoveAnime( 
        ButtonIndex old_cursor_pos, ButtonIndex new_cursor_pos )
    {
      ::app::util::StopAnimation( m_layout_work, BUTTON_DESC[ old_cursor_pos ].cursor_anime );
      ::app::util::StartAnimation( m_layout_work, BUTTON_DESC[ new_cursor_pos ].cursor_anime );
    }






    // I\ǂ𒲂ׂ
    bool YesNo::IsSelectEnable( ButtonIndex cursor_pos ) const
    {
      return m_button_manager->IsButtonActive( cursor_pos );
    } 


    // J[\ʒu, 쌋ʂZbg
    void YesNo::SetResultByCursorPos( ButtonIndex cursor_pos )
    {
      this->SetResult( BUTTON_DESC[ cursor_pos ].result );
    } 





    // ȊIAj[VJn
    void YesNo::StartSelectAnime( ButtonIndex cursor_pos )
    {
      m_wait_anime_index = BUTTON_DESC[ cursor_pos ].select_anime;
      ::app::util::StartAnimation( m_layout_work, m_wait_anime_index );
    }


    // ȊIAj[VIǂ𒲂ׂ
    bool YesNo::IsSelectAnimeFinished( void ) const
    {
      if( m_wait_anime_index < ANIME_NUM ) {
        return m_layout_work->IsAnimeEnd( m_wait_anime_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }






  }  // namespace app
}  // namespace btl
