//============================================================================================
/**
 * @file		kawaigari_menu.cpp
 * @brief		Proc֘A
 * @author	Hiroyuki Nakamura
 * @date		11.09.20
 *
 * namespace	app::kawaigari_menu::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "kawaigari_menu.h"
#include "kawaigari_menu_main.h"


namespace app {
namespace kawaigari_menu {

//============================================================================================
//	萔`
//============================================================================================
#define	KAWAIGARI_MENU_SYS_HEAP_SIZE		( 0x1000 )		// VXeq[vTCY


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		prm		Oݒp[^
 */
//--------------------------------------------------------------------------------------------
Proc::Proc( APP_PARAM * prm )
{
	CreateHeap();
	pMain = GFL_NEW( pHeap )	MainSystem( prm );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::~Proc(void)
{
	GFL_DELETE	pMain;
	DeleteHeap();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcI
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcAbvf[g
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
	if( pMain->Update() == true ){
		return gfl::proc::RES_CONTINUE;
	}
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc`揈
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
	pMain->Draw();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::CreateHeap(void)
{
	pHeap = gfl::heap::Manager::CreateHeap(
						gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ),
						HEAPID_KAWAIGARI_MENU_SYS, KAWAIGARI_MENU_SYS_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DeleteHeap(void)
{
	gfl::heap::Manager::DeleteHeap( pHeap );
}


}	// kawaigari_menu
}	// app
