//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldBeamEffect.h
 *	@brief  䊂\鉉o
 *	@author	Koji Kawada
 *	@date		2011.09.19
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#if 0
// @todo
AP[^̓tB[ĥ؂Ă܂BallocatorŌB
#endif


#include <gflib.h>


// field
#include "field/Fieldmap.h"
#include "field/FieldGraphics.h"

#include "FieldBeamEffect.h"


// resource
#include "arc/arc_def.h"                   // ARCID_ 
#include "arc/field_beam_effect_d01.gaix"


namespace field {


//-----------------------------------------------------------------------------
/**
 *					NX`
*/
//-----------------------------------------------------------------------------

// Create͌Ă΂܂B
FieldBeamEffect::FieldBeamEffect(void)
  : m_fieldmap(NULL),
    m_arc_file(NULL),
    m_resource_num_max(0),
    m_resource_array(NULL),
    m_model_num_max(0),
    m_model_array(NULL)
{
}

// CreateĂт܂B
FieldBeamEffect::FieldBeamEffect(field::Fieldmap* fieldmap)
  : m_fieldmap(NULL),
    m_arc_file(NULL),
    m_resource_num_max(0),
    m_resource_array(NULL),
    m_model_num_max(0),
    m_model_array(NULL)
{
  Create(fieldmap);
}

// DestroyĂт܂B
FieldBeamEffect::~FieldBeamEffect()
{
  Destroy();
}

//
// sceneɑ΂Add܂B
void FieldBeamEffect::Create(field::Fieldmap* fieldmap)
{
  m_fieldmap = fieldmap;

  field::Graphics*         graphics         = m_fieldmap->GetGraphics();
  gfl::grp::g3d::Scene*    scene            = graphics->GetScene();

  gfl::heap::HeapBase*     heap_memory      = m_fieldmap->GetHeapField();
  gfl::heap::HeapBase*     device_memory    = m_fieldmap->GetDeviceHeapField();
  gfl::heap::NwAllocator*  heap_allocator   = m_fieldmap->GetHeapFieldAllocator();
  gfl::heap::NwAllocator*  device_allocator = m_fieldmap->GetDeviceHeapFieldAllocator();

  m_arc_file = GFL_NEW(heap_memory) gfl::fs::ArcFile( ARCID_FIELD_BEAM_EFFECT_D01 );

  m_resource_num_max = GARC_field_beam_effect_d01_DATA_NUM;
  m_resource_array = GFL_NEW(heap_memory) gfl::grp::g3d::Resource*[m_resource_num_max];
  for(u32 i=0; i<m_resource_num_max; ++i)
  {
    m_resource_array[i] = NULL;
  }
  for(u32 i=0; i<m_resource_num_max; ++i)
  {
    m_resource_array[i] = GFL_NEW(heap_memory) gfl::grp::g3d::Resource;
    m_resource_array[i]->LoadAndSetup(device_allocator, m_arc_file, i);
  }
  m_resource_array[GARC_field_beam_effect_d01_d01_01_01_lm_BCMDL]->Setup(
      device_allocator,
      m_resource_array[GARC_field_beam_effect_d01_d01_hikari_a_BCTEX],
      gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT
  );

  m_model_num_max = 1;
  m_model_array = GFL_NEW(heap_memory) gfl::grp::g3d::Model*[m_model_num_max];
  for(u32 i=0; i<m_model_num_max; ++i)
  {
    m_model_array[i] = NULL;
  }
  m_model_array[0] = GFL_NEW(heap_memory) gfl::grp::g3d::Model;
  m_model_array[0]->Create(heap_allocator, device_allocator, m_resource_array[GARC_field_beam_effect_d01_d01_01_01_lm_BCMDL], 0);
  m_model_array[0]->ChangeAnimation(
      device_allocator,
      m_resource_array[GARC_field_beam_effect_d01_d01_01_01_lm_BCMATA],
      gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_MATERIAL,
      0
  );
  m_model_array[0]->SetAnimationLoop(true);
  // V[Add
  scene->AddSceneNode(m_model_array[0]);
}

// ĂłvBfXgN^͌Ă΂܂B
// sceneɑ΂Remove܂B
void FieldBeamEffect::Destroy(void)
{
  field::Graphics*       graphics  = m_fieldmap->GetGraphics();
  gfl::grp::g3d::Scene*  scene     = graphics->GetScene();

  if( m_model_array )
  {
    for( u32 i=0; i<m_model_num_max; ++i )
    {
      if( m_model_array[i] )
      {
        // V[Remove
        scene->RemoveSceneNode(m_model_array[i]);
        GFL_DELETE m_model_array[i];
        m_model_array[i] = NULL;
      }
    }
    GFL_DELETE m_model_array;
    m_model_array = NULL;
  }
  m_model_num_max = 0;

  if( m_resource_array )
  {
    for( u32 i=0; i<m_resource_num_max; ++i )
    {
      if( m_resource_array[i] )
      {
        GFL_DELETE m_resource_array[i];
        m_resource_array[i] = NULL;
      }
    }
    GFL_DELETE m_resource_array;
    m_resource_array = NULL;
  }
  m_resource_num_max = 0;

  if( m_arc_file )
  {
    GFL_DELETE m_arc_file;
    m_arc_file = NULL;
  }

  m_fieldmap = NULL;
}


} // namespace field
