//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldSubWindowDressUpTestProc.cpp
 *	@brief  ւ̃eXgsCxg̉
 *	@author	Koji Kawada
 *	@date		2011.09.14
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C

// gflib
#include <gflib.h>

// xy_project
#include "FieldSubWindowDressUpTestProc.h"


namespace field {

//-----------------------------------------------------------------------------
/**
 *					NX`
*/
//-----------------------------------------------------------------------------

//-------------------------------------
///	ւ̃eXgsCxg̉ʃNX
//=====================================

const s32 SubWindowDressUpTestProc::PART_NO[ITEM_SECTION_MAX] = 
{
  xy_system::dress_up::DressUpModel::PART_HEAD,
  xy_system::dress_up::DressUpModel::VALUE_NONE,  // 
  xy_system::dress_up::DressUpModel::PART_UPPER,
  xy_system::dress_up::DressUpModel::PART_LOWER,
};
const s32 SubWindowDressUpTestProc::ITEM_NO[ITEM_SECTION_MAX][ELEMENT_MAX] =
{
  {
    xy_system::dress_up::DressUpModel::PARTELEMENT_HEAD_LONG,
    xy_system::dress_up::DressUpModel::PARTELEMENT_HEAD_SHORT,
    ITEM_NO_NONE
  },
  {
    xy_system::dress_up::DressUpModel::SKIN_ASIAN,
    xy_system::dress_up::DressUpModel::SKIN_AFRICAN,
    xy_system::dress_up::DressUpModel::SKIN_EUROPEAN
  },
  {
    xy_system::dress_up::DressUpModel::PARTELEMENT_UPPER_A,
    xy_system::dress_up::DressUpModel::PARTELEMENT_UPPER_B,
    ITEM_NO_NONE
  },
  {
    xy_system::dress_up::DressUpModel::PARTELEMENT_LOWER_PANTS,
    xy_system::dress_up::DressUpModel::PARTELEMENT_LOWER_SKIRT,
    ITEM_NO_NONE
  },
};
const wchar_t* SubWindowDressUpTestProc::ITEM_TEXT[ITEM_SECTION_MAX][ELEMENT_MAX] =
{
  { L"O",    L"V[g",  NULL },
  { L"AWA",    L"AtJ",  L"k" },
  { L"p^[1", L"p^[2", NULL },
  { L"pc",    L"XJ[g",  NULL },
};
const wchar_t* SubWindowDressUpTestProc::ITEM_TITLE[ITEM_SECTION_MAX] =
{
  L"^",
  L"F",
  L"gbvX",
  L"{gX",
};


//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤UpdateFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result SubWindowDressUpTestProc::InitFunc(gfl::proc::Manager* /*pManager*/)
{
  m_item_section_index = 0;
  for( s32 i=0; i<ITEM_SECTION_MAX; ++i )
  {
    m_element_index[i] = 0;
  }

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃CXVs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result SubWindowDressUpTestProc::UpdateFunc(gfl::proc::Manager* /*pManager*/)
{
  if( this->IsReqEnd() ){
    return gfl::proc::RES_FINISH;
  }

  field::Fieldmap*         p_fieldmap = this->GetFieldmap();
  gamesystem::GameManager* gmgr       = p_fieldmap->GetGameManager();
  field::Graphics*         graphics   = p_fieldmap->GetGraphics();
  gfl::grp::g3d::Scene*    scene      = graphics->GetScene();

  field::PlayerGrid*                  player_grid                  = p_fieldmap->GetFieldPlayer();
  field::mmodel::MoveModel*           player_move_model            = player_grid->GetModel();
  field::mmodel::Move3DModel*         player_move_3d_model         = player_move_model->GetDrawModel();
  field::mmodel::Move3DVisibleModel*  player_move_3d_visible_model = player_move_3d_model->GetVisibleModel();
  xy_system::dress_up::DressUpModel*  player_dress_up_model        = player_move_3d_visible_model->GetDressUpModel();

  const gfl::ui::Button*       button    = gmgr->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
  const gfl::ui::VectorDevice* cross_key = gmgr->GetUiDeviceManager()->GetCrossKey(gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD);
  const gfl::ui::VectorDevice* stick     = gmgr->GetUiDeviceManager()->GetStick(gfl::ui::CTR_DeviceManager::STICK_STANDARD);

  // ݂̒l𔽉f
  {
    if(player_dress_up_model)
    {
      xy_system::dress_up::DressUpModel::Profile profile;
      player_dress_up_model->GetComponent(&profile);
    
      s32 current_index[ITEM_SECTION_MAX];
      current_index[ITEM_SECTION_HAIR]    = profile.part_head;
      current_index[ITEM_SECTION_SKIN]    = profile.skin;
      current_index[ITEM_SECTION_TOPS]    = profile.part_upper;
      current_index[ITEM_SECTION_BOTTOMS] = profile.part_lower;
    
      // xy_system::dress_up::DressUpModel̒lÃNX̒lɕϊ
      for(s32 h=0; h<ITEM_SECTION_MAX; ++h)
      {
        for(s32 i=0; i<ELEMENT_MAX; ++i)
        {
          if( current_index[h] == ITEM_NO[h][i] )
          {
            m_element_index[h] = i;
            break;
          }
        }
      }
    }
    else
    {
      return gfl::proc::RES_CONTINUE;
    }
  }

  // 
  {
    // I
    if( button->IsTrigger( gfl::ui::BUTTON_B ) )
    {
      // B{^͂PROC𐶐CxgŌm
    }
    else if( button->IsTrigger( gfl::ui::BUTTON_A ) )
    {
      ++(m_element_index[m_item_section_index]);
      if( m_element_index[m_item_section_index] >= ELEMENT_MAX )
      {
        m_element_index[m_item_section_index] = 0;
      }
      else if( ITEM_NO[m_item_section_index][m_element_index[m_item_section_index]] == ITEM_NO_NONE )
      {
        m_element_index[m_item_section_index] = 0;
      }

      // ύX
      {
        if(player_dress_up_model)
        {
          if( m_item_section_index == ITEM_SECTION_SKIN )
          {
            player_dress_up_model->ChangeComponent(
                NULL,
                NULL,
                scene,
                xy_system::dress_up::DressUpModel::COMPONENT_SKIN,
                ITEM_NO[m_item_section_index][m_element_index[m_item_section_index]]
            );
          }
          else
          {
            player_dress_up_model->ChangeComponent(
                NULL,
                NULL,
                scene,
                xy_system::dress_up::DressUpModel::COMPONENT_PART,
                PART_NO[m_item_section_index],
                ITEM_NO[m_item_section_index][m_element_index[m_item_section_index]]
            );
          }
        }
      }
    }
    else
    {
      if( cross_key->IsRepeat( gfl::ui::DIR_UP ) )
      {
        --m_item_section_index;
        if( m_item_section_index < 0 )
        {
          m_item_section_index = ITEM_SECTION_MAX -1;
        }
      }
      else if( cross_key->IsRepeat( gfl::ui::DIR_DOWN ) )
      {
        ++m_item_section_index;
        if( m_item_section_index >= ITEM_SECTION_MAX )
        {
          m_item_section_index = 0;
        }
      }
    }
  }

  return gfl::proc::RES_CONTINUE;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃C`s֐
 *          zł͂܂B
 */
//------------------------------------------------------------------
void   SubWindowDressUpTestProc::DrawFunc(gfl::proc::Manager* /*pManager*/)
{
  field::Fieldmap*          p_fieldmap      = this->GetFieldmap();
  field::Graphics*          graphics        = p_fieldmap->GetGraphics();
  gfl::grp::GraphicsSystem* graphics_system = graphics->GetGraphicsSystem();

  // ̊ȈՕ`
  {
    // tB[hőO㏈͍ς܂Ă̂ŁA`悷邾ł悢

    // 
    gfl::grp::RenderTarget* lower_frame_buffer = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
    graphics_system->BindCurrentCommandList( lower_frame_buffer );
    gfl::grp::util::DrawUtil::BeginRender( lower_frame_buffer ); 
    gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 1.0f, 1.0f) );  // RGBA
    gfl::grp::util::DrawUtil::SetTextScale( 0.5f, 0.5f );   // オ(0, 0)

    s32 text_x_pos = 10;
    s32 text_y_pos = 10;
    const s32 text_y_pos_add = 20;

    const s32 text_x_pos_page    = 10;
    const s32 text_x_pos_title   = 30;
    const s32 text_x_pos_element = 120;
    
    gfl::grp::util::DrawUtil::DrawText( text_x_pos_page, text_y_pos, L"[ւ]" );
    text_y_pos += text_y_pos_add;
    
    text_y_pos += text_y_pos_add;

    for( s32 i=0; i<ITEM_SECTION_MAX; ++i )
    {
      if( i == m_item_section_index )
      {
        gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 0.0f, 0.0f, 1.0f) );  // RGBA
      }
      else
      {
        gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 1.0f, 1.0f) );  // RGBA
      }
      gfl::grp::util::DrawUtil::DrawText( text_x_pos_title,   text_y_pos, ITEM_TITLE[i] );
      gfl::grp::util::DrawUtil::DrawText( text_x_pos_element, text_y_pos, ITEM_TEXT[i][m_element_index[i]] );
      text_y_pos += text_y_pos_add;
    }
    
    gfl::grp::util::DrawUtil::EndRender();
  }
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result SubWindowDressUpTestProc::EndFunc(gfl::proc::Manager* /*pManager*/)
{
  return gfl::proc::RES_FINISH;
}


}  // namespace field

