//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldEvTypeEye.cpp
 *	@brief  ng[i[
 *	@author	tomoya takahashi 
 *	@date		2011.09.17
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "FieldEvTypeEye.h"
#include "field/Fieldmap.h"

namespace field
{
namespace mmodel
{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------

  //-----------------------------------------------------------------------------
  /**
   *    180x낫뎋
   */
  //-----------------------------------------------------------------------------
  //----------------------------------------------------------------------------
  /**
   *	@brief  R[h@
   *
   *	@param	p_wk  R[h[N
   */
  //-----------------------------------------------------------------------------
  void EvTypeEye180::InitProcess( EvTypeWork* p_wk ) const
  {
    Work* p_work = static_cast<Work*>(EvTypeBase::GetEvTypeWork( p_wk, sizeof(Work) ));
    MoveModel* p_model = reinterpret_cast<MoveModel*>(p_wk->p_model);
    
    // JEg𗐐Ō
    p_work->count = xy_system::GflUse::GetPublicRand( COUNT_MAX );
  
    // ݒ
    MainProcess( p_wk );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  R[h  C@
   *
   *	@param	p_wk  R[h[N
   *
   *	@retval true  MoveCodȅ𓮂
   *	@retval false MoveCodȅ𓮂Ȃ
   */
  //-----------------------------------------------------------------------------
  bool EvTypeEye180::MainProcess( EvTypeWork* p_wk ) const
  {
    Work* p_work = static_cast<Work*>(EvTypeBase::GetEvTypeWork( p_wk, sizeof(Work) ));
    MoveModel* p_model = reinterpret_cast<MoveModel*>(p_wk->p_model);
    
    gfl::math::VEC3 way;
    gfl::math::VEC3 pos;
    
    p_wk->p_model->GetVectorPos( &pos );
    p_wk->p_model->GetDirDispWay(&way);

    // count up
    p_work->count = (p_work->count + 1) % COUNT_MAX;
    
    // countɑΉɎĂB
    // Sin֐gpĊ炩ɓB
    f32 deg = (static_cast<f32>(p_work->count) / static_cast<f32>(COUNT_MAX)) * 360.0f;
    f32 percent = gfl::math::SinDeg( deg );
    
    // EYMax45x]B
    gfl::math::MTX34 rot;
    gfl::math::MTX34RotXYZFIdx( &rot, 0.0f, percent * EYE_R, 0.0f );  // idx = 1256
    gfl::math::VEC3Transform( &way, &rot, &way );
    way = way.Normalize();
    p_work->way = way;
    pos = pos + (way * 32.0f);

    // `惂f邩`FbN
    Move3DModel* p_drawmodel = p_model->GetDrawModel();
    if( p_drawmodel ){
      // ̐ݒ
      p_drawmodel->SetInterestView( pos );
      p_drawmodel->SetInterestMode( Move3DModel::INTEREST_NEAR );
    }
    
    return true;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  R[h  j
   *
   *	@param	p_wk  R[h[N
   */
  //-----------------------------------------------------------------------------
  void EvTypeEye180::DeleteProcess( EvTypeWork* p_wk ) const
  {
    MoveModel* p_model = reinterpret_cast<MoveModel*>(p_wk->p_model);
    
    // `惂f邩`FbN
    Move3DModel* p_drawmodel = p_model->GetDrawModel();
    if( p_drawmodel ){
      // ̐ݒ
      p_drawmodel->ClearInterestView();
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  R[h  A
   *
   *	@param	p_wk  R[h[N
   */
  //-----------------------------------------------------------------------------
  void EvTypeEye180::ReturnProcess( EvTypeWork* /*p_wk*/ ) const
  {
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  
   */
  //-----------------------------------------------------------------------------
  void EvTypeEye180::GetEyeWay( const EvTypeWork* cp_wk, gfl::math::VEC3* p_way ) const
  {
    const Work* cp_work = static_cast<const Work*>(EvTypeBase::GetEvTypeWork( cp_wk, sizeof(Work) ));
    *p_way = cp_work->way;
  }




  //-----------------------------------------------------------------------------
  /**
   *    ڌ^
   */
  //-----------------------------------------------------------------------------
  //----------------------------------------------------------------------------
  /**
   *	@brief  R[h@
   *
   *	@param	p_wk  R[h[N
   */
  //-----------------------------------------------------------------------------
  void EvTypeEyeTarget::InitProcess( EvTypeWork* p_wk ) const
  {
    this->MainProcess(p_wk);
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  R[h  C@
   *
   *	@param	p_wk  R[h[N
   *
   *	@retval true  MoveCodȅ𓮂
   *	@retval false MoveCodȅ𓮂Ȃ
   */
  //-----------------------------------------------------------------------------
  bool EvTypeEyeTarget::MainProcess( EvTypeWork* p_wk ) const
  {
    Dir dir;
    // SɂΉĂȂB
    dir = p_wk->p_model->GetDirDisp();
    if(dir > DIR_RIGHT){
      GFL_ASSERT( dir <= DIR_RIGHT );
      return true;
    }

    // @̎擾
    MoveModel* p_model = reinterpret_cast<MoveModel*>(p_wk->p_model);
    PlayerGrid* p_player = p_model->GetManager()->GetFieldmap()->GetFieldPlayer();
    Move3DModel* p_drawmodel = p_model->GetDrawModel();
    gfl::math::VEC3 pos;
    
    p_player->GetPos(&pos);
    
    s32 gx, gz;
    gx = p_wk->p_model->GetGridPosX();
    gz = p_wk->p_model->GetGridPosZ();

    s32 range = p_model->GetTrRange();

    // `FbNObhW
    s32 cgx, cgz;
    cgx = POS_TO_GRID<s32>(static_cast<s32>(pos.x));
    cgz = POS_TO_GRID<s32>(static_cast<s32>(pos.z));
    

    do
    {
      // `惏[N邩H
      if( p_drawmodel == NULL ){
        break;
      }
      
      // W͂邩H
      if(range <= 0){
        break;
      }

      // YẄႢ邩H
      if( gfl::math::Abs(pos.y - p_wk->p_model->GetVectorPosY()) >= H_GRID_FELLOW_SIZE ){
        break;
      }

      // ͈͂̋߂Ɏ@邩H
      s32 gsx, gex, gsz, gez; // `FbN[v͈
      CheckArea( dir, range, &gsx, &gsz, &gex, &gez );
      gsx += gx;
      gex += gx;
      gsz += gz;
      gez += gz;
      for( u32 i=gsx; i<=gex; ++i ){
        for( u32 j=gsz; j<=gez; ++j ){

          // I
          if( (i==cgx) && (j==cgz) ){
            p_drawmodel->SetInterestView( pos );
            p_drawmodel->SetInterestMode( Move3DModel::INTEREST_NEAR );
            TOMOYA_PRINT( "Target Hit\n" );
            return true;
          }
        }
      }
    }while(0);
    


    // X܂łƂƂ̓WO
    // ړ_͂
    if(p_drawmodel){
      if( p_drawmodel->IsInterestView() ){
        TOMOYA_PRINT( "Target Out\n" );
        p_drawmodel->ClearInterestView();
      }
    }
    
    return true;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  R[h  j
   *
   *	@param	p_wk  R[h[N
   */
  //-----------------------------------------------------------------------------
  void EvTypeEyeTarget::DeleteProcess( EvTypeWork* p_wk ) const
  {
    // @̎擾
    MoveModel* p_model = reinterpret_cast<MoveModel*>(p_wk->p_model);
    Move3DModel* p_drawmodel = p_model->GetDrawModel();

    if(p_drawmodel){
      p_drawmodel->ClearInterestView();
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  R[h  A
   *
   *	@param	p_wk  R[h[N
   */
  //-----------------------------------------------------------------------------
  void EvTypeEyeTarget::ReturnProcess( EvTypeWork* p_wk ) const
  {
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  qbg`FbN͈͂߂B
   *
   *	@param	dir     
   *	@param	range   W
   *	@param	p_gsx   JnX͈͊i[
   *	@param	p_gsz   JnZ͈͊i[
   *	@param	p_gex   IX͈͊i[
   *	@param	p_gez   IZ͈͊i[
   *
   *	@return qbg`FbŃ͈B
   */
  //-----------------------------------------------------------------------------
  void EvTypeEyeTarget::CheckArea( Dir dir, s32 range, s32* p_gsx, s32* p_gsz, s32* p_gex, s32* p_gez )
  {
    switch( dir ){
    case DIR_UP:			  ///<
      *p_gsx = -1;
      *p_gex = 1;
      *p_gsz = -(range + 1);
      *p_gez = -1;
      break;

    case DIR_DOWN:		  ///<
      *p_gsx = -1;
      *p_gex = 1;
      *p_gsz = 1;
      *p_gez = range + 1;
      break;

    case DIR_LEFT:		  ///<
      *p_gsx = -(range + 1);
      *p_gex = -1;
      *p_gsz = -1;
      *p_gez = 1;
      break;

    case DIR_RIGHT:		///<E
      *p_gsx = 1;
      *p_gex = (range + 1);
      *p_gsz = -1;
      *p_gez = 1;
      break;
    }
  }


} // namespace mmodel
} // namespace field
