//=======================================================================================
/**
 * @file ItemListBase.h
 * @briefuXgvʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.16
 */
//=======================================================================================
#ifndef __ITEMLISTBASE_H__
#define __ITEMLISTBASE_H__
#include <gflib.h>
#include "AppBase.h"


namespace btl {

  class BattleViewSystem;


  namespace app {

    class ItemListBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( ItemListBase );  // Rs[֎~

      public: 


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      ItemListBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~ItemListBase();




      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      // |Pbgԍ
      enum PocketIndex {
        POCKET_HP,
        POCKET_BALL,
        POCKET_STATUS,
        POCKET_BATTLE,
        POCKET_NUM,
      };

      // ݒ
      struct Setting {
        PocketIndex pocket_index;  // \|Pbg
        u32 last_item_id;          // ŌɎgACehc
      };

      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting ) = 0;




      //---------------------------------------------------------------------------------
      // 
      //---------------------------------------------------------------------------------
      // I
      enum Result {
        RESULT_RETURN,  //uǂvI
        RESULT_ITEM,    // I
        RESULT_NULL,
      };

      /**
       * @brief ʂ擾
       */
      Result GetResult( void ) const;

      /**
       * @brief Îhc擾
       * @note RESULT_ITEM ̏ꍇɂ̂ݗL
       */
      u32 GetSelectedItemID( void ) const;







      protected:
      void SetSetting( const Setting& new_setting ) { m_settings = new_setting; }
      const Setting& GetSetting( void ) const { return m_settings; }
      PocketIndex GetPocketIndex( void ) const { return m_settings.pocket_index; }
      u32 GetLastItemID( void ) const { return m_settings.last_item_id; }

      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }
      void SetSelectedItemID( u32 item_id ) { m_selected_item_id =item_id; }


      private:
      Setting m_settings;
      Result m_result;
      u32 m_selected_item_id;
    };


  }  // namespace app
}  // namespace btl


#endif // __ITEMLISTBASE_H__ 
