//=======================================================================================
/**
 * @file ItemListBase.h
 * @briefuXgvʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.16
 */
//=======================================================================================
#include <gflib.h>
#include <system/main.h>
#include <battle/btlv/btlv_core.h>
#include "AppBase.h"
#include "ItemListBase.h"


namespace btl {
  namespace app {



    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param app_heap          gpAvP[Vq[v
     * @param app_heap_size     gpAvP[Vq[ṽTCY
     * @param device_heap       gpfoCXq[v
     * @param device_heap_size  gpfoCXq[ṽTCY
     * @param btlv_system       og`RAVXe
     */
    //---------------------------------------------------------------------------------
    ItemListBase::ItemListBase( 
        gfl::heap::HeapBase* app_heap, u32 app_heap_size,
        gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
        BattleViewSystem* btlv_system ) :
      AppBase( 
          app_heap, HEAPID_BATTLE_ITEM_LIST, app_heap_size, 
          device_heap, HEAPID_BATTLE_ITEM_LIST_DEVICE, device_heap_size, 
          btlv_system ),
      m_settings(),
      m_result( RESULT_NULL ),
      m_selected_item_id( ITEM_DUMMY_DATA )
    {
    }



    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    ItemListBase::~ItemListBase()
    {
    }



    //---------------------------------------------------------------------------------
    /**
     * @brief ʂ擾
     */
    //---------------------------------------------------------------------------------
    ItemListBase::Result ItemListBase::GetResult( void ) const
    {
      return m_result;
    }

    //---------------------------------------------------------------------------------
    /**
     * @brief Îhc擾
     * @note RESULT_ITEM ̏ꍇɂ̂ݗL
     */
    //---------------------------------------------------------------------------------
    u32 ItemListBase::GetSelectedItemID( void ) const
    {
      return m_selected_item_id;
    }



  }  // namespace app
}  // namespace btl
