//=======================================================================================
/**
 * @file ItemList.h
 * @briefuXgv
 * @author obata_toshihiro
 * @date 2011.09.16
 */
//=======================================================================================
#ifndef __ITEMLIST_H__
#define __ITEMLIST_H__
#include <gflib.h>
#include <savedata/sv_myitem.h>
#include <battle/btl_common.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "ItemListBase.h"


namespace btl {

  class BattleViewSystem;


  namespace app {

    class ItemList : public ItemListBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( ItemList );  // Rs[֎~

      public:


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap      gpAvP[Vq[v
       * @param device_heap   gpfoCXq[v
       * @param btlv_system   og`RAVXe
       */
      ItemList( 
          gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap,
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~ItemList(); 


      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting );


      //---------------------------------------------------------------------------------
      // {
      //---------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      virtual void Update( void );

      /**
       * @brief ŏĊJ( ݒ͈p )
       */
      virtual void Restart( void );

      /**
       * @brief I[g`tOZbg
       */
      virtual void SetAutoDrawFlag( bool flag );





      private: 

      // V[PX
      enum Sequence {
        SEQ_INPUT_WAIT,   // ͑҂
        SEQ_ANIME_WAIT,   // Aj[V҂
        SEQ_NEXT_PAGE,    // ̃y[Wֈړ
        SEQ_PREV_PAGE,    // Õy[Wֈړ
        SEQ_FINISH,       // I
        SEQ_NULL,
      };


      // {^
      enum ItemButtonIndex {
        ITEM_BUTTON_00,
        ITEM_BUTTON_01,
        ITEM_BUTTON_02,
        ITEM_BUTTON_03,
        ITEM_BUTTON_04,
        ITEM_BUTTON_05,
        ITEM_BUTTON_NUM,
        ITEM_BUTTON_NULL,
      };

      // {^ԍ
      enum ButtonIndex {
        BUTTON_ITEM,                                  // 
        BUTTON_LEFT = BUTTON_ITEM + ITEM_BUTTON_NUM,  // 
        BUTTON_RIGHT,                                 // E
        BUTTON_RETURN,                                //uǂv
        BUTTON_NUM,
      };


      // Aj[Vf[^ԍ
      enum AnimeDataIndex {
        ANIME_DATA_DUMMY_BUTTON_HOLD,
        ANIME_DATA_DUMMY_BUTTON_RELEASE,
        ANIME_DATA_DUMMY_BUTTON_SELECT,
        ANIME_DATA_LEFT_BUTTON_ACTIVE,
        ANIME_DATA_LEFT_BUTTON_PASSIVE,
        ANIME_DATA_RIGHT_BUTTON_ACTIVE,
        ANIME_DATA_RIGHT_BUTTON_PASSIVE,
        ANIME_DATA_ITEM_00_ACTIVE,
        ANIME_DATA_ITEM_00_PASSIVE,
        ANIME_DATA_ITEM_01_ACTIVE,
        ANIME_DATA_ITEM_01_PASSIVE,
        ANIME_DATA_ITEM_02_ACTIVE,
        ANIME_DATA_ITEM_02_PASSIVE,
        ANIME_DATA_ITEM_03_ACTIVE,
        ANIME_DATA_ITEM_03_PASSIVE,
        ANIME_DATA_ITEM_04_ACTIVE,
        ANIME_DATA_ITEM_04_PASSIVE,
        ANIME_DATA_ITEM_05_ACTIVE,
        ANIME_DATA_ITEM_05_PASSIVE,
        ANIME_DATA_CURSOR_FLUCTUATE,
        ANIME_DATA_CURSOR_ON_ITEM_00,
        ANIME_DATA_CURSOR_ON_ITEM_01,
        ANIME_DATA_CURSOR_ON_ITEM_02,
        ANIME_DATA_CURSOR_ON_ITEM_03,
        ANIME_DATA_CURSOR_ON_ITEM_04,
        ANIME_DATA_CURSOR_ON_ITEM_05,
        ANIME_DATA_CURSOR_ON_LEFT,
        ANIME_DATA_CURSOR_ON_RIGHT,
        ANIME_DATA_CURSOR_ON_RETURN,
        ANIME_DATA_NUM,
      };


      // Aj[Vԍ
      enum AnimeIndex {
        ANIME_DUMMY_BUTTON_HOLD,
        ANIME_DUMMY_BUTTON_RELEASE,
        ANIME_DUMMY_BUTTON_SELECT,
        ANIME_LEFT_BUTTON_ACTIVE,
        ANIME_LEFT_BUTTON_PASSIVE,
        ANIME_RIGHT_BUTTON_ACTIVE,
        ANIME_RIGHT_BUTTON_PASSIVE,
        ANIME_ITEM_00_ACTIVE,
        ANIME_ITEM_00_PASSIVE,
        ANIME_ITEM_01_ACTIVE,
        ANIME_ITEM_01_PASSIVE,
        ANIME_ITEM_02_ACTIVE,
        ANIME_ITEM_02_PASSIVE,
        ANIME_ITEM_03_ACTIVE,
        ANIME_ITEM_03_PASSIVE,
        ANIME_ITEM_04_ACTIVE,
        ANIME_ITEM_04_PASSIVE,
        ANIME_ITEM_05_ACTIVE,
        ANIME_ITEM_05_PASSIVE,
        ANIME_CURSOR_FLUCTUATE,
        ANIME_CURSOR_ON_ITEM_00,
        ANIME_CURSOR_ON_ITEM_01,
        ANIME_CURSOR_ON_ITEM_02,
        ANIME_CURSOR_ON_ITEM_03,
        ANIME_CURSOR_ON_ITEM_04,
        ANIME_CURSOR_ON_ITEM_05,
        ANIME_CURSOR_ON_LEFT,
        ANIME_CURSOR_ON_RIGHT,
        ANIME_CURSOR_ON_RETURN,
        // ȉ, LAj[V
        ANIME_BUTTON_HOLD,
        ANIME_BUTTON_RELEASE = ANIME_BUTTON_HOLD + BUTTON_NUM,
        ANIME_BUTTON_SELECT = ANIME_BUTTON_RELEASE + BUTTON_NUM,
        ANIME_NUM = ANIME_BUTTON_SELECT + BUTTON_NUM,
        ANIME_NULL,
      };


      // LAj[Vԍ
      enum ShareAnimeIndex {
        SHARE_ANIME_BUTTON_HOLD,
        SHARE_ANIME_BUTTON_RELEASE,
        SHARE_ANIME_BUTTON_SELECT,
        SHARE_ANIME_NUM,
      };


      // LAj[VƂ̐ݒ
      struct ShareAnimeDesc {
        AnimeIndex top_anime_index;                     // o^CfbNX
        AnimeDataIndex anime_data_index;                // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };


      // {^Ƃ̐ݒ
      struct ButtonDesc {
        ItemButtonIndex item_button_index;       // Ή铹{^̃CfbNX
        Result result;                           // Iꂽꍇ̌
        gfl::grp::g2d::LytPaneIndex pane_index;  // {^ƂĈyC
        AnimeIndex hold_anime;                   // ꂽۂ̃Aj[V
        AnimeIndex release_anime;                // ꂽۂ̃Aj[V
        AnimeIndex select_anime;                 // I΂ꂽۂ̃Aj[V
        AnimeIndex active_anime;                 // {^Lȍۂ̃Aj[V
        AnimeIndex passive_anime;                // {^ȍۂ̃Aj[V
        AnimeIndex cursor_anime;                 // J[\ZbgAj[V
      };

      // {^Ƃ̐ݒ
      struct ItemButtonDesc {
        gfl::grp::g2d::LytPaneIndex name_pane;   // \yC
        gfl::grp::g2d::LytPaneIndex count_pane;  // \yC
        bool prev_page_enable;                   // L[ɂÕy[Wֈړł邩ǂ
        bool next_page_enable;                   // EL[ɂ莟̃y[Wֈړł邩ǂ
      };


      // |PbgƂ̍őACe
      static const u32 MAX_POCKET_ITEM_NUM = 32;

      // |PbgƂ̃f[^
      struct PocketData {
        u32 item_count;
        savedata::MYITEM::ITEM_ST items[ MAX_POCKET_ITEM_NUM ];
      };




      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE;
      static const u32 PAGE_COUNT_PLACE_NUM;
      static const u32 ITEM_COUNT_PLACE_NUM;
      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIME_DATA_TABLE[ ANIME_DATA_NUM ];
      static const ShareAnimeDesc SHARE_ANIME_DESC[ SHARE_ANIME_NUM ];
      static const ButtonDesc BUTTON_DESC[ BUTTON_NUM ];
      static const ItemButtonDesc ITEM_BUTTON_DESC[ ITEM_BUTTON_NUM ];
      static const ::app::tool::CursorManager::MOVE_DATA CURSOR_MOVE_DATA[ BUTTON_NUM ];

      
      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;
      ::app::tool::ButtonManager* m_button_manager;
      ::app::tool::CursorManager* m_cursor_manager;

      Sequence m_seq;
      Sequence m_next_seq;
      AnimeIndex m_wait_anime_index;

      PocketData m_pocket_data[ POCKET_NUM ];
      u8 m_current_page_index;
      u32 m_init_item_index;


      u8 CalcPageCount( PocketIndex pocket ) const; 
      u8 CalcPageIndex( u8 item_index ) const;
      u8 CalcItemIndex( ItemButtonIndex button_index ) const;

      void InitializeGraphicsSystem( void );
      void SetupFont( void );
      void CreateLayoutWork( void );
      void CreateShareAnime( void );
      void CreateCursorManager( void );
      void CreateButtonManager( void );
      void SetupButtonManager( void ); 

      void FinalizeGraphicsSystem( void );
      void DeleteLayoutWork( void );
      void DeleteCursorManager( void );
      void DeleteButtonManager( void );

      void SetupItemButtons( void );
      void SetupItemButton( ButtonIndex button );
      void SetupItemButton( ItemButtonIndex button );
      void InitializeCursorPos( void );

      void InitPocketData( void );
      u8 SetupPocketData( void );
      void AddItemToPocket( PocketIndex pocket_index, u32 item_id );
      void SetupButtonItemIndex( void );

      void SetupLeftButton( void );
      void SetupRightButton( void );
      void SetupPage( void );
      void SetupPocketName( void );

      void UpdateSequence( void );
      void OnButtonSelected( ButtonIndex selected_button );
      void SetNextPage( void );
      void SetPrevPage( void );
      bool IsNextPageInputDetected( void ) const;
      bool IsPrevPageInputDetected( void ) const;
      bool IsNextPageEnable( void ) const;
      bool IsPrevPageEnable( void ) const;
      bool IsButtonHolding( void ) const;
      bool IsButtonSelected( void ) const;
      ButtonIndex GetSelectedCursorPosByButton( void ) const;
      bool UpdateCursorMove( void );
      ButtonIndex GetCurrentCursorPos( void ) const;
      ButtonIndex GetPrevCursorPos( void ) const;
      bool IsSelectEnable( ButtonIndex cursor_pos ) const;
      void SetResultByCursorPos( ButtonIndex cursor_pos );

      void StartSelectAnime( ButtonIndex cursor_pos );
      bool IsSelectAnimeFinished( void ) const;
      void StartCursorMoveAnime( ButtonIndex old_cursor_pos, ButtonIndex new_cursor_pos );
    };


  }  // namespace app
}  // namespace btl


#endif // __ITEMLIST_H__ 
