//=======================================================================================
/**
 * @file ItemList.h
 * @briefuXgv
 * @author obata_toshihiro
 * @date 2011.09.16
 */
//=======================================================================================
#include <gflib.h>
#include <savedata/sv_myitem.h>
#include <battle/btlv/btlv_core.h>
#include <app/util/app_util.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include <item/itemsym.h>
#include <item/itempocket_def.h>
#include "ItemListBase.h"
#include "ItemList.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <arc/item_battle_pocket.gaix>
#include <message/msg_btl_app.h>
#include "item_list.h"
#include "item_list_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 ItemList::APP_HEAPSIZE    =  0x1000;
    const u32 ItemList::DEVICE_HEAPSIZE = 0x60000;


    // ľ
    const u32 ItemList::ITEM_COUNT_PLACE_NUM = 3;
    const u32 ItemList::PAGE_COUNT_PLACE_NUM = 1;


    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp ItemList::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex ItemList::ANIME_DATA_TABLE[ ItemList::ANIME_DATA_NUM ] = 
    {
      /* ANIME_DATA_DUMMY_BUTTON_HOLD */ LYTRES_ITEM_LIST_ITEM_LIST_DUMMY_BUTTON_HOLD_BCLAN,
      /* ANIME_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_ITEM_LIST_ITEM_LIST_DUMMY_BUTTON_RELEASE_BCLAN,
      /* ANIME_DATA_DUMMY_BUTTON_SELECT */ LYTRES_ITEM_LIST_ITEM_LIST_DUMMY_BUTTON_SELECT_BCLAN,
      /* ANIME_DATA_LEFT_BUTTON_ACTIVE */ LYTRES_ITEM_LIST_ITEM_LIST_LEFT_BUTTON_ACTIVE_BCLAN,
      /* ANIME_DATA_LEFT_BUTTON_PASSIVE */ LYTRES_ITEM_LIST_ITEM_LIST_LEFT_BUTTON_PASSIVE_BCLAN,
      /* ANIME_DATA_RIGHT_BUTTON_ACTIVE */ LYTRES_ITEM_LIST_ITEM_LIST_RIGHT_BUTTON_ACTIVE_BCLAN,
      /* ANIME_DATA_RIGHT_BUTTON_PASSIVE */ LYTRES_ITEM_LIST_ITEM_LIST_RIGHT_BUTTON_PASSIVE_BCLAN,
      /* ANIME_DATA_ITEM_00_ACTIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_00_ACTIVE_BCLAN,
      /* ANIME_DATA_ITEM_00_PASSIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_00_PASSIVE_BCLAN,
      /* ANIME_DATA_ITEM_01_ACTIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_01_ACTIVE_BCLAN,
      /* ANIME_DATA_ITEM_01_PASSIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_01_PASSIVE_BCLAN,
      /* ANIME_DATA_ITEM_02_ACTIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_02_ACTIVE_BCLAN,
      /* ANIME_DATA_ITEM_02_PASSIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_02_PASSIVE_BCLAN,
      /* ANIME_DATA_ITEM_03_ACTIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_03_ACTIVE_BCLAN,
      /* ANIME_DATA_ITEM_03_PASSIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_03_PASSIVE_BCLAN,
      /* ANIME_DATA_ITEM_04_ACTIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_04_ACTIVE_BCLAN,
      /* ANIME_DATA_ITEM_04_PASSIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_04_PASSIVE_BCLAN,
      /* ANIME_DATA_ITEM_05_ACTIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_05_ACTIVE_BCLAN,
      /* ANIME_DATA_ITEM_05_PASSIVE */ LYTRES_ITEM_LIST_ITEM_LIST_ITEM_05_PASSIVE_BCLAN,
      /* ANIME_DATA_CURSOR_FLUCTUATE */ LYTRES_ITEM_LIST_ITEM_LIST_CURSOR_FLUCTUATE_BCLAN,
      /* ANIME_DATA_CURSOR_ON_ITEM_00 */ LYTRES_ITEM_LIST_ITEM_LIST_CURSOR_ON_ITEM_00_BCLAN,
      /* ANIME_DATA_CURSOR_ON_ITEM_01 */ LYTRES_ITEM_LIST_ITEM_LIST_CURSOR_ON_ITEM_01_BCLAN,
      /* ANIME_DATA_CURSOR_ON_ITEM_02 */ LYTRES_ITEM_LIST_ITEM_LIST_CURSOR_ON_ITEM_02_BCLAN,
      /* ANIME_DATA_CURSOR_ON_ITEM_03 */ LYTRES_ITEM_LIST_ITEM_LIST_CURSOR_ON_ITEM_03_BCLAN,
      /* ANIME_DATA_CURSOR_ON_ITEM_04 */ LYTRES_ITEM_LIST_ITEM_LIST_CURSOR_ON_ITEM_04_BCLAN,
      /* ANIME_DATA_CURSOR_ON_ITEM_05 */ LYTRES_ITEM_LIST_ITEM_LIST_CURSOR_ON_ITEM_05_BCLAN,
      /* ANIME_DATA_CURSOR_ON_LEFT */ LYTRES_ITEM_LIST_ITEM_LIST_CURSOR_ON_LEFT_BCLAN,
      /* ANIME_DATA_CURSOR_ON_RIGHT */ LYTRES_ITEM_LIST_ITEM_LIST_CURSOR_ON_RIGHT_BCLAN,
      /* ANIME_DATA_CURSOR_ON_RETURN */ LYTRES_ITEM_LIST_ITEM_LIST_CURSOR_ON_RETURN_BCLAN,
    }; 

    

    // LAj[VƂ̐ݒ
    const ItemList::ShareAnimeDesc ItemList::SHARE_ANIME_DESC[ ItemList::SHARE_ANIME_NUM ] = 
    {
      /* SHARE_ANIME_BUTTON_HOLD */
      {
        ANIME_BUTTON_HOLD, 
        ANIME_DATA_DUMMY_BUTTON_HOLD,
        BUTTON_NUM,
        PANENAME_ITEM_LIST_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_BUTTON_RELEASE */
      {
        ANIME_BUTTON_RELEASE, 
        ANIME_DATA_DUMMY_BUTTON_RELEASE,
        BUTTON_NUM,
        PANENAME_ITEM_LIST_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIME_BUTTON_SELECT */
      {
        ANIME_BUTTON_SELECT, 
        ANIME_DATA_DUMMY_BUTTON_SELECT,
        BUTTON_NUM,
        PANENAME_ITEM_LIST_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };




    // {^Ƃ̐ݒ
    const ItemList::ButtonDesc ItemList::BUTTON_DESC[ ItemList::BUTTON_NUM ] = 
    {
      /* BUTTON_ITEM + ITEM_BUTTON_00 */
      {
        ITEM_BUTTON_00,
        ItemListBase::RESULT_ITEM,
        PANENAME_ITEM_LIST_PANE_ITEM_BUTTON_00,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_ITEM + ITEM_BUTTON_00 ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_ITEM + ITEM_BUTTON_00  ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_ITEM + ITEM_BUTTON_00  ),
        ANIME_ITEM_00_ACTIVE,
        ANIME_ITEM_00_PASSIVE,
        ANIME_CURSOR_ON_ITEM_00,
      },
      /* BUTTON_ITEM + ITEM_BUTTON_01 */
      {
        ITEM_BUTTON_01,
        ItemListBase::RESULT_ITEM,
        PANENAME_ITEM_LIST_PANE_ITEM_BUTTON_01,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_ITEM + ITEM_BUTTON_01 ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_ITEM + ITEM_BUTTON_01 ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_ITEM + ITEM_BUTTON_01 ),
        ANIME_ITEM_01_ACTIVE,
        ANIME_ITEM_01_PASSIVE,
        ANIME_CURSOR_ON_ITEM_01,
      },
      /* BUTTON_ITEM + ITEM_BUTTON_02 */
      {
        ITEM_BUTTON_02,
        ItemListBase::RESULT_ITEM,
        PANENAME_ITEM_LIST_PANE_ITEM_BUTTON_02,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_ITEM + ITEM_BUTTON_02 ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_ITEM + ITEM_BUTTON_02 ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_ITEM + ITEM_BUTTON_02 ),
        ANIME_ITEM_02_ACTIVE,
        ANIME_ITEM_02_PASSIVE,
        ANIME_CURSOR_ON_ITEM_02,
      },
      /* BUTTON_ITEM + ITEM_BUTTON_03 */
      {
        ITEM_BUTTON_03,
        ItemListBase::RESULT_ITEM,
        PANENAME_ITEM_LIST_PANE_ITEM_BUTTON_03,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_ITEM + ITEM_BUTTON_03 ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_ITEM + ITEM_BUTTON_03 ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_ITEM + ITEM_BUTTON_03 ),
        ANIME_ITEM_03_ACTIVE,
        ANIME_ITEM_03_PASSIVE,
        ANIME_CURSOR_ON_ITEM_03,
      },
      /* BUTTON_ITEM + ITEM_BUTTON_04 */
      {
        ITEM_BUTTON_04,
        ItemListBase::RESULT_ITEM,
        PANENAME_ITEM_LIST_PANE_ITEM_BUTTON_04,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_ITEM + ITEM_BUTTON_04 ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_ITEM + ITEM_BUTTON_04 ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_ITEM + ITEM_BUTTON_04 ),
        ANIME_ITEM_04_ACTIVE,
        ANIME_ITEM_04_PASSIVE,
        ANIME_CURSOR_ON_ITEM_04,
      },
      /* BUTTON_ITEM + ITEM_BUTTON_05 */
      {
        ITEM_BUTTON_05,
        ItemListBase::RESULT_ITEM,
        PANENAME_ITEM_LIST_PANE_ITEM_BUTTON_05,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_ITEM + ITEM_BUTTON_05 ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_ITEM + ITEM_BUTTON_05 ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_ITEM + ITEM_BUTTON_05 ),
        ANIME_ITEM_05_ACTIVE,
        ANIME_ITEM_05_PASSIVE,
        ANIME_CURSOR_ON_ITEM_05,
      },
      /* BUTTON_LEFT */
      {
        ITEM_BUTTON_NULL,
        ItemListBase::RESULT_NULL,
        PANENAME_ITEM_LIST_PANE_LEFT_BUTTON,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_LEFT ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_LEFT ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_LEFT ),
        ANIME_LEFT_BUTTON_ACTIVE,
        ANIME_LEFT_BUTTON_PASSIVE,
        ANIME_CURSOR_ON_LEFT,
      },
      /* BUTTON_RIGHT */
      {
        ITEM_BUTTON_NULL,
        ItemListBase::RESULT_NULL,
        PANENAME_ITEM_LIST_PANE_RIGHT_BUTTON,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_RIGHT ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_RIGHT ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_RIGHT ),
        ANIME_RIGHT_BUTTON_ACTIVE,
        ANIME_RIGHT_BUTTON_PASSIVE,
        ANIME_CURSOR_ON_RIGHT,
      },
      /* BUTTON_RETURN */ 
      {
        ITEM_BUTTON_NULL,
        ItemListBase::RESULT_RETURN,
        PANENAME_ITEM_LIST_PANE_RETURN_BUTTON,
        static_cast<AnimeIndex>( ANIME_BUTTON_HOLD + BUTTON_RETURN ),
        static_cast<AnimeIndex>( ANIME_BUTTON_RELEASE + BUTTON_RETURN ),
        static_cast<AnimeIndex>( ANIME_BUTTON_SELECT + BUTTON_RETURN ),
        ANIME_NULL,
        ANIME_NULL,
        ANIME_CURSOR_ON_RETURN,
      },
    };





    // {^Ƃ̐ݒ
    const ItemList::ItemButtonDesc ItemList::ITEM_BUTTON_DESC[ ItemList::ITEM_BUTTON_NUM ] = 
    {
      /* ITEM_BUTTON_00 */
      {
        PANENAME_ITEM_LIST_PANE_NAME_00,
        PANENAME_ITEM_LIST_PANE_COUNT_00,
        true,
        false,
      },
      /* ITEM_BUTTON_01 */
      {
        PANENAME_ITEM_LIST_PANE_NAME_01,
        PANENAME_ITEM_LIST_PANE_COUNT_01,
        false,
        true,
      },
      /* ITEM_BUTTON_02 */
      {
        PANENAME_ITEM_LIST_PANE_NAME_02,
        PANENAME_ITEM_LIST_PANE_COUNT_02,
        true,
        false,
      },
      /* ITEM_BUTTON_03 */
      {
        PANENAME_ITEM_LIST_PANE_NAME_03,
        PANENAME_ITEM_LIST_PANE_COUNT_03,
        false,
        true,
      },
      /* ITEM_BUTTON_04 */
      {
        PANENAME_ITEM_LIST_PANE_NAME_04,
        PANENAME_ITEM_LIST_PANE_COUNT_04,
        true,
        false,
      },
      /* ITEM_BUTTON_05 */
      {
        PANENAME_ITEM_LIST_PANE_NAME_05,
        PANENAME_ITEM_LIST_PANE_COUNT_05,
        false,
        true,
      },
    };





    // J[\ړf[^
    const ::app::tool::CursorManager::MOVE_DATA ItemList::CURSOR_MOVE_DATA[ ItemList::BUTTON_NUM ] = 
    {
      /*   id             up               down                 left              right  */
      { (BUTTON_ITEM+ITEM_BUTTON_00), { (BUTTON_ITEM+ITEM_BUTTON_00),  (BUTTON_ITEM+ITEM_BUTTON_02),  (BUTTON_ITEM+ITEM_BUTTON_00),  (BUTTON_ITEM+ITEM_BUTTON_01) } },
      { (BUTTON_ITEM+ITEM_BUTTON_01), { (BUTTON_ITEM+ITEM_BUTTON_01),  (BUTTON_ITEM+ITEM_BUTTON_03),  (BUTTON_ITEM+ITEM_BUTTON_00),  (BUTTON_ITEM+ITEM_BUTTON_01) } },
      { (BUTTON_ITEM+ITEM_BUTTON_02), { (BUTTON_ITEM+ITEM_BUTTON_00),  (BUTTON_ITEM+ITEM_BUTTON_04),  (BUTTON_ITEM+ITEM_BUTTON_02),  (BUTTON_ITEM+ITEM_BUTTON_03) } },
      { (BUTTON_ITEM+ITEM_BUTTON_03), { (BUTTON_ITEM+ITEM_BUTTON_01),  (BUTTON_ITEM+ITEM_BUTTON_05),  (BUTTON_ITEM+ITEM_BUTTON_02),  (BUTTON_ITEM+ITEM_BUTTON_03) } },
      { (BUTTON_ITEM+ITEM_BUTTON_04), { (BUTTON_ITEM+ITEM_BUTTON_02),  BUTTON_LEFT,                   (BUTTON_ITEM+ITEM_BUTTON_04),  (BUTTON_ITEM+ITEM_BUTTON_05) } },
      { (BUTTON_ITEM+ITEM_BUTTON_05), { (BUTTON_ITEM+ITEM_BUTTON_03),  BUTTON_RETURN,                 (BUTTON_ITEM+ITEM_BUTTON_04),  (BUTTON_ITEM+ITEM_BUTTON_05) } },
      { BUTTON_LEFT,                  { (BUTTON_ITEM+ITEM_BUTTON_04),  BUTTON_LEFT,                   BUTTON_LEFT,                   BUTTON_RIGHT } },
      { BUTTON_RIGHT,                 { (BUTTON_ITEM+ITEM_BUTTON_04),  BUTTON_RIGHT,                  BUTTON_LEFT,                   BUTTON_RETURN } },
      { BUTTON_RETURN,                { (BUTTON_ITEM+ITEM_BUTTON_05),  BUTTON_RETURN,                 BUTTON_RIGHT,                  BUTTON_RETURN } },
    };









    //---------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap          gpAvP[Vq[v
     * @param device_heap   gpfoCXq[v
     * @param btlv_system   og`RAVXe
     */
    //---------------------------------------------------------------------------------
    ItemList::ItemList( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
        BattleViewSystem* btlv_system ) :
      ItemListBase( heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, btlv_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager( NULL ),
      m_cursor_manager( NULL ),
      m_seq( SEQ_INPUT_WAIT ),
      m_next_seq( SEQ_INPUT_WAIT ),
      m_wait_anime_index( ANIME_NULL ),
      m_pocket_data(),
      m_current_page_index( 0 ),
      m_init_item_index( 0 )
    {
      this->InitializeGraphicsSystem();
      this->SetupFont();
      this->CreateLayoutWork();
      this->CreateShareAnime();
      this->CreateCursorManager();
      this->CreateButtonManager();
      this->SetupButtonManager();

#if 0 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_BATTLE_ITEM_LIST: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif
    }



    // OtBbNXVXe
    void ItemList::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void ItemList::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void ItemList::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_item_list_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_ITEM_LIST_ITEM_LIST_BCLYT,
          ANIME_DATA_TABLE, ANIME_DATA_NUM, ANIME_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ
    }


    // LAj[V𐶐
    void ItemList::CreateShareAnime( void )
    {
      for( u32 i=0; i<SHARE_ANIME_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIME_DESC[i].top_anime_index,
            ANIME_DATA_TABLE[ SHARE_ANIME_DESC[i].anime_data_index ],
            SHARE_ANIME_DESC[i].max_share_num,
            SHARE_ANIME_DESC[i].share_group_index,
            SHARE_ANIME_DESC[i].share_pane_index );
      }
    }


    // J[\ǗIuWFNg𐶐
    void ItemList::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager( CURSOR_MOVE_DATA, BUTTON_NUM, heap, 0 );
    }


    // {^}l[W𐶐
    void ItemList::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIME_NULL );
    }


    // {^}l[WZbgAbv
    void ItemList::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) {
        m_button_manager->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_anime,
            BUTTON_DESC[i].release_anime,
            BUTTON_DESC[i].select_anime,
            BUTTON_DESC[i].active_anime,
            BUTTON_DESC[i].passive_anime,
            NULL );  // R[obNȂ
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------
    ItemList::~ItemList()
    {
      this->DeleteCursorManager();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
      this->FinalizeGraphicsSystem();
    }



    // J[\ǗIuWFNgj
    void ItemList::DeleteCursorManager( void )
    {
      if( m_cursor_manager ) {
        GFL_DELETE m_cursor_manager;
      }
    }


    // {^}l[Wj
    void ItemList::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    // CAEg[Nj
    void ItemList::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    // OtBbNXVXȅI
    void ItemList::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }










    //---------------------------------------------------------------------------------
    /**
     * @brief ݒύX
     * @param new_setting  Vݒ
     */
    //---------------------------------------------------------------------------------
    void ItemList::ChangeSetting( const Setting& new_setting )
    {
      this->SetSetting( new_setting ); 
      this->InitPocketData();
      m_init_item_index = this->SetupPocketData();
      this->SetupPocketName();
    }


    /**
     * @brief |Pbgf[^
     */
    void ItemList::InitPocketData( void )
    {
      gfl::std::MemClear( m_pocket_data, sizeof(m_pocket_data) );
    }


    /**
     * @brief |Pbgf[^ZbgAbv
     * @return J[\ʒũ|PbgACeCfbNX
     *
     * @note
     * ARCID_BATTLE_POCKET  GARC_item_battle_pocket_battle_pocket_DAT 
     * ̎̂ reousrce/item/item_battle_pocket.dat
     * SẴACeɂ
     * ǂ̃og|Pbgɏ̂8biti[Ă.
     * 0000 0001 ̃rbgĂȂu{[v      |Pbgɏ.
     * 0000 0010 ̃rbgĂȂuƂ悤v|Pbgɏ.
     * 0000 0100 ̃rbgĂȂuHP/PPv       |Pbgɏ.
     * 0000 1000 ̃rbgĂȂuԈُv    |Pbgɏ.
     */
    u8 ItemList::SetupPocketData( void )
    {
      // ogobOɓo^|Pbg
      const u8 ITEM_POCKETS[] = 
      {
        ITEMPOCKET_NORMAL,
        ITEMPOCKET_DRUG,
        ITEMPOCKET_NUTS,
      };

      // og|Pbghc
      const u8 POCKET_ID[ POCKET_NUM ] = 
      {
        1 << 2,  // HP/PP
        1 << 0,  // {[
        1 << 3,  // Ԉُ
        1 << 1,  // Ƃ悤
      };

      u8 init_item_index = 0;
      u32 last_item_id = this->GetLastItemID();
      PocketIndex pocket_index = this->GetPocketIndex();

      gfl::heap::HeapBase* heap = this->GetHeap()->GetLowerHandle();
      void* buffer = GflHeapAllocMemory( heap, sizeof(u8) * ( ITEM_DATA_MAX + 1 ) );
      gfl::fs::ArcFile arcfile( ARCID_BATTLE_POCKET, heap );
      arcfile.LoadData( GARC_item_battle_pocket_battle_pocket_DAT, buffer );

      for( u32 item_id=0; item_id<=ITEM_DATA_MAX; item_id++ ) // @todo ACê݂𑖍
      {  
        u8* battle_pocket_data = reinterpret_cast<u8*>( buffer );
        if( battle_pocket_data[ item_id ] & POCKET_ID[ pocket_index ] ) 
        {
          if( item_id == last_item_id ) {  // ŌɎgACe𔭌
            const PocketData& pocket = m_pocket_data[ pocket_index ];
            init_item_index = pocket.item_count;
          }
          this->AddItemToPocket( pocket_index, item_id );
        } 
      }

      GflHeapFreeMemory( buffer );
      return init_item_index;
    }


    /**
     * @brief |Pbgɓǉ
     * @param pocket_index  ǉ|Pbg
     * @param item_id       ǉ铹
     */
    void ItemList::AddItemToPocket( PocketIndex pocket_index, u32 item_id )
    {
      PocketData& pocket = m_pocket_data[ pocket_index ];
      GFL_ASSERT( pocket.item_count < MAX_POCKET_ITEM_NUM );
      if( pocket.item_count < MAX_POCKET_ITEM_NUM ) {
        pocket.items[ pocket.item_count ].id = item_id;
        pocket.items[ pocket.item_count ].num = 100;  // @todo obO擾
        pocket.item_count++;
      }
    }







    /**
     * @brief {^ZbgAbv
     */
    void ItemList::SetupLeftButton( void )
    {
      if( this->IsPrevPageEnable() ) {
        m_button_manager->SetButtonActive( BUTTON_LEFT );
      }
      else {
        m_button_manager->SetButtonPassive( BUTTON_LEFT );
      }
    }


    /**
     * @brief E{^ZbgAbv
     */
    void ItemList::SetupRightButton( void )
    {
      PocketIndex pocket_index = this->GetPocketIndex();
      u8 page_count = this->CalcPageCount( pocket_index );
      u8 max_page = page_count - 1;
      if( this->IsNextPageEnable() ) {
        m_button_manager->SetButtonActive( BUTTON_RIGHT );
      }
      else {
        m_button_manager->SetButtonPassive( BUTTON_RIGHT );
      }
    }

    /**
     * @brief y[WvZ
     * @param pocket_index  |Pbg̃CfbNX
     */
    u8 ItemList::CalcPageCount( PocketIndex pocket_index ) const
    {
      const PocketData& pocket = m_pocket_data[ pocket_index ];
      return ( pocket.item_count + ( ITEM_BUTTON_NUM - 1 ) ) / ITEM_BUTTON_NUM;
    }


    /**
     * @brief \y[WԍZbgAbv
     */
    void ItemList::SetupPage( void )
    {
      PocketIndex pocket_index = this->GetPocketIndex();
      u8 page_count = CalcPageCount( pocket_index );

      ::app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_ITEM_LIST_PANE_PAGE_MAX, page_count, PAGE_COUNT_PLACE_NUM );

      ::app::util::SetTextboxPaneNumber( m_layout_work, 
          PANENAME_ITEM_LIST_PANE_PAGE_VALUE, m_current_page_index + 1, PAGE_COUNT_PLACE_NUM );
    }


    /**
     * @brief \|PbgZbgAbv
     */
    void ItemList::SetupPocketName( void )
    {
      gfl::str::MsgData* message = this->GetMessageData();

      switch( this->GetPocketIndex() ) 
      {
      case POCKET_HP:
        ::app::util::SetPaneVisible( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_00 );
        ::app::util::SetPaneVisible( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_01 );
        ::app::util::SetTextboxPaneMessage( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_00, message, str_btl_bag_00 );
        ::app::util::SetTextboxPaneMessage( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_01, message, str_btl_bag_02 );
        break;

      case POCKET_STATUS:
        ::app::util::SetPaneVisible( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_00 );
        ::app::util::SetPaneVisible( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_01 );
        ::app::util::SetTextboxPaneMessage( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_00, message, str_btl_bag_01 );
        ::app::util::SetTextboxPaneMessage( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_01, message, str_btl_bag_02 );
        break;

      case POCKET_BALL:
        ::app::util::SetPaneVisible( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_00 );
        ::app::util::SetPaneInvisible( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_01 );
        ::app::util::SetTextboxPaneMessage( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_00, message, str_btl_bag_03 );
        break;

      case POCKET_BATTLE:
        ::app::util::SetPaneVisible( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_00 );
        ::app::util::SetPaneInvisible( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_01 );
        ::app::util::SetTextboxPaneMessage( 
            m_layout_work, PANENAME_ITEM_LIST_PANE_CATEGORY_NAME_00, message, str_btl_bag_04 );
        break;
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief ŏĊJ( ݒ͈p )
     */
    //---------------------------------------------------------------------------------
    void ItemList::Restart( void )
    {
      this->ResetFinishFlag();
      this->ResetResult();
      m_seq = SEQ_INPUT_WAIT;
      m_next_seq = SEQ_INPUT_WAIT;
      m_wait_anime_index = ANIME_NULL; 
      m_current_page_index = this->CalcPageIndex( m_init_item_index );
      this->SetupPage();
      this->SetupLeftButton();
      this->SetupRightButton();
      this->SetupItemButtons();
      this->InitializeCursorPos();
    }


    /**
     * @brief SĂ̓{^ZbgAbv
     */
    void ItemList::SetupItemButtons( void )
    {
      for( u8 i=0; i<BUTTON_NUM; i++ ) {
        ItemButtonIndex item_button_index = 
          static_cast<ItemButtonIndex>( BUTTON_DESC[i].item_button_index );
        if( item_button_index < ITEM_BUTTON_NUM ) {
          this->SetupItemButton( item_button_index );
        }
      }
    }


    /**
     * @brief {^ZbgAbv
     * @param button  ZbgAbvΏۂ̓{^
     */
    void ItemList::SetupItemButton( ItemButtonIndex button )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      PocketIndex pocket_index = this->GetPocketIndex();
      const PocketData& pocket = m_pocket_data[ pocket_index ];
      u32 item_index = this->CalcItemIndex( button );
      u32 item_id = pocket.items[ item_index ].id;
      u32 item_count = pocket.items[ item_index ].num;

      if( item_id == ITEM_DUMMY_DATA ) {
        m_button_manager->SetButtonPassive( BUTTON_ITEM + button );
      }
      else {
        m_button_manager->SetButtonActive( BUTTON_ITEM + button );
        ::app::util::SetTextboxPaneItemName( m_layout_work, 
            ITEM_BUTTON_DESC[ button ].name_pane, item_id, heap ); 
        ::app::util::SetTextboxPaneNumber( m_layout_work, 
            ITEM_BUTTON_DESC[ button ].count_pane, item_count, ITEM_COUNT_PLACE_NUM );
      } 
    }


    /**
     * @brief w肵{^ɑΉACeCfbNXvZ
     * @param button_index  {^
     */
    u8 ItemList::CalcItemIndex( ItemButtonIndex button_index ) const
    {
      return ( m_current_page_index * ITEM_BUTTON_NUM ) + button_index;
    } 

    /**
     * @brief w肵y[WԍvZ
     * @param item_index  ACeCfbNX
     */
    u8 ItemList::CalcPageIndex( u8 item_index ) const
    {
      return ( item_index / ITEM_BUTTON_NUM );
    }




    // J[\ʒu
    void ItemList::InitializeCursorPos( void )
    {
      ButtonIndex init_button = 
        static_cast<ButtonIndex>( BUTTON_ITEM + ( m_init_item_index % ITEM_BUTTON_NUM ) );
      m_cursor_manager->SetPos( init_button );

      for( u8 i=0; i<BUTTON_NUM; i++ ) {
        ::app::util::StopAnimation( m_layout_work, BUTTON_DESC[i].cursor_anime );
      } 
      ::app::util::StartAnimation( m_layout_work, BUTTON_DESC[ init_button ].cursor_anime );
      ::app::util::StartAnimation( m_layout_work, ANIME_CURSOR_FLUCTUATE );
    }









    //---------------------------------------------------------------------------------
    /**
     * @brief I[g`tOZbg
     */
    //--------------------------------------------------------------------------------- 
    void ItemList::SetAutoDrawFlag( bool flag )
    {
      if( m_layout_work ) {
        m_layout_work->SetAutoDrawFlag( flag );
      }
    }







    //---------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //---------------------------------------------------------------------------------
    void ItemList::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 
    } 



    // V[PXXV
    void ItemList::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = this->GetButton();
      const gfl::ui::TouchPanel* touchpanel = this->GetTouchpanel();

      switch( m_seq )
      {
      case SEQ_INPUT_WAIT:
        if( this->IsButtonSelected() ) {
          ButtonIndex selected_button = this->GetSelectedCursorPosByButton();
          if( this->IsSelectEnable( selected_button ) ) {
            this->OnButtonSelected( selected_button );
          }
        }
        else if( this->IsButtonHolding() ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_B ) ) {
          if( this->IsSelectEnable( BUTTON_RETURN ) ) {
            this->SetResultByCursorPos( BUTTON_RETURN );
            this->StartSelectAnime( BUTTON_RETURN );
            m_seq = SEQ_ANIME_WAIT;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          ButtonIndex cursor_pos = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->OnButtonSelected( cursor_pos );
          }
        }
        else if( this->UpdateCursorMove() ) {  // J[\ړ
          ButtonIndex old_cursor_pos = this->GetPrevCursorPos();
          ButtonIndex new_cursor_pos = this->GetCurrentCursorPos();
          this->StartCursorMoveAnime( old_cursor_pos, new_cursor_pos );
        }
        else if( this->IsNextPageEnable() && this->IsNextPageInputDetected() ) {
          this->StartSelectAnime( BUTTON_RIGHT );
          m_seq = SEQ_ANIME_WAIT;
          m_next_seq = SEQ_NEXT_PAGE;
        }
        else if( this->IsPrevPageEnable() && this->IsPrevPageInputDetected() ) {
          this->StartSelectAnime( BUTTON_LEFT );
          m_seq = SEQ_ANIME_WAIT;
          m_next_seq = SEQ_PREV_PAGE;
        }
        break;


      case SEQ_ANIME_WAIT:
        if( this->IsSelectAnimeFinished() ) {
          m_seq = m_next_seq;
        }
        break;


      case SEQ_NEXT_PAGE:
        this->SetNextPage();
        m_seq = SEQ_INPUT_WAIT;
        break;


      case SEQ_PREV_PAGE:
        this->SetPrevPage();
        m_seq = SEQ_INPUT_WAIT;
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
        break; 
      }
    }




    /**
     * @brief {^Iꂽۂ̏
     * @param selected_button  Iꂽ{^
     */
    void ItemList::OnButtonSelected( ButtonIndex selected_button )
    {
      switch( selected_button ) 
      {
      case BUTTON_LEFT:
        this->StartSelectAnime( BUTTON_LEFT );
        m_seq = SEQ_ANIME_WAIT;
        m_next_seq = SEQ_PREV_PAGE;
        break;

      case BUTTON_RIGHT:
        this->StartSelectAnime( BUTTON_RIGHT );
        m_seq = SEQ_ANIME_WAIT;
        m_next_seq = SEQ_NEXT_PAGE;
        break;

      default:
        this->SetResultByCursorPos( selected_button );
        this->StartSelectAnime( selected_button );
        m_seq = SEQ_ANIME_WAIT;
        m_next_seq = SEQ_FINISH;
        break;
      }
    }





    /**
     * @brief ̃y[Wֈړ
     */
    void ItemList::SetNextPage( void ) 
    {
      m_current_page_index++;
      this->SetupPage();
      this->SetupItemButtons();
      this->SetupLeftButton();
      this->SetupRightButton();
    } 

    /**
     * @brief ̃y[Wւ̈ړ͂oǂ𒲂ׂ
     * @retval true   o
     * @retval false  oĂȂ
     */
    bool ItemList::IsNextPageInputDetected( void ) const
    {
      const gfl::ui::Button* ui_button = this->GetButton();
      if( ui_button->IsTrigger( gfl::ui::BUTTON_RIGHT ) ) {
        ButtonIndex cursor_pos = this->GetCurrentCursorPos();
        ItemButtonIndex item_button_index = BUTTON_DESC[ cursor_pos ].item_button_index;
        if( item_button_index < ITEM_BUTTON_NUM ) {
          return ITEM_BUTTON_DESC[ item_button_index ].next_page_enable;
        }
      }
      return false;
    }

    /**
     * @brief ̃y[Wւ̈ړ\ǂ𒲂ׂ
     * @retval true   \
     * @retval false  s\
     */
    bool ItemList::IsNextPageEnable( void ) const
    {
      PocketIndex pocket_index = this->GetPocketIndex();
      u8 page_count = this->CalcPageCount( pocket_index );
      u8 max_page_index = page_count - 1;
      return ( m_current_page_index < max_page_index );
    }






    /**
     * @brief Õy[Wֈړ
     */
    void ItemList::SetPrevPage( void )
    {
      m_current_page_index--;
      this->SetupPage();
      this->SetupItemButtons();
      this->SetupLeftButton();
      this->SetupRightButton();
    }

    /**
     * @brief Õy[Wւ̈ړ͂oǂ𒲂ׂ
     * @retval true   o
     * @retval false  oĂȂ
     */
    bool ItemList::IsPrevPageInputDetected( void ) const
    {
      const gfl::ui::Button* ui_button = this->GetButton();
      if( ui_button->IsTrigger( gfl::ui::BUTTON_LEFT ) ) {
        ButtonIndex cursor_pos = this->GetCurrentCursorPos();
        ItemButtonIndex item_button_index = BUTTON_DESC[ cursor_pos ].item_button_index;
        if( item_button_index < ITEM_BUTTON_NUM ) {
          return ITEM_BUTTON_DESC[ item_button_index ].prev_page_enable;
        }
      }
      return false;
    }

    /**
     * @brief Õy[Wւ̈ړ\ǂ𒲂ׂ
     * @retval true   \
     * @retval false  s\
     */
    bool ItemList::IsPrevPageEnable( void ) const
    {
      return ( 0 < m_current_page_index );
    }







    // {^Ă邩ǂ𒲂ׂ
    bool ItemList::IsButtonHolding( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    // {^Iꂽǂ𒲂ׂ
    bool ItemList::IsButtonSelected( void ) const
    {
      return m_button_manager->IsButtonSelected();
    }

    // Iꂽ{^Ɋ֘AtĂJ[\ʒu擾
    ItemList::ButtonIndex ItemList::GetSelectedCursorPosByButton( void ) const
    {
      return static_cast<ButtonIndex>( m_button_manager->GetSelectedButtonId() );
    }





    // J[\̓XV
    bool ItemList::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 


    // ݂̃J[\ʒu擾
    ItemList::ButtonIndex ItemList::GetCurrentCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetID() );
    } 


    // ÕJ[\ʒu擾
    ItemList::ButtonIndex ItemList::GetPrevCursorPos( void ) const
    {
      return static_cast<ButtonIndex>( m_cursor_manager->GetOldID() );
    }


    // J[\ړۂ̏
    void ItemList::StartCursorMoveAnime( 
        ButtonIndex old_cursor_pos, ButtonIndex new_cursor_pos )
    {
      ::app::util::StopAnimation( m_layout_work, BUTTON_DESC[ old_cursor_pos ].cursor_anime );
      ::app::util::StartAnimation( m_layout_work, BUTTON_DESC[ new_cursor_pos ].cursor_anime );
    }






    // I\ǂ𒲂ׂ
    bool ItemList::IsSelectEnable( ButtonIndex cursor_pos ) const
    {
      return m_button_manager->IsButtonActive( cursor_pos );
    } 


    // J[\ʒu, 쌋ʂZbg
    void ItemList::SetResultByCursorPos( ButtonIndex cursor_pos )
    {
      this->SetResult( BUTTON_DESC[ cursor_pos ].result );

      const ButtonDesc& button_desc = BUTTON_DESC[ cursor_pos ];
      if( button_desc.item_button_index < ITEM_BUTTON_NUM ) {
        PocketIndex pocket_index = this->GetPocketIndex();
        const PocketData& pocket = m_pocket_data[ pocket_index ];
        u32 item_index = this->CalcItemIndex( button_desc.item_button_index );
        u32 item_id = pocket.items[ item_index ].id;
        this->SetSelectedItemID( item_id );
      }
    } 





    // ȊIAj[VJn
    void ItemList::StartSelectAnime( ButtonIndex cursor_pos )
    {
      m_wait_anime_index = BUTTON_DESC[ cursor_pos ].select_anime;
      ::app::util::StartAnimation( m_layout_work, m_wait_anime_index );
    }


    // ȊIAj[VIǂ𒲂ׂ
    bool ItemList::IsSelectAnimeFinished( void ) const
    {
      if( m_wait_anime_index < ANIME_NUM ) {
        return m_layout_work->IsAnimeEnd( m_wait_anime_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }






  }  // namespace app
}  // namespace btl
