//======================================================================
/**
 * @file  model_test.h
 * @brief LeXgF΂傤
 * @author  ariizumi
 * @data  11/05/16
 */
//======================================================================

#ifndef __MODEL_TEST_TEST_H__
#define __MODEL_TEST_TEST_H__

namespace test
{
namespace ariizumi
{


class ModelTest;


class TestModel
{
public:
  TestModel();

  void Create( ModelTest *parent , gfl::fs::ArcFile *arcFile, const gfl::fs::ArcFile::ARCDATID mdlId );
  void Delete(ModelTest *parent);

  gfl::grp::g3d::Resource *mResModel;
  gfl::grp::g3d::Model    *mModel;

};

class ModelTest:public gamesystem::GameProc
{
public:
  //------------------------------------------------------------------
  /**
   * @brief	  PROC̏s֐
   * @return	Result 삪I RES_FINISHԂĂ炤MainFuncɐi
   */
  //------------------------------------------------------------------
  virtual gfl::proc::Result InitFunc(gfl::proc::Manager* pManager);
  //------------------------------------------------------------------
  /**
   * @brief	  PROC̃Cs֐
   * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
   */
  //------------------------------------------------------------------
  virtual gfl::proc::Result UpdateFunc(gfl::proc::Manager* pManager);
  virtual gfl::proc::Result NextFrameMainFunc(gfl::proc::Manager* pManager);
  virtual void DrawFunc(gfl::proc::Manager* pManager);

  //------------------------------------------------------------------
  /**
   * @brief	  PROC̏Is֐
   * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
   */
  //------------------------------------------------------------------
  virtual gfl::proc::Result EndFunc(gfl::proc::Manager* pManager);


//private:
  static const int MODEL_NUM = 12;

  static const f32 NEAR_PLANE = 32.0f;
  static const f32 FAR_PLANE  = 6000.0f;

  gfl::heap::HeapBase*  mHeapMem;
  gfl::heap::HeapBase*  mDevMem;
  //eAP[^
  gfl::heap::NwAllocator* mHeapAllocator;
  gfl::heap::NwAllocator* mDeviceAllocator;

  //OtBbNnVXe
  gfl::grp::GraphicsSystem*     mGrpSys;
  gfl::grp::g3d::System*        mG3dSys;
  gfl::grp::g3d::Scene*         mScene;
  gfl::debug::DebugG3dStereoCamera*  mCamera;

  gfl::ui::DeviceManager*  mDeviceManager;

  //@todo Ƃ肠u
  gfl::math::VEC3 mCamPos;
  gfl::math::VEC3 mCamTrg;

  gfl::fs::ArcFile *mModelArc;

  TestModel mModel[MODEL_NUM];
  TestModel mModelBg;
};



}//namespace test
}//namespace ariizumi


#endif //__MODEL_TEST_TEST_H__
