//======================================================================
/**
 * @file  model_test.cpp
 * @brief LeXgFoO
 * @author  ariizumi
 * @data  11/09/15
 */
//======================================================================

#include <gflib.h>

#include "model_test.h"
#include "ari_model_test.gaix"


namespace test
{
namespace ariizumi
{

  
//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤MainFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result ModelTest::InitFunc(gfl::proc::Manager* pManager)
{

  gfl::heap::HeapBase* heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
  
  mHeapMem = gfl::heap::Manager::CreateHeap( heap_memory, HEAPID_TEST_ARIIZUMI    , 0x570000  , gfl::heap::HEAP_TYPE_EXP );
  mDevMem = gfl::heap::Manager::CreateHeap( device_memory,HEAPID_TEST_ARIIZUMI_DEV, 0x1480000 , gfl::heap::HEAP_TYPE_EXP );

  // eAP[^쐬
  mHeapAllocator = GFL_NEW(mHeapMem) gfl::heap::NwAllocator(mHeapMem);
  mDeviceAllocator = GFL_NEW(mDevMem) gfl::heap::NwAllocator(mDevMem);

  // OtBbNXVXe擾
  mGrpSys = GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetGraphicsSystem();
  mGrpSys->InitializeApplicationMemory(mDeviceAllocator);

  //3D
  mG3dSys = GFL_NEW(mHeapMem) gfl::grp::g3d::System( mHeapAllocator, mDeviceAllocator );

  //V[VXe̍쐬
  //RootNodes
  gfl::grp::g3d::Scene::Description sceneDesc;
  mScene = GFL_NEW(mHeapMem) gfl::grp::g3d::Scene( mDeviceAllocator , &sceneDesc );

  //J
  mCamPos.x = 190.0f;
  mCamPos.y = 100.0f;
  mCamPos.z = 270.0f;
  mCamTrg.x = 0.0f;
  mCamTrg.y = 0.0f;
  mCamTrg.z = 0.0f;
  mCamera = GFL_NEW(mHeapMem) gfl::debug::DebugG3dStereoCamera;
  mCamera->Create( mDeviceAllocator ,
                  mCamPos,
                  mCamTrg,
                  NEAR_PLANE,
                  FAR_PLANE ,
                  GFL_MATH_DEG_TO_RAD(40.0f));

  mScene->AddSceneNode( mCamera );
  // SceneInitializer Ń}eA\[g̏肷 MaterialId ݒ肵܂B
  // SceneTraverser ŃV[m[h̎Wƒ񉻂 SceneContext ɒǉs܂B
  mScene->Initialize();

  // Jʒu𐢊EWɂ邽߂ɈxXVĂ܂B
  mScene->Calculate();

  // Jݒ肵܂B
  gfl::grp::g3d::Camera::SetCameraAspectRatio(mCamera->GetBaseCamera()->GetNwCamera(), 400.0f/240.0f);

  GFL_GL_ASSERT();


  mDeviceManager = GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetUiDeviceManager();
  mModelArc = GFL_NEW( mHeapMem ) gfl::fs::ArcFile( ARCID_ARI_MODEL_TEST );
/*  
  mModel[0].Create( this , mModelArc , GARC_ari_model_test_pmkujira025_BCRES );
  mModel[1].Create( this , mModelArc , GARC_ari_model_test_pmkujira025_BCRES );
  mModel[2].Create( this , mModelArc , GARC_ari_model_test_pmkujira025_BCRES );
  mModel[3].Create( this , mModelArc , GARC_ari_model_test_pmkujira025_BCRES );
  //mModel[4].Create( this , mModelArc , GARC_ari_model_test_touko_model_BCMDL );
  //mModel[5].Create( this , mModelArc , GARC_ari_model_test_touko_model_BCMDL );
  mModel[4].Create( this , mModelArc , GARC_ari_model_test_ground01_BCMDL );

  mModel[0].mModel->SetTranslate(  50.0f , 0.0f , 0.0f );
  mModel[1].mModel->SetTranslate( -50.0f , 0.0f , 0.0f );
  mModel[2].mModel->SetTranslate(  50.0f , 0.0f , 30.0f );
  mModel[3].mModel->SetTranslate( -50.0f , 0.0f , 30.0f );
  //mModel[4].mModel->SetVisible(false);
  //mModel[4].mModel->SetTranslate(  50.0f , 0.0f ,-30.0f );
  //mModel[5].mModel->SetTranslate( -50.0f , 0.0f ,-30.0f );
*/

  for( int i=0;i<MODEL_NUM;i++ )
  {
    //mModel[i].Create( this , mModelArc , (i%2?GARC_ari_model_test_pmkujira025_BCRES:GARC_ari_model_test_touko_model_BCMDL) );
    mModel[i].Create( this , mModelArc , GARC_ari_model_test_touko_model_BCMDL );
    mModel[i].mModel->SetTranslate( -120.0f + (i/2)*40.0f , 0.0f , (i%2)*60.0f );
    
  }
  mModelBg.Create( this , mModelArc , GARC_ari_model_test_ground01_BCMDL );
  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result ModelTest::EndFunc(gfl::proc::Manager* pManager)
{
  GFL_UNUSED( pManager );

  mModelBg.Delete(this);
  for( int i=0;i<MODEL_NUM;i++ )
  {
    mModel[i].Delete(this);
  }

  mScene->RemoveAllSceneNodes();

  GFL_DELETE mModelArc;

  GFL_DELETE mCamera;

  GFL_DELETE mScene;
  GFL_DELETE mG3dSys;

  GFL_DELETE mHeapAllocator;
  GFL_DELETE mDeviceAllocator;

  mGrpSys->FinalizeApplicationMemory();

  gfl::heap::Manager::DeleteHeap( mHeapMem );
  gfl::heap::Manager::DeleteHeap( mDevMem );

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result ModelTest::UpdateFunc(gfl::proc::Manager* pManager)
{
  gfl::ui::Button *uiButton = mDeviceManager->GetButton(0);

  mCamera->Control(mDeviceManager);

  //3D
  {
    // _ɈˑXV RenderQueue ̍\zs܂B
    mScene->Calculate();
    mScene->SubmitView(mCamera);
  }

  static f32 ofs = 0;
  if( uiButton->IsTrigger( gfl::ui::BUTTON_A ) )
  {
    ofs += 10.0f;

    for( int i=0;i<MODEL_NUM;i++ )
    {
      mModel[i].mModel->SetTranslate( -120.0f + (i/2)*40.0f , ofs , (i%2)*60.0f );
    }
  }
  if( uiButton->IsTrigger( gfl::ui::BUTTON_B ) )
  {
    ofs -= 10.0f;

    for( int i=0;i<MODEL_NUM;i++ )
    {
      mModel[i].mModel->SetTranslate( -120.0f + (i/2)*40.0f , ofs , (i%2)*60.0f );
    }
  }
  if( uiButton->IsTrigger( gfl::ui::BUTTON_X ) )
  {
    for( int i=0;i<MODEL_NUM;i++ )
    {
      gfl::math::VEC2 scale;
      f32 rot;
      mModel[i].mModel->GetMaterialTextureCoordinatorScaleUV( 0 , 0 , &scale );
      rot = mModel[i].mModel->GetMaterialTextureCoordinatorRotateUV( 0 , 0 );
      GFL_PRINT("[%.f][%.f]:[%.f]\n",scale.x,scale.y,rot);
    }
  }
  if( uiButton->IsTrigger( gfl::ui::BUTTON_Y ) )
  {
    {
      gfl::math::VEC2 scale(1.0f,1.0f);
      mModel[0].mModel->SetMaterialTextureCoordinatorScaleUV( 0 , 0 , scale );
      mModel[0].mModel->SetMaterialTextureCoordinatorScaleUV( 0 , 1 , scale );
      mModel[0].mModel->SetMaterialTextureCoordinatorScaleUV( 1 , 0 , scale );
      mModel[0].mModel->SetMaterialTextureCoordinatorScaleUV( 1 , 1 , scale );
      mModel[0].mModel->SetMaterialTextureCoordinatorScaleUV( 2 , 0 , scale );
      mModel[0].mModel->SetMaterialTextureCoordinatorScaleUV( 2 , 1 , scale );
      mModel[0].mModel->SetMaterialTextureCoordinatorScaleUV( 3 , 0 , scale );
      mModel[0].mModel->SetMaterialTextureCoordinatorScaleUV( 3 , 1 , scale );
    }
  }


  if( uiButton->IsTrigger( gfl::ui::BUTTON_START ) )
  {
   return gfl::proc::RES_FINISH;
  }

 return gfl::proc::RES_CONTINUE;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result ModelTest::NextFrameMainFunc(gfl::proc::Manager* pManager)
{

  return gfl::proc::RES_CONTINUE;
}

void ModelTest::DrawFunc(gfl::proc::Manager* pManager)
{
  // _O^[Qbg̎擾
  gfl::grp::RenderTarget* upperFrameBuffer = mGrpSys->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
  gfl::grp::RenderTarget* rightFrameBuffer = mGrpSys->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER_RIGHT);
  gfl::grp::RenderTarget* lowerFrameBuffer = mGrpSys->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);

  //C̕`
  mScene->StereoDraw( mGrpSys ,
                      mCamera ,
                      upperFrameBuffer,
                      rightFrameBuffer );

}


TestModel::TestModel()
:mResModel(NULL)
,mModel(NULL)
{
}

void TestModel::Create(ModelTest *parent , gfl::fs::ArcFile *arcFile, const gfl::fs::ArcFile::ARCDATID mdlId )
{
  gfl::grp::g3d::Resource::Description resource_description;
  u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
  common_resource_flag |= gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT;


  mResModel = GFL_NEW(parent->mDevMem) gfl::grp::g3d::Resource;
  mResModel->LoadAndSetup( parent->mDeviceAllocator , arcFile , mdlId ,&resource_description , common_resource_flag);

  mModel = GFL_NEW(parent->mDevMem) gfl::grp::g3d::Model();
  mModel->Create( parent->mHeapAllocator, parent->mDeviceAllocator, mResModel, 0 );

  parent->mScene->AddSceneNode( mModel );
  mModel->SetVisible(true);
}

void TestModel::Delete(ModelTest *parent)
{
  if( mModel )
  {
    parent->mScene->RemoveSceneNode( mModel );
    GFL_DELETE mModel;
    mModel = NULL;
  }
  if( mResModel )
  {
    GFL_DELETE mResModel;
    mResModel = NULL;
  }
}

  
}//namespace test
}//namespace ariizumi

