//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_nuts_ViewController.cpp
 *	@brief ؂̎̂Q[̕\ˑ̑NX
 *	@author	takada
 *	@date		2011.09.01
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include "app_nuts_CoreData.h"
#include "app_nuts_NutsData.h"
#include "app_nuts_LowerLayoutInformation.h"
#include "app_nuts_LowerDrawer.h"
#include "app_nuts_ViewController.h"

namespace app {
  namespace nuts {
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    ViewController::ViewController( 
        gfl::heap::HeapBase* heap,
        const gfl::ui::DeviceManager* uiDeviceManager, 
        const CoreData* coreData, 
        const LowerDrawer* drawer ) :
      mUiDeviceManager( uiDeviceManager ),
      mTouchPanel( uiDeviceManager->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD ) ),
      mLayoutWork( drawer->GetLayoutWork() ),
      mCoreData( coreData ),
      m_nuts_data( coreData->GetConstNutsData() ),
      mDrawer( drawer )
    {
    }

    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    ViewController::~ViewController()
    {
    }

    //------------------------------------------------------------------------------------
    // `nˑ̔XV
    //------------------------------------------------------------------------------------
    void ViewController::UpdateState( void )
    {
      this->UpdateTouchState_Nuts();      
    }

    // ؂̎̃^b`XV
    void ViewController::UpdateTouchState_Nuts( void )
    {
      if( !mLayoutWork->IsHitCheckOK() ) {  // x`悵Ȃƃ`FbNs
        return;
      }
      u16 touchX = mTouchPanel->GetX();
      u16 touchY = mTouchPanel->GetY(); 
      gfl::grp::g2d::LytPaneIndex touchedPaneIndex = mLayoutWork->GetHitPaneIndexGroup( LowerLayout::information.groupIndexOfNuts, touchX, touchY, false ); 
      if( touchedPaneIndex == gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR ) {
        m_nuts_touch_flag = false;
        m_touched_nuts_index = NutsData::NUTS_NULL;
      }
      else {
        m_nuts_touch_flag = true;
        
        //u32 level = this->NutsData()->GetLevel();
        //u32 nutsNum = NutsData::levelInformation[ level ].numberOfNuts;
        //for( u32 i=0; i<nutsNum; ++i ) {
        for( u32 i=0; i<NutsData::NUTS_NUM; ++i )
        {
          if( touchedPaneIndex == LowerLayout::information.paneIndexOfNuts[ i ] ) {
            m_touched_nuts_index = static_cast<NutsData::NutsIndex>( i );
          }
        }
      }
    }


    // Zv[g_W̃^b`XV
    void ViewController::UpdateTouchState_NutsBasePosition( void )
    {
      /*
      if( !m_layout_work->IsHitCheckOK() ) {  // x`悵Ȃƃ`FbNs
        return;
      } 
      u16 touch_x = m_touch_panel->GetX();
      u16 touch_y = m_touch_panel->GetY(); 
      gfl::grp::g2d::LytPaneIndex touched_pane_index = m_layout_work->GetHitPaneIndexGroup( LowerLayout::information.group_index_of_waza_plate_base_positions, touch_x, touch_y, false ); 
      if( touched_pane_index == gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR ) {
        m_waza_plate_base_position_touch_flag = false;
      }
      else { 
        m_waza_plate_base_position_touch_flag = true;
        u8 touched_waza_order = 0;
        for( u32 i=0; i<WazaPlateData::PLATE_NUM; i++ ) {
          if( touched_pane_index == LowerLayout::information.pane_index_of_waza_plate_base_pos[i] ) {
            touched_waza_order = i;
          }
        }
        m_touched_waza_plate_index_by_base_position = m_waza_plate_data->GetPlateIndexByOrder( touched_waza_order );
      }
      */
    }

    //------------------------------------------------------------------------------------
    // ؂̎̈̓ɂ邩ǂ𒲂ׂ
    //------------------------------------------------------------------------------------
    bool ViewController::IsNutsInsideOfDecisionRegion( s32 nutsIdx, s32& hitIdx ) const
    {
      hitIdx = 1000000;
      gfl::math::VEC3 panePos; 
      gfl::grp::g2d::LytPaneIndex paneIndex = LowerLayout::information.paneIndexOfNuts[ nutsIdx ];
      this->GetGlobalPositionOfPane( paneIndex, &panePos );

      for( s32 i=0; i<LowerLayout::MAXIMUM_NUMBER_OF_SIMULTANEOUS_BALLOON_LEAVES; ++i ){

        gfl::grp::g2d::LytPane* regionPane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfDecisionRegion[ i ] ); 
        const nw::lyt::Size& regionSize = regionPane->GetSize();
        f32 leftLimitX = regionPane->GetTranslate().x - ( regionSize.width / 2.0f );
        f32 rightLimitX = regionPane->GetTranslate().x + ( regionSize.width / 2.0f );
        f32 upperLimitY = regionPane->GetTranslate().y + ( regionSize.height / 2.0f );
        f32 lowerLimitY = regionPane->GetTranslate().y - ( regionSize.height / 2.0f );

        if( ( leftLimitX < panePos.x ) && ( panePos.x < rightLimitX ) )
        {
          if( ( panePos.y < upperLimitY ) && ( lowerLimitY < panePos.y ) )
          {
            hitIdx = i;
            return true;
          }
        }
      }

      return false;
    }

    //------------------------------------------------------------------------------------
    // ؂̎^b`Ă邩ǂ𒲂ׂ
    //------------------------------------------------------------------------------------
    bool ViewController::IsNutsTouch( void ) const
    {
      return m_nuts_touch_flag;
    }

    //------------------------------------------------------------------------------------
    // ^b`Ă؂̎̃CfbNX擾
    //------------------------------------------------------------------------------------
    NutsData::NutsIndex ViewController::GetTouchedNutsIndex( void ) const
    {
      return m_touched_nuts_index;
    }

#if 0
    //------------------------------------------------------------------------------------
    // IڂJ[\͈͂̏ɂ邩ǂ𒲂ׂ
    //------------------------------------------------------------------------------------
    bool ViewController::IsBeyondUpperLimitOfControlArea( s32 crtIdx ) const
    {
      gfl::math::VEC3 panePos; 
      gfl::grp::g2d::LytPaneIndex paneIndex = LowerLayout::information.settings[ crtIdx ].paneIndexOfBack;
      this->GetGlobalPositionOfPane( paneIndex, &panePos );

      gfl::grp::g2d::LytPane* areaPane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfCursorControlArea ); 
      const nw::lyt::Size& areaSize = areaPane->GetSize(); 
      f32 upperLimitY = areaPane->GetTranslate().y + ( areaSize.height / 2.0f );

      return ( upperLimitY < panePos.y );
    }


    //------------------------------------------------------------------------------------
    // IڂJ[\͈͂̉艺ɂ邩ǂ𒲂ׂ
    //------------------------------------------------------------------------------------
    bool ViewController::IsBeyondLowerLimitOfControlArea( s32 crtIdx ) const
    {
      gfl::math::VEC3 panePos; 
      gfl::grp::g2d::LytPaneIndex paneIndex =  LowerLayout::information.settings[ crtIdx ].paneIndexOfBack;
      this->GetGlobalPositionOfPane( paneIndex, &panePos );

      gfl::grp::g2d::LytPane* areaPane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfCursorControlArea ); 
      const nw::lyt::Size& areaSize = areaPane->GetSize(); 
      f32 lowerLimitY = areaPane->GetTranslate().y - ( areaSize.height / 2.0f ); 
      return ( panePos.y < lowerLimitY );
    } 


    //------------------------------------------------------------------------------------
    /**
     * @brief IڂJ[\͈͂̍ŏ㕔ɂȂ悤ȃXN[lZo
     * @param ctrIdx  J[\͈͂̍ŏ㕔ɔzuݒ荀
     */
    //------------------------------------------------------------------------------------
    f32 ViewController::CalculateScrollValueAtUpperLimitOfControlArea( s32 crtIdx ) const
    { 
      gfl::grp::g2d::LytPaneIndex settingPaneIndex = LowerLayout::information.settings[ crtIdx ].paneIndexOfBack;
      gfl::grp::g2d::LytPane* settingPane = mLayoutWork->GetPane( settingPaneIndex ); 
      const gfl::math::VEC3& settingLocalPos = settingPane->GetTranslate();
      const nw::lyt::Size& settingSize = settingPane->GetSize(); 
      f32 settingHalfHeight = settingSize.height / 2.0f;

      gfl::grp::g2d::LytPane* areaPane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfCursorControlArea ); 
      const nw::lyt::Size& areaSize = areaPane->GetSize(); 
      f32 upperLimitY = areaPane->GetTranslate().y + ( areaSize.height / 2.0f );

      return upperLimitY - settingHalfHeight - settingLocalPos.y;
    } 


    //------------------------------------------------------------------------------------
    /**
     * @brief IڂJ[\͈͂̍ŉɂȂ悤ȃXN[lZo
     * @param ctrIdx  J[\͈͂̍ŉɔzuݒ荀
     */
    //------------------------------------------------------------------------------------
    f32 ViewController::CalculateScrollValueAtLowerLimitOfControlArea( s32 crtIdx ) const
    {
      gfl::grp::g2d::LytPaneIndex settingPaneIndex = LowerLayout::information.settings[ crtIdx ].paneIndexOfBack;
      gfl::grp::g2d::LytPane* settingPane = mLayoutWork->GetPane( settingPaneIndex ); 
      const gfl::math::VEC3& settingLocalPos = settingPane->GetTranslate();
      const nw::lyt::Size& settingSize = settingPane->GetSize(); 
      f32 settingHalfHeight = settingSize.height / 2.0f;

      gfl::grp::g2d::LytPane* areaPane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfCursorControlArea ); 
      const nw::lyt::Size& areaSize = areaPane->GetSize(); 
      f32 lowerLimitY = areaPane->GetTranslate().y - ( areaSize.height / 2.0f );

      return lowerLimitY + settingHalfHeight - settingLocalPos.y;
    }
#endif

    // yC̃[JW擾
    void ViewController::GetLocalPositionOfPane( gfl::grp::g2d::LytPaneIndex paneIndex, gfl::math::VEC3* buffer ) const
    {
      const gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( paneIndex ); 
      *buffer = pane->GetTranslate();
    }


    // yC̃O[oW擾
    void ViewController::GetGlobalPositionOfPane( gfl::grp::g2d::LytPaneIndex paneIndex, gfl::math::VEC3* buffer ) const
    {
      const gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( paneIndex ); 
      const gfl::math::MTX34& globalMatrix = pane->GetGlobalMtx();
      buffer->x = globalMatrix._03;
      buffer->y = globalMatrix._13;
      buffer->z = globalMatrix._23;
    }

  } // namespace nuts
} // namespace app
