//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_nuts_UpperDrawer.cpp
 *	@brief ؂̎̂Q[̏ʕ`NX
 *	@author takada
 *	@date		2011.09.01
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include "app_nuts_CoreData.h"
#include "app_nuts_UpperDrawer.h"
#include "app_nuts_UpperLayoutInformation.h"

namespace app {
  namespace nuts {
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
    // CAEg[ÑZbgAbvp[^
    const gfl::grp::g2d::LytWkSetUp UpperDrawer::mLayoutWorkSetupParameter =
    {
      gfl::math::VEC3( 0, 0, 0 ),   // pos
      gfl::math::VEC2( 1, 1 ),     // scale
      gfl::math::VEC3( 0, 0, 0 ),   // rotate
      1,                        // priority
    };


    // ˉeϊp[^
    const gfl::grp::ProjectionParam UpperDrawer::mProjectionParameter =
    {
      gfl::grp::PROJECTION_ORTHO,
      { -200.0f, 200.0f, -120.0f, 120.0f },
      0.10f,
      800.0f,
      gfl::math::PIVOT_UPSIDE_TO_TOP,
    };


    // r[ϊp[^
    const gfl::grp::ViewParam UpperDrawer::mViewParameter[ 2 ] = 
    {
      // ( ڗp )
      { 
        gfl::math::VEC3( 0, 0, 1 ),  // JW
        gfl::math::VEC3( 0, 1, 0 ),  // 
        gfl::math::VEC3( 0, 0, 0 ),  // ^[QbgW
      },
      // ( Eڗp )
      { 
        gfl::math::VEC3( 10, 0, 1),  // JW
        gfl::math::VEC3( 0, 1, 0 ),   // 
        gfl::math::VEC3( 10, 0, 0 ),  // ^[QbgW
      },
    };

    // bZ[WEBhE̐ݒ
    const u32 UpperDrawer::MSGWIN_LINE_NUM = 2;
    const u32 UpperDrawer::MSGWIN_WAIT_FRAME = 3;

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    UpperDrawer::UpperDrawer(
        gfl::heap::HeapBase* heap,
        gfl::heap::HeapBase* deviceHeapForTextureData,
        gfl::heap::NwAllocator* nwHeapAllocator,
        gfl::heap::NwAllocator* nwDeviceAllocator,
        gfl::grp::GraphicsSystem* graphicsSystem, 
        gfl::grp::g2d::LytSys* layoutSystem,
        const gfl::ui::DeviceManager* uiDeviceManager,
        const void* layoutResourceData,
        //gfl::str::MsgData* nutsMessageData,
        const app::nuts::CoreData* nutsCore ) : 
      Drawer( nwHeapAllocator, nwDeviceAllocator, graphicsSystem, layoutSystem, nutsCore ),
      mLayoutWork( NULL ),
      mUpperLayoutEnv( NULL ),
      mLowerLayoutEnv( NULL ),
      //mNutsMessageData( nutsMessageData ),
      mNutsMessageData( this->GetMessageData() ),
      mMessageWindow( NULL ),
      mIsReregistrationMsgWindow( false ),
      mStrbuf( 128, heap ),
      mDeviceHeapForTextureData( deviceHeapForTextureData ),
      mCurrentScene( CoreData::SCENE_NULL )
    {
      this->CreateLayoutWork( nwDeviceAllocator, layoutResourceData ); 
      
      this->CreateLayoutEnv( heap ); 
      this->SetupLayoutEnvForLayoutWork();

      this->CreateMessageWindow( heap, uiDeviceManager );

      this->SetupStaticStrings();
    }


    // CAEg[N𐶐
    void UpperDrawer::CreateLayoutWork( gfl::heap::NwAllocator* nwDeviceAllocator, const void* layoutResourceData )
    { 
      GFL_ASSERT( mLayoutWork == NULL );
      gfl::grp::g2d::LytSys* layoutSystem = this->LayoutSystem();
      mLayoutWork = UpperLayout::CreateLayoutWork( nwDeviceAllocator, layoutSystem, layoutResourceData, &mLayoutWorkSetupParameter );
      mLayoutWork->SetAutoDrawFlag( false ); 
    } 


    // CAEg[N̕`𐶐
    void UpperDrawer::CreateLayoutEnv(  gfl::heap::HeapBase* heap )
    { 
      GFL_ASSERT( mUpperLayoutEnv == NULL );
      mUpperLayoutEnv = GFL_NEW( heap ) gfl::grp::g2d::Env();
      mUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, mProjectionParameter, mViewParameter[ 0 ] );
      mUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, mProjectionParameter, mViewParameter[ 1 ] );

      GFL_ASSERT( mLowerLayoutEnv == NULL );
      mLowerLayoutEnv = GFL_NEW( heap ) gfl::grp::g2d::Env(); 
    }

    // bZ[WEBhE쐬
    void UpperDrawer::CreateMessageWindow( gfl::heap::HeapBase* heap, const gfl::ui::DeviceManager* uiDeviceManager )
    {
      GFL_ASSERT( mMessageWindow == NULL );
      GFL_ASSERT( mLayoutWork );
      mMessageWindow = GFL_NEW( heap ) print::MsgWin( uiDeviceManager, mLayoutWork, MSGWIN_LINE_NUM, MSGWIN_WAIT_FRAME, heap );
      //mMessageWindow->AddLinePaneIdx( UpperLayout::information.mComment.paneIndexOfWindow1Label );
      //mMessageWindow->AddLinePaneIdx( UpperLayout::information.mComment.paneIndexOfWindow2Label );
    }


    // CAEg[N̕`ݒ肷
    void UpperDrawer::SetupLayoutEnvForLayoutWork( void )
    {
      mLayoutWork->SetUserEnv( mUpperLayoutEnv, mLowerLayoutEnv );
    }


    // xݒ肵ύXȂZbgAbv
    void UpperDrawer::SetupStaticStrings( void )
    {
    }

    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    UpperDrawer::~UpperDrawer()
    {
      this->DeleteLayoutWork();
      this->DeleteLayoutEnv();
      this->DeleteMessageWindow();
    }

    // CAEg[Nj
    void UpperDrawer::DeleteLayoutWork( void )
    {
      GFL_ASSERT( mLayoutWork ); 
      this->LayoutSystem()->RemoveLytWk( mLayoutWork ); 
    }

    // CAEg[N̕`j
    void UpperDrawer::DeleteLayoutEnv( void )
    {
      GFL_ASSERT( mUpperLayoutEnv );
      GFL_ASSERT( mLowerLayoutEnv );
      GFL_DELETE mUpperLayoutEnv;
      GFL_DELETE mLowerLayoutEnv; 
    }

    // \EBhEj
    void UpperDrawer::DeleteMessageWindow( void )
    {
      GFL_ASSERT( mMessageWindow );
      GFL_DELETE mMessageWindow;
    }

    //--------------------------------------------------------------------------------
    // bZ[WEBhE擾
    //--------------------------------------------------------------------------------
    print::MsgWin* UpperDrawer::GetMessageWindow( void )
    {
      return mMessageWindow;
    }
   
    //------------------------------------------------------------------------------------
    // vZX̂߂̍Œ̃ZbgAbv
    //------------------------------------------------------------------------------------
    void UpperDrawer::SetupForProcessStart( void )
    {
    }    

    //------------------------------------------------------------------------------------
    // \eXV
    //------------------------------------------------------------------------------------
    void UpperDrawer::UpdateView( void )
    {
      /*
      if( mCurrentScene < CoreData::SCENE_NUM ) {
        this->StopAnimation( UpperLayout::information.animation_index_of_scene_change_to[ mCurrentScene ] );
      }
      */
      if( this->CoreData()->IsDirty( CoreData::DIRTY_FLAG_FOR_UPPER, CoreData::DIRTY_BIT_SCENE ) ) {
        this->CoreData()->RemoveDirtyBit( CoreData::DIRTY_FLAG_FOR_UPPER, CoreData::DIRTY_BIT_SCENE );
        this->UpdateScene();
      }

      mLayoutWork->Update();
    } 


    // V[XV
    void UpperDrawer::UpdateScene( void )
    { 
      CoreData::SceneNo nextScene = this->CoreData()->GetScene();
      if( nextScene < CoreData::SCENE_NUM ) {
        //this->StartAnimation( UpperLayout::information.animation_index_of_scene_change_to[ nextScene ] );
        mCurrentScene = nextScene;
      }
    }



    // Aj[VJn
    void UpperDrawer::StartAnimation( UpperLayout::AnimationIndex animationIndex )
    {
      if( animationIndex < UpperLayout::ANIMATION_NUM ) {
        if( mLayoutWork->IsBindAnime( animationIndex ) == false ) {
          mLayoutWork->BindAnime( animationIndex );
        }
        mLayoutWork->SetAutoAnime( animationIndex, true );
        mLayoutWork->SetAnimeFrame( animationIndex, 0 );
      }
    }

    // Aj[V~
    void UpperDrawer::StopAnimation( UpperLayout::AnimationIndex animationIndex ) 
    {
      if( animationIndex < UpperLayout::ANIMATION_NUM ) {
        if( mLayoutWork->IsBindAnime( animationIndex ) ) {
          mLayoutWork->UnBindAnime( animationIndex );
        }
      }
    }



    //------------------------------------------------------------------------------------
    // ʂ`悷
    //------------------------------------------------------------------------------------
    void UpperDrawer::Draw( void )
    {
      gfl::grp::RenderTarget* upperFrameBuffer = this->GraphicsSystem()->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
      gfl::grp::RenderTarget* rightFrameBuffer = this->GraphicsSystem()->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );
      mLayoutWork->Draw( this->GraphicsSystem(), gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
    }

  } // namespace nuts
} // namespace app
