//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_nuts_Process.cpp
 *	@brief ؂̎̂Q[̃vZX
 *	@author	takada
 *	@date		2011.09.01
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include <message/message.gaix>
#include <print/system_font.h>
#include <system/thread_priority.h> 
#include <app/games_take_nuts/app_nuts_Process.h>
#include "app_nuts_LowerLayoutInformation.h"
#include "app_nuts_ArchiveData.h"
#include "app_nuts_CoreData.h"
#include "app_nuts_Operator.h"
#include "app_nuts_UpperDrawer.h"
#include "app_nuts_LowerDrawer.h"
#include "app_nuts_PokemonDrawer.h"
#include "app_nuts_ViewController.h"
#include "app_nuts_ArchiveDataLoadThread.h"
#include "app_nuts_ProcessInitThread.h"

#include <arc/games_take_nuts.gaix>

namespace app {
  namespace nuts {

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
    // bZ[Wf[^̃t@C
    const wchar_t* Process::mMessageFilename = L"rom:/message.garc";

    // VXetHg̃t@C
    const char* Process::mSystemfontFilename = "cbf_std.bcfnt";

    // CAEgVXẽZbgAbvf[^
    const gfl::grp::g2d::LytSysSetUp Process::mLayoutSystemSetupData = 
    {
      128, // Ǘ\[Xő吔
      10,  // ǗCAEg[Nő吔
    };
//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //----------------------------------------------------------------------------
    /**
     *	@brief RXgN^
     *
     *	@param heap
     *	@param deviceHeap
     *	@param graphicsSystem
     *	@param uiDeviceManager
     */
    //-----------------------------------------------------------------------------
    Process::Process(
        gfl::heap::HeapBase* heap,
        gfl::heap::HeapBase* deviceHeap, 
        gfl::grp::GraphicsSystem* graphicsSystem,
        gfl::ui::DeviceManager* uiDeviceManager ) :
      gamesystem::GameProc(),
      mInitSeq( 0 ),
      mArchiveDataLoadThread( NULL ),
      mProcessInitThread( NULL ),
      mUiDeviceManager( uiDeviceManager ),
      mPokeParty( NULL ),
      mInitialPokemonIndex( 0 ),
      mHeap( heap ),
      mDeviceHeap( deviceHeap ),
      mNwHeapAllocator( NULL ),
      mNwDeviceAllocator( NULL ),
      mGraphicsSystem( graphicsSystem ),
      mG3dSystem( NULL ),
      mLayoutSystem( NULL ),
      mNutsMessageData( NULL ),
      mArchiveData( NULL ),
      mCoreData( NULL ),
      mOperator( NULL ),
      mViewController( NULL ),
      mUpperDrawer( NULL ),
      mLowerDrawer( NULL ),
      mPokemonDrawer( NULL )
    {
      gamesystem::GameManager* gameManager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      gamesystem::GameData* gameData = gameManager->GetGameData();
      mPokeParty = gameData->GetPlayerParty();
    }

    //--------------------------------------------------------------------------------
    // \|Pw肷( ftHgł͐擪̃|P )
    //--------------------------------------------------------------------------------
    void Process::SetPokemonIndex( u8 pokeIndex )
    {
      u8 memberCount = mPokeParty->GetMemberCount();
      if( pokeIndex < memberCount ) {
        mInitialPokemonIndex = pokeIndex;
      }
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief fXgN^
     */
    //-----------------------------------------------------------------------------
    Process::~Process()
    {
    }



    //--------------------------------------------------------------------------------
    /**
     * @brief	vZX̏
     *
     * @param procManager  vZX̃}l[W
     *
     * @retval RES_CONTINUE  p
     * @retval RES_FINISH    I
     */
    //--------------------------------------------------------------------------------
    gfl::proc::Result Process::InitFunc( gfl::proc::Manager* procManager )
    {
      GFL_UNUSED( procManager );

      switch( mInitSeq ) {
      case 0: 
        this->CreateArchiveData();
        this->StartArchiveDataAsyncLoad();
        mInitSeq++;
        return gfl::proc::RES_CONTINUE;

      case 1:
        app::nuts::Drawer::CreateTemporaryStrbuf( mHeap );
        this->CreateNwAllocators();
        this->CreateGraphicsSystem();
        this->CreateG3dSystem();
        this->CreateLayoutSystem();
        this->SetupFont();

        this->CreateCoreData();

        /*
        while( !mArchiveData->IsDataExist( ArchiveData::DATA_NUTS_MESSAGE ) ) {
          GFL_PRINT( "have not finished nuts message data\n" );
        }
        this->CreateNutsMessageData();
        */
        // bZ[Wf[^𐶐
        Drawer::InitMessageData( mHeap );

        while( !mArchiveData->IsDataExist( ArchiveData::DATA_LOWER_LAYOUT_RESOURCE ) ) {
          GFL_PRINT( "have not finished lower layout resource data\n" );
        }
        this->CreateLowerDrawer();

        while( !mArchiveData->IsDataExist( ArchiveData::DATA_UPPER_LAYOUT_RESOURCE ) ) {
          GFL_PRINT( "have not finished upper layout resource data\n" );
        }
        this->CreateUpperDrawer();

        this->CreatePokemonDrawer();
        //GFL_PRINT( "proc init > pokemon drawer\n" );

        this->CreateViewController();
        //GFL_PRINT( "proc init > view controller\n" );

        mOperator = this->CreateOperator();
        //GFL_PRINT( "proc init > operator\n" );

        this->SetupCoreData();

        mInitSeq++;

      case 2:
        if( this->IsArchiveDataAsyncLoadFinished() ) {
          this->EndArchiveDataAsyncLoad();
          mInitSeq++;
        }
        return gfl::proc::RES_CONTINUE;

      case 3:
        gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, 10 );  // ʃtF[hCJn
        mInitSeq++;
        break;
      } 

      return gfl::proc::RES_FINISH;
    }



    // A[JCuf[^̃obt@𐶐
    void Process::CreateArchiveData( void )
    {
      GFL_ASSERT( mArchiveData == NULL );
      mArchiveData = GFL_NEW( mHeap ) app::nuts::ArchiveData( mHeap );
    } 

    // A[JCuf[^̔񓯊ǂݍ݂Jn
    void Process::StartArchiveDataAsyncLoad( void )
    {
      GFL_ASSERT( mArchiveDataLoadThread == NULL );
      GFL_ASSERT( mArchiveData );
      mArchiveDataLoadThread = GFL_NEW( mHeap ) ArchiveDataLoadThread( mHeap, mDeviceHeap, mArchiveData );
      mArchiveDataLoadThread->Start( STATUS_ARCHIVE_LOAD_THREAD_PRIORITY );
    } 

    // A[JCuf[^̔񓯊ǂݍ݂ǂ𒲂ׂ
    bool Process::IsArchiveDataAsyncLoadFinished( void ) const
    {
      GFL_ASSERT( mArchiveDataLoadThread );
      return !mArchiveDataLoadThread->IsAlive();
    }

    // A[JCuf[^̔񓯊ǂݍ݂I
    void Process::EndArchiveDataAsyncLoad( void )
    {
      GFL_ASSERT( mArchiveDataLoadThread );
      GFL_DELETE mArchiveDataLoadThread;
      mArchiveDataLoadThread = NULL;
    }



    // vZX̔񓯊Jn
    void Process::StartProcessAsyncInit( void )
    {
      GFL_ASSERT( mProcessInitThread == NULL );
      mProcessInitThread = GFL_NEW( mHeap ) ProcessInitThread( mHeap, this );
      mProcessInitThread->Start( STATUS_PROCESS_INIT_THREAD_PRIORITY );
    } 

    // vZX̔񓯊ǂ𒲂ׂ
    bool Process::IsProcessAsyncInitFinished( void ) const
    {
      GFL_ASSERT( mProcessInitThread );
      return !mProcessInitThread->IsAlive();
    }

    // vZX̔񓯊I
    void Process::EndProcessAsyncInit( void )
    {
      GFL_ASSERT( mProcessInitThread );
      GFL_DELETE mProcessInitThread;
      mProcessInitThread = NULL;
    }



    //------------------------------------------------------------------------------------
    /**
     * @breif vZX
     */
    //------------------------------------------------------------------------------------
    void Process::Initialize( void )
    {
      app::nuts::Drawer::CreateTemporaryStrbuf( mHeap );
      this->CreateNwAllocators();
      this->CreateGraphicsSystem();
      this->CreateG3dSystem();
      this->CreateLayoutSystem();
      this->SetupFont();

      this->CreateCoreData();

      /*
      while( !mArchiveData->IsDataExist( ArchiveData::DATA_NUTS_MESSAGE ) ) {
        GFL_PRINT( "have not finished nuts message data\n" );
      }
      this->CreateNutsMessageData();
      */
      // bZ[Wf[^𐶐
      Drawer::InitMessageData( mHeap );

      while( !mArchiveData->IsDataExist( ArchiveData::DATA_LOWER_LAYOUT_RESOURCE ) ) {
        GFL_PRINT( "have not finished lower layout resource data\n" );
      }
      this->CreateLowerDrawer();

      while( !mArchiveData->IsDataExist( ArchiveData::DATA_UPPER_LAYOUT_RESOURCE ) ) {
        GFL_PRINT( "have not finished upper layout resource data\n" );
      }
      this->CreateUpperDrawer();

      this->CreatePokemonDrawer();
      //GFL_PRINT( "proc init > pokemon drawer\n" );
      
      this->CreateViewController();
      //GFL_PRINT( "proc init > view controller\n" );

      mOperator = this->CreateOperator();
      //GFL_PRINT( "proc init > operator\n" );

      this->SetupCoreData();
    }

    
    
    // OtBbNXVXeŎgpAP[^𐶐
    void Process::CreateNwAllocators( void )
    {
      GFL_ASSERT( mNwHeapAllocator == NULL );
      GFL_ASSERT( mNwDeviceAllocator == NULL );
      mNwHeapAllocator = GFL_NEW( mHeap ) gfl::heap::NwAllocator( mHeap );
      mNwDeviceAllocator = GFL_NEW( mDeviceHeap ) gfl::heap::NwAllocator( mDeviceHeap );
    } 


    // OtBbNXVXe𐶐
    void Process::CreateGraphicsSystem( void )
    {
      GFL_ASSERT( mNwDeviceAllocator );
      mGraphicsSystem->InitializeApplicationMemory( mNwDeviceAllocator );
    }

    // G3D VXe𐶐
    void Process::CreateG3dSystem( void )
    {
      GFL_ASSERT( mG3dSystem == NULL );
      mG3dSystem = GFL_NEW( mHeap ) gfl::grp::g3d::System( mNwHeapAllocator, mNwDeviceAllocator );
    }

    // CAEgVXe𐶐
    void Process::CreateLayoutSystem( void )
    {
      GFL_ASSERT( mLayoutSystem == NULL );
      mLayoutSystem = GFL_NEW( mHeap ) gfl::grp::g2d::LytSys( &mLayoutSystemSetupData, mNwHeapAllocator, mNwDeviceAllocator );
    }


    // tHg̃ZbgAbv
    void Process::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), mSystemfontFilename );
    }

    // ȈՕ`惉Cu
    void Process::InitializeDrawUtilLibrary( void )
    {
    }

    // ݒʂ̃RAf[^𐶐
    void Process::CreateCoreData( void )
    {
      GFL_ASSERT( mCoreData == NULL );
      mCoreData = GFL_NEW( mHeap ) CoreData( mHeap, mPokeParty, mInitialPokemonIndex  );
    }

    // ʂ̕`IuWFNg𐶐
    void Process::CreateUpperDrawer( void )
    {
      GFL_ASSERT( mArchiveData );
      GFL_ASSERT( mArchiveData->IsDataExist( ArchiveData::DATA_UPPER_LAYOUT_RESOURCE ) );
      //GFL_ASSERT( mNutsMessageData );
      GFL_ASSERT( mCoreData );
      GFL_ASSERT( mUpperDrawer == NULL );
      mUpperDrawer = GFL_NEW( mHeap ) 
        UpperDrawer( 
            mHeap, 
            mDeviceHeap,
            mNwHeapAllocator, 
            mNwDeviceAllocator, 
            mGraphicsSystem, 
            mLayoutSystem,
            mUiDeviceManager,
            mArchiveData->GetData( ArchiveData::DATA_UPPER_LAYOUT_RESOURCE ),
            //mNutsMessageData, 
            mCoreData );
    }

    // ʂ̕`IuWFNg𐶐
    void Process::CreateLowerDrawer( void )
    {
      GFL_ASSERT( mArchiveData );
      GFL_ASSERT( mArchiveData->IsDataExist( ArchiveData::DATA_LOWER_LAYOUT_RESOURCE ) );
      //GFL_ASSERT( mNutsMessageData );
      GFL_ASSERT( mCoreData );
      GFL_ASSERT( mLowerDrawer == NULL );
      mLowerDrawer = GFL_NEW( mHeap ) 
        LowerDrawer( 
            mHeap, 
            mDeviceHeap,
            mNwHeapAllocator, 
            mNwDeviceAllocator, 
            mGraphicsSystem, 
            mLayoutSystem, 
            mUiDeviceManager, 
            mArchiveData->GetData( ArchiveData::DATA_LOWER_LAYOUT_RESOURCE ),
            //mNutsMessageData, 
            mCoreData );
    }

    // |P`IuWFNg𐶐
    void Process::CreatePokemonDrawer( void )
    {
      GFL_ASSERT( mCoreData );
      GFL_ASSERT( mG3dSystem );
      GFL_ASSERT( mArchiveData );
      GFL_ASSERT( mPokemonDrawer == NULL );
      mPokemonDrawer = GFL_NEW( mHeap ) 
        PokemonDrawer( 
            mHeap,
            mHeap,  // @todo LOWmۂq[vn
            mNwHeapAllocator,
            mNwDeviceAllocator,
            mGraphicsSystem,
            mG3dSystem,
            mLayoutSystem,
            mCoreData,
            mArchiveData );

      const pml::pokepara::PokemonParam* initialParam = mCoreData->GetConstPokemonParameter();
      MonsNo initialMonsno = initialParam->GetMonsNo();
      mPokemonDrawer->ChangePokemon( initialMonsno );
    }

    // \ˑ̑IuWFNg𐶐
    void Process::CreateViewController( void )
    {
      GFL_ASSERT( mCoreData );
      GFL_ASSERT( mLowerDrawer );
      mViewController = GFL_NEW( mHeap ) ViewController( mHeap, mUiDeviceManager, mCoreData, mLowerDrawer );
    } 


    // RAf[^̏ݒs
    void Process::SetupCoreData( void )
    { 
      GFL_ASSERT( mCoreData );
      GFL_ASSERT( mLowerDrawer );

      // f[^̂߂ɕKvȃZbgAbv
      mLowerDrawer->SetupForProcessStart();
      mUpperDrawer->SetupForProcessStart();

      {
        f32 minValue = mLowerDrawer->GetMinScrollValue();
        f32 maxValue = mLowerDrawer->GetMaxScrollValue();
        f32 initValue = mLowerDrawer->GetInitialScrollValue();
        mCoreData->SetMinScrollValue( minValue );
        mCoreData->SetMaxScrollValue( maxValue );
        mCoreData->SetScrollValue( initValue );
      }

      {
        app::tool::MenuWindowSystem* menuWindowSystem = 
          mLowerDrawer->GetMenuWindowSystem();

        mCoreData->SetMenuWindowSystem( menuWindowSystem );
      }
    }



    //--------------------------------------------------------------------------------
    /**
     * @brief vZX̏I
     *
     * @param procManager  vZX̃}l[W
     *
     * @retval RES_CONTINUE  Ip
     * @retval RES_FINISH    II
     */
    //--------------------------------------------------------------------------------
    gfl::proc::Result Process::EndFunc( gfl::proc::Manager* procManager )
    {
      GFL_UNUSED( procManager ); 
      this->PutResult();
      this->DeleteCoreDrawer();
      this->DeleteViewController();
      this->DeleteCoreOperator();
      this->DeleteCoreData();
      this->FinalizeDrawUtilLibrary();
      this->DeleteMessageData();
      this->DeleteLayoutSystem();
      this->CleanupFont();
      this->DeleteG3dSystem();
      this->DeleteGraphicsSystem();
      this->DeleteNwAllocators();
      this->DeleteArchiveData();
      app::nuts::Drawer::DeleteTemporaryStrbuf();

      // bZ[Wf[^j
      Drawer::FinalizeMessageData();

      return gfl::proc::RES_FINISH;
    } 

    // RAf[^`IuWFNgj
    void Process::DeleteCoreDrawer( void )
    {
      GFL_ASSERT( mUpperDrawer );
      GFL_ASSERT( mLowerDrawer );
      GFL_ASSERT( mPokemonDrawer );
      GFL_DELETE mUpperDrawer;
      GFL_DELETE mLowerDrawer;
      GFL_DELETE mPokemonDrawer;
    }

    // \ˑ̑IuWFNgj
    void Process::DeleteViewController( void )
    {
      GFL_ASSERT( mViewController );
      GFL_DELETE mViewController;
    }

    // RAf[^IuWFNgj
    void Process::DeleteCoreOperator( void )
    {
      GFL_ASSERT( mOperator );
      GFL_DELETE mOperator;
    }

    // Xe[^Xʂ̃RAf[^j
    void Process::DeleteCoreData( void )
    {
      GFL_ASSERT( mCoreData );
      GFL_DELETE mCoreData;
    }

    // ȈՕ`惉CuI
    void Process::FinalizeDrawUtilLibrary( void )
    {
    }

    // e탁bZ[Wf[^j
    void Process::DeleteMessageData( void )
    {
      GFL_ASSERT( mNutsMessageData );
      GFL_DELETE mNutsMessageData;
    } 

    // CAEgVXej
    void Process::DeleteLayoutSystem( void )
    {
      GFL_ASSERT( mLayoutSystem );
      GFL_DELETE mLayoutSystem; 
    } 

    // tHǧЕt
    void Process::CleanupFont( void )
    {
    }

    // G3DVXej
    void Process::DeleteG3dSystem( void )
    {
      GFL_ASSERT( mG3dSystem );
      GFL_DELETE mG3dSystem; 
    }

    // OtBbNXVXej
    void Process::DeleteGraphicsSystem( void )
    {
      mGraphicsSystem->FinalizeApplicationMemory();
    }

    // OtBbNXVXeŎgpAP[^j
    void Process::DeleteNwAllocators( void )
    {
      GFL_ASSERT( mNwHeapAllocator );
      GFL_ASSERT( mNwDeviceAllocator );
      GFL_DELETE mNwHeapAllocator;
      GFL_DELETE mNwDeviceAllocator;
    }

    // A[JCut@Cj
    void Process::DeleteArchiveData( void )
    {
      GFL_ASSERT( mArchiveData );
      GFL_DELETE mArchiveData;
    }


   //--------------------------------------------------------------------------------
   /**
    * @brief vZX̍XV
    *
    * @param procManager  vZX̃}l[W
    *
    * @retval RES_CONTINUE  Cp
    * @retval RES_FINISH    CI
    */
   //--------------------------------------------------------------------------------
    gfl::proc::Result Process::UpdateFunc( gfl::proc::Manager* procManager )
    {
      GFL_UNUSED( procManager );

      gfl::ui::Button* button = mUiDeviceManager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );

      mCoreData->UpdateData();
      mViewController->UpdateState();
      mOperator->ControlCoreData();
      mPokemonDrawer->UpdateView();
      mUpperDrawer->UpdateView();
      mLowerDrawer->UpdateView();
      mLayoutSystem->UpdateAll();

      if( mOperator->IsFinished() ) {
        return gfl::proc::RES_FINISH;
      }
      return gfl::proc::RES_CONTINUE;
    }


   //--------------------------------------------------------------------------------
   /**
    * @brief vZX̕`揈
    *
    * @param procManager  vZX̃}l[W
    */
   //--------------------------------------------------------------------------------
    void Process::DrawFunc( gfl::proc::Manager* procManager )
    {
      GFL_UNUSED( procManager );

      gfl::grp::RenderTarget* upperFrameBuffer = mGraphicsSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
      gfl::grp::RenderTarget* rightFrameBuffer = mGraphicsSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );
      gfl::grp::RenderTarget* lowerFrameBuffer = mGraphicsSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );

      mLayoutSystem->DrawAll( mGraphicsSystem, gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
      mLayoutSystem->DrawAll( mGraphicsSystem, gfl::grp::DISPLAY_LOWER, lowerFrameBuffer );
      mUpperDrawer->Draw();
      mLowerDrawer->Draw();
      mPokemonDrawer->Draw();      
    }

  } // namespace nuts
} // namespace app
