//========================================================================================
/**
 * @file app_nuts_PokemonDrawerSetupThread.h
 * @brief |P`NXZbgAbvXbh
 * @author takadao
 * @date 2011.09.02
 */
//========================================================================================
#ifndef __APP_NUTS_POKEMONDRAWERSETUPTHREAD_H__
#define __APP_NUTS_POKEMONDRAWERSETUPTHREAD_H__
#include <gflib.h>


namespace app {
  namespace nuts { 
    
    class ArchiveData;
    class PokemonDrawer;


    class PokemonDrawerSetupThread : public gfl::base::Thread
    {
      GFL_FORBID_COPY_AND_ASSIGN( PokemonDrawerSetupThread );

      public: 

      // f[^̐Ɣj
      static PokemonDrawer::Data* CreateDrawerData( gfl::heap::HeapBase* heap );
      static void DeleteDrawerData( PokemonDrawer::Data* data );

      // f[^NA
      static void ClearDrawerData( PokemonDrawer::Data* data );


      // RXgN^
      PokemonDrawerSetupThread(
          gfl::heap::HeapBase* heap,
          gfl::heap::NwAllocator* nw_heap_allocator,
          gfl::heap::NwAllocator* nw_device_allocator,
          app::nuts::ArchiveData* archive_data,
          app::nuts::PokemonDrawer::Data* drawer_data, 
          MonsNo monsno );

      // fXgN^
      ~PokemonDrawerSetupThread();



      private: 
      gfl::heap::NwAllocator* m_nw_heap_allocator;
      gfl::heap::NwAllocator* m_nw_device_allocator;
      app::nuts::ArchiveData* m_arc_data;
      app::nuts::PokemonDrawer::Data* m_drawer_data;
      MonsNo m_monsno;


      // Xbh̃C
      virtual void Main( void );


      // eIuWFNg̐
      void LoadResources( void );
      void SetupModel( void );
      void SetupModelAnimation( void );
      void SetupScene( void ); 
    };

  } // namespace nuts
} // namespace app


#endif // __APP_NUTS_POKEMONDRAWERSETUPTHREAD_H__
