//========================================================================================
/**
 * @file app_nuts_PokemonDrawerSetupThread.cpp
 * @brief |P`NXZbgAbvXbh
 * @author takada
 * @date 2011.09.02
 */
//========================================================================================
#include <arc/games_take_nuts_pokemon_data.gaix>
#include "app_nuts_ArchiveData.h"
#include "app_nuts_PokemonDrawer.h"
#include "app_nuts_PokemonDrawerSetupThread.h"


namespace app {
  namespace nuts { 






    //------------------------------------------------------------------------------------
    // f[^𐶐
    //------------------------------------------------------------------------------------
    PokemonDrawer::Data* PokemonDrawerSetupThread::CreateDrawerData( gfl::heap::HeapBase* heap )
    {
      PokemonDrawer::Data* drawer_data = GFL_NEW( heap ) PokemonDrawer::Data();
      drawer_data->camera = NULL;
      drawer_data->model = GFL_NEW( heap ) gfl::grp::g3d::Model();
      drawer_data->model_resource = GFL_NEW( heap ) gfl::grp::g3d::Resource();
      drawer_data->scene = GFL_NEW( heap ) gfl::grp::g3d::Scene();
      drawer_data->environment_resource = GFL_NEW( heap ) gfl::grp::g3d::Resource();
      drawer_data->camera_resource = GFL_NEW( heap ) gfl::grp::g3d::Resource();
      for( u32 i=0; i<PokemonDrawer::MODEL_ANIMATION_NUM; i++ ) {
        drawer_data->model_animation_resource[i] = GFL_NEW( heap ) gfl::grp::g3d::Resource();
        drawer_data->model_animation[i] = GFL_NEW( heap ) gfl::grp::g3d::ResAnim();
      } 
      drawer_data->setup_flag = false;
      return drawer_data;
    }


    //------------------------------------------------------------------------------------
    // f[^j
    //------------------------------------------------------------------------------------
    void PokemonDrawerSetupThread::DeleteDrawerData( PokemonDrawer::Data* drawer_data )
    {
      drawer_data->scene->RemoveAllSceneNodes();
      drawer_data->scene->DestroyOwnObject();
#ifdef EDGE_ENABLE
      drawer_data->scene->DestroyEdgeMapSystem();
      drawer_data->scene->DestroyPostEffectSystem();
#endif
      GFL_DELETE( drawer_data->model );
      GFL_DELETE( drawer_data->scene );
      GFL_DELETE( drawer_data->environment_resource );
      GFL_DELETE( drawer_data->camera_resource );
      GFL_DELETE( drawer_data->model_resource );
      for( u32 i=0; i<PokemonDrawer::MODEL_ANIMATION_NUM; i++ ) {
        GFL_DELETE( drawer_data->model_animation[i] );
        GFL_DELETE( drawer_data->model_animation_resource[i] );
      }
      GFL_DELETE( drawer_data );
    }



    //------------------------------------------------------------------------------------
    // f[^NA
    //------------------------------------------------------------------------------------
    void PokemonDrawerSetupThread::ClearDrawerData( PokemonDrawer::Data* data )
    {
      data->camera = NULL;
      data->scene->Destroy();
      data->model->Destroy();
      data->environment_resource->Unload();
      data->camera_resource->Unload();
      data->model_resource->Unload();
      for( u32 i=0; i<PokemonDrawer::MODEL_ANIMATION_NUM; i++ ) {
        data->model_animation[i]->Destroy();
        data->model_animation_resource[i]->Unload();
      }
      data->setup_flag = false;
    }





    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    PokemonDrawerSetupThread::PokemonDrawerSetupThread(
        gfl::heap::HeapBase* heap,
        gfl::heap::NwAllocator* nw_heap_allocator,
        gfl::heap::NwAllocator* nw_device_allocator,
        app::nuts::ArchiveData* archive_data,
        app::nuts::PokemonDrawer::Data* drawer_data,
        MonsNo monsno ) : 
      gfl::base::Thread( heap, 4096 ), 
      m_nw_heap_allocator( nw_heap_allocator ),
      m_nw_device_allocator( nw_device_allocator ),
      m_arc_data( archive_data ),
      m_drawer_data( drawer_data ),
      m_monsno( monsno )
    { 
    }



    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    PokemonDrawerSetupThread::~PokemonDrawerSetupThread() 
    {
    }





    //====================================================================================
    // Xbh̃C
    //====================================================================================
    void PokemonDrawerSetupThread::Main( void )
    {
      GFL_ASSERT( !m_drawer_data->setup_flag ); 
      this->LoadResources();
      //GFL_PRINT( "pokemon drawer settup > load resource\n" );
      this->SetupModel();
      //GFL_PRINT( "pokemon drawer settup > setup model\n" );
      this->SetupModelAnimation();
      //GFL_PRINT( "pokemon drawer settup > setup model anime\n" );
      this->SetupScene();
      //GFL_PRINT( "pokemon drawer settup > setup scene\n" );
      m_drawer_data->setup_flag = true;
      this->Kill();  // E
    } 


    // \[Xǂݍ
    void PokemonDrawerSetupThread::LoadResources( void )
    {
      gfl::fs::ArcFile* arc_file = m_arc_data->GetArcFile();
      gfl::fs::ArcFile::ARCDATID arc_data_id = 0;

      switch( m_monsno ) {
      case MONSNO_PIKATYUU:  arc_data_id = GARC_games_take_nuts_pokemon_data_pikachu_BCRES;  break;
      case MONSNO_SIKIZIKA:  arc_data_id = GARC_games_take_nuts_pokemon_data_pikachu_BCRES;  break;
      default:  arc_data_id = GARC_games_take_nuts_pokemon_data_pikachu_BCRES;  break;
      }

      // f
      gfl::grp::g3d::Resource::Description resource_description;
      u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
      common_resource_flag |= gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT; 
      m_drawer_data->model_resource->LoadAndSetup( m_nw_device_allocator, 
          arc_file, arc_data_id, &resource_description, common_resource_flag ); 

      // fAj[V
      for( u32 i=0; i<PokemonDrawer::MODEL_ANIMATION_NUM; i++ ) {
        m_drawer_data->model_animation_resource[i]->LoadAndSetup( m_nw_device_allocator, arc_file, arc_data_id );
      }

      // 
      m_drawer_data->environment_resource->LoadAndSetup( m_nw_device_allocator, arc_file, GARC_pokemon_status_environment_BCENV ); 

      // J
      m_drawer_data->camera_resource->LoadAndSetup( m_nw_device_allocator, arc_file, GARC_pokemon_status_camera_BCENV );
    }


    // f𐶐
    void PokemonDrawerSetupThread::SetupModel( void )
    {
      f32 model_scale = 1.0f;
      switch( m_monsno ) {
      case MONSNO_PIKATYUU:  model_scale = 4.00f;  break;
      case MONSNO_SIKIZIKA:  model_scale = 3.50f;  break;
      }
      m_drawer_data->model->Create( m_nw_heap_allocator, m_nw_device_allocator, m_drawer_data->model_resource, 0 );
      m_drawer_data->model->SetScale( model_scale, model_scale, model_scale );
    }


    // f̃Aj[V𐶐
    void PokemonDrawerSetupThread::SetupModelAnimation( void )
    { 
      for( u32 i=0; i<PokemonDrawer::MODEL_ANIMATION_NUM; i++ ) {
        m_drawer_data->model_animation[i]->Create( m_nw_heap_allocator, m_drawer_data->model_animation_resource[i], 0, gfl::grp::g3d::ResAnim::TYPE_SKELETAL );
      }
    } 


    // V[ZbgAbv
    void PokemonDrawerSetupThread::SetupScene( void )
    {
      gfl::grp::g3d::Scene::Description scene_desc;
      scene_desc.own_model_num_max = 8; 
      m_drawer_data->scene->Create( m_nw_device_allocator, &scene_desc );
      m_drawer_data->scene->BuildSceneUsingResource( m_nw_heap_allocator, m_nw_device_allocator, m_drawer_data->environment_resource ); 
      m_drawer_data->scene->BuildSceneUsingResource( m_nw_heap_allocator, m_nw_device_allocator, m_drawer_data->camera_resource ); 

      m_drawer_data->camera = m_drawer_data->scene->GetOwnCamera( m_drawer_data->camera_resource->GetId(), 0 );
      GFL_ASSERT_STOP( m_drawer_data->camera );
      m_drawer_data->camera->SetPivotDirection( gfl::math::PIVOT_UPSIDE_TO_TOP ); 

      m_drawer_data->scene->AddSceneNode( m_drawer_data->model );
      m_drawer_data->scene->AddModelToSceneCalculateGroup( m_drawer_data->model, 0 );
      m_drawer_data->scene->AddModelToSceneDrawGroup( m_drawer_data->model, 0 );

#ifdef EDGE_ENABLE
      gfl::grp::g3d::G3DPostEffectSystem::Description post_effect_desc;
      post_effect_desc.edge_draw_group_id = 0;
      post_effect_desc.edge_enable = true;
      post_effect_desc.edge_type = gfl::grp::g3d::G3DEdgeFilter::DEFAULT_EDGE;
      post_effect_desc.bloom_filter_enable = false;
      m_drawer_data->scene->CreatePostEffectSystem( m_nw_heap_allocator, m_nw_device_allocator, &post_effect_desc ); 
      m_drawer_data->scene->CreateEdgeMapSystem( m_nw_heap_allocator, m_nw_device_allocator, 0 ); 
      m_drawer_data->scene->SetEdgeEnable( true ); 
      m_drawer_data->scene->SwitchEdgeMapModel( m_drawer_data->model, true );
#endif 

      m_drawer_data->scene->Initialize();
      m_drawer_data->scene->SetSceneEnvironmentUsingOwnObject();
      m_drawer_data->scene->Calculate(); 
    }



  } // namespace nuts
} // namespace app
