//========================================================================================
/**
 * @file app_nuts_PokemonDrawer.h
 * @brief ؂̎̂Q[̃|P`NX
 * @author takada
 * @date 2011.09.02
 */
//========================================================================================
#ifndef __NUTS_DRAWER_POKEMON_H__
#define __NUTS_DRAWER_POKEMON_H__
#include <gflib.h>
#include <pmlib.h>
#include <arc/games_take_nuts_pokemon_data.gaix>
#include "app_nuts_BalloonData.h"

// GbW`Lɂ
//#define EDGE_ENABLE


namespace app {
  namespace nuts {

    class CoreData;
    class ArchiveData;
    class PokemonDrawerSetupThread;


    class PokemonDrawer : public Drawer
    {
      GFL_FORBID_COPY_AND_ASSIGN( PokemonDrawer );  // Rs[֎~

      public:
      //--------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param heap_for_instance    CX^X̐Ɏgpq[v
       * @param heap_for_setup_work  f[^̃ZbgAbvɎgpq[v
       * @param nw_heap_allocator    OtBbNXVXeŎgpAP[^
       * @param nw_device_allocator  OtBbNXVXeŎgpAP[^
       * @param graphics_system      `ɎgpOtBbNXVXe
       * @param g3d_system           `ɎgpG3DVXe
       * @param layout_system        `Ɏgp郌CAEgVXe
       * @param status_core          `Ώۂ̃Xe[^XʃRA
       * @param arc_data             Xe[^Xʂ̃A[JCuf[^
       */
      //--------------------------------------------------------------------------------
      PokemonDrawer( 
          gfl::heap::HeapBase* heap_for_instance,
          gfl::heap::HeapBase* heap_for_setup_work,
          gfl::heap::NwAllocator* nw_heap_allocator,
          gfl::heap::NwAllocator* nw_device_allocator,
          gfl::grp::GraphicsSystem* graphics_system, 
          gfl::grp::g3d::System* g3d_system,
          gfl::grp::g2d::LytSys* layout_system,
          app::nuts::CoreData* status_core,
          app::nuts::ArchiveData* arc_data );

      //--------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //--------------------------------------------------------------------------------
      virtual ~PokemonDrawer();

      //--------------------------------------------------------------------------------
      /**
       * @brief \eXV
       */
      //--------------------------------------------------------------------------------
      virtual void UpdateView( void );

      //--------------------------------------------------------------------------------
      /**
       * @brief ʂ`悷
       */
      //--------------------------------------------------------------------------------
      virtual void Draw( void );



      //--------------------------------------------------------------------------------
      /**
       * @brief `悷|PύX
       */
      //--------------------------------------------------------------------------------
      void ChangePokemon( MonsNo monsno );



      // f̃Aj[V
      enum ModelAnimaiton {
        MODEL_ANIMATION_WAIT,  // ҋ@Aj
        MODEL_ANIMATION_NUM,
      };

      enum Position {
        POSITION_FIXING, // Œ
        POSITION_RANDOM, // _

        POSITION_NUM,
        POSITION_NULL,
      };
      // Xebv
      struct StepInformation {
        s32 maxNumOfSimultaneousAppearance; // ő哯o
        s32 numOfGoToTheNextStep; // ̃Xebvɐiސ
        s32 maxTimeBreak; // ő̊Ԋu
        s32 minTimeBreak; // Œx̊Ԋu
        s32 maxTimeLimit; // ő̐
        s32 minTimeLimit; // Œx̐
        s32 numBecomeTheFastest; // őɐԂŌŒɂȂc
        s32 position; // ʒu
      };
      static const StepInformation stepInformation[ 4 ];

      // 
      struct BehaviorInfo {
        BalloonData::BalloonIndex wantColors[ 2 ];
        BalloonData::BalloonIndex balloonIndex;
        s32 occurrences;
        gfl::math::VEC3 rot;
        bool rotFlag;
        s32 counter;
        bool isSetup;
        bool isAppearance;
        s32 timeLimit;
      };

      // `ɕKvȃf[^
      struct Data {
        bool setup_flag;  // ZbgAbvĂ邩ǂ
        gfl::grp::g3d::Model* model;
        gfl::grp::g3d::ResAnim* model_animation[ MODEL_ANIMATION_NUM ];
        gfl::grp::g3d::Scene* scene;
        gfl::grp::g3d::Resource* environment_resource;
        gfl::grp::g3d::Resource* camera_resource;
        gfl::grp::g3d::Resource* model_resource;
        gfl::grp::g3d::Resource* model_animation_resource[ MODEL_ANIMATION_NUM ];
        BehaviorInfo behaviorInfo;
      };

      // {ʒu
      static const gfl::math::VEC3 basePositionOfPokemon[ 3 ];

      // f[^̐Ɣj
      void CreateDrawerData( gfl::heap::HeapBase* heap );
      void DeleteDrawerData( void );

      // eIuWFNg̐
      void LoadResources( s32 index );
      void SetupModel( s32 index );
      void SetupModelAnimation( s32 index );
      void SetupScene( s32 index );
      void SetupBehaviorInfo( s32 index );


      private: 

      gfl::grp::g3d::System* m_g3d_system;
      gfl::fs::ArcFile m_arc_file;
      PokemonDrawer::Data m_data[ 3 ];
      gfl::grp::g3d::Camera* m_camera;      
      gfl::heap::HeapBase* m_heap_for_setup_work;
      gfl::heap::NwAllocator* m_nw_heap_allocator;
      gfl::heap::NwAllocator* m_nw_device_allocator;

      // f[^̃ZbgAbvJn
      void StartDataSetup( MonsNo monsno );

      // f[^̃ZbgAbv
      void EndDataSetup( void );

      bool IsReachedMaxNum( void );
      void UpdateBehaviorInfo( s32 index );
      void UpdateData( s32 index );
      s32 GetRandOccurrences( void );
      s32 GetRandPokemon( void );
      void GetRandArray( s32* array );
      void UpdataData( s32 index );

      // ݂̃Zbgԍ
      s32 mCurrentNumOfSet;
      // o|P̐
      s32 mTotalNumOfPokemon;

      // Ԃ߂
      s32 GetTimeLimit( void );

      s32 mLastPokeIDOfSet;
      s32 mSameTimePokeID;
    };


  } // namespace nuts
} // namespace app


#endif // __NUTS_DRAWER_POKEMON_H__
