//========================================================================================
/**
 * @file app_nuts_PokemonDrawer.cpp
 * @brief ؂̎̂Q[̃|P`NX
 * @author takada
 * @date 2011.09.02
 */
//========================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <system/thread_priority.h>
#include <arc/arc_def.h>
#include "app_nuts_CoreData.h"
#include "app_nuts_ArchiveData.h"
#include "app_nuts_PokemonDrawer.h"
#include "app_nuts_PokemonDrawerSetupThread.h"
#include "app_nuts_LowerLayoutInformation.h"

namespace app {
  namespace nuts {

    const gfl::math::VEC3 PokemonDrawer::basePositionOfPokemon[ 3 ] = 
    {
      gfl::math::VEC3( -80.0f, 0.0f, 0.0f ),
      gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),
      gfl::math::VEC3( 80.0f, 0.0f, 0.0f ),
    };

    const PokemonDrawer::StepInformation PokemonDrawer::stepInformation[ 4 ] =
    {
      {
        2,
        3,
        60,
        120,
        180,
        300,
        3,
        POSITION_FIXING,
      },

      {
        2,
        15,
        30,
        120,
        120,
        240,
        5,
        POSITION_RANDOM,
      },

      {
        2,
        16,
        18,
        90,
        120,
        240,
        6,
        POSITION_RANDOM,
      },

      {
        3,
        30,
        6,
        60,
        60,
        180,
        9,
        POSITION_RANDOM,
      },
    };

    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    PokemonDrawer::PokemonDrawer( 
        gfl::heap::HeapBase* heap_for_instance,
        gfl::heap::HeapBase* heap_for_setup_work,
        gfl::heap::NwAllocator* nw_heap_allocator,
        gfl::heap::NwAllocator* nw_device_allocator,
        gfl::grp::GraphicsSystem* graphics_system, 
        gfl::grp::g3d::System* g3d_system,
        gfl::grp::g2d::LytSys* layout_system,
        app::nuts::CoreData* status_core,
        app::nuts::ArchiveData* arc_data ) : 
      Drawer( nw_heap_allocator, nw_device_allocator, graphics_system, layout_system, status_core ),
      m_g3d_system( g3d_system ),
      m_arc_file( ARCID_GAME_TAKE_NUTS_POKEMON_DATA, heap_for_instance ),
      m_camera( NULL ),
      m_heap_for_setup_work( heap_for_setup_work ),
      m_nw_heap_allocator( nw_heap_allocator ),
      m_nw_device_allocator( nw_device_allocator ),
      mCurrentNumOfSet( 0 ),
      mTotalNumOfPokemon( 0 ),
      mLastPokeIDOfSet( -1 ),
      mSameTimePokeID( -1 )
    {
      for( s32 i=0; i<GFL_NELEMS( m_data ); ++i )
      { 
        m_data[ i ].model = NULL;
        m_data[ i ].model_resource = NULL;
        m_data[ i ].scene = NULL;
        m_data[ i ].environment_resource = NULL;
        m_data[ i ].camera_resource = NULL;
        for( u32 j=0; j<MODEL_ANIMATION_NUM; ++j ) {
          m_data[ i ].model_animation_resource[j] = NULL;
          m_data[ i ].model_animation[j] = NULL;
        } 
        m_data[ i ].setup_flag = false;

        m_data[ i ].behaviorInfo.balloonIndex = BalloonData::BALLOON_NULL;
        m_data[ i ].behaviorInfo.occurrences = 0;
        m_data[ i ].behaviorInfo.rot = gfl::math::VEC3( 0.0f, 0.0f, 0.0f );
        m_data[ i ].behaviorInfo.rotFlag = false;
        m_data[ i ].behaviorInfo.counter = 0;
        m_data[ i ].behaviorInfo.isSetup = false;
        m_data[ i ].behaviorInfo.isAppearance = false;
        m_data[ i ].behaviorInfo.timeLimit = 0;
      }
            
      this->CreateDrawerData( heap_for_instance );
      this->m_camera = GFL_NEW( heap_for_instance ) gfl::grp::g3d::Camera();
    }

    //------------------------------------------------------------------------------------
    // f[^𐶐
    //------------------------------------------------------------------------------------
    void PokemonDrawer::CreateDrawerData( gfl::heap::HeapBase* heap )
    {
      // TODO
      m_data[ 0 ].behaviorInfo.wantColors[ 0 ] = BalloonData::BALLOON_ONE;
      m_data[ 0 ].behaviorInfo.wantColors[ 1 ] = BalloonData::BALLOON_TWO;      
      m_data[ 1 ].behaviorInfo.wantColors[ 0 ] = BalloonData::BALLOON_THREE;
      m_data[ 1 ].behaviorInfo.wantColors[ 1 ] = BalloonData::BALLOON_FOUR;      
      m_data[ 2 ].behaviorInfo.wantColors[ 0 ] = BalloonData::BALLOON_FIVE;
      m_data[ 2 ].behaviorInfo.wantColors[ 1 ] = BalloonData::BALLOON_SIX;

      for( s32 i=0; i<GFL_NELEMS( m_data ); ++i )
      {
        //m_data[ i ] = GFL_NEW( heap ) PokemonDrawer::Data();
        m_data[ i ].model = GFL_NEW( heap ) gfl::grp::g3d::Model();
        m_data[ i ].model_resource = GFL_NEW( heap ) gfl::grp::g3d::Resource();
        m_data[ i ].scene = GFL_NEW( heap ) gfl::grp::g3d::Scene();
        m_data[ i ].environment_resource = GFL_NEW( heap ) gfl::grp::g3d::Resource();
        m_data[ i ].camera_resource = GFL_NEW( heap ) gfl::grp::g3d::Resource();
        for( u32 j=0; j<MODEL_ANIMATION_NUM; ++j ) {
          m_data[ i ].model_animation_resource[j] = GFL_NEW( heap ) gfl::grp::g3d::Resource();
          m_data[ i ].model_animation[j] = GFL_NEW( heap ) gfl::grp::g3d::ResAnim();
        } 
        m_data[ i ].setup_flag = false;

        m_data[ i ].behaviorInfo.balloonIndex = m_data[ i ].behaviorInfo.wantColors[ 0 ];
        m_data[ i ].behaviorInfo.occurrences = 0;
        m_data[ i ].behaviorInfo.rot = gfl::math::VEC3( 0.0f, 0.0f, 0.0f );
        m_data[ i ].behaviorInfo.rotFlag = false;
        m_data[ i ].behaviorInfo.counter = 0;
        m_data[ i ].behaviorInfo.isSetup = false;
        m_data[ i ].behaviorInfo.isAppearance = false;
        m_data[ i ].behaviorInfo.timeLimit = 0;
      }        
    }

    //------------------------------------------------------------------------------------
    // f[^j
    //------------------------------------------------------------------------------------
    void PokemonDrawer::DeleteDrawerData( void )
    {
      for( s32 i=0; i<GFL_NELEMS( m_data ); ++i )
      {
        m_data[ i ].scene->RemoveAllSceneNodes();
        m_data[ i ].scene->DestroyOwnObject();
#ifdef EDGE_ENABLE
        m_data[ i ].scene->DestroyEdgeMapSystem();
        m_data[ i ].scene->DestroyPostEffectSystem();
#endif
        GFL_DELETE( m_data[ i ].model );
        GFL_DELETE( m_data[ i ].scene );
        GFL_DELETE( m_data[ i ].environment_resource );
        GFL_DELETE( m_data[ i ].camera_resource );
        GFL_DELETE( m_data[ i ].model_resource );
        for( u32 j=0; j<MODEL_ANIMATION_NUM; ++j ) {
          GFL_DELETE( m_data[ i ].model_animation[j] );
          GFL_DELETE( m_data[ i ].model_animation_resource[j] );
        }
        //GFL_DELETE( drawer_data );
      }
    }

    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    PokemonDrawer::~PokemonDrawer()
    {
      this->DeleteDrawerData();
    }

    // \[Xǂݍ
    void PokemonDrawer::LoadResources( s32 index )
    {
      //gfl::fs::ArcFile* arc_file = m_arc_data->GetArcFile();
      gfl::fs::ArcFile::ARCDATID arc_data_id = 0;

      /*
      switch( monsno ) {
      case MONSNO_PIKATYUU:  arc_data_id = GARC_games_take_nuts_pokemon_data_pikachu_BCRES;  break;
      default:  arc_data_id = GARC_games_take_nuts_pokemon_data_pikachu_BCRES;  break;
      }
      */
      arc_data_id = GARC_games_take_nuts_pokemon_data_pikachu_BCRES;

      // f
      gfl::grp::g3d::Resource::Description resource_description;
      u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
      common_resource_flag |= gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT; 
      m_data[ index ].model_resource->LoadAndSetup( m_nw_device_allocator, 
          &m_arc_file, arc_data_id, &resource_description, common_resource_flag ); 

      // fAj[V
      for( u32 i=0; i<MODEL_ANIMATION_NUM; i++ ) {
        m_data[ index ].model_animation_resource[i]->LoadAndSetup( m_nw_device_allocator, &m_arc_file, arc_data_id );
      }
    }

    // f𐶐
    void PokemonDrawer::SetupModel( s32 index )
    {
      f32 model_scale = 1.0f;
      /*
      switch( m_monsno ) {
      case MONSNO_PIKATYUU:  model_scale = 4.0f;  break;
      case MONSNO_SIKIZIKA:  model_scale = 3.5f;  break;
      }
      */
      m_data[ index ].model->Create( m_nw_heap_allocator, m_nw_device_allocator, m_data[ index ].model_resource, 0 );
      m_data[ index ].model->SetScale( model_scale, model_scale, model_scale );
    }

    // f̃Aj[V𐶐
    void PokemonDrawer::SetupModelAnimation( s32 index )
    { 
      for( u32 i=0; i<MODEL_ANIMATION_NUM; i++ ) {
        m_data[ index ].model_animation[i]->Create( m_nw_heap_allocator, m_data[ index ].model_animation_resource[i], 0, gfl::grp::g3d::ResAnim::TYPE_SKELETAL );
      }
    }

    // V[ZbgAbv
    void PokemonDrawer::SetupScene( s32 index )
    {
      gfl::grp::g3d::Scene::Description scene_desc;
      scene_desc.own_model_num_max = 8; 
      m_data[ index ].scene->Create( m_nw_device_allocator, &scene_desc );
      m_data[ index ].scene->BuildSceneUsingResource( m_nw_heap_allocator, m_nw_device_allocator, m_data[ index ].environment_resource ); 
      m_data[ index ].scene->BuildSceneUsingResource( m_nw_heap_allocator, m_nw_device_allocator, m_data[ index ].camera_resource ); 

      //m_camera = m_data[ index ].scene->GetOwnCamera( m_data[ index ].camera_resource->GetId(), 0 );
      gfl::grp::g3d::Camera::Description camera_description;
      camera_description.camera_position = gfl::math::VEC3(0.0f, 150.0f, 200.0f);
      camera_description.target_position = gfl::math::VEC3(0.0f, 150.0f, 0.0f);
      m_camera->Create( m_nw_heap_allocator, &camera_description ); 
      GFL_ASSERT_STOP( m_camera );
      m_camera->SetPivotDirection( gfl::math::PIVOT_UPSIDE_TO_TOP );
      m_data[ index ].scene->AddSceneNode( m_camera );

      m_data[ index ].scene->AddSceneNode( m_data[ index ].model );
      m_data[ index ].scene->AddModelToSceneCalculateGroup( m_data[ index ].model, 0 );
      m_data[ index ].scene->AddModelToSceneDrawGroup( m_data[ index ].model, 0 );

#ifdef EDGE_ENABLE
      gfl::grp::g3d::G3DPostEffectSystem::Description post_effect_desc;
      post_effect_desc.edge_draw_group_id = 0;
      post_effect_desc.edge_enable = true;
      post_effect_desc.edge_type = gfl::grp::g3d::G3DEdgeFilter::DEFAULT_EDGE;
      post_effect_desc.bloom_filter_enable = false;
      m_data[ index ].scene->CreatePostEffectSystem( m_nw_heap_allocator, m_nw_device_allocator, &post_effect_desc ); 
      m_data[ index ].scene->CreateEdgeMapSystem( m_nw_heap_allocator, m_nw_device_allocator, 0 ); 
      m_data[ index ].scene->SetEdgeEnable( true ); 
      m_data[ index ].scene->SwitchEdgeMapModel( m_data[ index ].model, true );
#endif 

      m_data[ index ].scene->Initialize();
      m_data[ index ].scene->SetSceneEnvironmentUsingOwnObject();
      m_data[ index ].scene->Calculate(); 
    }

    //------------------------------------------------------------------------------------
    // `悷|PύX
    //------------------------------------------------------------------------------------
    void PokemonDrawer::ChangePokemon( MonsNo monsno )
    {
      this->StartDataSetup( monsno );
    }


    // f[^̃ZbgAbvJn
    void PokemonDrawer::StartDataSetup( MonsNo monsno )
    {
      for( s32 i=0; i<GFL_NELEMS( m_data ); ++i )
      {
        this->LoadResources( i );
        this->SetupModel( i );
        this->SetupModelAnimation( i );
        this->SetupScene( i );
        m_data[ i ].setup_flag = true;
      }
    }

    //------------------------------------------------------------------------------------
    // \eXV
    //------------------------------------------------------------------------------------
    void PokemonDrawer::UpdateView( void )
    {
      // |Pω
      if( this->CoreData()->IsDirty( CoreData::DIRTY_FLAG_FOR_POKEMON, CoreData::DIRTY_BIT_POKEMON ) ) {
        this->CoreData()->RemoveDirtyBit( CoreData::DIRTY_FLAG_FOR_POKEMON, CoreData::DIRTY_BIT_POKEMON ); 
        const pml::pokepara::PokemonParam* pokemon_param = this->CoreData()->GetConstPokemonParameter();
        MonsNo monsno = pokemon_param->GetMonsNo();
        this->ChangePokemon( monsno );
      }

      if( mLastPokeIDOfSet == -1 && mSameTimePokeID == -1 )
      {
        while( IsReachedMaxNum() == false )
        {
          s32 num = GetRandPokemon();

          if( m_data[ num ].behaviorInfo.isSetup == false )
          {
            // o|P̐JEgAbv
            mTotalNumOfPokemon++;
            if( mTotalNumOfPokemon == stepInformation[ mCurrentNumOfSet ].maxNumOfSimultaneousAppearance )
            {
              mSameTimePokeID = num;
            }
            if( stepInformation[ mCurrentNumOfSet ].numOfGoToTheNextStep <= mTotalNumOfPokemon )
            {
              // Zbg̍Ō̃|Po
              mLastPokeIDOfSet = num;
            }

            // TODO: ~؂̎̐FQFꍇ́A_łǂ炩I
            m_data[ num ].behaviorInfo.balloonIndex = m_data[ num ].behaviorInfo.wantColors[ 0 ];
 
            // \tO𗧂Ă
            m_data[ num ].behaviorInfo.isSetup = true;
          }

          if( mLastPokeIDOfSet != -1 || mSameTimePokeID != -1 )
            break;
        }
      }

      for( s32 i=0; i<GFL_NELEMS( m_data ); ++i )
      {
        if( m_data[ i ].behaviorInfo.isAppearance == true )
        {
          UpdateData( i );
        }
        else
        {
          if( m_data[ i ].behaviorInfo.isSetup == true )
          {
            UpdateBehaviorInfo( i );
          }
        }

        // f[^̕`揀Ă
        if( m_data[ i ].setup_flag ) {

          m_data[ i ].scene->Calculate(); // 3D V[̌vZ

          m_data[ i ].scene->SubmitView( m_camera ); // _ɈˑXVRenderQueue̍\z
#ifdef EDGE_ENABLE
          m_data[ i ].scene->SubmitViewOfEdge( m_camera );
#endif
        }
      }
    }

    void PokemonDrawer::UpdateBehaviorInfo( s32 index )
    {
      // JEgAbv
      m_data[ index ].behaviorInfo.counter++;
      // oԔ
      s32 time = stepInformation[ mCurrentNumOfSet ].maxTimeBreak;
      if( time <= m_data[ index ].behaviorInfo.counter )
      {
        // JE^[Zbg
        m_data[ index ].behaviorInfo.counter = 0;

        // ZbgAbv
        SetupBehaviorInfo( index );

        // Ԃ擾
        m_data[ index ].behaviorInfo.timeLimit = GetTimeLimit();

        // öʒuA|P̏oʒuƊ]̐FɂύX
        BalloonData::BalloonIndex targetBalloon = m_data[ index ].behaviorInfo.balloonIndex;
        this->BalloonData()->SetBasePosition( m_data[ index ].behaviorInfo.occurrences, targetBalloon );
        
        m_data[ index ].behaviorInfo.isAppearance = true;
      }        
    }    

    /*
    // ݂̃Zbg̍ő哯o
    s32 maxNumOfSimultaneousAppearance = stepInformation[ mCurrentNumOfSet ].maxNumOfSimultaneousAppearance;
    // ̐zp
    s32 array[ maxNumOfSimultaneousAppearance ];
    this->GetRandArray( array );

    for( s32 i=0; i<GFL_NELEMS( array ); ++i )
    {
    }
    void PokemonDrawer::GetRandArray( s32* array )
    {
      s32 num[ GFL_NELEMS( m_data ) ]; 
      bool flag[ GFL_NELEMS( m_data ) ];
      s32 tmp;

      for( s32 i=0; i<GFL_NELEMS( m_data ); ++i )
      {
        num[ i ] = i;
        flag[ i ] = false;
      }

      for( s32 i=0; i<GFL_NELEMS( array ); ++i, ++array )
      {
        tmp = xy_system::GflUse::GetPublicRand( GFL_NELEMS( m_data ) );
        if( flag[ tmp ] == false ){
          flag[ tmp ] = true;
          *array = num[ tmp ];
        }
      }
    }
    */

    //----------------------------------------------------------------------------
    /**
     *	@brief ő哯oɒBĂ邩ǂ`FbN
     *
     *	@param Ȃ
     *
     *	@return ő哯oɒBĂ邩
     */
    //-----------------------------------------------------------------------------
    bool PokemonDrawer::IsReachedMaxNum( void )
    {
      s32 insideNum = 0;
      for( s32 i=0; i<GFL_NELEMS( m_data ); ++i )
      {
        if( m_data[ i ].behaviorInfo.isSetup == true )
        {
          insideNum++;
        }
      }

      if( insideNum < stepInformation[ mCurrentNumOfSet ].maxNumOfSimultaneousAppearance )
      {
        return false;
      }
      return true;      
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief ɏoĂȂ|P̒A_őIo
     *
     *	@param Ȃ
     *
     *	@return |P̊Ǘԍ
     */
    //-----------------------------------------------------------------------------
    s32 PokemonDrawer::GetRandPokemon( void )
    {
      s32 num = -1; 

      do {

        s32 tmp = xy_system::GflUse::GetPublicRand( GFL_NELEMS( m_data ) );

        if( m_data[ tmp ].behaviorInfo.isSetup == false )
        {
          num = tmp;
        }

      } while( num == -1 );

      GFL_ASSERT( num != -1 );

      return num;
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief |P̏oʒuANȂʒu̒烉_őIo
     *
     *	@param |P̊Ǘԍ
     *
     *	@return |P̏oʒu
     */
    //-----------------------------------------------------------------------------
    s32 PokemonDrawer::GetRandOccurrences()
    {
      s32 num = -1; 

      do {

        s32 tmp = xy_system::GflUse::GetPublicRand( 3 );

        bool isSame = false;
        for( s32 i=0; i<GFL_NELEMS( m_data ); ++i )
        {
          //if( m_data[ i ].behaviorInfo.isSetup == true )
          if( m_data[ i ].behaviorInfo.isAppearance == true )
          {
            if( tmp == m_data[ i ].behaviorInfo.occurrences )
            {
              isSame = true;
            }
          }
        }

        if( isSame == false )
        {
          num = tmp;
        }

        /*
        // ǂ̃|PoĂȂꍇɂ͊ǗԍԂ
        if( isInside == false )
        {
          if( num == -1 ) num = index;
        }
        */

      } while( num == -1 );
      
      GFL_ASSERT( num != -1 );

      return num;
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief |P̋Zbg
     *
     *	@param |P̊Ǘԍ
     *
     *	@return Ȃ
     */
    //-----------------------------------------------------------------------------
    void PokemonDrawer::SetupBehaviorInfo( s32 index )
    { 
      // oʒu擾
      m_data[ index ].behaviorInfo.occurrences = this->GetRandOccurrences();
      GFL_PRINT( "set%d, %dhikime, occurrences=%d\n", mCurrentNumOfSet, mTotalNumOfPokemon, m_data[ index ].behaviorInfo.occurrences );      
      // oʒuɑΉx[X|WVZbg
      m_data[ index ].model->SetTranslate( basePositionOfPokemon[ m_data[ index ].behaviorInfo.occurrences ] );      
      // ]pZbg
      m_data[ index ].behaviorInfo.rot = gfl::math::VEC3( 0.0f, 0.0f, 0.0f );
      m_data[ index ].model->SetRotateXYZ( m_data[ index ].behaviorInfo.rot );
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief Ԃ߂
     *
     *	@param Ȃ
     *
     *	@return 
     */
    //-----------------------------------------------------------------------------
    s32 PokemonDrawer::GetTimeLimit( void )
    {
      s32 answer;

      s32 maxTimeLimit = stepInformation[ mCurrentNumOfSet ].maxTimeLimit; // 180
      s32 minTimeLimit = stepInformation[ mCurrentNumOfSet ].minTimeLimit; // 300
      s32 middleTimeLimit = maxTimeLimit + ( ( minTimeLimit - maxTimeLimit ) / 2 ); // 240

      s32 numOfGoToTheNextStep = stepInformation[ mCurrentNumOfSet ].numOfGoToTheNextStep; // 10
      s32 numBecomeTheFastest = stepInformation[ mCurrentNumOfSet ].numBecomeTheFastest; // 3
      s32 middleNumOfSet = ( numOfGoToTheNextStep - numBecomeTheFastest ) / 2; // 3

      if( mTotalNumOfPokemon <= middleNumOfSet )
      {
        s32 num = ( minTimeLimit - middleTimeLimit ) + 1; // 61
        answer = xy_system::GflUse::GetPublicRand( num ) + middleTimeLimit; // 240`300
      }
      else if( middleNumOfSet < mTotalNumOfPokemon &&
               mTotalNumOfPokemon <= ( numOfGoToTheNextStep - numBecomeTheFastest ) )
      {
        s32 num = ( middleTimeLimit - maxTimeLimit ) + 1; // 61
        answer = xy_system::GflUse::GetPublicRand( num ) + maxTimeLimit; // 180`240 
      }
      else
      {
        answer = maxTimeLimit;
      }

      //GFL_PRINT( "set%d, %dhikime, limitTime=%d\n", mCurrentNumOfSet, mTotalNumOfPokemon, answer );

      return answer;
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief |P̋XV
     *
     *	@param	|P̊Ǘԍ
     *
     *	@return Ȃ
     */
    //-----------------------------------------------------------------------------
    void PokemonDrawer::UpdateData( s32 index )
    {
      // ǒ݂̃Aj[VԂ擾
      BalloonData::BalloonIndex targetBalloon = m_data[ index ].behaviorInfo.balloonIndex;
      BalloonData::BalloonAnimeState balloonAnimeState = this->BalloonData()->GetCurrentBalloonAnimeState( targetBalloon );

      gfl::math::VEC3 pos = gfl::math::VEC3( 0.0f, 0.0f, 0.0f );
      gfl::math::VEC3 rot = m_data[ index ].behaviorInfo.rot;
      // ]̐l
      float limitRad = GFL_MATH_DEG_TO_RAD( 10.0f );
      
      switch( balloonAnimeState )
      {
      // oĂ铮
      case BalloonData::BALLOON_ANIME_STATE_OPEN:
        m_data[ index ].model->GetTranslate( &pos );
        pos.y += ( 50.0f / 20 );
        m_data[ index ].model->SetTranslate( pos );
        break;
      // h铮
      case BalloonData::BALLOON_ANIME_STATE_WAIT:
        // JEgAbv
        m_data[ index ].behaviorInfo.counter++;
        // Ԕ
        if( m_data[ index ].behaviorInfo.timeLimit <= m_data[ index ].behaviorInfo.counter )
        {
          m_data[ index ].behaviorInfo.counter = 0;
          this->BalloonData()->SetIsLimitTime( targetBalloon, true ); 
        }

        //m_data[ index ].model->GetRotateXYZ( &rot );
        if( m_data[ index ].behaviorInfo.rotFlag == false )
        {
          rot.z += ( limitRad / 20 );
          if( limitRad <= rot.z )
          {
            m_data[ index ].behaviorInfo.rotFlag = true;
          }
        }
        else
        {
          rot.z -= ( limitRad / 20 );
          if( rot.z <= -limitRad )
          {
            m_data[ index ].behaviorInfo.rotFlag = false;
          }
        }
        m_data[ index ].model->SetRotateXYZ( rot );
        m_data[ index ].behaviorInfo.rot = rot;
        break;
      case BalloonData::BALLOON_ANIME_STATE_ACTION:
          m_data[ index ].behaviorInfo.counter = 0;
        break;
      // ȂȂ铮
      case BalloonData::BALLOON_ANIME_STATE_CLOSE:
        m_data[ index ].model->GetTranslate( &pos );
        pos.y -= ( 50.0f / 20 );
        m_data[ index ].model->SetTranslate( pos );
        break;
      case BalloonData::BALLOON_ANIME_STATE_NUM:
        m_data[ index ].behaviorInfo.isSetup = false;
        m_data[ index ].behaviorInfo.isAppearance = false;
        if( index == mLastPokeIDOfSet )
        {
          mLastPokeIDOfSet = -1;
          mTotalNumOfPokemon = 0;
          // Zbgi
          //if( mCurrentNumOfSet < 3 )
          //{
            mCurrentNumOfSet++;
          //}

          GFL_ASSERT( mCurrentNumOfSet <= 3 );
        }
        if( index == mSameTimePokeID )
        {
          mSameTimePokeID = -1;
        }
        break;
      case BalloonData::BALLOON_ANIME_STATE_NULL:
        break;
      default:
        break;
      }
    }

    //------------------------------------------------------------------------------------
    // ʂ`悷
    //------------------------------------------------------------------------------------
    void PokemonDrawer::Draw( void )
    {
      for( s32 i=0; i<GFL_NELEMS( m_data ); ++i )
      {
        if( m_data[ i ].setup_flag ) {
          gfl::grp::GraphicsSystem* graphics_system = this->GraphicsSystem(); 
#ifdef EDGE_ENABLE
          m_data[ i ].scene->EdgeMapDraw( graphics_system, gfl::grp::DISPLAY_LOWER, m_camera );
#endif
          m_data[ i ].scene->Draw( graphics_system, gfl::grp::DISPLAY_LOWER, m_camera );
#ifdef EDGE_ENABLE
          m_data[ i ].scene->PostEffectDraw( graphics_system, gfl::grp::DISPLAY_LOWER, m_camera );
#endif 
        }
      }
    } 




  } // namespace nuts
} // namespace app
