//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_nuts_NutsOperator.cpp
 *	@brief ؂̎̂Q[̑NX
 *	@author	takada
 *	@date		2011.09.01
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include "app_nuts_CoreData.h"
#include "app_nuts_ViewController.h"
#include "app_nuts_Operator.h"
#include "app_nuts_NutsOperator.h"

namespace app {
  namespace nuts {
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
    
//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    NutsOperator::NutsOperator( 
        const gfl::ui::DeviceManager* uiDeviceManager, 
        app::nuts::CoreData* core, 
        app::nuts::ViewController* viewController ) :
      Operator( uiDeviceManager, core, viewController ),
      mSequence( SEQUENCE_NULL ),
      mOffsetForDraggingNutsPos(),
      mDragFlag( false ),
      mInitialSpeedOfScroll( 0.0f )
    {
      const app::nuts::CoreData* coreData = this->CoreData();
      this->SetInitialSequence();
    } 


    // ŏ̃V[PXݒ肷 
    void NutsOperator::SetInitialSequence()
    {
      this->ChangeSequence( SEQUENCE_NUTS_NORMAL );
    }

    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    NutsOperator::~NutsOperator()
    {
    }

    // V[PXύX
    void NutsOperator::ChangeSequence( Sequence nextSequence )
    {
      switch( nextSequence ) 
      {
      case SEQUENCE_NUTS_NORMAL:
        this->CoreData()->SetScene( CoreData::SCENE_NUTS_TOP );
        break;

      case SEQUENCE_FOR_FINISH:
        break;
      }

      mSequence = nextSequence;
    }

    //------------------------------------------------------------------------------------
    // RAf[^𑀍삷
    //------------------------------------------------------------------------------------
    void NutsOperator::ControlCoreData( void )
    {
      switch( mSequence )
      {
      /* ʏ */
      case SEQUENCE_NUTS_NORMAL:

        // X{^͂ĂIɏI
        if( this->Button()->IsTrigger( gfl::ui::BUTTON_X ) ) {
          this->SetFinishState( FINISH_STATE_RETURN_TO_TOP );
          this->ChangeSequence( SEQUENCE_FOR_FINISH );
        }

        // ؂̎yĂ
        if( this->ViewController()->IsNutsTouch() == false )
        {
          NutsData::NutsIndex targetNutsIndex = this->NutsData()->GetCurrentTouchedNuts();
          // ؂͔̎̈悩OĂ
          this->NutsData()->SetIsNutsInsideOfDecisionRegion( targetNutsIndex, false );
          // ͖؂̎^b`ĂȂ
          this->NutsData()->SetCurrentTouchdNuts( NutsData::NUTS_NULL );          
        }

        if( this->TouchPanel()->IsTouchTrigger() ) {
          if( this->ViewController()->IsNutsTouch() ) {
            NutsData::NutsIndex touched_nuts_index = this->ViewController()->GetTouchedNutsIndex();
            this->NutsData()->SetCurrentTouchdNuts( touched_nuts_index );
          }
          break;
        }
        if( this->TouchPanel()->IsTouch() ) {  // @todo l
          NutsData::NutsIndex touched_nuts_index = this->NutsData()->GetCurrentTouchedNuts();
          if( touched_nuts_index != NutsData::NUTS_NULL )
          {
            this->StartNutsDrag();
            this->ChangeSequence( SEQUENCE_DRAG_NUTS );
          }
          break;
        }

        break;

      /* p[^\ > ؂̎hbO */
      case SEQUENCE_DRAG_NUTS:
        if( this->TouchPanel()->IsTouch() ) {
          //if( this->ViewController()->IsNutsTouch() ) {
          this->UpdateDraggingNutsPosition();

          s32 hitIndex; // ̈̔ԍ 
          NutsData::NutsIndex targetNutsIndex = this->NutsData()->GetCurrentTouchedNuts();
          s32 nutsNum = static_cast<s32>( targetNutsIndex );

          if( this->ViewController()->IsNutsInsideOfDecisionRegion( nutsNum, hitIndex ) )
          {
            this->NutsData()->SetIsNutsInsideOfDecisionRegion( targetNutsIndex, true );
            this->NutsData()->SetNumberOfDecisionRegion( targetNutsIndex, hitIndex );

            this->EndNutsDrag();
            this->ChangeSequence( SEQUENCE_NUTS_NORMAL );
          }
          else
          {
            this->NutsData()->SetIsNutsInsideOfDecisionRegion( targetNutsIndex, false );
          }
          //}
        }
        if( this->TouchPanel()->IsTouchRelease() ) {
          this->EndNutsDrag();
          this->ChangeSequence( SEQUENCE_NUTS_NORMAL );
          break;
        }
        break;
        
      /* I */
      case SEQUENCE_FOR_FINISH:
        //this->FinishOperation();
        break;
      }
    }

    // ؂̎̃hbOJn
    void NutsOperator::StartNutsDrag( void )
    {
      u16 touchX = this->TouchPanel()->GetX();
      u16 touchY = this->TouchPanel()->GetY();
      NutsData::NutsIndex targetNutsIndex = this->NutsData()->GetCurrentTouchedNuts();
      this->CalculateNutsDragOffset( targetNutsIndex, touchX, touchY, &mOffsetForDraggingNutsPos );
      this->NutsData()->LockNutsPositionUpdate( targetNutsIndex );
      //this->NutsData()->SetNutsHold( targetNutsIndex );
    }

    // hbO̖؂̎̍WXV
    void NutsOperator::UpdateDraggingNutsPosition( void )
    {
      u16 touchX = this->TouchPanel()->GetX();
      u16 touchY = this->TouchPanel()->GetY();
      gfl::math::VEC3 touchedPos( touchX, touchY, 0 );
      this->ConvertCoordinateScreenToView( &touchedPos );
      NutsData::NutsIndex targetNutsIndex = this->NutsData()->GetCurrentTouchedNuts();
      gfl::math::VEC3 nutsPos = this->NutsData()->GetNutsPosition( targetNutsIndex );
      nutsPos.x = touchedPos.x + mOffsetForDraggingNutsPos.x;
      nutsPos.y = touchedPos.y + mOffsetForDraggingNutsPos.y;
      this->NutsData()->SetNutsPosition( targetNutsIndex, nutsPos ); 
    }

    // ؂̎̃hbOI
    void NutsOperator::EndNutsDrag( void )
    {
      NutsData::NutsIndex targetNutsIndex = this->NutsData()->GetCurrentTouchedNuts();
      if( this->NutsData()->GetIsNutsInsideOfDecisionRegion( targetNutsIndex ) )
      {
        this->NutsData()->SetNutsBasePosition( targetNutsIndex );
      }
      else
      {
        this->NutsData()->UnlockNutsPostionUpdate( targetNutsIndex );
      }
      //this->NutsData()->SetNutsRelease( targetNutsIndex );
    }

     // hbOɉZItZbgW( r[Wn )vZ
    void NutsOperator::CalculateNutsDragOffset( NutsData::NutsIndex nutsIndex, u16 touchX, u16 touchY, gfl::math::VEC3* offset )
    {
      gfl::math::VEC3 touchedPos( touchX, touchY, 0 );
      this->ConvertCoordinateScreenToView( &touchedPos );
      const gfl::math::VEC3& nutsPos = this->NutsData()->GetNutsPosition( nutsIndex );
      *offset = nutsPos - touchedPos;
    }

    // Wnϊ( XN[Wn ==> r[Wn )
    void NutsOperator::ConvertCoordinateScreenToView( gfl::math::VEC3* screenPos )
    {
      screenPos->x = screenPos->x - 160;
      screenPos->y = 120 - screenPos->y;
    }

#if 0
    NutsOperator::ScrollState NutsOperator::UpdateDragState()
    {
      if( this->TouchPanel()->IsTouch() ) {
        if( this->IsDragging() ) {
          this->UpdateScrollByDrag();
          return SCROLL_STATE_DRAGGING;
        }
      }
      else if( this->TouchPanel()->IsTouchRelease() ) {
        if( this->IsDragging() ) {
          this->EndDrag();
          return ( this->StartScrollByDragRelease() );
        }
      }
      else GFL_ASSERT(0);

      // S[NNA
      // ԂNA

      return SCROLL_STATE_NONE;
    }
#endif

    // hbOJn
    void NutsOperator::StartDrag( void )
    {
      mDragFlag = true;
      mInitialSpeedOfScroll = 0.0f;
      this->CoreData()->StopScroll();
      this->CoreData()->LockScroll();
    }


    // hbOI
    void NutsOperator::EndDrag( void )
    {
      mDragFlag = false;
      this->CoreData()->UnlockScroll();
    }


    // hbOǂ𒲂ׂ
    bool NutsOperator::IsDragging( void ) const
    {
      return mDragFlag;
    }

#if 0
    // hbOɂAXN[lXV
    void NutsOperator::UpdateScrollByDrag( void )
    {
      gfl::math::VEC3 touchMovedVec;
      this->TouchPanel()->GetMoveXY( &touchMovedVec );
      f32 oldScrollValue = this->CoreData()->GetScrollValue();
      f32 newScrollValue = oldScrollValue - touchMovedVec.y;  // r[Wnyt]
      
      f32 differentScrollValue = newScrollValue - oldScrollValue;
      if( differentScrollValue != 0 )
        mInitialSpeedOfScroll = differentScrollValue;
    }


    // hbO[XɂXN[Jn
    NutsOperator::ScrollState NutsOperator::StartScrollByDragRelease( void )
    {
      // x̐Βl擾
      f32 absSpeed = gfl::math::FAbs( mInitialSpeedOfScroll );

      // 悭
      if( 5.0f < absSpeed )
      {
        // XN[x𓪑ł
        mInitialSpeedOfScroll = ( 0 < mDir ) ? ( 5.0f ) : ( -5.0f );
        this->CoreData()->StartScroll( mInitialSpeedOfScroll, 30 );

        return SCROLL_STATE_RELEASE_WITH_MOMENTUM;
      }
      // 藣
      else
      {
        // ␳ړ
        f32 bindScrollValue = this->ViewController()->CalculateScrollValueAtDivisibleByAtomicValue( 30, mDir );
        this->CoreData()->StartBindScroll( bindScrollValue, 5 );
        //this->CoreData()->SetScrollValue( bindScrollValue );

        return SCROLL_STATE_RELEASE;        
      }
    }
#endif
  } // namespace nuts
} // namespace app
