//========================================================================================
/**
 * @file app_nuts_NutsData.h
 * @brief ؂̎̂Q[̖؂̎f[^
 * @author takada
 * @date 2011.09.06
 */
//========================================================================================
#ifndef __NUTS_NUTS_DATA_H__
#define __NUTS_NUTS_DATA_H__
#include <gflib.h>
#include <pmlib.h>
#include <app/tool/app_tool_AlignmentManager.h>


namespace app {
  namespace nuts {


    class NutsData
    {
      GFL_FORBID_COPY_AND_ASSIGN( NutsData );

      public:

      static const s32 NOT_INSIDE_INDEX = 1000000;      

      //--------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param heap  CX^X̐Ɏgpq[v
       */
      //--------------------------------------------------------------------------------
      NutsData( gfl::heap::HeapBase* heap );

      //--------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //--------------------------------------------------------------------------------
      virtual ~NutsData(); 

      //--------------------------------------------------------------------------------
      /**
       * @brief f[^XV
       */
      //--------------------------------------------------------------------------------
      void UpdateData( void ); 

      //--------------------------------------------------------------------------------
      // ؂̎̃CfbNX
      //--------------------------------------------------------------------------------
      enum NutsIndex {
        NUTS_ONE,
        NUTS_TWO,
        NUTS_THREE,
        NUTS_FOUR,
        NUTS_FIVE,
        NUTS_SIX,
        NUTS_SEVEN,
        NUTS_EIGHT,
        NUTS_NINE,
        NUTS_TEN,

        NUTS_NUM,          // 
        NUTS_NULL,         // l
      };

      enum Level {
        LEVEL_EASY,
        LEVEL_NORMAL,
        LEVEL_HARD,
        LEVEL_INFINITE,

        LEVEL_NUM,
      };

      // x
      struct LevelInformation {
        s32 numberOfNuts;
        gfl::math::VEC3 basePositionOfNuts[ NUTS_NUM ]; 
      };
      static const LevelInformation levelInformation[ LEVEL_NUM ];

      //--------------------------------------------------------------------------------
      // ؂̎̏
      //--------------------------------------------------------------------------------
      struct NutsDescription {
        u32 color;  // F
      };
      const NutsDescription& GetNutsDescription( NutsIndex nutsIndex ) const;      // ؂̎̏擾
      void SetNutsDescription( NutsIndex nutsIndex, const NutsDescription& data ); // ؂̎̏ݒ肷


      //--------------------------------------------------------------------------------
      // ؂̎̕я
      //-------------------------------------------------------------------------------- 
      u8 GetNutsOrder( NutsIndex nuts_index ) const;                          // ؂̎̕я擾
      NutsIndex GetNutsIndexByOrder( u8 nuts_order ) const;                   // w肵яʂ؂̎ԍ擾
      void ChangeNutsOrder( NutsIndex target_index, NutsIndex aim_index );    // ؂̎̕яύX
      void ExchangeNutsOrder( NutsIndex waza_index1, NutsIndex waza_index2 ); // ؂̎̕яւ
      void ResetNutsOrderAndPositions( void );                                  // ؂̎̕яEWZbg


      //--------------------------------------------------------------------------------
      // ؂̎̍W
      //-------------------------------------------------------------------------------- 
      //void SetNutsBasePosition( NutsIndex nuts_index, const gfl::math::VEC3& base_pos ); // ؂̎̒ʒuݒ肷
      void SetNutsBasePosition( NutsIndex nuts_index ); // ؂̎̍Wʒuɐݒ肷
      const gfl::math::VEC3& GetNutsPosition( NutsIndex nuts_index ) const;              // ؂̎̍W擾
      void SetNutsPosition( NutsIndex nuts_index, const gfl::math::VEC3& nuts_pos );    // ؂̎̍Wݒ肷
      void LockNutsPositionUpdate( NutsIndex nuts_index );                               // ؂̎̍W̎XV~
      void UnlockNutsPostionUpdate( NutsIndex nuts_index );                              // ؂̎̍W̎XVĊJ


      //--------------------------------------------------------------------------------
      // ؂̎̃z[h
      //--------------------------------------------------------------------------------
      bool IsNutsHold( NutsIndex nuts_index ) const; // ؂̎z[hԂǂ擾
      void SetNutsHold( NutsIndex nuts_index );      // ؂̎z[hԂɂ
      void SetNutsRelease( NutsIndex nuts_index );   // ؂̎̃z[hԂ

      //--------------------------------------------------------------------------------
      // ̈Ƃ̓
      //--------------------------------------------------------------------------------
      void SetIsNutsInsideOfDecisionRegion( NutsIndex nutsIndex, bool isHit );
      bool GetIsNutsInsideOfDecisionRegion( NutsIndex nutsIndex ) const;
      void SetNumberOfDecisionRegion( NutsIndex nutsIndex, s32 hitIndex );
      s32 GetNumberOfDecisionRegion( NutsIndex nutsIndex ) const;

      //--------------------------------------------------------------------------------
      // x
      //--------------------------------------------------------------------------------
      s32 GetLevel( void ) const;

      //--------------------------------------------------------------------------------
      // ^b`Ă؂̎
      //--------------------------------------------------------------------------------
      void SetCurrentTouchdNuts( NutsIndex nutsIndex );
      NutsIndex GetCurrentTouchedNuts( void ) const;

      private:

      NutsDescription m_nuts_descriptions[ NUTS_NUM ];       // ؂̎̏
      app::tool::AlignmentManager* m_nuts_alignment_manager; // ؂̎̍WǗIuWFNg
      gfl::math::VEC3 m_nuts_positions[ NUTS_NUM ];          // ؂̎̍W
      gfl::math::VEC3 m_nuts_base_positions[ NUTS_NUM ];     // ؂̎̊_W
      bool m_nuts_hold_flag[ NUTS_NUM ];                     // ؂̎z[hԂǂ
      bool mNutsAutoUpdate[ NUTS_NUM ];                      // ؂̎ǂ

      bool mIsNutsInsideOfDecisionRegion[ NUTS_NUM ];        // ؂̎̈̓ɂ邩ǂ
      s32 mNumberOfDecisionRegion[ NUTS_NUM ];               // ؂̎Ԗڂ̔̈̓ɂ邩

      s32 mLevel;                                            // x

      NutsIndex mCurrentTouchedNuts;                         // ^b`Ă؂̎

      /**
       * @brief ؂̎̐ړ֐
       * @param current_frame  ݂̃t[
       * @param max_frame      ŏIt[
       * @return ݂̃t[ɂ, ړ̐isx
       * @retval [0, 1]
       */
      static f32 NutsAlignMoveFunc( u32 current_frame, u32 max_frame ); 


      // ؂̎
      void InitializeNuts( void );

      // ؂̎̐}l[W𐶐
      void CreateNutsAlignmentManager( gfl::heap::HeapBase* heap );

      // ؂̎̐}l[Wj
      void DeleteNutsAlignmentManager( void );

      // ؂̎XV
      void AutoUpdateNutsPosition( void );
    };


  } // namespace nuts
} // namespace app


#endif // __NUTS_NUTS_DATA_H__
