//========================================================================================
/**
 * @file app_nuts_NutsData.cpp
 * @brief ؂̎̂Q[̖؂̎f[^
 * @author takada
 * @date 2011.09.06
 */
//========================================================================================
#include <gflib.h>
#include <pmlib.h>
#include "app_nuts_NutsData.h"


namespace app {
  namespace nuts {

    const NutsData::LevelInformation NutsData::levelInformation[ NutsData::LEVEL_NUM ] = 
    {
      /* x */
        {
          3,
          {
            gfl::math::VEC3( -80.0f, 80.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 80.0f, 0.0f ),
            gfl::math::VEC3( 80.0f, 80.0f, 0.0f ),
          },
        },
        
        {
          5,
          {
            gfl::math::VEC3( -80.0f, 65.0f, 0.0f ),
            gfl::math::VEC3( -40.0f, 95.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 65.0f, 0.0f ),
            gfl::math::VEC3( 40.0f, 95.0f, 0.0f ),
            gfl::math::VEC3( 80.0f, 65.0f, 0.0f ),
          },
        },

        {
          7,
          {
            gfl::math::VEC3( -120.0f, 95.0f, 0.0f ),
            gfl::math::VEC3( -80.0f, 65.0f, 0.0f ),
            gfl::math::VEC3( -40.0f, 95.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 65.0f, 0.0f ),
            gfl::math::VEC3( 40.0f, 95.0f, 0.0f ),
            gfl::math::VEC3( 80.0f, 65.0f, 0.0f ),
            gfl::math::VEC3( 120.0f, 95.0f, 0.0f ),
          },
        },

        {
          10,
          {
            gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),
            gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),
          },
        },
    };

    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    NutsData::NutsData( gfl::heap::HeapBase* heap ) :
      m_nuts_descriptions(),
      m_nuts_alignment_manager( NULL ),      
      m_nuts_positions(),
      m_nuts_base_positions(),
      m_nuts_hold_flag(),
      mIsNutsInsideOfDecisionRegion(),
      mNumberOfDecisionRegion(),
      mLevel( LEVEL_NORMAL ),
      mCurrentTouchedNuts( NUTS_NULL )
    {
      this->InitializeNuts();
      this->CreateNutsAlignmentManager( heap );
    
    }


    // ؂̎
    void NutsData::InitializeNuts( void )
    {
      for( u32 i=0; i<NUTS_NUM; i++ ) {
        NutsIndex nutsIndex = static_cast<NutsIndex>( i );

        m_nuts_descriptions[i].color = 0;
        m_nuts_hold_flag[i] = false;

        mIsNutsInsideOfDecisionRegion[ i ] = false;
        mNumberOfDecisionRegion[ i ] = NOT_INSIDE_INDEX;

        if( i < levelInformation[ mLevel ].numberOfNuts )
        {
          m_nuts_positions[ nutsIndex ].x = levelInformation[ mLevel ].basePositionOfNuts[ nutsIndex ].x;
          m_nuts_positions[ nutsIndex ].y = levelInformation[ mLevel ].basePositionOfNuts[ nutsIndex ].y;
        }
      }
    } 

    // ؂̎̐}l[W𐶐
    void NutsData::CreateNutsAlignmentManager( gfl::heap::HeapBase* heap )
    {
      GFL_ASSERT( m_nuts_alignment_manager == NULL );
      app::tool::AlignmentManager::Settings setting;
      setting.move_frame = 10;
      setting.pos_count = NUTS_NUM;
      setting.base_position = m_nuts_base_positions;
      setting.control_position = m_nuts_positions;
      setting.move_func = app::nuts::NutsData::NutsAlignMoveFunc;
      m_nuts_alignment_manager = GFL_NEW( heap ) app::tool::AlignmentManager( heap, setting );
    } 

    // ؂̎̐ړ֐
    f32 NutsData::NutsAlignMoveFunc( u32 current_frame, u32 max_frame )
    {
      // @todo CT
      return static_cast<f32>( current_frame ) / static_cast<f32>( max_frame );
    } 







    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    NutsData::~NutsData()
    {
      this->DeleteNutsAlignmentManager();
    } 

    // ؂̎̐}l[Wj
    void NutsData::DeleteNutsAlignmentManager( void )
    {
      GFL_ASSERT( m_nuts_alignment_manager );
      GFL_DELETE m_nuts_alignment_manager;
    }







    //------------------------------------------------------------------------------------
    // f[^XV
    //------------------------------------------------------------------------------------
    void NutsData::UpdateData( void )
    {
      //m_nuts_alignment_manager->UpdatePositions();  // ؂̎̍WXV
      this->AutoUpdateNutsPosition();
    }







    //--------------------------------------------------------------------------------
    // ؂̎̏擾
    //--------------------------------------------------------------------------------
    const NutsData::NutsDescription& NutsData::GetNutsDescription( NutsIndex nutsIndex ) const
    {
      GFL_ASSERT( nutsIndex < NUTS_NUM );
      return m_nuts_descriptions[ nutsIndex ];
    }

    //--------------------------------------------------------------------------------
    // ؂̎̏ݒ肷
    //--------------------------------------------------------------------------------
    void NutsData::SetNutsDescription( NutsIndex nutsIndex, const NutsDescription& data )
    {
      GFL_ASSERT( nutsIndex < NUTS_NUM );
      if( nutsIndex < NUTS_NUM ) {
        m_nuts_descriptions[ nutsIndex ] = data;
      }
    }






    //------------------------------------------------------------------------------------
    // ؂̎̕я擾
    //------------------------------------------------------------------------------------
    u8 NutsData::GetNutsOrder( NutsIndex nuts_index ) const
    {
      return m_nuts_alignment_manager->GetOrder( nuts_index );
    }


    //------------------------------------------------------------------------------------
    // w肵яɂ؂̎̃CfbNX擾
    //------------------------------------------------------------------------------------
    NutsData::NutsIndex NutsData::GetNutsIndexByOrder( u8 nuts_order ) const
    {
      s32 nuts_index = m_nuts_alignment_manager->GetActorIndexByOrder( nuts_order );
      return static_cast<NutsIndex>( nuts_index );
    }


    //------------------------------------------------------------------------------------
    // ؂̎̕яύX
    //------------------------------------------------------------------------------------
    void NutsData::ChangeNutsOrder( NutsIndex target_index, NutsIndex aim_index )
    {
      GFL_ASSERT( target_index < NUTS_NUM );
      GFL_ASSERT( aim_index < NUTS_NUM ); 
      u8 target_order = this->GetNutsOrder( target_index );
      u8 aim_order = this->GetNutsOrder( aim_index );
      m_nuts_alignment_manager->ChangeOrder( target_order, aim_order );
    }


    //------------------------------------------------------------------------------------
    // ؂̎̕яւ
    //------------------------------------------------------------------------------------
    void NutsData::ExchangeNutsOrder( NutsIndex waza_index1, NutsIndex waza_index2 )
    {
      GFL_ASSERT( waza_index1 < NUTS_NUM );
      GFL_ASSERT( waza_index2 < NUTS_NUM ); 
      u8 waza_order1 = this->GetNutsOrder( waza_index1 );
      u8 waza_order2 = this->GetNutsOrder( waza_index2 );
      m_nuts_alignment_manager->ExchangeOrder( waza_order1, waza_order2 );
    }






    //------------------------------------------------------------------------------------
    // ؂̎̕яEWZbg
    //------------------------------------------------------------------------------------
    void NutsData::ResetNutsOrderAndPositions( void )
    {
      this->m_nuts_alignment_manager->ResetOrderAndPositions();
    }




/*
    //--------------------------------------------------------------------------------
    // ؂̎̒ʒuݒ肷
    //--------------------------------------------------------------------------------
    void NutsData::SetNutsBasePosition( NutsIndex nuts_index, const gfl::math::VEC3& base_pos )
    {
      GFL_ASSERT( nuts_index < NUTS_NUM );
      m_nuts_base_positions[ nuts_index ] = base_pos;
    }
*/

    //------------------------------------------------------------------------------------
    // ؂̎̍Wʒuɐݒ肷
    //------------------------------------------------------------------------------------
    void NutsData::SetNutsBasePosition( NutsIndex nutsIndex )
    {
      if( nutsIndex < NUTS_NUM ) {      
        m_nuts_positions[ nutsIndex ].x = levelInformation[ mLevel ].basePositionOfNuts[ nutsIndex ].x;
        m_nuts_positions[ nutsIndex ].y = levelInformation[ mLevel ].basePositionOfNuts[ nutsIndex ].y;
      }
    }

    //------------------------------------------------------------------------------------
    // ؂̎̍W擾
    //------------------------------------------------------------------------------------
    const gfl::math::VEC3& NutsData::GetNutsPosition( NutsIndex nuts_index ) const
    {
      GFL_ASSERT( nuts_index < NUTS_NUM );
      return m_nuts_positions[ nuts_index ];
    } 

    //------------------------------------------------------------------------------------
    // ؂̎̍Wݒ肷
    //------------------------------------------------------------------------------------
    void NutsData::SetNutsPosition( NutsIndex nuts_index, const gfl::math::VEC3& nuts_pos )
    {
      if( nuts_index < NUTS_NUM ) {      
        m_nuts_positions[ nuts_index ] = nuts_pos;
      }
    }

    //------------------------------------------------------------------------------------
    // ؂̎W̎XV~
    //------------------------------------------------------------------------------------
    void NutsData::LockNutsPositionUpdate( NutsIndex nuts_index )
    {
      GFL_ASSERT( nuts_index < NUTS_NUM );
      mNutsAutoUpdate[ nuts_index ] = false;
      //u8 nuts_order = this->GetNutsOrder( nuts_index );
      //m_nuts_alignment_manager->LockPositionUpdate( nuts_order );
    }

    //------------------------------------------------------------------------------------
    // ؂̎W̎XVĊJ
    //------------------------------------------------------------------------------------
    void NutsData::UnlockNutsPostionUpdate( NutsIndex nuts_index )
    {
      GFL_ASSERT( nuts_index < NUTS_NUM );
      mNutsAutoUpdate[ nuts_index ] = true;
      //u8 nuts_order = this->GetNutsOrder( nuts_index );
      //m_nuts_alignment_manager->UnlockPositionUpdate( nuts_order );
    }

    void NutsData::AutoUpdateNutsPosition( void )
    {
      for( s32 i=0; i<NUTS_NUM; ++i )
      {
        NutsIndex nuts_index = static_cast<NutsIndex>( i );

        if( mNutsAutoUpdate[ nuts_index ] == true )
        {
          gfl::math::VEC3 nutsPos = m_nuts_positions[ nuts_index ];
          nutsPos.y -= ( 240 / 20);
          m_nuts_positions[ nuts_index ] = nutsPos;

          if( nutsPos.y < -120 )
          {
            mNutsAutoUpdate[ nuts_index ] = false;
            this->SetNutsBasePosition( nuts_index );
          }
        }
      }
    }



    //------------------------------------------------------------------------------------
    // ؂̎z[hԂǂ擾
    //------------------------------------------------------------------------------------
    bool NutsData::IsNutsHold( NutsIndex nuts_index ) const
    {
      GFL_ASSERT( nuts_index < NUTS_NUM );
      if( nuts_index < NUTS_NUM ) {
        return m_nuts_hold_flag[ nuts_index ];
      }
      return false;
    }

    //------------------------------------------------------------------------------------
    // ؂̎z[hԂɂ
    //------------------------------------------------------------------------------------
    void NutsData::SetNutsHold( NutsIndex nuts_index )
    {
      GFL_ASSERT( nuts_index < NUTS_NUM );
      if( nuts_index < NUTS_NUM ) {
        m_nuts_hold_flag[ nuts_index ] = true;
      }
    }

    //------------------------------------------------------------------------------------
    // ؂̎̃z[hԂ
    //------------------------------------------------------------------------------------
    void NutsData::SetNutsRelease( NutsIndex nuts_index )
    {
      GFL_ASSERT( nuts_index < NUTS_NUM );
      if( nuts_index < NUTS_NUM ) {
        m_nuts_hold_flag[ nuts_index ] = false;
      }
    }

    //--------------------------------------------------------------------------------
    // ̈Ƃ̓
    //--------------------------------------------------------------------------------
    void NutsData::SetIsNutsInsideOfDecisionRegion( NutsIndex nutsIndex, bool isHit )
    {
      if( nutsIndex < NUTS_NUM ) {
        mIsNutsInsideOfDecisionRegion[ nutsIndex ] = isHit;
        if( isHit == false )
        {
          this->SetNumberOfDecisionRegion( nutsIndex, NOT_INSIDE_INDEX );
        }
      }
    }

    bool NutsData::GetIsNutsInsideOfDecisionRegion( NutsIndex nutsIndex ) const
    {
      GFL_ASSERT( nutsIndex < NUTS_NUM );
      return mIsNutsInsideOfDecisionRegion[ nutsIndex ];
    }

    void NutsData::SetNumberOfDecisionRegion( NutsIndex nutsIndex, s32 hitIndex )
    {
      if( nutsIndex < NUTS_NUM ) {
        mNumberOfDecisionRegion[ nutsIndex ] = hitIndex;
      }
    }

    s32 NutsData::GetNumberOfDecisionRegion( NutsIndex nutsIndex ) const
    {
      GFL_ASSERT( nutsIndex < NUTS_NUM );
      return mNumberOfDecisionRegion[ nutsIndex ];
    }

    //--------------------------------------------------------------------------------
    // x
    //--------------------------------------------------------------------------------
    s32 NutsData::GetLevel( void ) const
    {
      return mLevel;
    }

    //--------------------------------------------------------------------------------
    // ^b`Ă؂̎
    //--------------------------------------------------------------------------------
    void NutsData::SetCurrentTouchdNuts( NutsIndex nutsIndex )
    {
      //GFL_ASSERT( nutsIndex < NUTS_NUM );
      //if( nutsIndex < NUTS_NUM ) {
        mCurrentTouchedNuts = nutsIndex;
      //}
    }

    NutsData::NutsIndex NutsData::GetCurrentTouchedNuts( void ) const
    {
      return mCurrentTouchedNuts;
    }


  } // namespace nuts
} // namespace app
