//========================================================================================
/**
 * @file app_nuts_LowerLayoutInformation.h
 * @brief ؂̎̂Q[̉ʂ̃CAEg
 * @author takada
 * @date 2011.09.01
 */
//========================================================================================
#ifndef __APP_NUTS_LOWERLAYOUTINFORMATION_H__
#define __APP_NUTS_LOWERLAYOUTINFORMATION_H__

#include <gflib.h>
#include <pmlib.h>
#include "app_nuts_CoreData.h"
#include "kgame_lower.h"
#include "kgame_lower_pane.h"

#include "app_nuts_CommonSettings.h"

namespace app {
  namespace nuts { 


    class LowerLayout 
    { 
      public:
      // Aj[Vf[^
      enum AnimationData {
        // ӂAj
        //----------
        ANIMATION_DATA_BALLOON00_CLOSE,
        ANIMATION_DATA_BALLOON00_MISTAKE,
        ANIMATION_DATA_BALLOON00_OPEN,
        ANIMATION_DATA_BALLOON00_RIGHT01,
        ANIMATION_DATA_BALLOON00_RIGHT02,
        ANIMATION_DATA_BALLOON00_WAIT,
        //----------
        ANIMATION_DATA_BALLOON01_CLOSE,
        ANIMATION_DATA_BALLOON01_MISTAKE,
        ANIMATION_DATA_BALLOON01_OPEN,
        ANIMATION_DATA_BALLOON01_RIGHT01,
        ANIMATION_DATA_BALLOON01_RIGHT02,
        ANIMATION_DATA_BALLOON01_WAIT,
        //----------
        ANIMATION_DATA_BALLOON02_CLOSE,
        ANIMATION_DATA_BALLOON02_MISTAKE,
        ANIMATION_DATA_BALLOON02_OPEN,
        ANIMATION_DATA_BALLOON02_RIGHT01,
        ANIMATION_DATA_BALLOON02_RIGHT02,
        ANIMATION_DATA_BALLOON02_WAIT,
        //----------
        ANIMATION_DATA_BALLOON03_CLOSE,
        ANIMATION_DATA_BALLOON03_MISTAKE,
        ANIMATION_DATA_BALLOON03_OPEN,
        ANIMATION_DATA_BALLOON03_RIGHT01,
        ANIMATION_DATA_BALLOON03_RIGHT02,
        ANIMATION_DATA_BALLOON03_WAIT,
        //----------
        ANIMATION_DATA_BALLOON04_CLOSE,
        ANIMATION_DATA_BALLOON04_MISTAKE,
        ANIMATION_DATA_BALLOON04_OPEN,
        ANIMATION_DATA_BALLOON04_RIGHT01,
        ANIMATION_DATA_BALLOON04_RIGHT02,
        ANIMATION_DATA_BALLOON04_WAIT,
        //----------
        ANIMATION_DATA_BALLOON05_CLOSE,
        ANIMATION_DATA_BALLOON05_MISTAKE,
        ANIMATION_DATA_BALLOON05_OPEN,
        ANIMATION_DATA_BALLOON05_RIGHT01,
        ANIMATION_DATA_BALLOON05_RIGHT02,
        ANIMATION_DATA_BALLOON05_WAIT,
        //----------
        ANIMATION_DATA_BALLOON06_CLOSE,
        ANIMATION_DATA_BALLOON06_MISTAKE,
        ANIMATION_DATA_BALLOON06_OPEN,
        ANIMATION_DATA_BALLOON06_RIGHT01,
        ANIMATION_DATA_BALLOON06_RIGHT02,
        ANIMATION_DATA_BALLOON06_WAIT,
        //----------
        ANIMATION_DATA_BALLOON07_CLOSE,
        ANIMATION_DATA_BALLOON07_MISTAKE,
        ANIMATION_DATA_BALLOON07_OPEN,
        ANIMATION_DATA_BALLOON07_RIGHT01,
        ANIMATION_DATA_BALLOON07_RIGHT02,
        ANIMATION_DATA_BALLOON07_WAIT,
        //----------
        ANIMATION_DATA_BALLOON08_CLOSE,
        ANIMATION_DATA_BALLOON08_MISTAKE,
        ANIMATION_DATA_BALLOON08_OPEN,
        ANIMATION_DATA_BALLOON08_RIGHT01,
        ANIMATION_DATA_BALLOON08_RIGHT02,
        ANIMATION_DATA_BALLOON08_WAIT,
        //----------
        ANIMATION_DATA_BALLOON09_CLOSE,
        ANIMATION_DATA_BALLOON09_MISTAKE,
        ANIMATION_DATA_BALLOON09_OPEN,
        ANIMATION_DATA_BALLOON09_RIGHT01,
        ANIMATION_DATA_BALLOON09_RIGHT02,
        ANIMATION_DATA_BALLOON09_WAIT,

        // ؂̎Aj
        ANIMATION_DATA_KINOMI00_CATCH1,
        ANIMATION_DATA_KINOMI00_CATCH2,

        ANIMATION_DATA_NUM,

        ANIMATION_DATA_NULL,
      };

      // Aj[Vԍ
      enum AnimationIndex {
        // ӂAj
        //----------
        ANIMATION_INDEX_BALLOON00_CLOSE,
        ANIMATION_INDEX_BALLOON00_MISTAKE,
        ANIMATION_INDEX_BALLOON00_OPEN,
        ANIMATION_INDEX_BALLOON00_RIGHT01,
        ANIMATION_INDEX_BALLOON00_RIGHT02,
        ANIMATION_INDEX_BALLOON00_WAIT,
        //----------
        ANIMATION_INDEX_BALLOON01_CLOSE,
        ANIMATION_INDEX_BALLOON01_MISTAKE,
        ANIMATION_INDEX_BALLOON01_OPEN,
        ANIMATION_INDEX_BALLOON01_RIGHT01,
        ANIMATION_INDEX_BALLOON01_RIGHT02,
        ANIMATION_INDEX_BALLOON01_WAIT,
        //----------
        ANIMATION_INDEX_BALLOON02_CLOSE,
        ANIMATION_INDEX_BALLOON02_MISTAKE,
        ANIMATION_INDEX_BALLOON02_OPEN,
        ANIMATION_INDEX_BALLOON02_RIGHT01,
        ANIMATION_INDEX_BALLOON02_RIGHT02,
        ANIMATION_INDEX_BALLOON02_WAIT,
        //----------
        ANIMATION_INDEX_BALLOON03_CLOSE,
        ANIMATION_INDEX_BALLOON03_MISTAKE,
        ANIMATION_INDEX_BALLOON03_OPEN,
        ANIMATION_INDEX_BALLOON03_RIGHT01,
        ANIMATION_INDEX_BALLOON03_RIGHT02,
        ANIMATION_INDEX_BALLOON03_WAIT,
        //----------
        ANIMATION_INDEX_BALLOON04_CLOSE,
        ANIMATION_INDEX_BALLOON04_MISTAKE,
        ANIMATION_INDEX_BALLOON04_OPEN,
        ANIMATION_INDEX_BALLOON04_RIGHT01,
        ANIMATION_INDEX_BALLOON04_RIGHT02,
        ANIMATION_INDEX_BALLOON04_WAIT,
        //----------
        ANIMATION_INDEX_BALLOON05_CLOSE,
        ANIMATION_INDEX_BALLOON05_MISTAKE,
        ANIMATION_INDEX_BALLOON05_OPEN,
        ANIMATION_INDEX_BALLOON05_RIGHT01,
        ANIMATION_INDEX_BALLOON05_RIGHT02,
        ANIMATION_INDEX_BALLOON05_WAIT,
        //----------
        ANIMATION_INDEX_BALLOON06_CLOSE,
        ANIMATION_INDEX_BALLOON06_MISTAKE,
        ANIMATION_INDEX_BALLOON06_OPEN,
        ANIMATION_INDEX_BALLOON06_RIGHT01,
        ANIMATION_INDEX_BALLOON06_RIGHT02,
        ANIMATION_INDEX_BALLOON06_WAIT,
        //----------
        ANIMATION_INDEX_BALLOON07_CLOSE,
        ANIMATION_INDEX_BALLOON07_MISTAKE,
        ANIMATION_INDEX_BALLOON07_OPEN,
        ANIMATION_INDEX_BALLOON07_RIGHT01,
        ANIMATION_INDEX_BALLOON07_RIGHT02,
        ANIMATION_INDEX_BALLOON07_WAIT,
        //----------
        ANIMATION_INDEX_BALLOON08_CLOSE,
        ANIMATION_INDEX_BALLOON08_MISTAKE,
        ANIMATION_INDEX_BALLOON08_OPEN,
        ANIMATION_INDEX_BALLOON08_RIGHT01,
        ANIMATION_INDEX_BALLOON08_RIGHT02,
        ANIMATION_INDEX_BALLOON08_WAIT,
        //----------
        ANIMATION_INDEX_BALLOON09_CLOSE,
        ANIMATION_INDEX_BALLOON09_MISTAKE,
        ANIMATION_INDEX_BALLOON09_OPEN,
        ANIMATION_INDEX_BALLOON09_RIGHT01,
        ANIMATION_INDEX_BALLOON09_RIGHT02,
        ANIMATION_INDEX_BALLOON09_WAIT,

        // ؂̎Aj
        ANIMATION_INDEX_KINOMI00_CATCH01,
        ANIMATION_INDEX_KINOMI00_CATCH02,

        /*
        // ؂̎LAj
        ANIMATION_DATA_KINOMI02_CATCH1,
        ANIMATION_DATA_KINOMI03_CATCH1,
        ANIMATION_DATA_KINOMI04_CATCH1,
        ANIMATION_DATA_KINOMI05_CATCH1,
        ANIMATION_DATA_KINOMI06_CATCH1,
        ANIMATION_DATA_KINOMI07_CATCH1,
        ANIMATION_DATA_KINOMI08_CATCH1,
        ANIMATION_DATA_KINOMI09_CATCH1,
        ANIMATION_DATA_KINOMI02_CATCH2,
        ANIMATION_DATA_KINOMI03_CATCH2,
        ANIMATION_DATA_KINOMI04_CATCH2,
        ANIMATION_DATA_KINOMI05_CATCH2,
        ANIMATION_DATA_KINOMI06_CATCH2,
        ANIMATION_DATA_KINOMI07_CATCH2,
        ANIMATION_DATA_KINOMI08_CATCH2,
        ANIMATION_DATA_KINOMI09_CATCH2,
        */

        ANIMATION_INDEX_NUM,
        
        ANIMATION_INDEX_NULL,
      };

      static const u32 MAXIMUM_NUMBER_OF_BALLOON = 10;
      static const u32 MAXIMUM_NUMBER_OF_SIMULTANEOUS_BALLOON_LEAVES = 3;

      // o
      struct BalloonInformation {
        gfl::grp::g2d::LytPaneIndex paneIndexOfRoot;    // [g        
        gfl::grp::g2d::LytPaneIndex paneIndexOfBalloon; // oyC
        gfl::grp::g2d::LytPaneIndex paneIndexOfNote;    // m[gyC
        gfl::grp::g2d::LytPaneIndex paneIndexOfNuts;    // ؂̎
        gfl::grp::g2d::LytPaneIndex paneIndexOfStar01;  // 1ԐyC
        gfl::grp::g2d::LytPaneIndex paneIndexOfStar02;  // 2ԐyC
        gfl::grp::g2d::LytPaneIndex paneIndexOfStar03;  // 3ԐyC
        AnimationIndex animationIndexWhenClose;   // ݃Aj[V
        AnimationIndex animationIndexWhenMistake; // sAj[V
        AnimationIndex animationIndexWhenOpen;    // oAj[V
        AnimationIndex animationIndexWhenRight01; // Aj[V01
        AnimationIndex animationIndexWhenRight02; // Aj[V02
        AnimationIndex animationIndexWhenWait;    // ҋ@Aj[V
        gfl::grp::g2d::LytPaneIndex groupIndexOfBalloon;  // O[v
      };

      enum Nuts {
        NUTS_ONE,
        NUTS_TWO,
        NUTS_THREE,
        NUTS_FOUR,
        NUTS_FIVE,
        NUTS_SIX,
        NUTS_SEVEN,
        NUTS_EIGHT,
        NUTS_NINE,
        NUTS_TEN,

        NUTS_NUM,
      };

      // CAEg
      struct Information {
        gfl::grp::g2d::LytArcIndex layoutDataId;  // CAEgf[^̃CAEg\[XID
        // ӂ
        BalloonInformation balloonInfo[ MAXIMUM_NUMBER_OF_BALLOON ];
        gfl::grp::g2d::LytPaneIndex paneIndexOfBalloonBasePosition[ MAXIMUM_NUMBER_OF_SIMULTANEOUS_BALLOON_LEAVES ];
        gfl::grp::g2d::LytPaneIndex paneIndexOfDecisionRegion[ MAXIMUM_NUMBER_OF_SIMULTANEOUS_BALLOON_LEAVES ];

        // ؂̎
        gfl::grp::g2d::LytPaneIndex paneIndexOfNuts[ NUTS_NUM ];
        gfl::grp::g2d::LytPaneIndex paneIndexOfTranslucentNuts[ NUTS_NUM ];
        gfl::grp::g2d::LytPaneIndex groupIndexOfNuts; 

        gfl::grp::g2d::LytPaneIndex paneIndexOfScrollRoot;
        gfl::grp::g2d::LytPaneIndex paneIndexOfScrollMinPosition; // XN[̍ŏl\yC
        gfl::grp::g2d::LytPaneIndex paneIndexOfScrollMaxPosition; // XN[̍ől\yC
        gfl::grp::g2d::LytPaneIndex paneIndexOfCursorControlArea; // J[\̈
      };
      static const Information information;

      static const gfl::grp::g2d::LytArcIndex animDataIdTable[ ANIMATION_DATA_NUM ];

      // CAEg[N𐶐
      static gfl::grp::g2d::LytWk* CreateLayoutWork( 
        gfl::heap::NwAllocator* device_allocator, gfl::grp::g2d::LytSys* layout_system, 
        const void* layout_resource_data, const gfl::grp::g2d::LytWkSetUp* layout_work_setup_data );

      struct ButtonInfo
      { 
        gfl::grp::g2d::LytPaneIndex paneIndex;
        AnimationIndex touchAnimeIndex;
        AnimationIndex releaseAnimeIndex;
        AnimationIndex passiveAnimeIndex;
        AnimationIndex activeAnimeIndex;
        AnimationIndex selectAnimeIndex;        
      };
    };

  } // namespace nuts
} // namespace app


#endif // __APP_NUTS_LOWERLAYOUTINFORMATION_H__ 
