//========================================================================================
/**
 * @file app_nuts_LowerLayoutInformation.cpp
 * @brief ؂̎̂Q[̉ʂ̃CAEg
 * @author takada
 * @date 2011.09.01
 */
//======================================================================================== 
#include "app_nuts_LowerLayoutInformation.h"


namespace app {
  namespace nuts {

    // CAEg
    const LowerLayout::Information LowerLayout::information = 
    {
      /* CAEgf[^̃CAEg\[XID */ LYTRES_KGAME_LOWER_KGAME_LOWER_BCLYT,

      /* ȍ */
      {
        //------------
        {
          /* [g */ PANENAME_KGAME_LOWER_PANE_BALLOON_ROOT_00,
          /* oyC */ PANENAME_KGAME_LOWER_PANE_BALLOON00,
          /* m[gyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_NOTE00,
          PANENAME_KGAME_LOWER_MATERIAL_BALLOON_KINOMI00,
          /* 1ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_00,
          /* 2ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_01,
          /* 3ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_02,
          /* ݃Aj[V */ ANIMATION_INDEX_BALLOON00_CLOSE,
          /* sAj[V */ ANIMATION_INDEX_BALLOON00_MISTAKE,
          /* oAj[V */ ANIMATION_INDEX_BALLOON00_OPEN,
          /* Aj[V01 */ ANIMATION_INDEX_BALLOON00_RIGHT01,
          /* Aj[V02 */ ANIMATION_INDEX_BALLOON00_RIGHT02,
          /* ҋ@Aj[V */ ANIMATION_INDEX_BALLOON00_WAIT,
          /* O[v */ PANENAME_KGAME_LOWER_GROUP_BALLOON00,
        }, 
        //------------
        {
          /* [g */ PANENAME_KGAME_LOWER_PANE_BALLOON_ROOT_01,
          /* oyC */ PANENAME_KGAME_LOWER_PANE_BALLOON01,
          /* m[gyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_NOTE01,
          PANENAME_KGAME_LOWER_MATERIAL_BALLOON_KINOMI01,
          /* 1ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_03,
          /* 2ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_04,
          /* 3ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_05,
          /* ݃Aj[V */ ANIMATION_INDEX_BALLOON01_CLOSE,
          /* sAj[V */ ANIMATION_INDEX_BALLOON01_MISTAKE,
          /* oAj[V */ ANIMATION_INDEX_BALLOON01_OPEN,
          /* Aj[V01 */ ANIMATION_INDEX_BALLOON01_RIGHT01,
          /* Aj[V02 */ ANIMATION_INDEX_BALLOON01_RIGHT02,
          /* ҋ@Aj[V */ ANIMATION_INDEX_BALLOON01_WAIT,
          /* O[v */ PANENAME_KGAME_LOWER_GROUP_BALLOON01,
        },  
        //------------
        {
          /* [g */ PANENAME_KGAME_LOWER_PANE_BALLOON_ROOT_02,
          /* oyC */ PANENAME_KGAME_LOWER_PANE_BALLOON02,
          /* m[gyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_NOTE02,
          PANENAME_KGAME_LOWER_MATERIAL_BALLOON_KINOMI02,
          /* 1ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_06,
          /* 2ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_07,
          /* 3ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_08,
          /* ݃Aj[V */ ANIMATION_INDEX_BALLOON02_CLOSE,
          /* sAj[V */ ANIMATION_INDEX_BALLOON02_MISTAKE,
          /* oAj[V */ ANIMATION_INDEX_BALLOON02_OPEN,
          /* Aj[V01 */ ANIMATION_INDEX_BALLOON02_RIGHT01,
          /* Aj[V02 */ ANIMATION_INDEX_BALLOON02_RIGHT02,
          /* ҋ@Aj[V */ ANIMATION_INDEX_BALLOON02_WAIT,
          /* O[v */ PANENAME_KGAME_LOWER_GROUP_BALLOON02,
        },  
        //------------
        {
          /* [g */ PANENAME_KGAME_LOWER_PANE_BALLOON_ROOT_03,
          /* oyC */ PANENAME_KGAME_LOWER_PANE_BALLOON03,
          /* m[gyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_NOTE03,
          PANENAME_KGAME_LOWER_MATERIAL_BALLOON_KINOMI03,
          /* 1ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_09,
          /* 2ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_10,
          /* 3ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_11,
          /* ݃Aj[V */ ANIMATION_INDEX_BALLOON03_CLOSE,
          /* sAj[V */ ANIMATION_INDEX_BALLOON03_MISTAKE,
          /* oAj[V */ ANIMATION_INDEX_BALLOON03_OPEN,
          /* Aj[V01 */ ANIMATION_INDEX_BALLOON03_RIGHT01,
          /* Aj[V02 */ ANIMATION_INDEX_BALLOON03_RIGHT02,
          /* ҋ@Aj[V */ ANIMATION_INDEX_BALLOON03_WAIT,
          /* O[v */ PANENAME_KGAME_LOWER_GROUP_BALLOON03,
        },  
        //------------
        {
          /* [g */ PANENAME_KGAME_LOWER_PANE_BALLOON_ROOT_04,
          /* oyC */ PANENAME_KGAME_LOWER_PANE_BALLOON04,
          /* m[gyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_NOTE04,
          PANENAME_KGAME_LOWER_MATERIAL_BALLOON_KINOMI04,
          /* 1ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_12,
          /* 2ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_13,
          /* 3ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_14,
          /* ݃Aj[V */ ANIMATION_INDEX_BALLOON04_CLOSE,
          /* sAj[V */ ANIMATION_INDEX_BALLOON04_MISTAKE,
          /* oAj[V */ ANIMATION_INDEX_BALLOON04_OPEN,
          /* Aj[V01 */ ANIMATION_INDEX_BALLOON04_RIGHT01,
          /* Aj[V02 */ ANIMATION_INDEX_BALLOON04_RIGHT02,
          /* ҋ@Aj[V */ ANIMATION_INDEX_BALLOON04_WAIT,
          /* O[v */ PANENAME_KGAME_LOWER_GROUP_BALLOON04,
        },  
        //------------
        {
          /* [g */ PANENAME_KGAME_LOWER_PANE_BALLOON_ROOT_05,
          /* oyC */ PANENAME_KGAME_LOWER_PANE_BALLOON05,
          /* m[gyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_NOTE05,
          PANENAME_KGAME_LOWER_MATERIAL_BALLOON_KINOMI05,
          /* 1ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_15,
          /* 2ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_16,
          /* 3ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_17,
          /* ݃Aj[V */ ANIMATION_INDEX_BALLOON05_CLOSE,
          /* sAj[V */ ANIMATION_INDEX_BALLOON05_MISTAKE,
          /* oAj[V */ ANIMATION_INDEX_BALLOON05_OPEN,
          /* Aj[V01 */ ANIMATION_INDEX_BALLOON05_RIGHT01,
          /* Aj[V02 */ ANIMATION_INDEX_BALLOON05_RIGHT02,
          /* ҋ@Aj[V */ ANIMATION_INDEX_BALLOON05_WAIT,
          /* O[v */ PANENAME_KGAME_LOWER_GROUP_BALLOON05,
        },  
        //------------
        {
          /* [g */ PANENAME_KGAME_LOWER_PANE_BALLOON_ROOT_06,
          /* oyC */ PANENAME_KGAME_LOWER_PANE_BALLOON06,
          /* m[gyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_NOTE06,
          PANENAME_KGAME_LOWER_MATERIAL_BALLOON_KINOMI06,
          /* 1ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_18,
          /* 2ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_19,
          /* 3ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_20,
          /* ݃Aj[V */ ANIMATION_INDEX_BALLOON06_CLOSE,
          /* sAj[V */ ANIMATION_INDEX_BALLOON06_MISTAKE,
          /* oAj[V */ ANIMATION_INDEX_BALLOON06_OPEN,
          /* Aj[V01 */ ANIMATION_INDEX_BALLOON06_RIGHT01,
          /* Aj[V02 */ ANIMATION_INDEX_BALLOON06_RIGHT02,
          /* ҋ@Aj[V */ ANIMATION_INDEX_BALLOON06_WAIT,
          /* O[v */ PANENAME_KGAME_LOWER_GROUP_BALLOON06,
        },  
        //------------
        {
          /* [g */ PANENAME_KGAME_LOWER_PANE_BALLOON_ROOT_07,
          /* oyC */ PANENAME_KGAME_LOWER_PANE_BALLOON07,
          /* m[gyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_NOTE07,
          PANENAME_KGAME_LOWER_MATERIAL_BALLOON_KINOMI07,
          /* 1ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_21,
          /* 2ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_22,
          /* 3ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_23,
          /* ݃Aj[V */ ANIMATION_INDEX_BALLOON07_CLOSE,
          /* sAj[V */ ANIMATION_INDEX_BALLOON07_MISTAKE,
          /* oAj[V */ ANIMATION_INDEX_BALLOON07_OPEN,
          /* Aj[V01 */ ANIMATION_INDEX_BALLOON07_RIGHT01,
          /* Aj[V02 */ ANIMATION_INDEX_BALLOON07_RIGHT02,
          /* ҋ@Aj[V */ ANIMATION_INDEX_BALLOON07_WAIT,
          /* O[v */ PANENAME_KGAME_LOWER_GROUP_BALLOON07,
        },  
        //------------
        {
          /* [g */ PANENAME_KGAME_LOWER_PANE_BALLOON_ROOT_08,
          /* oyC */ PANENAME_KGAME_LOWER_PANE_BALLOON08,
          /* m[gyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_NOTE08,
          PANENAME_KGAME_LOWER_MATERIAL_BALLOON_KINOMI08,
          /* 1ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_24,
          /* 2ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_25,
          /* 3ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_26,
          /* ݃Aj[V */ ANIMATION_INDEX_BALLOON08_CLOSE,
          /* sAj[V */ ANIMATION_INDEX_BALLOON08_MISTAKE,
          /* oAj[V */ ANIMATION_INDEX_BALLOON08_OPEN,
          /* Aj[V01 */ ANIMATION_INDEX_BALLOON08_RIGHT01,
          /* Aj[V02 */ ANIMATION_INDEX_BALLOON08_RIGHT02,
          /* ҋ@Aj[V */ ANIMATION_INDEX_BALLOON08_WAIT,
          /* O[v */ PANENAME_KGAME_LOWER_GROUP_BALLOON08,
        },  
        //------------
        {
          /* [g */ PANENAME_KGAME_LOWER_PANE_BALLOON_ROOT_09,
          /* oyC */ PANENAME_KGAME_LOWER_PANE_BALLOON09,
          /* m[gyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_NOTE09,
          PANENAME_KGAME_LOWER_MATERIAL_BALLOON_KINOMI09,
          /* 1ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_27,
          /* 2ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_28,
          /* 3ԐyC */ PANENAME_KGAME_LOWER_PANE_BALLOON_STAR_29,
          /* ݃Aj[V */ ANIMATION_INDEX_BALLOON09_CLOSE,
          /* sAj[V */ ANIMATION_INDEX_BALLOON09_MISTAKE,
          /* oAj[V */ ANIMATION_INDEX_BALLOON09_OPEN,
          /* Aj[V01 */ ANIMATION_INDEX_BALLOON09_RIGHT01,
          /* Aj[V02 */ ANIMATION_INDEX_BALLOON09_RIGHT02,
          /* ҋ@Aj[V */ ANIMATION_INDEX_BALLOON09_WAIT,
          /* O[v */ PANENAME_KGAME_LOWER_GROUP_BALLOON09,
        }, 
      },

      {
        PANENAME_KGAME_LOWER_PANE_BALLOON_SET00,
        PANENAME_KGAME_LOWER_PANE_BALLOON_SET01,
        PANENAME_KGAME_LOWER_PANE_BALLOON_SET02,
      },

      {
        PANENAME_KGAME_LOWER_PANE_BALLOON00_BOUND,
        PANENAME_KGAME_LOWER_PANE_BALLOON01_BOUND,
        PANENAME_KGAME_LOWER_PANE_BALLOON02_BOUND,
      },

      {
        PANENAME_KGAME_LOWER_PANE_KINOMI00,
        PANENAME_KGAME_LOWER_PANE_KINOMI01,
        PANENAME_KGAME_LOWER_PANE_KINOMI02,
        PANENAME_KGAME_LOWER_PANE_KINOMI03,
        PANENAME_KGAME_LOWER_PANE_KINOMI04,
        PANENAME_KGAME_LOWER_PANE_KINOMI05,
        PANENAME_KGAME_LOWER_PANE_KINOMI06,
        PANENAME_KGAME_LOWER_PANE_KINOMI07,
        PANENAME_KGAME_LOWER_PANE_KINOMI08,
        PANENAME_KGAME_LOWER_PANE_KINOMI09,
      },
      
      {
        PANENAME_KGAME_LOWER_PANE_KINOMI00_R,
        PANENAME_KGAME_LOWER_PANE_KINOMI01_R,
        PANENAME_KGAME_LOWER_PANE_KINOMI02_R,
        PANENAME_KGAME_LOWER_PANE_KINOMI03_R,
        PANENAME_KGAME_LOWER_PANE_KINOMI04_R,
        PANENAME_KGAME_LOWER_PANE_KINOMI05_R,
        PANENAME_KGAME_LOWER_PANE_KINOMI06_R,
        PANENAME_KGAME_LOWER_PANE_KINOMI07_R,
        PANENAME_KGAME_LOWER_PANE_KINOMI08_R,
        PANENAME_KGAME_LOWER_PANE_KINOMI09_R,
      },

      PANENAME_KGAME_LOWER_GROUP_KINOMI
    };

    const gfl::grp::g2d::LytArcIndex LowerLayout::animDataIdTable[ LowerLayout::ANIMATION_DATA_NUM ] = 
    {
      //------------
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_CLOSE_00_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_MISTAKE_00_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_OPEN_00_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT1_00_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT2_00_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_WAIT_00_BCLAN,
      //------------
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_CLOSE_01_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_MISTAKE_01_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_OPEN_01_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT1_01_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT2_01_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_WAIT_01_BCLAN,
      //------------
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_CLOSE_02_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_MISTAKE_02_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_OPEN_02_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT1_02_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT2_02_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_WAIT_02_BCLAN,
      //------------
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_CLOSE_03_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_MISTAKE_03_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_OPEN_03_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT1_03_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT2_03_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_WAIT_03_BCLAN,
      //------------
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_CLOSE_04_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_MISTAKE_04_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_OPEN_04_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT1_04_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT2_04_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_WAIT_04_BCLAN,
      //------------
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_CLOSE_05_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_MISTAKE_05_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_OPEN_05_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT1_05_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT2_05_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_WAIT_05_BCLAN,
      //------------
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_CLOSE_06_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_MISTAKE_06_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_OPEN_06_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT1_06_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT2_06_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_WAIT_06_BCLAN,
      //------------
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_CLOSE_07_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_MISTAKE_07_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_OPEN_07_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT1_07_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT2_07_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_WAIT_07_BCLAN,
      //------------
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_CLOSE_08_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_MISTAKE_08_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_OPEN_08_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT1_08_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT2_08_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_WAIT_08_BCLAN,
      //------------
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_CLOSE_09_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_MISTAKE_09_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_OPEN_09_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT1_09_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_RIGHT2_09_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_BALLOON_WAIT_09_BCLAN,

      LYTRES_KGAME_LOWER_KGAME_LOWER_KINOMI_CATCH1_BCLAN,
      LYTRES_KGAME_LOWER_KGAME_LOWER_KINOMI_CATCH2_BCLAN,
    };

    /*
    for( s8 i=0; i<BUTTON_NUM; ++i )
    {
      mButtonInfo[i].xxxx;
    }
    */
    
    //------------------------------------------------------------------------------------
    // CAEg[N𐶐
    //------------------------------------------------------------------------------------
    gfl::grp::g2d::LytWk* LowerLayout::CreateLayoutWork( 
        gfl::heap::NwAllocator* device_allocator, gfl::grp::g2d::LytSys* layout_system, 
        const void* layout_resource_data, const gfl::grp::g2d::LytWkSetUp* layout_work_setup_data )
    {
      gfl::grp::g2d::LytResID layout_resource_id = layout_system->LoadLytRes( device_allocator, layout_resource_data );
      layout_system->TransferAllTexture( layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      gfl::grp::g2d::LytWk* layout_work = layout_system->CreateLytWk(
          layout_resource_id, LowerLayout::information.layoutDataId,
          animDataIdTable, ANIMATION_DATA_NUM, ANIMATION_INDEX_NUM, 
          layout_work_setup_data, 
          false );  // Aj[VoChȂ

      // LAj̓o^
      /*
      // ӂoAj
      layout_work->CreateShareAnime( ANIMATION_DATA_BALLOON02_CLOSE, 
          animDataIdTable[ ANIMATION_DATA_BALLOON_CLOSE ],
          0, PANENAME_KGAME_LOWER_GROUP_BALLOON );
      // ӂҋ@Aj
      layout_work->CreateShareAnime( ANIMATION_DATA_BALLOON02_MISTAKE, 
          animDataIdTable[ ANIMATION_DATA_BALLOON_MISTAKE ],
          0, PANENAME_KGAME_LOWER_GROUP_BALLOON );
      // ӂAjP
      layout_work->CreateShareAnime( ANIMATION_DATA_BALLOON02_OPEN, 
          animDataIdTable[ ANIMATION_DATA_BALLOON_OPEN ],
          0, PANENAME_KGAME_LOWER_GROUP_BALLOON );
      // ӂAjQ
      layout_work->CreateShareAnime( ANIMATION_DATA_BALLOON02_RIGHT1, 
          animDataIdTable[ ANIMATION_DATA_BALLOON_RIGHT1 ],
          0, PANENAME_KGAME_LOWER_GROUP_BALLOON );
      // ӂsAj
      layout_work->CreateShareAnime( ANIMATION_DATA_BALLOON02_RIGHT2, 
          animDataIdTable[ ANIMATION_DATA_BALLOON_RIGHT2 ],
          0, PANENAME_KGAME_LOWER_GROUP_BALLOON );
      // ӂ݃Aj
      layout_work->CreateShareAnime( ANIMATION_DATA_BALLOON02_WAIT, 
          animDataIdTable[ ANIMATION_DATA_BALLOON_WAIT ],
          0, PANENAME_KGAME_LOWER_GROUP_BALLOON );
      */

      return layout_work;
    }

  } // namespace nuts
} // namespace app
