//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_nuts_LowerDrawer.cpp
 *	@brief ؂̎̂Q[̉ʕ`NX
 *	@author	takada
 *	@date		2011.09.01
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include "app_nuts_LowerLayoutInformation.h"
#include "app_nuts_LowerDrawer.h"

namespace app {
  namespace nuts {

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp LowerDrawer::mLayoutWorkSetupParameter =
    {
      gfl::math::VEC3( 0, -290, 0 ),   // pos
      gfl::math::VEC2( 1, 1 ),        // scale
      gfl::math::VEC3( 0, 0, 0 ),      // rotate
      1,                           // priority
    };


    // ˉeϊp[^
    const gfl::grp::ProjectionParam LowerDrawer::mProjectionParameter =
    {
#if 1
      gfl::grp::PROJECTION_ORTHO,
      { -160.0f, 160.0f, -120.0f, 120.0f },
#else
      gfl::grp::PROJECTION_PERSPECTIVE,
      { 
        gfl::math::AtanRad( 120.0f / 100.0f ) * 2,   // zl0{ŕ\悤ɐݒ
        320.0f / 240.0f 
      },
#endif
      0.10f,
      800.0f,
      gfl::math::PIVOT_UPSIDE_TO_TOP,
    };


    // r[ϊp[^
    const gfl::grp::ViewParam LowerDrawer::mViewParameter = 
    {
      gfl::math::VEC3( 0, -290, 100 ),  // JW
      gfl::math::VEC3( 0, 1, 0 ),     // 
      gfl::math::VEC3( 0, -290, 0) ,  // ^[QbgW
    }; 

    // XN[o[̕\
    const LowerDrawer::ScrollBarParamter LowerDrawer::mScrollBarParameter = 
    { 
      /* [̒ */ 200.0f,
      /* x̍ől */ 1.0f, 
      /* x̍ŏl */ 0.0f, 
      /* x̃tF[hx */ 0.1f, 
      /* \xW */ 155, 
      /* \yW */ 15, 
    };

    // bZ[WEBhE̐ݒ
    const u32 LowerDrawer::MSGWIN_LINE_NUM = 2;
    const u32 LowerDrawer::MSGWIN_WAIT_FRAME = 3;

    // V[Ƃ̐ݒ
    const LowerDrawer::SceneSetting LowerDrawer::mSceneSettings[ CoreData::SCENE_NUM ] = 
    {
      {
        /* XN[o[̍XVsǂ */ true,
        /* XN[o[`悷邩ǂ */ true,
      },
    };

    const app::tool::MenuWindow::MenuParameter LowerDrawer::mMenuParam = 
    {
      /* `̃fBXvC */ gfl::grp::DISPLAY_LOWER,
      /* \W̎w@( x ) */ app::tool::MenuWindow::X_POSITION_TYPE_LEFT,
      /* \W̎w@( y ) */ app::tool::MenuWindow::Y_POSITION_TYPE_TOP,
      /* j[̕\W( x ) */ 30,
      /* j[̕\W( y ) */ 60,
      /* IEBhE̍ŏ */ 128,
      /* I̍s */ 2,
      /* I̗ */ 1,
      /* J[\̈ړ[v邩ǂ */ true,
    };

    const app::tool::MenuWindow::AlternativeParameter LowerDrawer::mAlternativeParam[ 2 ] = 
    {
      // CHANGE_YES
      {
        /* sCfbNX */ 0,
        /* CfbNX */ 0,
        /* IɎ擾l */ 0,
        /* B{^Ɋ֘At邩ǂ */ false, 
        /*u߂vACR\邩ǂ */ false,
      },
      // CHANGE_NO
      {
        /* sCfbNX */ 1,
        /* CfbNX */ 0,
        /* IɎ擾l */ 1,
        /* B{^Ɋ֘At邩ǂ */ false, 
        /*u߂vACR\邩ǂ */ false,
      },
    };

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //--------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap                          CX^X̐Ɏgpq[v
     * @param deviceHeapForTextureData      eNX`f[^̊mۂɎgpfoCXq[v
     * @param nwHeapAllocator               OtBbNXVXeŎgpAP[^
     * @param nwDeviceAllocator             OtBbNXVXeŎgpAP[^
     * @param graphicsSystem                `ɎgpOtBbNXVXe
     * @param layoutSystem                  `Ɏgp郌CAEgVXe
     * @param uiDeviceManager               bZ[WEBhE̐ɎgpUIfoCX
     * @param layoutReosurceData            CAEg\[X̃oCif[^
     * @param arcFile                       ݒʗp̃A[JCut@C
     * @param nutsMessageData             ݒʂ̃bZ[Wf[^
     * @param coreData                      `Ώۂ̃Xe[^XʃRAf[^
     */
    //--------------------------------------------------------------------------------
     LowerDrawer::LowerDrawer(
        gfl::heap::HeapBase* heap,
        gfl::heap::HeapBase* deviceHeapForTextureData,
        gfl::heap::NwAllocator* nwHeapAllocator,
        gfl::heap::NwAllocator* nwDeviceAllocator,
        gfl::grp::GraphicsSystem* graphicsSystem, 
        gfl::grp::g2d::LytSys* layoutSystem,
        const gfl::ui::DeviceManager* uiDeviceManager,
        const void* layoutResourceData,
        //gfl::str::MsgData* nutsMessageData,
        const app::nuts::CoreData* coreData ) :
      Drawer( nwHeapAllocator, nwDeviceAllocator, graphicsSystem, layoutSystem, coreData ),
      mLayoutWork( NULL ),
      mUpperLayoutEnv( NULL ),
      mLowerLayoutEnv( NULL ),
      //mNutsMessageData( nutsMessageData ),
      mNutsMessageData( this->GetMessageData() ),
      mMessageWindow( NULL ),
      mDeviceHeapForTextureData( deviceHeapForTextureData ),
      mScrollBar( NULL ),
      mCurrentScene( CoreData::SCENE_NULL ),
      mScrollBarAlpha( 0.0f ),
      mMenuWindow(),
      mMenuWindowSystem( NULL )
    {
      this->CreateLayoutWork( nwDeviceAllocator, layoutResourceData );

      this->CreateLayoutEnv( heap ); 
      this->SetupLayoutEnvForLayoutWork();

      this->CreateMessageWindow( heap, uiDeviceManager );

      this->CreateScrollBar( heap );

      this->SetupStaticPaneInfo();
      this->SetupStaticStrings();

      mMenuWindowSystem = GFL_NEW( heap ) app::tool::MenuWindowSystem( heap, deviceHeapForTextureData, uiDeviceManager, graphicsSystem, layoutSystem );
      this->CreateMenuWindow( heap );
      mMenuWindowSystem->SetMenuWindow( mMenuWindow );
    } 

     // CAEg[N𐶐
    void LowerDrawer::CreateLayoutWork( gfl::heap::NwAllocator* nwDeviceAllocator, const void* layoutResourceData )
    { 
      GFL_ASSERT( mLayoutWork == NULL );
      mLayoutWork = LowerLayout::CreateLayoutWork( 
          nwDeviceAllocator, 
          this->LayoutSystem(), 
          layoutResourceData, 
          &mLayoutWorkSetupParameter );
      mLayoutWork->SetAutoDrawFlag( false );
    }


    // CAEg[N̕`𐶐
    void LowerDrawer::CreateLayoutEnv(  gfl::heap::HeapBase* heap )
    { 
      GFL_ASSERT( mUpperLayoutEnv == NULL );
      mUpperLayoutEnv = GFL_NEW( heap ) gfl::grp::g2d::Env();

      GFL_ASSERT( mLowerLayoutEnv == NULL );
      mLowerLayoutEnv = GFL_NEW( heap ) gfl::grp::g2d::Env(); 
      mLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, mProjectionParameter, mViewParameter );
      mLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, mProjectionParameter, mViewParameter );

      gfl::grp::FragmentOperationParam operationParam = gfl::grp::FragmentOperation::DefaultParam;
      operationParam.depth_test = true;
      operationParam.depth_func = gfl::grp::TEST_FUNC_LEQUAL;
      //operationParam.depth_write = true;
      operationParam.depth_write = false;
      operationParam.frame_depth_read = true;
      //operationParam.frame_depth_write = true;
      operationParam.frame_depth_write = false;
      mLowerLayoutEnv->GetFragmentOperationPtr()->SetParam( operationParam );
    }


    // CAEg[N̕`ݒ肷
    void LowerDrawer::SetupLayoutEnvForLayoutWork( void )
    {
      mLayoutWork->SetUserEnv( mUpperLayoutEnv, mLowerLayoutEnv );
    }


    // bZ[WEBhE쐬
    void LowerDrawer::CreateMessageWindow( gfl::heap::HeapBase* heap, const gfl::ui::DeviceManager* uiDeviceManager )
    {
      GFL_ASSERT( mMessageWindow == NULL );
      GFL_ASSERT( mLayoutWork );
      mMessageWindow = GFL_NEW( heap ) print::MsgWin( uiDeviceManager, mLayoutWork, MSGWIN_LINE_NUM, MSGWIN_WAIT_FRAME, heap );
    }

    // XN[o[𐶐
    void LowerDrawer::CreateScrollBar( gfl::heap::HeapBase* heap )
    {
      GFL_ASSERT( mScrollBar == NULL );
      mScrollBar = GFL_NEW( heap ) app::tool::ScrollBar( heap, this->GraphicsSystem() );

      f32 railLen = mScrollBarParameter.railLength;
      f32 min = this->GetMinScrollValue();
      f32 max = this->GetMaxScrollValue();
      f32 range = max - min;
      f32 areaHeiht = GetSlideAreaHeight();
      //f32 knobLen = railLen * ( 240.0f / range );  // @todo ʂ̍萔ɒu
      f32 knobLen = railLen * ( areaHeiht / ( areaHeiht + range ) );
      mScrollBar->SetDrawParam( gfl::grp::DISPLAY_LOWER, app::tool::ScrollBar::SCROLL_DIRECTION_VERTICAL, railLen, knobLen );
    }

    // j[EChE쐬
    void LowerDrawer::CreateMenuWindow( gfl::heap::HeapBase* heap )
    {
      mMenuWindow = GFL_NEW( heap ) app::tool::MenuWindow( heap, mMenuParam );

      mMenuWindow->AddAlternative( mAlternativeParam[ 0 ] );
      mMenuWindow->AddAlternative( mAlternativeParam[ 1 ] );

      /*
      gfl::str::StrBuf strbuf( 128, heap );
      mNutsMessageData->GetString( msg_option_100_02, strbuf );
      mMenuWindow->SetAlternativeString( 0, 0, strbuf );
      mNutsMessageData->GetString( msg_option_100_03, strbuf );      
      mMenuWindow->SetAlternativeString( 1, 0, strbuf );
      */
    }

    // sςȃyCݒ肷
    void LowerDrawer::SetupStaticPaneInfo( void )
    {
      u32 level = this->NutsData()->GetLevel();
      u32 nutsNum = NutsData::levelInformation[ level ].numberOfNuts;

      for( u32 i=0; i<nutsNum; ++i ) {
        NutsData::NutsIndex index = static_cast<NutsData::NutsIndex>( i );
        gfl::grp::g2d::LytPaneIndex paneIndex = LowerLayout::information.paneIndexOfTranslucentNuts[ index ];

        gfl::math::VEC3 pos = NutsData::levelInformation[ level ].basePositionOfNuts[ index ];
        this->SetPaneTranslate( mLayoutWork, paneIndex, pos );

        //this->SetPaneAlpha( mLayoutWork, paneIndex, 128 );
      }
    }

    // sςȕݒ肷
    void LowerDrawer::SetupStaticStrings( void )
    {
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //--------------------------------------------------------------------------------
    LowerDrawer::~LowerDrawer()
    {
      this->DeleteMessageWindow();
      this->DeleteLayoutWork();
      this->DeleteLayoutEnv();
      this->DeleteMenuWindowSystem();
      this->DeleteScrollBar();
      this->DeleteMenuWindow();
    } 


    // XN[o[j
    void LowerDrawer::DeleteScrollBar( void )
    {
      GFL_ASSERT( mScrollBar );
      GFL_DELETE mScrollBar;
    }


    // \EBhEj
    void LowerDrawer::DeleteMessageWindow( void )
    {
      GFL_ASSERT( mMessageWindow );
      GFL_DELETE mMessageWindow;
    }


    // CAEg[Nj
    void LowerDrawer::DeleteLayoutWork( void )
    {
      GFL_ASSERT( mLayoutWork );
      this->LayoutSystem()->RemoveLytWk( mLayoutWork );
    }


    // CAEg[N̕`j
    void LowerDrawer::DeleteLayoutEnv( void )
    {
      GFL_ASSERT( mUpperLayoutEnv );
      GFL_ASSERT( mLowerLayoutEnv );
      GFL_DELETE mUpperLayoutEnv;
      GFL_DELETE mLowerLayoutEnv; 
    }

    // j[VXej
    void LowerDrawer::DeleteMenuWindowSystem( void )
    {
      GFL_ASSERT( mMenuWindowSystem );
      GFL_DELETE mMenuWindowSystem;
    }

    // j[j
    void LowerDrawer::DeleteMenuWindow( void )
    {
      GFL_ASSERT( mMenuWindow );
      GFL_DELETE mMenuWindow;
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief CAEg[N擾
     */
    //--------------------------------------------------------------------------------
    const gfl::grp::g2d::LytWk* LowerDrawer::GetLayoutWork( void ) const
    {
      return mLayoutWork;
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief \EBhE擾
     */
    //--------------------------------------------------------------------------------
    print::MsgWin* LowerDrawer::GetMessageWindow( void )
    {
      return mMessageWindow;
    }

    //------------------------------------------------------------------------------------
    // XN[̏l擾
    //------------------------------------------------------------------------------------
    f32 LowerDrawer::GetInitialScrollValue( void ) const
    {
      const gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfScrollMinPosition ); 
      return pane->GetTranslate().y;
    }
    
    //------------------------------------------------------------------------------------
    // XN[̍ŏl擾
    //------------------------------------------------------------------------------------
    f32 LowerDrawer::GetMinScrollValue( void ) const
    {
      const gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfScrollMinPosition ); 
      return pane->GetTranslate().y;
    }

    //------------------------------------------------------------------------------------
    // XN[̍ől擾
    //------------------------------------------------------------------------------------
    f32 LowerDrawer::GetMaxScrollValue( void ) const
    {
      const gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfScrollMaxPosition ); 
      return pane->GetTranslate().y;
    }

    //------------------------------------------------------------------------------------
    // XChGA̕擾
    //------------------------------------------------------------------------------------
    f32 LowerDrawer::GetSlideAreaHeight( void ) const
    {
      gfl::grp::g2d::LytPane* areaPane = mLayoutWork->GetPane( LowerLayout::information.paneIndexOfCursorControlArea ); 
      const nw::lyt::Size& areaSize = areaPane->GetSize();

      return areaSize.height;
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief j[EChEVXe擾
     */
    //--------------------------------------------------------------------------------
    app::tool::MenuWindowSystem* LowerDrawer::GetMenuWindowSystem( void ) const
    {
      GFL_ASSERT( mMenuWindowSystem );      
      return mMenuWindowSystem;
    }

    //------------------------------------------------------------------------------------
    /**
     * @brefi vZX̂߂̍Œ̃ZbgAbv
     */
    //------------------------------------------------------------------------------------
    void LowerDrawer::SetupForProcessStart( void )
    {
      this->UpdateScene(); // V[XV
      mLayoutWork->Update();
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief \eXV
     */
    //--------------------------------------------------------------------------------
    void LowerDrawer::UpdateView( void )
    { 
      CoreData::SceneNo currentScene = this->CoreData()->GetScene();
      if( mCurrentScene < CoreData::SCENE_NUM ) {
        //this->StopAnimation( LowerLayout::information.animation_index_of_scene_change_to[ mCurrentScene ] );
      } 
      if( this->CoreData()->IsDirty( CoreData::DIRTY_FLAG_FOR_LOWER, CoreData::DIRTY_BIT_SCENE ) ) {
        this->CoreData()->RemoveDirtyBit( CoreData::DIRTY_FLAG_FOR_LOWER, CoreData::DIRTY_BIT_SCENE );
        this->UpdateScene();
      }

      if( mSceneSettings[ currentScene ].scrollbarUpdateEnable ) {
        this->UpdateScrollBarAlpha(); 
      } 

      // TODO: |P̏oʒuƊ]̐FɂAöʒuύX
      //if( this->NutsData()->GetCurrentTouchedNuts() != NutsData::NUTS_NULL )
      //{
        this->BalloonData()->SetBasePosition( mLayoutWork );
      //}

      // õAj[VXV
      //this->UpdateBalloonAnimation();
      this->BalloonData()->UpdateAnimation( mLayoutWork, this->NutsData() );

      //this->UpdateNutsSelectState();
      //this->UpdateNutsHoldState();

      // ؂̎̈ʒuύX
      this->UpdateNutsPaneXYPosition();  // lȂ̂, Aj[V̍XVɎs

      mLayoutWork->Update();      
    }

#if 0
    void LowerDrawer::UpdateBalloonAnimation( void )
    {
      for( u32 i=0; i<BalloonData::BALLOON_NUM; ++i )
      {
        BalloonData::BalloonIndex targetBalloon = static_cast<BalloonData::BalloonIndex>( i );
        bool isBalloonInsideOfDecisionRegion = this->BalloonData()->GetIsBalloonInsideOfDecisionRegion( targetBalloon );
        if( isBalloonInsideOfDecisionRegion == true )
        {
          u32 level;
          u32 nutsNum;

          switch( mCurrentBalloonAnimeState[ targetBalloon ] )
          {
          case BALLOON_ANIME_STATE_OPEN:
            mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenOpen;
            this->StartAnimation( mCurrentBalloonAnimationIndex[ targetBalloon ] );
            break;            
          case BALLOON_ANIME_STATE_WAIT:
            mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenWait;
            this->StartAnimation( mCurrentBalloonAnimationIndex[ targetBalloon ] );
            //break;            
          //case BALLOON_ANIME_STATE_ACTION:
            /*u32*/ level = this->NutsData()->GetLevel();
            /*u32*/ nutsNum = NutsData::levelInformation[ level ].numberOfNuts;

            for( u32 j=0; j<nutsNum; ++j ) {
              NutsData::NutsIndex index = static_cast<NutsData::NutsIndex>( j );
              bool isNutsInsideOfDecisionRegion = this->NutsData()->GetIsNutsInsideOfDecisionRegion( index );
              s32 numberOfDecisionRegion = this->NutsData()->GetNumberOfDecisionRegion( index );              
              if( isNutsInsideOfDecisionRegion == true &&
                  i == numberOfDecisionRegion )
              {
                // TODO: ؂̎( j )̐FƁAnumberOfDecisionRegion̗̈ɂA
                // o( i )̐FrčvAAj[VĐ
                if( i == j )
                {
                  mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenRight02; 
                  this->StartAnimation( mCurrentBalloonAnimationIndex[ targetBalloon ] );
                }
                else
                {
                  mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenMistake; 
                  this->StartAnimation( mCurrentBalloonAnimationIndex[ targetBalloon ] );
                }
              }
            }
            break;
          case BALLOON_ANIME_STATE_ACTION:
            break;
          case BALLOON_ANIME_STATE_CLOSE:
            mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenClose; 
            this->StartAnimation( mCurrentBalloonAnimationIndex[ targetBalloon ] );
            break;
          case BALLOON_ANIME_STATE_NULL:
            mCurrentBalloonAnimeState[ targetBalloon ] = BALLOON_ANIME_STATE_OPEN;
            break;
          default:
            break;
          }
 
          if( mLayoutWork->IsAnimeEnd( mCurrentBalloonAnimationIndex[ targetBalloon ] ) == true )
          {
            this->StopAnimation( mCurrentBalloonAnimationIndex[ targetBalloon ] );
            s32 balloonAnimeStateIndex = static_cast<s32>( mCurrentBalloonAnimeState[ targetBalloon ] );
            mCurrentBalloonAnimeState[ targetBalloon ] = static_cast<BalloonAnimeState>( ++balloonAnimeStateIndex );
            
            if( mCurrentBalloonAnimeState[ targetBalloon ] == BALLOON_ANIME_STATE_NUM )
              //mCurrentBalloonAnimeState[ targetBalloon ] = BALLOON_ANIME_STATE_NULL;
              this->BalloonData()->SetIsBalloonInsideOfDecisionRegion( targetBalloon, false );
          }
          if( mCurrentBalloonAnimeState[ targetBalloon ] == BALLOON_ANIME_STATE_WAIT &&
              mCurrentBalloonAnimationIndex[ targetBalloon ] != LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenOpen &&
              mCurrentBalloonAnimationIndex[ targetBalloon ] != LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenWait )
          {
            this->StopAnimation( LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenWait );
            mCurrentBalloonAnimeState[ targetBalloon ] = BALLOON_ANIME_STATE_ACTION;
          }
        }
      }
    }
#endif

    // V[XV
    void LowerDrawer::UpdateScene( void )
    { 
      CoreData::SceneNo nextScene = this->CoreData()->GetScene();
      if( nextScene < CoreData::SCENE_NUM ) {
        //this->StartAnimation( LowerLayout::information.animation_index_of_scene_change_to[ nextScene ] );
        mCurrentScene = nextScene;
      }
    }

    /*
    // ؂̎̑IԂXV
    void LowerDrawer::UpdateNutsSelectState( void )
    {
      //bool selectNutsIsValid = this->NutsData()->IsNutsValid( NutsData::NUTS_SELECT );
      //NutsData::NutsIndex selectedIndex = this->NutsData()->GetNutsPos( NutsData::NUTS_SELECT );

      for( u32 nutsIndex=0; nutsIndex<NutsData::NUTS_NUM; ++nutsIndex ) {
        if( m_nuts_display_state[ nutsIndex ].selected_flag ) {
          if( !selectNutsIsValid || ( nutsIndex != selectedIndex ) ) {
            m_nuts_display_state[ nutsIndex ].selected_flag = false;
            //LowerLayout::AnimationIndex animationIndex = LowerLayout::information.waza_plate_info[ nutsIndex ].animation_index_on_selected;
            //this->StopAnimation( animation_index );
          }
        }
        else {
          if( selectNutsIsValid && ( nutsIndex == selectedIndex ) ) {
            m_nuts_display_state[ nutsIndex ].selected_flag = true;
            //LowerLayout::AnimationIndex animationIndex = LowerLayout::information.waza_plate_info[ nutsIndex ].animation_index_on_selected;
            //this->StartAnimation( animationIndex );
          }
        }
      }
    }
    */

    /*
    // ؂̎̃z[hԂXV
    void LowerDrawer::UpdateNutsHoldState( void )
    {
      for( u32 i=0; i<NutsData::NUTS_NUM; ++i ) {
        NutsData::NutsIndex nutsIndex = static_cast<NutsData::PlateIndex>(i);
        //LowerLayout::AnimationIndex animationIndexHold = LowerLayout::information.waza_plate_info[i].animation_index_on_hold;
        //LowerLayout::AnimationIndex animationIndexRelease = LowerLayout::information.waza_plate_info[i].animation_index_on_release;
        if( m_nuts_display_state[i].hold_flag && !this->NutsData()->IsNutsHeld( nutsIndex ) ) {
          m_nuts_display_state[i].hold_flag = false;
          //this->StopAnimation( animationIndexHold );
          //this->StartAnimation( animationIndexRelease );
        }
        else if( !m_nuts_display_state[i].hold_flag && this->NutsData()->IsNutsHeld( nutsIndex ) ) {
          m_nuts_display_state[i].hold_flag = true;
          //this->StopAnimation( animationIndexRelease );
          //this->StartAnimation( animationIndexHold );
        }
      }
    }
    */

    // ؂̎̕\ʒuXV
    void LowerDrawer::UpdateNutsPaneXYPosition()
    {
      u32 level = this->NutsData()->GetLevel();
      u32 nutsNum = NutsData::levelInformation[ level ].numberOfNuts;

      for( u32 i=0; i<nutsNum; ++i ) {
        NutsData::NutsIndex index = static_cast<NutsData::NutsIndex>( i );
        gfl::grp::g2d::LytPaneIndex paneIndex = LowerLayout::information.paneIndexOfNuts[ index ];
        gfl::grp::g2d::LytPane* pane = mLayoutWork->GetPane( paneIndex ); 
        gfl::math::VEC3 panePos = pane->GetTranslate();
        const gfl::math::VEC3& newPos = this->NutsData()->GetNutsPosition( index );
        panePos.x = newPos.x;
        panePos.y = newPos.y;
        pane->SetTranslate( panePos );
      }
    }

    // Aj[VJn
    void LowerDrawer::StartAnimation( LowerLayout::AnimationIndex animationIndex )
    {
      if( animationIndex < LowerLayout::ANIMATION_INDEX_NUM ) {
        if( mLayoutWork->IsBindAnime( animationIndex ) == false ) {
          mLayoutWork->BindAnime( animationIndex );
          mLayoutWork->SetAutoAnime( animationIndex, true );
          mLayoutWork->SetAnimeFrame( animationIndex, 0 );
        }
        else
        {
          return;
        }
        
      }
    }

    // Aj[V~
    void LowerDrawer::StopAnimation( LowerLayout::AnimationIndex animationIndex ) 
    {
      if( animationIndex < LowerLayout::ANIMATION_INDEX_NUM ) {
        if( mLayoutWork->IsBindAnime( animationIndex ) ) {
          mLayoutWork->UnBindAnime( animationIndex );
        }
      }
    }

    // XN[o[̃At@lXV
    void LowerDrawer::UpdateScrollBarAlpha( void )
    {
      bool scrollBarIsUpdated = this->CoreData()->IsDirty( CoreData::DIRTY_FLAG_FOR_LOWER, CoreData::DIRTY_BIT_SCROLL_VALUE );
      this->CoreData()->RemoveDirtyBit( CoreData::DIRTY_FLAG_FOR_LOWER, CoreData::DIRTY_BIT_SCROLL_VALUE );

      if( scrollBarIsUpdated ) {
        mScrollBarAlpha += mScrollBarParameter.fadeSpeed;
        if( mScrollBarParameter.fadeMax < mScrollBarAlpha ) {
          mScrollBarAlpha = mScrollBarParameter.fadeMax;
        }
      }
      else {
        mScrollBarAlpha -= mScrollBarParameter.fadeSpeed;
        if( mScrollBarAlpha < mScrollBarParameter.fadeMin ) {
          mScrollBarAlpha = mScrollBarParameter.fadeMin;
        }
      }
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief ʂ`悷
     */
    //--------------------------------------------------------------------------------
    void LowerDrawer::Draw( void )
    { 
      gfl::grp::RenderTarget* lowerFrameBuffer = this->GraphicsSystem()->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      mLayoutWork->Draw( this->GraphicsSystem(), gfl::grp::DISPLAY_LOWER, lowerFrameBuffer );

      CoreData::SceneNo currentScene = this->CoreData()->GetScene();
      if( mSceneSettings[ currentScene ].scrollbarDrawEnable && ( 0.0f < mScrollBarAlpha ) ) {
        mScrollBar->Draw( mScrollBarParameter.x, mScrollBarParameter.y, this->CoreData()->GetScrollValueObject(), mScrollBarAlpha );
      }

      
      //mMenuWindowSystem->DrawMenuWindow();
    }

  } //nuts
} //app
