//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file	app_nuts_Drawer.cpp
 *	@brief ؂̎̂Q[̕`{NX
 *	@author takada
 *	@date		2011.09.01
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include "app_nuts_CoreData.h"
#include "app_nuts_Drawer.h"

#include <message/message.gaix>
#include <message/msg_kgame.h>

namespace app {
  namespace nuts {

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
    // ̈ꎞobt@̍ő啶
    const size_t Drawer::mTemporaryStrbufLength = 1024;

    // ̈ꎞobt@
    gfl::str::StrBuf* Drawer::mTemporaryStrbuf = NULL;
    wchar_t* Drawer::mTemporaryString = NULL;

    // bZ[Wf[^
    gfl::str::MsgData* Drawer::mMessageData = NULL;

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//----------------------------------------------------------------------------- 

    //--------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     *
     * @param nwHeapAllocator    OtBbNXVXeŎgpAP[^
     * @param nwDeviceAllocator  OtBbNXVXeŎgpAP[^
     * @param graphicsSystem      `ɎgpOtBbNXVXe
     * @param layoutSystem        `Ɏgp郌CAEgVXe
     * @param coreData            `Ώۂ̐ݒʃRA
     */
    //--------------------------------------------------------------------------------
    Drawer::Drawer( 
        gfl::heap::NwAllocator* nwHeapAllocator,
        gfl::heap::NwAllocator* nwDeviceAllocator,
        gfl::grp::GraphicsSystem* graphicsSystem, 
        gfl::grp::g2d::LytSys* layoutSystem,
        const app::nuts::CoreData* coreData ) : 
      mNwHeapAllocator( nwHeapAllocator ),
      mNwDeviceAllocator( nwDeviceAllocator ),
      mGraphicsSystem( graphicsSystem ),
      mLayoutSystem( layoutSystem ),
      mCoreData( coreData ),
      m_nuts_data( coreData->GetConstNutsData() ),
      m_balloon_data( coreData->GetBalloonData() )
    {
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //--------------------------------------------------------------------------------
    Drawer::~Drawer()
    {
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief ̈ꎞobt@𐶐
     *
     * @param heap  obt@̊mۂɎgpq[v
     */
    //--------------------------------------------------------------------------------
    void Drawer::CreateTemporaryStrbuf( gfl::heap::HeapBase* heap )
    {
      GFL_ASSERT( mTemporaryStrbuf == NULL );
      GFL_ASSERT( mTemporaryString == NULL );
      mTemporaryStrbuf = GFL_NEW( heap ) gfl::str::StrBuf( mTemporaryStrbufLength, heap );
      mTemporaryString = GFL_NEW_ARRAY( heap ) wchar_t[ mTemporaryStrbufLength ];
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief ̈ꎞobt@j
     */
    //--------------------------------------------------------------------------------
    void Drawer::DeleteTemporaryStrbuf( void )
    {
      GFL_ASSERT( mTemporaryStrbuf );
      GFL_ASSERT( mTemporaryString );
      GFL_DELETE mTemporaryStrbuf;
      GFL_DELETE_ARRAY mTemporaryString;
      mTemporaryStrbuf = NULL;
      mTemporaryString = NULL;
    }

    // eLXg{bNXyCɃbZ[Wf[^̕ݒ肷
    void Drawer::SetTextBoxPaneStringFromMessageData( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex, gfl::str::MsgData* messageData, u32 stringId )
    {
      GFL_ASSERT( mTemporaryStrbuf );
      messageData->GetString( stringId, *mTemporaryStrbuf );
      const wchar_t* string = mTemporaryStrbuf->GetPtr();
      SetTextBoxPaneString( layoutWork, paneIndex, string );
    } 


    // eLXg{bNXyCɕݒ肷
    void Drawer::SetTextBoxPaneString( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex, const wchar_t* string )
    {
      gfl::grp::g2d::LytTextBox* textBox;
      textBox = layoutWork->GetTextBoxPane( paneIndex ); 
      GFL_ASSERT( textBox );
      if( textBox ) {
        textBox->SetString( string );
      }
    }

    // yC̓xύX
    void Drawer::SetPaneAlpha( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex, u8 alpha )
    {
      gfl::grp::g2d::LytPane* pane;
      pane = layoutWork->GetPane( paneIndex ); 
      GFL_ASSERT( pane );
      if( pane ) {
        pane->SetAlpha( alpha );
      }
    }

    // yC̉ԂύX
    void Drawer::SetPaneVisibility( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex, bool visible )
    {
      gfl::grp::g2d::LytPane* pane;
      pane = layoutWork->GetPane( paneIndex ); 
      GFL_ASSERT( pane );
      if( pane ) {
        pane->SetVisible( visible );
      }
    }

    // O[v̉ԂύX
    void Drawer::SetGroupVisibility( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex groupIndex, bool visible )
    {
      gfl::grp::g2d::LytPaneList* paneList = layoutWork->GetPaneList( groupIndex );
      GFL_ASSERT( paneList );
      if( paneList ) {
        gfl::grp::g2d::LytPaneList::iterator it = paneList->begin();
        while( it != paneList->end() ) {
          it->target->SetVisible( visible );
          it++;
        }
      }
    }

    // yC̈ʒuύX
    void Drawer::SetPaneTranslate( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex, gfl::math::VEC3 pos )
    {
      gfl::grp::g2d::LytPane* pane;
      pane = layoutWork->GetPane( paneIndex ); 
      GFL_ASSERT( pane );
      if( pane ) {
        pane->SetTranslate( pos );
      }
    }

    // O[vɏSẴyCZlύX
    void Drawer::SetGroupZPos( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex groupIndex, float z )
    {
      gfl::grp::g2d::LytPaneList* paneList = layoutWork->GetPaneList( groupIndex );
      GFL_ASSERT( paneList );
      if( paneList ) {
        gfl::grp::g2d::LytPaneList::iterator it = paneList->begin();
        while( it != paneList->end() ) {
          gfl::math::VEC3 pos = it->target->GetTranslate();
          pos.z = z;
          it->target->SetTranslate( pos );
          it++;
        }
      }
    }

    void Drawer::InitMessageData( gfl::heap::HeapBase* heap )
    {
      if( Drawer::mMessageData == NULL ) {
        Drawer::mMessageData = GFL_NEW( heap ) 
          gfl::str::MsgData( 
              L"rom:/message.garc", GARC_message_btl_app_DAT, heap, gfl::str::MsgData::LOAD_FULL );
      }
    }

    void Drawer::FinalizeMessageData()
    {
      if( Drawer::mMessageData ) {
        GFL_DELETE Drawer::mMessageData;
        Drawer::mMessageData = NULL;
      }
    }

    gfl::str::MsgData* Drawer::GetMessageData()
    {
      return mMessageData;
    }

  } // namespace nuts
} // namespace app
