//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file app_nuts_CoreData.cpp
 *	@brief ؂̎̂Q[̃RAf[^
 *	@author takada
 *	@date		2011.09.01
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include "app_nuts_CoreData.h"
#include "app_nuts_NutsData.h"
#include "app_nuts_BalloonData.h"

namespace app {
  namespace nuts {

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

    // XN[̐ݒ
    const app::tool::ScrollValue::Settings CoreData::mScrollValueSettings = 
    {
      /* l */ 0.0f,
      /* ŏl */ -100.0f,  // ɐlݒ肷邽, ͉̒l
      /* ől */ 100.0f,   // ɐlݒ肷邽, ͉̒l
      /* x */ 0.05f,
      /* E˔jǂ */ false,
      /* E˔ǰx */ 2.0f,
      /* E˔j̋XN[̃t[ */ 20,
    };

    const u32 CoreData::SCROLLBAR_TIME_TO_DIE = 30;

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //--------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     *
     * @param heap                   CX^X̐Ɏgpq[v
     */
    //--------------------------------------------------------------------------------
    CoreData::CoreData( gfl::heap::HeapBase* heap, pml::PokeParty* pokeParty, u8 initialPokemonIndex ) :
      mPokeParty( pokeParty ),
      mCurrentPokemonIndexInParty( initialPokemonIndex ),
      mScene( SCENE_NUTS_TOP ),
      mDirtyFlag(),
      m_nuts_data( NULL ),
      m_balloon_data( NULL ),
      mScrollValue( NULL ),
      mScrollBarCounterUntilDisappears( -1 ),
      mMenuWindowSystem( NULL )
    {
      this->InitializeDirtyFlags();
      this->CreateNutsData( heap );
      this->CreateBalloonData( heap );
      this->CreateScrollValueOfList( heap );
    }

    // XVtO
    void CoreData::InitializeDirtyFlags( void )
    {
      for( u32 i=0; i<DIRTY_FLAG_NUM; i++ ) {
        mDirtyFlag[i] = 0;
      }
    }

    // ؂̎f[^𐶐
    void CoreData::CreateNutsData( gfl::heap::HeapBase* heap )
    {
      GFL_ASSERT( m_nuts_data == NULL );
      m_nuts_data = GFL_NEW( heap ) NutsData( heap );
    }

    // of[^𐶐
    void CoreData::CreateBalloonData( gfl::heap::HeapBase* heap )
    {
      GFL_ASSERT( m_balloon_data == NULL );
      m_balloon_data = GFL_NEW( heap ) BalloonData( heap );
    }

    // XN[l𐶐
    void CoreData::CreateScrollValueOfList( gfl::heap::HeapBase* heap )
    {
      GFL_ASSERT( mScrollValue == NULL );
      mScrollValue = GFL_NEW( heap ) app::tool::ScrollValue( mScrollValueSettings );
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //--------------------------------------------------------------------------------
    CoreData::~CoreData()
    {
      this->DeleteScrollValueOfList();
      this->DeleteNutsData();
      this->DeleteBalloonData();
    }

    // ؂̎f[^j
    void CoreData::DeleteNutsData( void )
    {
      GFL_ASSERT( m_nuts_data );
      GFL_DELETE m_nuts_data;
    }

    // of[^j
    void CoreData::DeleteBalloonData( void )
    {
      GFL_ASSERT( m_balloon_data );
      GFL_DELETE m_balloon_data;
    }

    // XN[lj
    void CoreData::DeleteScrollValueOfList( void )
    {
      GFL_ASSERT( mScrollValue );
      GFL_DELETE mScrollValue;
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief f[^XV
     */
    //--------------------------------------------------------------------------------
    void CoreData::UpdateData( void )
    {
      this->UpdateScrollValue();
      m_nuts_data->UpdateData();
      m_balloon_data->UpdateData();
    }

    //------------------------------------------------------------------------------------
    // XVNǂ𒲂ׂ
    //------------------------------------------------------------------------------------
    bool CoreData::IsDirty( DirtyFlagIndex index, DirtyBit bit ) const 
    {
      return mDirtyFlag[ index ] & bit; 
    }

    //------------------------------------------------------------------------------------
    // XVtO菜
    //------------------------------------------------------------------------------------
    void CoreData::RemoveDirtyBit( DirtyFlagIndex index, DirtyBit bit ) const 
    { 
      const_cast< CoreData* >( this )->mDirtyFlag[ index ] = mDirtyFlag[ index ] & ( ~bit ); 
    }

    // XVtOZbg
    void CoreData::SetDirtyBit( DirtyBit bit ) 
    {
      for( u32 i=0; i<DIRTY_FLAG_NUM; i++ ) {
        mDirtyFlag[ i ] |= bit; 
      }
    }



    //------------------------------------------------------------------------------------
    // V[擾
    //------------------------------------------------------------------------------------
    CoreData::SceneNo CoreData::GetScene( void ) const 
    { 
      return mScene; 
    }

    //------------------------------------------------------------------------------------
    // V[ݒ肷
    //------------------------------------------------------------------------------------
    void CoreData::SetScene( SceneNo scene ) 
    {
      if( mScene != scene ) {
        mScene = scene; 
        this->SetDirtyBit( DIRTY_BIT_SCENE );
      }
    }

    //------------------------------------------------------------------------------------
    // ؂̎f[^擾
    //------------------------------------------------------------------------------------
    NutsData* CoreData::GetNutsData( void ) const
    {
      return m_nuts_data;
    }

    //------------------------------------------------------------------------------------
    // ؂̎f[^擾
    //------------------------------------------------------------------------------------
    const NutsData* CoreData::GetConstNutsData( void ) const
    {
      return m_nuts_data;
    }

    //------------------------------------------------------------------------------------
    // of[^擾
    //------------------------------------------------------------------------------------
    BalloonData* CoreData::GetBalloonData( void ) const
    {
      return m_balloon_data;
    }

    //------------------------------------------------------------------------------------
    // of[^擾
    //------------------------------------------------------------------------------------
    const BalloonData* CoreData::GetConstBalloonData( void ) const
    {
      return m_balloon_data;
    }

    //------------------------------------------------------------------------------------
    // \Ώۂ̃|Pp[eB擾
    //------------------------------------------------------------------------------------
    const pml::PokeParty* CoreData::GetConstPokeParty( void ) const
    {
      return mPokeParty;
    }

    //------------------------------------------------------------------------------------
    // \Ώۂ̃|Pp[^擾
    //------------------------------------------------------------------------------------
    const pml::pokepara::PokemonParam* CoreData::GetConstPokemonParameter( void ) const
    {
      return mPokeParty->GetMemberPointerConst( mCurrentPokemonIndexInParty );
    }

    //------------------------------------------------------------------------------------
    // \Ώۂ̃|Pp[^擾
    //------------------------------------------------------------------------------------
    pml::pokepara::PokemonParam* CoreData::GetPokemonParameter( void ) const
    {
      return mPokeParty->GetMemberPointer( mCurrentPokemonIndexInParty );
    }

    //------------------------------------------------------------------------------------
    // \̃|P̃p[eBCfbNX擾
    //------------------------------------------------------------------------------------
    u8 CoreData::GetCurrentPokemonIndexInParty( void ) const
    {
      return mCurrentPokemonIndexInParty;
    }

    //------------------------------------------------------------------------------------
    // \|PύX
    //------------------------------------------------------------------------------------
    void CoreData::ChangeCurrentPokemonIndexInParty( u8 index )
    {
      u32 poke_count = mPokeParty->GetMemberCountEx( pml::PokeParty::POKE_COUNT_TYPE_ALL );
      if( ( index < poke_count ) && ( mCurrentPokemonIndexInParty != index ) ) {
        mCurrentPokemonIndexInParty = index;
        this->SetDirtyBit( DIRTY_BIT_POKEMON );
      }
    }

    //------------------------------------------------------------------------------------
    // XN[lIuWFNg擾
    //------------------------------------------------------------------------------------
    const app::tool::ScrollValue& CoreData::GetScrollValueObject( void ) const
    {
      return *mScrollValue;
    }

    //------------------------------------------------------------------------------------
    // XN[ʒu擾
    //------------------------------------------------------------------------------------
    f32 CoreData::GetScrollValue( void ) const
    {
      return mScrollValue->GetCurrentValue();
    }

    //------------------------------------------------------------------------------------
    // XN[ʒuݒ肷
    //------------------------------------------------------------------------------------
    void CoreData::SetScrollValue( f32 value )
    {
      mScrollValue->SetCurrentValue( value );
      this->SetDirtyBit( DIRTY_BIT_SCROLL_VALUE );
    }

    //------------------------------------------------------------------------------------
    // XN[Jn
    //------------------------------------------------------------------------------------
    void CoreData::StartScroll( f32 scroll_speed, f32 endValue )
    {
      mScrollValue->StartScroll( scroll_speed, endValue );
    }

    //------------------------------------------------------------------------------------
    // XN[~߂
    //------------------------------------------------------------------------------------
    void CoreData::StopScroll( void )
    {
      mScrollValue->StopScroll();
    }

    //--------------------------------------------------------------------------------
    // ŏXN[lݒ肷
    //--------------------------------------------------------------------------------
    void CoreData::SetMinScrollValue( f32 min_value )
    {
      mScrollValue->SetMinValue( min_value );
    }

    //--------------------------------------------------------------------------------
    // őXN[lݒ肷
    //--------------------------------------------------------------------------------
    void CoreData::SetMaxScrollValue( f32 max_value )
    {
      mScrollValue->SetMaxValue( max_value );
    }

    //--------------------------------------------------------------------------------
    // XN[Œ肷
    //--------------------------------------------------------------------------------
    void CoreData::LockScroll( void )
    {
      mScrollValue->LockScroll();
    }

    //--------------------------------------------------------------------------------
    // XN[Œ
    //--------------------------------------------------------------------------------
    void CoreData::UnlockScroll( void )
    {
      mScrollValue->UnlockScroll();
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief XN[lXV
     */
    //--------------------------------------------------------------------------------
    void CoreData::UpdateScrollValue( void )
    {
      f32 oldValue = mScrollValue->GetCurrentValue();
      mScrollValue->UpdateScroll();
      f32 newValue = mScrollValue->GetCurrentValue();
      if( oldValue != newValue ) {
        this->SetDirtyBit( DIRTY_BIT_SCROLL_VALUE );
        mScrollBarCounterUntilDisappears = 0;
      }
      else if( mScrollBarCounterUntilDisappears != -1 &&
          mScrollBarCounterUntilDisappears <= SCROLLBAR_TIME_TO_DIE )
      {
        mScrollBarCounterUntilDisappears++;
        this->SetDirtyBit( DIRTY_BIT_SCROLL_VALUE );
      }
      else
      {
        mScrollBarCounterUntilDisappears = -1;
      }
    }

    //--------------------------------------------------------------------------------
    // SXN[Jn
    //--------------------------------------------------------------------------------
    void CoreData::StartBindScroll( f32 bindValue, u32 bindFrame )
    {
      mScrollValue->StartBindScroll( bindValue, bindFrame );
    }

    //--------------------------------------------------------------------------------
    // SXN[ǂ𒲂ׂ
    //--------------------------------------------------------------------------------
    bool CoreData::IsScroll( void ) const
    {
      return mScrollValue->IsScroll();
    }

    //--------------------------------------------------------------------------------
    /**
     * @brief j[EBhEVXeGetter/Setter
     */
    //--------------------------------------------------------------------------------
    void CoreData::SetMenuWindowSystem( app::tool::MenuWindowSystem* menuWindowSystem )
    {
      mMenuWindowSystem = menuWindowSystem;
    }

    app::tool::MenuWindowSystem* CoreData::GetMenuWindowSystem( void ) const
    {
      return mMenuWindowSystem;
    }

  } // namespace nuts
} // namespace app
