//========================================================================================
/**
 * @file app_nuts_BalloonData.h
 * @brief ؂̎̂Q[̐of[^
 * @author takada
 * @date 2011.09.07
 */
//========================================================================================
#ifndef __NUTS_BALLOON_DATA_H__
#define __NUTS_BALLOON_DATA_H__
#include <gflib.h>
#include <pmlib.h>

namespace app {
  namespace nuts {


    class BalloonData
    {
      GFL_FORBID_COPY_AND_ASSIGN( BalloonData );

      public:

      static const s32 NOT_INSIDE_INDEX = 1000000;

      //--------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param heap  CX^X̐Ɏgpq[v
       */
      //--------------------------------------------------------------------------------
      BalloonData( gfl::heap::HeapBase* heap );

      //--------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //--------------------------------------------------------------------------------
      virtual ~BalloonData(); 

      //--------------------------------------------------------------------------------
      /**
       * @brief f[^XV
       */
      //--------------------------------------------------------------------------------
      void UpdateData( void ); 

      void UpdateAnimation( gfl::grp::g2d::LytWk* layoutWork, const NutsData* pNutsData );
      void StartAnimation( gfl::grp::g2d::LytWk* layoutWork, LowerLayout::AnimationIndex animationIndex );
      void StopAnimation( gfl::grp::g2d::LytWk* layoutWork, LowerLayout::AnimationIndex animationIndex );

      //--------------------------------------------------------------------------------
      // õCfbNX
      //--------------------------------------------------------------------------------
      enum BalloonIndex {
        BALLOON_ONE,
        BALLOON_TWO,
        BALLOON_THREE,
        BALLOON_FOUR,
        BALLOON_FIVE,
        BALLOON_SIX,
        BALLOON_SEVEN,
        BALLOON_EIGHT,
        BALLOON_NINE,
        BALLOON_TEN,

        BALLOON_NUM,          // 
        BALLOON_NULL,         // l
      }; 


      //--------------------------------------------------------------------------------
      // ȍ
      //--------------------------------------------------------------------------------
      struct BalloonDescription {
        u32 color;  // F
      };
      const BalloonDescription& GetBalloonDescription( BalloonIndex balloonIndex ) const;      // ȍ擾
      void SetBalloonDescription( BalloonIndex balloonIndex, const BalloonDescription& data ); // ȍݒ肷

      //--------------------------------------------------------------------------------
      // ̈Ƃ̓
      //--------------------------------------------------------------------------------
      void SetIsBalloonInsideOfDecisionRegion( BalloonIndex balloonIndex, bool isHit );
      bool GetIsBalloonInsideOfDecisionRegion( BalloonIndex balloonIndex ) const;
      s32 GetNumberOfDecisionRegion( BalloonIndex balloonIndex ) const;

      //--------------------------------------------------------------------------------
      // o̍W
      //-------------------------------------------------------------------------------- 
      const gfl::math::VEC3& GetBalloonPosition( BalloonIndex balloon_index ) const;              // o̍W擾
      void SetBalloonPosition( BalloonIndex balloon_index, const gfl::math::VEC3& balloon_pos );    // o̍Wݒ肷

      //------------------------------------------------------------------------------------
      // x[XʒuɃZbg
      //------------------------------------------------------------------------------------
      void SetBasePosition( gfl::grp::g2d::LytWk* layoutWork );
      void SetBasePosition( u32 posIndex, BalloonIndex targetBalloon );

      //--------------------------------------------------------------------------------
      // õAj[V
      //--------------------------------------------------------------------------------
      enum BalloonAnimeState
      {
        BALLOON_ANIME_STATE_OPEN,
        BALLOON_ANIME_STATE_WAIT,
        BALLOON_ANIME_STATE_ACTION,
        BALLOON_ANIME_STATE_CLOSE,

        BALLOON_ANIME_STATE_NUM,
        BALLOON_ANIME_STATE_NULL,
      };
      BalloonAnimeState GetCurrentBalloonAnimeState( BalloonIndex targetBalloon );

      void SetCurrentBalloonAnimationIndex( BalloonIndex targetBalloon, LowerLayout::AnimationIndex animationIndex );
      LowerLayout::AnimationIndex GetCurrentBalloonAnimationIndex( BalloonIndex targetBalloon );

      //--------------------------------------------------------------------------------
      // ԂɒBĂ邩ǂ𒲂ׂ
      //--------------------------------------------------------------------------------
      void SetIsLimitTime( BalloonIndex targetBalloon, bool flag );
      bool GetIsLimitTime( BalloonIndex targetBalloon );

      private:

      BalloonAnimeState mCurrentBalloonAnimeState[ BALLOON_NUM ];
      LowerLayout::AnimationIndex mCurrentBalloonAnimationIndex[ BALLOON_NUM ];

      BalloonDescription m_balloon_descriptions[ BALLOON_NUM ];       // ȍ

      bool mIsBalloonInsideOfDecisionRegion[ BALLOON_NUM ];        // ö̓ɂ邩ǂ
      s32 mNumberOfDecisionRegion[ BALLOON_NUM ];    // oԖڂ̔̈̓ɂ邩 
      
      gfl::math::VEC3 m_balloon_positions[ BALLOON_NUM ];          // o̍W
      bool mIsLimitTime[ BALLOON_NUM ];   // ԂɒBǂ

      // o
      void InitializeBalloon( void );

      //--------------------------------------------------------------------------------
      // ֗֐
      //--------------------------------------------------------------------------------
      // yC̈ʒu擾
      gfl::math::VEC3 GetPaneTranslate( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex );
      
      // O[vɏSẴyC̈ʒuύX
      void SetGroupPos( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex groupIndex, gfl::math::VEC3 pos );

      // yC̉ԂύX
    void SetPaneVisibility( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex, bool visible );

    };


  } // namespace nuts
} // namespace app


#endif // __NUTS_BALLOON_DATA_H__
