//========================================================================================
/**
 * @file app_nuts_BalloonData.cpp
 * @brief ؂̎̂Q[̐of[^
 * @author takada
 * @date 2011.09.07
 */
//========================================================================================
#include <gflib.h>
#include <pmlib.h>
#include "app_nuts_NutsData.h"
#include "app_nuts_BalloonData.h"
#include "app_nuts_LowerLayoutInformation.h"

namespace app {
  namespace nuts {



    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    BalloonData::BalloonData( gfl::heap::HeapBase* heap ) :
      m_balloon_descriptions(),
      m_balloon_positions(),
      mIsLimitTime()
    {
      this->InitializeBalloon(); 

      // TODO:
      for( s32 i=0; i<BALLOON_NUM; ++i )
      {
        mCurrentBalloonAnimeState[ i ] = BALLOON_ANIME_STATE_NULL;
        mCurrentBalloonAnimationIndex[ i ] = LowerLayout::ANIMATION_INDEX_NULL;
      }
    }


    // o
    void BalloonData::InitializeBalloon( void )
    {
      for( u32 i=0; i<BALLOON_NUM; i++ ) {
        m_balloon_descriptions[i].color = 0;
        mIsLimitTime[ i ] = false;
      }
    }

    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    BalloonData::~BalloonData()
    {
    } 



    //------------------------------------------------------------------------------------
    // f[^XV
    //------------------------------------------------------------------------------------
    void BalloonData::UpdateData( void )
    {
    }

    void BalloonData::UpdateAnimation( gfl::grp::g2d::LytWk* layoutWork, const NutsData* pNutsData )
    {
      for( u32 i=0; i<BALLOON_NUM; ++i )
      {
        BalloonIndex targetBalloon = static_cast<BalloonData::BalloonIndex>( i );
        bool isBalloonInsideOfDecisionRegion = GetIsBalloonInsideOfDecisionRegion( targetBalloon );
        s32 numberOfDecisionRegionOfBalloon = GetNumberOfDecisionRegion( targetBalloon );        

        NutsData::NutsIndex targetNuts = NutsData::NUTS_NULL;
        s32 nutsNum = 0;
        bool isNutsInsideOfDecisionRegion = false;
        s32 numberOfDecisionRegionOfNuts = 0;
        gfl::grp::g2d::LytPaneIndex paneIndex = 0;

        if( isBalloonInsideOfDecisionRegion == true )
        {
          switch( mCurrentBalloonAnimeState[ targetBalloon ] )
          {
          case BALLOON_ANIME_STATE_OPEN:
            mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenOpen;
            this->StartAnimation( layoutWork, mCurrentBalloonAnimationIndex[ targetBalloon ] );
            break;            
          case BALLOON_ANIME_STATE_WAIT:
            if( mIsLimitTime[ targetBalloon ] == true )
            {
              mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenClose;
            }
            else
            {
              mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenWait;
            }
            this->StartAnimation( layoutWork, mCurrentBalloonAnimationIndex[ targetBalloon ] );

            /*NutsData::NutsIndex*/ targetNuts = pNutsData->GetCurrentTouchedNuts();
            if( targetNuts != NutsData::NUTS_NULL )
            {
              /*s32*/ nutsNum = static_cast<s32>( targetNuts );
              /*bool*/ isNutsInsideOfDecisionRegion = pNutsData->GetIsNutsInsideOfDecisionRegion( targetNuts );
              /*s32*/ numberOfDecisionRegionOfNuts = pNutsData->GetNumberOfDecisionRegion( targetNuts );

              if( isNutsInsideOfDecisionRegion == true && numberOfDecisionRegionOfBalloon == numberOfDecisionRegionOfNuts )
              {
                // TODO: ؂̎( j )̐FƁAnumberOfDecisionRegionOfNuts̗̈ɂA
                // o( i )̐FrčvAAj[VĐ
                if( i == nutsNum )
                {
                  mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenRight02; 
                }
                else
                {
                  mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenMistake; 
                }
                this->StartAnimation( layoutWork, mCurrentBalloonAnimationIndex[ targetBalloon ] );
              }
            }
            break;
          case BALLOON_ANIME_STATE_ACTION:
            break;
          case BALLOON_ANIME_STATE_CLOSE:
            mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenClose; 
            this->StartAnimation( layoutWork, mCurrentBalloonAnimationIndex[ targetBalloon ] );
            break;
          case BALLOON_ANIME_STATE_NUM:
            paneIndex = LowerLayout::information.balloonInfo[ targetBalloon ].paneIndexOfRoot;
            this->SetPaneVisibility( layoutWork, paneIndex, false ); 
            SetIsBalloonInsideOfDecisionRegion( targetBalloon, false );
            mCurrentBalloonAnimeState[ targetBalloon ] = BALLOON_ANIME_STATE_NULL;
            mCurrentBalloonAnimationIndex[ targetBalloon ] = LowerLayout::ANIMATION_INDEX_NULL;
            break;
          case BALLOON_ANIME_STATE_NULL:
            mCurrentBalloonAnimeState[ targetBalloon ] = BALLOON_ANIME_STATE_OPEN;
            break;
          default:
            break;
          }

          if( mCurrentBalloonAnimationIndex[ targetBalloon ] != LowerLayout::ANIMATION_INDEX_NULL )
          {
            if( layoutWork->IsAnimeEnd( mCurrentBalloonAnimationIndex[ targetBalloon ] ) == true )
            {
              this->StopAnimation( layoutWork, mCurrentBalloonAnimationIndex[ targetBalloon ] );

              s32 balloonAnimeStateIndex = static_cast<s32>( mCurrentBalloonAnimeState[ targetBalloon ] );
              mCurrentBalloonAnimeState[ targetBalloon ] = static_cast<BalloonAnimeState>( ++balloonAnimeStateIndex );
            }
            else if( mCurrentBalloonAnimeState[ targetBalloon ] == BALLOON_ANIME_STATE_WAIT &&
                mCurrentBalloonAnimationIndex[ targetBalloon ] != LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenWait )
            {
              this->StopAnimation( layoutWork, LowerLayout::information.balloonInfo[ targetBalloon ].animationIndexWhenWait );
             
              // ԂɒBĂ
              if( mIsLimitTime[ targetBalloon ] == true )
              {
                mIsLimitTime[ targetBalloon ] = false;
                mCurrentBalloonAnimeState[ targetBalloon ] = BALLOON_ANIME_STATE_CLOSE;
              }
              else
              {
                mCurrentBalloonAnimeState[ targetBalloon ] = BALLOON_ANIME_STATE_ACTION;
              }
            }
          }
        }
      }
    }

    // Aj[VJn
    void BalloonData::StartAnimation( gfl::grp::g2d::LytWk* layoutWork, LowerLayout::AnimationIndex animationIndex )
    {
      if( animationIndex < LowerLayout::ANIMATION_INDEX_NUM ) {
        if( layoutWork->IsBindAnime( animationIndex ) == false ) {
          layoutWork->BindAnime( animationIndex );
          layoutWork->SetAutoAnime( animationIndex, true );
          layoutWork->SetAnimeFrame( animationIndex, 0 );
        }
        else
        {
          return;
        }
      }
    }

    // Aj[V~
    void BalloonData::StopAnimation( gfl::grp::g2d::LytWk* layoutWork, LowerLayout::AnimationIndex animationIndex ) 
    {
      if( animationIndex < LowerLayout::ANIMATION_INDEX_NUM ) {
        if( layoutWork->IsBindAnime( animationIndex ) ) {
          layoutWork->UnBindAnime( animationIndex );
        }
      }
    }

    //------------------------------------------------------------------------------------
    // x[XʒuɃZbg
    //------------------------------------------------------------------------------------
    void BalloonData::SetBasePosition( gfl::grp::g2d::LytWk* layoutWork )
    {
      for( u32 i=0; i<BALLOON_NUM; ++i ) {
        bool isBalloonInsideOfDecisionRegion = mIsBalloonInsideOfDecisionRegion[ i ];
        if( isBalloonInsideOfDecisionRegion == true )
        {
          gfl::grp::g2d::LytPaneIndex paneIndex = LowerLayout::information.balloonInfo[ i ].paneIndexOfRoot;
          this->SetPaneVisibility( layoutWork, paneIndex, true );
          gfl::grp::g2d::LytPane* pane = layoutWork->GetPane( paneIndex ); 
          gfl::math::VEC3 panePos = pane->GetTranslate();

          s32 numberOfDecisionRegion = mNumberOfDecisionRegion[ i ];
          const gfl::math::VEC3 basePosition = this->GetPaneTranslate( layoutWork, LowerLayout::information.paneIndexOfBalloonBasePosition[ numberOfDecisionRegion ] );

          panePos.x = basePosition.x;
          panePos.y = basePosition.y;
          pane->SetTranslate( panePos );
        }
      }
    }

    void BalloonData::SetBasePosition( u32 posIndex, BalloonIndex targetBalloon )
    {
        mIsBalloonInsideOfDecisionRegion[ targetBalloon ] = true;
        mNumberOfDecisionRegion[ targetBalloon ] = posIndex;
    }

    //--------------------------------------------------------------------------------
    // ȍ擾
    //--------------------------------------------------------------------------------
        const BalloonData::BalloonDescription& BalloonData::GetBalloonDescription( BalloonIndex balloon_index ) const
    {
      GFL_ASSERT( balloon_index < BALLOON_NUM );
      return m_balloon_descriptions[ balloon_index ];
    }

    //--------------------------------------------------------------------------------
    // ̈Ƃ̓
    //--------------------------------------------------------------------------------
    void BalloonData::SetIsBalloonInsideOfDecisionRegion( BalloonIndex balloonIndex, bool isHit )
    {
      GFL_ASSERT( balloonIndex < BALLOON_NUM );
      if( balloonIndex < BALLOON_NUM ) {
        mIsBalloonInsideOfDecisionRegion[ balloonIndex ] = isHit;
        if( isHit == false )
        {
          this->mNumberOfDecisionRegion[ balloonIndex ] = NOT_INSIDE_INDEX;
        }
      }
    }

    bool BalloonData::GetIsBalloonInsideOfDecisionRegion( BalloonIndex balloonIndex ) const
    {
      GFL_ASSERT( balloonIndex < BALLOON_NUM );
      return mIsBalloonInsideOfDecisionRegion[ balloonIndex ];
    }

    s32 BalloonData::GetNumberOfDecisionRegion( BalloonIndex balloonIndex ) const
    {
      GFL_ASSERT( balloonIndex < BALLOON_NUM );
      return mNumberOfDecisionRegion[ balloonIndex ];
    }

    //--------------------------------------------------------------------------------
    // ȍݒ肷
    //--------------------------------------------------------------------------------
    void BalloonData::SetBalloonDescription( BalloonIndex balloon_index, const BalloonDescription& data )
    {
      GFL_ASSERT( balloon_index < BALLOON_NUM );
      if( balloon_index < BALLOON_NUM ) {
        m_balloon_descriptions[ balloon_index ] = data;
      }
    }

    //------------------------------------------------------------------------------------
    // o̍W擾
    //------------------------------------------------------------------------------------
    const gfl::math::VEC3& BalloonData::GetBalloonPosition( BalloonIndex balloon_index ) const
    {
      GFL_ASSERT( balloon_index < BALLOON_NUM );
      return m_balloon_positions[ balloon_index ];
    } 

    //------------------------------------------------------------------------------------
    // o̍Wݒ肷
    //------------------------------------------------------------------------------------
    void BalloonData::SetBalloonPosition( BalloonIndex balloon_index, const gfl::math::VEC3& balloon_pos )
    {
      GFL_ASSERT( balloon_index < BALLOON_NUM );
      m_balloon_positions[ balloon_index ] = balloon_pos;
    }

    //--------------------------------------------------------------------------------
    // õAj[V
    //--------------------------------------------------------------------------------
    BalloonData::BalloonAnimeState BalloonData::GetCurrentBalloonAnimeState( BalloonIndex targetBalloon )
    {
      return mCurrentBalloonAnimeState[ targetBalloon ];
    }

    void BalloonData::SetCurrentBalloonAnimationIndex( BalloonIndex targetBalloon, LowerLayout::AnimationIndex animationIndex )
    {
      mCurrentBalloonAnimationIndex[ targetBalloon ] = animationIndex;
    }

    LowerLayout::AnimationIndex BalloonData::GetCurrentBalloonAnimationIndex( BalloonIndex targetBalloon )
    {
      return mCurrentBalloonAnimationIndex[ targetBalloon ];
    }

    //--------------------------------------------------------------------------------
    // ԂɒBĂ邩ǂ𒲂ׂ
    //--------------------------------------------------------------------------------
    void BalloonData::SetIsLimitTime( BalloonIndex targetBalloon, bool flag )
    {
      mIsLimitTime[ targetBalloon ] = flag;
    }

    bool BalloonData::GetIsLimitTime( BalloonIndex targetBalloon )
    {
      return mIsLimitTime[ targetBalloon ];
    }

    //--------------------------------------------------------------------------------
    // ֗֐
    //--------------------------------------------------------------------------------
    // yC̈ʒu擾
    gfl::math::VEC3 BalloonData::GetPaneTranslate( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex )
    {
      gfl::math::VEC3 pos = gfl::math::VEC3( 0.0f, 0.0f, 0.0f );
      gfl::grp::g2d::LytPane* pane;
      pane = layoutWork->GetPane( paneIndex ); 
      GFL_ASSERT( pane );
      if( pane ) {
        pos = pane->GetTranslate();
      }
      return pos;
    }

    // O[vɏSẴyC̈ʒuύX
    void BalloonData::SetGroupPos( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex groupIndex, gfl::math::VEC3 pos )
    {
      gfl::grp::g2d::LytPaneList* paneList = layoutWork->GetPaneList( groupIndex );
      GFL_ASSERT( paneList );
      if( paneList ) {
        gfl::grp::g2d::LytPaneList::iterator it = paneList->begin();
        while( it != paneList->end() ) {
          it->target->SetTranslate( pos );
          it++;
        }
      }
    }

    // yC̉ԂύX
    void BalloonData::SetPaneVisibility( gfl::grp::g2d::LytWk* layoutWork, gfl::grp::g2d::LytPaneIndex paneIndex, bool visible )
    {
      gfl::grp::g2d::LytPane* pane;
      pane = layoutWork->GetPane( paneIndex ); 
      GFL_ASSERT( pane );
      if( pane ) {
        pane->SetVisible( visible );
      }
    }

  } // namespace nuts
} // namespace app
