//=======================================================================================
/**
 * @file ItemInfoBase.h
 * @briefuvʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.09.14
 */
//=======================================================================================
#ifndef __ITEMINFOBASE_H__
#define __ITEMINFOBASE_H__
#include <gflib.h>
#include "AppBase.h"


namespace btl {

  class BattleViewSystem;


  namespace app {

    class ItemInfoBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( ItemInfoBase );  // Rs[֎~

      public: 


      //---------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      ItemInfoBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      /**
       * @brief fXgN^
       */
      virtual ~ItemInfoBase();




      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      // J[\ʒu
      enum InitCursorPos {
        INIT_CURSOR_POS_USE,    //uv
        INIT_CURSOR_POS_RETURN, //uǂv
      };

      // ݒ
      struct Setting {
        u32 item_id;                    // \铹
        InitCursorPos init_cursor_pos;  // J[\ʒu
      };

      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      virtual void ChangeSetting( const Setting& new_setting ) = 0;




      //---------------------------------------------------------------------------------
      // 
      //---------------------------------------------------------------------------------
      // I
      enum Result {
        RESULT_RETURN,  //uǂvI
        RESULT_USE,     //uvI
        RESULT_NULL,
      };

      /**
       * @brief ʂ擾
       */
      Result GetResult( void ) const;





      protected:
      void SetSetting( const Setting& new_setting ) { m_settings = new_setting; }
      const Setting& GetSetting( void ) const { return m_settings; }
      u32 GetItemId( void ) const { return m_settings.item_id; }
      InitCursorPos GetInitCursorPos( void ) const { return m_settings.init_cursor_pos; }

      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }


      private:
      Setting m_settings;
      Result m_result;
    };


  }  // namespace app
}  // namespace btl


#endif // __ITEMINFOBASE_H__ 
